// raw2Ac.c -- convert raw image to byte array, adding alpha (r,g,b,a)
#include <stdio.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
    FILE            *infp, *outfp;
    unsigned char    byt[256];
    int              w, h, n,i = 0, lin = 0;
    char            *label = "image";

    if(argc<5)
    {
        printf("USAGE: %s <input image> <w> <h> <outFile> [<label>] \n", argv[0]);
        return 0;
    }
    if(argc>5 && argv[5])
        label = argv[5];
    infp=fopen(argv[1],"rb");
    if( infp)
    {
        outfp=fopen(argv[4],"w");
        if( outfp)
        {
            w = atol(argv[2]);
            h = atol(argv[3]);
            fprintf(outfp,"// %s -- generated by %s from %s\n",argv[4],argv[0],argv[1]);
            fprintf(outfp,"#define %s_WIDTH    %d\n",label,w);
            fprintf(outfp,"#define %s_HEIGHT    %d\n",label,h);
            fprintf(outfp,"static unsigned char %s_DATA[] = {",label);
            while( 0 != (n = fread(byt,1,252,infp ))) // line length must divide by 3!!
            {
                for(i=0; i<n; i+=3, lin+=4)
                {
                    if(lin>=16) 
                        lin=0;
                    if(lin)
                        fprintf(outfp,"0x%02x,0x%02x,0x%02x,0xFF,",byt[i],byt[i+1],byt[i+2]);
                    else
                        fprintf(outfp,"\n\t0x%02x,0x%02x,0x%02x,0xFF,",byt[i],byt[i+1],byt[i+2]);
                }

            }
            fprintf(outfp," 0x00\n};\n");
            fclose(outfp);
        }
        else
            printf("Can't open output: %s",argv[4]);
        fclose(infp);
    }
    else
        printf("Can't open input: %s",argv[1]);

    return 0;
}
