/* Win32 GUI app skeleton */

#include <windows.h>
#include <sstream.h>
#include "external.h"
#include "openglstuff.h"
#include "game.h"
#include "terrain.h"


LRESULT CALLBACK WndProc( HWND hWnd, UINT messg,
								WPARAM wParam, LPARAM lParam );

//extern double minCameraY;

bool		bufferFPS = true;
int			targetFPS = 60;
int			targetFrameTime = 1000 / targetFPS;

HGLRC		hRC = NULL;
HDC			hDC = NULL;
HWND		hWnd = NULL;
HINSTANCE	hInstance;
bool		keys[256];// Array Used For The Keyboard Routine
bool		active=TRUE;// Window Active Flag Set To TRUE By Default
bool		fullscreen=TRUE;
bool		done = false;
bool		danderDingy;


double speed = 0;//0.01;

extern int currentWallNum, currentPitNum;
extern int xDrawOffset, zDrawOffset, wallDealy;
extern Camera camera;
extern UnicycleGuy guy;
int startTime = 0;
int frames = 0;
extern double xOffset, zOffset;
extern bool withinWall;

bool InputPrompt();


int WINAPI WinMain(	HINSTANCE	hInstance,				// Instance
			HINSTANCE	hPrevInstance,				// Previous Instance
			LPSTR		lpCmdLine,				// Command Line Parameters
			int		nCmdShow)				// Window Show State
{
	MSG	msg;
	bool gp = false;
	RECT textRect;
	int frameTime, currentTime;
	/*
	bool continueThing = InputPrompt();
	
	if (continueThing == false) return 0;
	*/
	fullscreen = false;
	targetFrameTime = 1000 / targetFPS;
	if (!CreateGLWindow("3D Terrain",640,480,16,fullscreen))
		return 0;
	
	InitProgram();
	
	frameTime = startTime = clock();
	while(!done)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
			if (msg.message == WM_QUIT)
				done = TRUE;
			else {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} else {
			if (active)	{
				if (keys[VK_ESCAPE])
					done=TRUE;
				else {
					//RECT windowRect;
					//GetClientRect(hWnd, &windowRect);
					
					currentTime = GetMilliseconds();
					if ( (currentTime-frameTime) >= targetFrameTime || !bufferFPS) {
						frameTime = currentTime;
						
						DrawGLScene();
						SwapBuffers(hDC);
						frames++;
					}
					if (keys['R']) {
						startTime = currentTime;
						frames = 0;
					}
					
					ostringstream s;
					
					if (currentTime - startTime > 0)
						s << frames/((currentTime-startTime) / 1000.0) << '\n' << camera.ry << '\n' << camera.rx <<
							'\n' << guy.x << '\n' << guy.y << '\n' << guy.z << '\n' << "Walls: "
							<< currentWallNum << "\nPits:" << currentPitNum << "\nX offset" << xOffset << "\nZ offset:"
							<< zOffset << "\nDead?: " << withinWall << "\nWallDealy: " << wallDealy <<  "\nSpeed: " << guy.speed;
					
					SetRect(&textRect, 0,0,200,350);
					DrawText(hDC, s.str().c_str(), -1, &textRect, DT_TOP);
					
					//InvalidateRect(hWnd, &windowRect, true);
					//UpdateWindow(hWnd);
				}
			}/*
			if (keys[VK_F1]) {
				keys[VK_F1] = FALSE;
				KillGLWindow();
				fullscreen = !fullscreen;	
				
				if (!CreateGLWindow("NeHe's OpenGL Framework",640,480,16,fullscreen))
					return 0;
			}*/
		}
		/*if (keys['G'] && !gp) {
			gp = TRUE;
			DEBUGAdjustFog();
		}
		if (!keys['G']) {
			gp=FALSE;
		}
		if (keys['Y'])
			speed += 0.001;
		if (keys['H'])
			speed -= 0.001;
		//movingForward = (speed > 0);
		//if (speed < 0) speed = 0;*/
		//CameraControls(keys);
		/*
		int dingy;
		keepGoing = true;
		while(keepGoing) {
			doodoo = GetMilliseconds();
			dingy = doodoo-frameTime;
			if (dingy > targetFrameTime) break;
		}*/
		/*
		if (frameTime != 0) {
			while( (GetMilliseconds()-frameTime) < targetFrameTime) {}
		}*/
		
	}
	DieDieDieDieDieDieDie();
	KillGLWindow();								// Kill The Window
	return (msg.wParam);							// Exit The Program
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT messg,				/*callback procedure */
								WPARAM wParam, LPARAM lParam )
{
	RECT textRect;
	HDC hdc;
	PAINTSTRUCT pstruct;
	
	
	SetRect(&textRect, 0,0,200,30);
	//InvalidateRect(hWnd, &textRect, true);
	switch(messg)
	{
		case WM_ACTIVATE:						// Watch For Window Activate Message
			if (!HIWORD(wParam))
				active=TRUE;					// Program Is Active
			else
				active=FALSE;					// Program Is No Longer Active
			return 0;						// Return To The Message Loop
		case WM_SYSCOMMAND:						// Intercept System Commands
			switch (wParam)						// Check System Calls
			{
				case SC_SCREENSAVE:				// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;					// Prevent From Happening
			}
			break;					// Jump Back
		case WM_KEYDOWN:						// Is A Key Being Held Down?
			keys[wParam] = TRUE;					// If So, Mark It As TRUE
			return 0;	
		case WM_KEYUP:	
			keys[wParam] = FALSE;					// If So, Mark It As FALSE
			return 0;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &pstruct ); /* prepare window for painting*/
			//DebugNodeList(hWnd, hdc);
			
			
			EndPaint(hWnd, &pstruct );	/* stop painting */
			return 0;	
		case WM_SIZE:	
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));		// LoWord=Width, HiWord=Height
			return 0;
		case WM_CLOSE:
			done=TRUE;
			return 0;
	}
	return DefWindowProc(hWnd,messg,wParam,lParam);
}




GLvoid KillGLWindow(GLvoid)							// Properly Kill The Window
{
	KillGL();
	if (fullscreen)								// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);						// Show Mouse Pointer
	}

	if (hRC)								// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))					// Are We Able To Delete The RC?
		{
			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		hRC=NULL;							// Set RC To NULL
	}
	if (hDC && !ReleaseDC(hWnd,hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hDC=NULL;							// Set DC To NULL
	}
	if (hWnd && !DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hWnd=NULL;							// Set hWnd To NULL
	}
	if (!UnregisterClass("OpenGL",hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hInstance=NULL;									// Set hInstance To NULL
	}
}

BOOL CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;						// Holds The Results After Searching For A Match
	WNDCLASS	wc;							// Windows Class Structure
	DWORD		dwExStyle;						// Window Extended Style
	DWORD		dwStyle;						// Window Style

	RECT WindowRect;							// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left=(long)0;						// Set Left Value To 0
	WindowRect.right=(long)width;						// Set Right Value To Requested Width
	WindowRect.top=(long)0;							// Set Top Value To 0
	WindowRect.bottom=(long)height;						// Set Bottom Value To Requested Height

	fullscreen=fullscreenflag;						// Set The Global Fullscreen Flag

	hInstance		= GetModuleHandle(NULL);			// Grab An Instance For Our Window
	wc.style		= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;		// Redraw On Move, And Own DC For Window
	wc.lpfnWndProc		= (WNDPROC) WndProc;				// WndProc Handles Messages
	wc.cbClsExtra		= 0;						// No Extra Window Data
	wc.cbWndExtra		= 0;						// No Extra Window Data
	wc.hInstance		= hInstance;					// Set The Instance
	wc.hIcon		= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;						// No Background Required For GL
	wc.lpszMenuName		= NULL;						// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL";					// Set The Class Name

	if (!RegisterClass(&wc))						// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Exit And Return FALSE
	}

	if (fullscreen)								// Attempt Fullscreen Mode?
	{

		DEVMODE dmScreenSettings;					// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));		// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;			// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;			// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= bits;				// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{

			// If The Mode Fails, Offer Two Options.  Quit Or Run In A Window.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{

				fullscreen=FALSE;				// Select Windowed Mode (Fullscreen=FALSE)
			}
			else
			{

				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;					// Exit And Return FALSE
			}
		}
	}      

	if (fullscreen)								// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;					// Window Extended Style
		dwStyle=WS_POPUP;						// Windows Style
		ShowCursor(FALSE);						// Hide Mouse Pointer
	}
	else
	{

		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;					// Windows Style
	}
	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	if (!(hWnd=CreateWindowEx(	dwExStyle,				// Extended Style For The Window
					"OpenGL",				// Class Name
					title,					// Window Title
					WS_CLIPSIBLINGS |			// Required Window Style
					WS_CLIPCHILDREN |			// Required Window Style
					dwStyle,				// Selected Window Style
					0, 0,					// Window Position
					WindowRect.right-WindowRect.left,	// Calculate Adjusted Window Width
					WindowRect.bottom-WindowRect.top,	// Calculate Adjusted Window Height
					NULL,					// No Parent Window
					NULL,					// No Menu
					hInstance,				// Instance
					NULL)))					// Don't Pass Anything To WM_CREATE
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd=					// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),					// Size Of This Pixel Format Descriptor
		1,								// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,						// Must Support Double Buffering
		PFD_TYPE_RGBA,							// Request An RGBA Format
		bits,								// Select Our Color Depth
		0, 0, 0, 0, 0, 0,						// Color Bits Ignored
		0,								// Alpha Buffer
		0,								// Shift Bit Ignored
		0,								// No Accumulation Buffer
		0, 0, 0, 0,							// Accumulation Bits Ignored
		16,								// 16Bit Z-Buffer (Depth Buffer)
		1,								// Stencil Buffer!!!!!!
		0,								// No Auxiliary Buffer
		PFD_MAIN_PLANE,							// Main Drawing Layer
		0,								// Reserved
		0, 0, 0								// Layer Masks Ignored
	};

	if (!(hDC=GetDC(hWnd)))							// Did We Get A Device Context?
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))				// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))				// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	if (!(hRC=wglCreateContext(hDC)))					// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	if(!wglMakeCurrent(hDC,hRC))						// Try To Activate The Rendering Context
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}

	ShowWindow(hWnd,SW_SHOW);						// Show The Window
	SetForegroundWindow(hWnd);						// Slightly Higher Priority
	SetFocus(hWnd);								// Sets Keyboard Focus To The Window
	ReSizeGLScene(width, height);						// Set Up Our Perspective GL Screen

	if (!InitGL())								// Initialize Our Newly Created GL Window
	{
		KillGLWindow();							// Reset The Display
		MessageBox(NULL,"Initialization Failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;							// Return FALSE
	}
	return TRUE;								// Success
}






#ifdef SPHERES
void WaitNextHill()
{
	bool done = false;
	MSG	msg;
	RECT textRect;
	while(!done)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
			if (msg.message == WM_QUIT)
				done = TRUE;
			else {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} else {
			if (active)	{
				if (keys[VK_ESCAPE])
					done=TRUE;
				else {
					DrawGLScene2();
					SwapBuffers(hDC);
					ostringstream s;
					//s << globalX << '\n' << globalZ;
					
					//SetRect(&textRect, 0,0,200,100);
					//DrawText(hDC, s.str().c_str(), -1, &textRect, DT_TOP);
				}
			} else done = true;
		}

		CameraControls(keys);
		if (keys['G']) done = true;
	}
	int oldTime = GetMilliseconds();
	while(done) {
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
			if (msg.message == WM_QUIT)
				done = false;
			else {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} else {
			if (active)	{
				if (keys[VK_ESCAPE])
					done=false;
				else {
					DrawGLScene2();
					SwapBuffers(hDC);
				}
			} else done = false;
		}
		if (!keys['G'] || GetMilliseconds()-oldTime > 125) done = false;
	}
}
#else
void WaitNextHill()
{
}
#endif

bool * GetKeys()
{
	return keys;
}

bool GetKey(char key)
{
	return keys[key];
}

int GetMilliseconds()
{
	MMTIME timeThing;
	timeGetSystemTime(&timeThing, sizeof(timeThing));
	return timeThing.u.ms;
}