#include "textures.h"
//#include <windows.h>

AUX_RGBImageRec *LoadBMP(const char *Filename);					// Loads A Bitmap Image

GLuint	*textureObjects = NULL;
int		textureNum;

// okay, this function is completely RIPPED from the tutorial
AUX_RGBImageRec *LoadBMP(const char *Filename)					// Loads A Bitmap Image
{
	FILE *File=NULL;							// File Handle
	
	if (!Filename)								// Make Sure A Filename Was Given
	{
		return NULL;							// If Not Return NULL
	}
	
	File=fopen(Filename,"r");						// Check To See If The File Exists
	
	if (File)								// Does The File Exist?
	{
		fclose(File);							// Close The Handle
		return auxDIBImageLoad(Filename);				// Load The Bitmap And Return A Pointer
	}
	
	return NULL;								// If Load Failed Return NULL
}

GLTexture::GLTexture()
	: textureLoaded(false), maskUsed(false)
{}

GLTexture::GLTexture(char *fn, GLint f)
{
	fileName = fn;
	maskName.clear();
	filter = f;
	maskUsed = false;
	//LoadTexture(fileName, f);
}

GLTexture::GLTexture(char *fn, char *mn, GLint f)
{
	fileName = fn;
	maskName = mn;
	filter = f;
	maskUsed = true;
	//LoadTexture(fileName, maskName, f);
}

void GLTexture::SetTexture(char *fn, GLint f)
{
	fileName = fn;
	maskName.clear();
	filter = f;
	maskUsed = false;
}

void GLTexture::SetTexture(char *fn, char *mn, GLint f)
{
	filter = f;
	fileName = fn;
	maskName = mn;
	maskUsed = true;
}

GLuint & GLTexture::GetTextureID()
{
	return textureID;
}


bool GLTexture::UsingMask()
{
	return maskUsed;
}


bool LoadTextures(GLTexture **textures, int n)
{
	AUX_RGBImageRec **TextureImage;					// Create Storage Space For The Texture
	unsigned char **finalImage;
	int t, m, totalImages = 0,  maskNum = 0, i = 0;
	GLuint *textureObjects2 = textureObjects;
	
	textureNum = n;
	textureObjects = new GLuint [textureNum];
	
	// count non-masked textures and masked textures:
	for(i = 0; i < textureNum; ++i) {
		if (textures[i]->maskUsed) {
			++maskNum;
			totalImages += 2;
		} else
			totalImages++;
	}
	
	TextureImage = new AUX_RGBImageRec * [totalImages];
	finalImage = new unsigned char * [maskNum];
	
	memset(TextureImage,0,sizeof(void *)*totalImages);
	
	// load bitmaps and such:
	t = 0;
	m = 0;
	for(i = 0; i < textureNum; ++i) {
		if (textures[i]->maskUsed) {
			TextureImage[t]   = LoadBMP(textures[i]->fileName.c_str());
			TextureImage[t+1] = LoadBMP(textures[i]->maskName.c_str());
			finalImage[m]	  = new unsigned char [TextureImage[t]->sizeX*TextureImage[t]->sizeY*4];
			
			if (!TextureImage[t] || !TextureImage[t+1] || !finalImage[m]) return false;
			
			t += 2;
			++m;
		} else {
			TextureImage[t]   = LoadBMP(textures[i]->fileName.c_str());
			
			if (!TextureImage[t]) return false;
			++t;
		}
	}
	
	// create the masked images:
	
	t = 0;
	m = 0;
	for(i = 0; i < textureNum; ++i) {
		if (textures[i]->maskUsed) {
			int d1, d2;
			for(int y = 0; y < TextureImage[t]->sizeY; ++y) {
				for(int x = 0; x < TextureImage[t]->sizeX; ++x) {
					
					d1 = y*TextureImage[t]->sizeX*3 + x*3;
					d2 = y*TextureImage[t]->sizeX*4 + x*4;
					
					finalImage[m][d2] = TextureImage[t]->data[d1];
					finalImage[m][d2+1] = TextureImage[t]->data[d1+1];
					finalImage[m][d2+2] = TextureImage[t]->data[d1+2];
					finalImage[m][d2+3] = 255-TextureImage[t+1]->data[d1];
					
				}
			}
			t += 2;
			++m;
		} else
			++t;
	}
	glGenTextures(textureNum, textureObjects);					// Create The Texture
	
	t = 0;
	m = 0;
	for(i = 0; i < textureNum; ++i) {
		if (textures[i]->maskUsed) {
			
			// Typical Texture Generation Using Data From The Bitmap
			glBindTexture(GL_TEXTURE_2D, textureObjects[i]);
			
			if (textures[i]->filter >= GL_NEAREST_MIPMAP_NEAREST && textures[i]->filter <= GL_LINEAR_MIPMAP_LINEAR) {
				// Create MipMapped Texture
				if (textures[i]->filter == GL_NEAREST_MIPMAP_NEAREST || textures[i]->filter == GL_NEAREST_MIPMAP_LINEAR)
					glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
				else
					glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
				
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,textures[i]->filter);
				gluBuild2DMipmaps(GL_TEXTURE_2D, 4, TextureImage[t]->sizeX, TextureImage[t]->sizeY, GL_RGBA, GL_UNSIGNED_BYTE, finalImage[m]);
				
			} else {
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,textures[i]->filter);
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,textures[i]->filter);
			
				// Generate The Texture
				glTexImage2D(GL_TEXTURE_2D, 0, 4, TextureImage[t]->sizeX, TextureImage[t]->sizeY, 0, GL_RGBA, GL_UNSIGNED_BYTE, finalImage[m]);

			}
			t += 2;
			++m;
		} else {
			
			// Typical Texture Generation Using Data From The Bitmap
			glBindTexture(GL_TEXTURE_2D, textureObjects[i]);
			
			if (textures[i]->filter == GL_LINEAR_MIPMAP_NEAREST) {
				// Create MipMapped Texture
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
				gluBuild2DMipmaps(GL_TEXTURE_2D, 3, TextureImage[t]->sizeX, TextureImage[t]->sizeY, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[t]->data);
				
			} else {
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,textures[i]->filter);
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,textures[i]->filter);
			
				// Generate The Texture
				glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[t]->sizeX, TextureImage[t]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[t]->data);
				
			}
			++t;
		}
		textures[i]->textureID = textureObjects[i];
	}
	
	for(i = 0; i < totalImages; ++i) {
		if (TextureImage[i])							// If Texture Exists
		{
			if (TextureImage[i]->data)					// If Texture Image Exists
			{
				free(TextureImage[i]->data);				// Free The Texture Image Memory
			}

			free(TextureImage[i]);						// Free The Image Structure
		}
	}
	delete[] TextureImage;
	
	for(i = 0; i < maskNum; ++i)
		delete [] finalImage[i];
	
	delete [] finalImage;
	
	return true;								// Return The Status
}