
#ifndef _TEXTURES_H_
#define _TEXTURES_H_

#include <string>
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
//#include <gl/glaux.h>

using namespace std;

enum {
	kGrass		= 0,
	kFace		= 1,
	kBody		= 2,
	kArm		= 3,
	kWheel		= 4,
	kBrickWall	= 5,
	kShadow		= 6,
	kStar		= 7,
	kDirt		= 8,
	kSky		= 9,
	kPit		= 10,
	kSmiley		= 11,
	kBigSmiley	= 12
};


class GLTexture
{
public:
	
	friend bool LoadTextures(GLTexture **textures, int n);
	
	GLTexture();
	GLTexture(char *fn, GLint f = GL_LINEAR);
	GLTexture(char *fn, char *mn, GLint f = GL_LINEAR);
	
	GLuint & GetTextureID();
	bool	 UsingMask();
	
	void SetTexture(char *gn, GLint f = GL_LINEAR);
	void SetTexture(char *gn, char *mn, GLint f = GL_LINEAR);
	
	
private:
	
	int GLLoadTexture(char *fileName);
	int GLLoadMaskedTexture(char *fileName, char *maskName);
	GLint	filter;
	string	fileName;
	string	maskName;
	
	bool	textureLoaded;
	GLuint	textureID;
	bool	maskUsed;
	
};

#endif
