#ifndef _TERRAIN_H_
#define _TERRAIN_H_

#include "LazyPointer.h"
#include "game.h"

class NormalVector {
public:
	
	NormalVector() : phi(0), theta(0) {};
	NormalVector(double p, double t) : phi(p), theta(t) {};
	
	void Set(double p, double t) {phi = p; theta = t;};
	void Add(double dp, double dt);
	void Subtract(double dp, double dt);
	void Convert(double &x, double &y, double &z) const;
	
	double phi;
	double theta;
	
};


class TriangleNode {
public:
	Triangle tri;
	
	TriangleNode *next;
	TriangleNode *arrayNext;
	TriangleNode *arrayPrev;
};

class HillPiece {
public:
	
	HillPiece() : normal(0,0), cuts(0L), resizedCuts(0L) {};
	
	float x;
	float y;
	float z;
	/*
	float x;
	float y;
	float z;
	*/
	NormalVector normal;
	
	float r;
	float g;
	float b;
	/*
	double texYBegin;
	double texYEnd;
	double texXBegin;
	double texXEnd;
	*/
	
	
	float texX;
	float texY;
	
	//float texX;
	//float texY;
	
	bool created;
	bool positiveCreated;
	
	bool cut;
	
	bool onPit;
	bool onPitSimplified;
	TriangleNode *cuts;
	TriangleNode *resizedCuts;
	bool yCalculated;
	bool yCalculatedSimplified;
	
	void CalculateShadow();
	void DoStuffAfterHillPieceIsMade();
	void CutPits(int x, int z);
	//void LogTerrain();
};



// hill stuff:

void CreateTerrain();
void InitHill();
void DestroyHill();
void ConstructTerrain();
void DrawTerrain();
void CreateTerrainLists();
void DrawTerrainAroundPits();
void CameraControls(bool *keys);
double minYValue(double x, double z);
void CreateMoreTerrain(double ox, double oz);
void GetTerrainPiece(double xLoc, double zLoc, int &x, int &z);
bool OnTerrain(int x, int z);
double NumFromSeed(unsigned int seed);
bool InSight(double x, double z);
unsigned int FindSeed(int x, int y);
void DrawInvisiblePolygons();


void CreatePitList();
void DrawPitInnards();

// debugging:
void GetOffsetCoords(double &x, double &z);

void CreateForwardTerrainX(HillPiece &newHill, const HillPiece &px);
void CreateForwardTerrainZ(HillPiece &newHill, const HillPiece &pz);
void CreateForwardTerrainXZ(HillPiece &newHill, const HillPiece &px, const HillPiece &pz);

void CreateBackwardTerrainX(HillPiece &newHill, const HillPiece &nx);
void CreateBackwardTerrainZ(HillPiece &newHill, const HillPiece &nz);
void CreateBackwardTerrainXZ(HillPiece &newHill, const HillPiece &nx, const HillPiece &nz);

void CalculateNormals(float *normal, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
double findPreviousPhi(double phi2, double minDelta, double maxDelta, double r, double order);


#endif