
#include <math.h>
#include <time.h>
#include <fstream>

#include "external.h"
#include "openglstuff.h"
#include "textures.h"
#include "terrain.h"
#include "game.h"
#include "drawstuff.h"


/*class Node {
public:
	int data;
	Node *next;
};*/



void NewVertex(int x, int z);
void NewVertex(int x, int z, double dx, double dy, double dz);
void NewVertex(Point p);
void NewVertex(double dx, double dy, double dz);
void NewInvisibleVertex(double dx, double dy, double dz);
void NewPolygon();
bool between(double a, double b, double c);
bool PointInRect(Point point, double left, double top, double right, double bottom);
bool CutTriangle(const Triangle &tri, const Quadrilateral &rect, Triangle *results, int &resultOn);
void AddTriangleNode(TriangleNode **head, const Triangle &tri);
void CutPits(int x, int z);
void GetEdges(const Triangle &tri);

// debug:
extern float debug1, debug2;

GLdouble pitDepth = 25;

using namespace std;

#define TRIANGLES

extern Camera camera;
extern GLTexture *textures;
extern GLUquadricObj *quadratic;
extern UnicycleGuy guy;
//extern int	newPitNum;
//extern Pit	**newPits = NULL;
extern Pit	*pits, *firstPit;
extern int  currentPitNum;

extern bool superFog;

#define MAXEDGES 100000
Edge	pitEdges[MAXEDGES];
int		edgeNum = 0;

GLfloat	pitVertices[MAXEDGES*4*4];
GLfloat pitColors[MAXEDGES*4*4];
GLfloat pitTexCoords[MAXEDGES*4*2];
int		pitVertexNum = 0;

const double pi = 3.141592653589;
const double twoPi = pi*2;
const double piOver180 = pi / 180.0;



HillPiece **terrain;

GLfloat *vertices = NULL;
GLfloat *invisVertices = NULL;
GLfloat *invisColors = NULL;
GLfloat *colors = NULL;
GLfloat *textureCoords = NULL;
GLuint *triangles = NULL;

unsigned long pointNum;

long *vertexPointers = NULL;

//Node *polygonGrid;

GLuint *vertexNumbers = NULL;
int vertexNum;
int invisVertexNum;


double		maxSlope = 1.5;
double		maxSlopeAccel = 0.2;
double		slopeOrder = 1;

double		minDeltaTheta = 0.02;
double		maxDeltaTheta = 0.03;//pi/4;
double		maxPhi = atan(maxSlope);
double		maxDeltaPhi = atan(maxSlopeAccel);

const double sqrtTwo = sqrt(2.0);

int		terrainSize = 200;
int		terrainSeed;
double spacing = 2;

int		terrainLength = terrainSize*spacing;

double textureScale = 0.0625*spacing;

NormalVector lightAngle;

int xDrawOffset = 0, zDrawOffset = 0;

int oldXPos = 0, oldZPos = 0;
bool initializeOldPos;
double xOffset, zOffset;


extern int targetFPS;
extern double		normalSpeed;
extern double		wallsPerUnitArea;
extern double	maxVSpeed;
extern double	minSpeed;
extern int		airHoldTime, wallDealy;
extern double	gravity;

extern bool fullscreen;
//extern bool danderDingy;

GLuint pitDisplayList, pitBlacknessList;

bool reconstructTerrain;


void DoSillyThing(int i);



double GetY(int x, int z)
{
	x = x%terrainSize;
	z = z%terrainSize;
	if (x < 0) x += terrainSize;
	if (z < 0) z += terrainSize;
	
	return terrain[x][z].y;
	//return vertices[(x*terrainSize+z)*3+1];
}


void ConstructTerrain()
{
	int x, z, nx, nz, triangleNum, p = 0;
	bool oddPolygon = true, dontDraw = false, simplified = false, atEdge, adjusted;
	Pit *pit;
	//bool goodToDraw;
	//double slope;
	//double cx, cz, mx, mz;
	
	debug2 = sizeof(TriangleNode);
	
	if (!reconstructTerrain)
		return;
	
	reconstructTerrain = false;
	
	double x1,x2,x3,x4,y1,y2,y3,y4,z1,z2,z3,z4, xDist, zDist;
	double simplifyDistance = terrainLength*0.3;
	TriangleNode *cursor;
	//Node *toBeDeleted, *cursor;
	
	Triangle results[4], results2[4], tri1, tri2;
	bool anything, anything2, onPit;
	int resultNum, resultNum2;
	TriangleNode *cuts, *prev, *toBeDeleted;
						
	
	// reset vertexPointers with -1
	memset(vertexPointers, 0xFF, terrainSize * terrainSize * sizeof(long));
	
	edgeNum = 0;
	triangleNum = 0;
	invisVertexNum = pointNum = vertexNum = 0;
	z = zDrawOffset;
	
	// reset polygonGrid:
	
	/*
	for(int i = 0; i < terrainSize*terrainSize; ++i) {
		polygonGrid[i].data = -1;
		cursor = polygonGrid[i].next;
		while(cursor != NULL) {
			toBeDeleted = cursor;
			cursor = cursor->next;
			delete toBeDeleted;
		}
	}*/
	
	
	/*
	glPushMatrix();
	glScalef(spacing, spacing, spacing);
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	
	glBegin(GL_TRIANGLES);
	*/
	
	
	for(int za = 0; za < terrainSize-1; ++za) {
		
		x = xDrawOffset;
		
		for(int xa = 0; xa < terrainSize-1; ++xa) {
			
			oddPolygon = false;
			dontDraw = false;
			
			if (x%2 == 0)
				nx = x;
			else {
				oddPolygon = true;
				nx = (x-1)%terrainSize;
				if (nx < 0) nx += terrainSize;
			}
			if (z%2 == 0)
				nz = z;
			else {
				oddPolygon = true;
				nz = (z-1)%terrainSize;
				if (nz < 0) nz += terrainSize;
			}
			
			x1 = terrain[nx][nz].x;
			y1 = terrain[nx][nz].y;
			z1 = terrain[nx][nz].z;
			
			xDist = abs((guy.x-spacing) - x1*spacing);
			zDist = abs((guy.z-spacing) - z1*spacing);
			
			
			atEdge = (xa == terrainSize-2 || za == terrainSize-2);
			
			if ((xDist > simplifyDistance || zDist > simplifyDistance) && !atEdge) {
				dontDraw = oddPolygon;
				nx = (x+2)%terrainSize;
				nz = (z+2)%terrainSize;
				if (nx < 0) nx += terrainSize;
				if (nz < 0) nz += terrainSize;
				simplified = true;
			} else {
				if (atEdge) dontDraw = true;
				nx = (x+1)%terrainSize;
				nz = (z+1)%terrainSize;
				if (nx < 0) nx += terrainSize;
				if (nz < 0) nz += terrainSize;
				simplified = false;
			}
			if (xDist*xDist + zDist*zDist > terrainLength*terrainLength*0.26) dontDraw = true;
			
			if (!dontDraw) {
				
				x1 = terrain[x][z].x;		y1 = terrain[x][z].y;		z1 = terrain[x][z].z;
				x2 = terrain[x][nz].x;		y2 = terrain[x][nz].y;		z2 = terrain[x][nz].z;
				x3 = terrain[nx][nz].x;		y3 = terrain[nx][nz].y;		z3 = terrain[nx][nz].z;
				x4 = terrain[nx][z].x;		y4 = terrain[nx][z].y;		z4 = terrain[nx][z].z;
				
				if (simplified) {
					
					if (terrain[x][z].onPitSimplified) {
					
						NewInvisibleVertex(x1,y1,z1);
						NewInvisibleVertex(x2,y2,z2);
						NewInvisibleVertex(x3,y3,z3);
						
						NewInvisibleVertex(x3,y3,z3);
						NewInvisibleVertex(x4,y4,z4);
						NewInvisibleVertex(x1,y1,z1);
						
						cursor = terrain[x][z].resizedCuts;
						
						while(cursor != NULL) {
							if (!terrain[x][z].yCalculated) {
								cursor->tri.points[0].y = minYValue(cursor->tri.points[0].x, cursor->tri.points[0].z);
								cursor->tri.points[1].y = minYValue(cursor->tri.points[1].x, cursor->tri.points[1].z);
								cursor->tri.points[2].y = minYValue(cursor->tri.points[2].x, cursor->tri.points[2].z);
							}
							//NewVertex(cursor->tri.points[0].x / spacing, cursor->tri.points[0].y / spacing, cursor->tri.points[0].z / spacing);
							//NewVertex(cursor->tri.points[1].x / spacing, cursor->tri.points[1].y / spacing, cursor->tri.points[1].z / spacing);
							//NewVertex(cursor->tri.points[2].x / spacing, cursor->tri.points[2].y / spacing, cursor->tri.points[2].z / spacing);
							NewVertex(cursor->tri.points[0]);
							NewVertex(cursor->tri.points[1]);
							NewVertex(cursor->tri.points[2]);
							
							GetEdges(cursor->tri);
							
							cursor = cursor->next;
						}
						terrain[x][z].yCalculatedSimplified = true;
					} else {
						NewVertex(x, z);
						NewVertex(x, nz);
						NewVertex(nx, nz);
						
						NewVertex(nx, nz);
						NewVertex(nx, z);
						NewVertex(x, z);
					}
					/*
					glColor3f(1,0.5,0.5);
					glVertex3f(x1,y1,z1);
					glColor3f(1,1,0.5);
					glVertex3f(x2,y2,z2);
					glColor3f(0.5,1,0.5);
					glVertex3f(x3,y3,z3);
					glColor3f(0.5,1,1);
					glVertex3f(x3,y3,z3);
					glColor3f(0.5,0.5,1);
					glVertex3f(x4,y4,z4);
					glColor3f(1,0.5,1);
					glVertex3f(x1,y1,z1);*/
				} else {
					
					/*
					 1  4
					 
					 2  3
					 
					 This next bit is pretty complicated - it's the part that adjusts the non-simplified terrain
					 so that polygons on the edge of the non-simplified area fit with the polygons on the edge
					 of the simplified area.  Trust me, it works.
					*/
					
					adjusted = false;
					
					glColor3f(0,0,1);
					// Check for top being next to simplified
					if ( abs((guy.z-spacing) - (( z1-(1+(1-z%2)) )*spacing)) > simplifyDistance) {
						adjusted = true;
						if (x%2 == 0)
							y4 = (y1 + GetY(x+2,z))/2.0;
						else
							y1 = (y4 + GetY(x-1,z))/2.0;
						
					}
					
					
					// Check for bottom being next to simplified
					if ( abs((guy.z-spacing) - (( z2-(1-z%2) )*spacing)) > simplifyDistance) {
						adjusted = true;
						if (x%2 == 0)
							y3 = (y2 + GetY(x+2,z+1))/2.0;
						else
							y2 = (y3 + GetY(x-1,z+1))/2.0;
					}
						
					// Check for left being next to simplified
					if ( abs((guy.x-spacing) - (( x1-(1+(1-x%2)) )*spacing)) > simplifyDistance) {
						adjusted = true;
						if (z%2 == 0)
							y2 = (y1 + GetY(x,z+2))/2.0;
						else
							y1 = (y2 + GetY(x,z-1))/2.0;
						
					}
					// Check for right being next to simplified.  Trust me, this works...
					if ( abs((guy.x-spacing) - (( x2-(1-x%2 - 1) )*spacing)) > simplifyDistance) {
						adjusted = true;
						if (z%2 == 0)
							y3 = (y4 + GetY(x+1,z+2))/2.0;
						else
							y4 = (y3 + GetY(x+1,z-1))/2.0;
					}
					//adjusted = true;
					if (adjusted) {
						//double thingy = double(int(y1)%15)/15.0;
						//if (thingy < 0) thingy += 1.0;
						//glColor3f(thingy, thingy, thingy);
						/*glColor3fv(colors + (x*terrainSize+z)*3);
						glTexCoord2fv(textureCoords + (x*terrainSize+z)*2);
						glVertex3f(x1,y1,z1);
						glColor3fv(colors + (x*terrainSize+nz)*3);
						glTexCoord2fv(textureCoords + (x*terrainSize+nz)*2);
						glVertex3f(x2,y2,z2);
						glColor3fv(colors + (nx*terrainSize+nz)*3);
						glTexCoord2fv(textureCoords + (nx*terrainSize+nz)*2);
						glVertex3f(x3,y3,z3);
						
						glColor3fv(colors + (nx*terrainSize+nz)*3);
						glTexCoord2fv(textureCoords + (nx*terrainSize+nz)*2);
						glVertex3f(x3,y3,z3);
						glColor3fv(colors + (nx*terrainSize+z)*3);
						glTexCoord2fv(textureCoords + (nx*terrainSize+z)*2);
						glVertex3f(x4,y4,z4);
						glColor3fv(colors + (x*terrainSize+z)*3);
						glTexCoord2fv(textureCoords + (x*terrainSize+z)*2);
						glVertex3f(x1,y1,z1);*/
						/*
						glColor3f(1,0,0);
						glVertex3f(x1,y1,z1);
						glColor3f(1,1,0);
						glVertex3f(x2,y2,z2);
						glColor3f(0,1,0);
						glVertex3f(x3,y3,z3);
						glColor3f(0,1,1);
						glVertex3f(x3,y3,z3);
						glColor3f(0,0,1);
						glVertex3f(x4,y4,z4);
						glColor3f(1,0,1);
						glVertex3f(x1,y1,z1);
						*/
						/*
						tri1.points[0].x = x*spacing;	tri1.points[0].z = z*spacing;
						tri1.points[1].x = x*spacing;	tri1.points[1].z = nz*spacing;
						tri1.points[2].x = nx*spacing;	tri1.points[2].z = nz*spacing;
						
						tri2.points[0].x = nx*spacing;	tri2.points[0].z = nz*spacing;
						tri2.points[1].x = nx*spacing;	tri2.points[1].z = z*spacing;
						tri2.points[2].x = x*spacing;	tri2.points[2].z = z*spacing;
						*/
						
						tri1.points[0].x = x1*spacing;
						tri1.points[0].z = z1*spacing;
						tri1.points[0].texX = terrain[x][z].texX;
						tri1.points[0].texY = terrain[x][z].texY;
						
						tri1.points[1].x = x2*spacing;
						tri1.points[1].z = z2*spacing;
						tri1.points[1].texX = terrain[x][z].texX + textureScale/2;
						tri1.points[1].texY = terrain[x][z].texY;
						
						tri1.points[2].x = x3*spacing;
						tri1.points[2].z = z3*spacing;
						tri1.points[2].texX = terrain[x][z].texX;
						tri1.points[2].texY = terrain[x][z].texY + textureScale/2;
						
						tri2.points[0].x = x3*spacing;
						tri2.points[0].z = z3*spacing;
						tri2.points[0].texX = terrain[x][z].texX + textureScale/2;
						tri2.points[0].texY = terrain[x][z].texY + textureScale/2;
						
						tri2.points[1].x = x4*spacing;
						tri2.points[1].z = z4*spacing;
						tri2.points[1].texX = terrain[x][z].texX + textureScale/2;
						tri2.points[1].texY = terrain[x][z].texY;
						
						tri2.points[2].x = x1*spacing;
						tri2.points[2].z = z1*spacing;
						tri2.points[2].texX = terrain[x][z].texX;
						tri2.points[2].texY = terrain[x][z].texY + textureScale/2;
						
						tri1.points[0].r = terrain[x][z].r;
						tri1.points[1].r = terrain[nx][z].r;
						tri1.points[2].r = terrain[x][nz].r;
						tri2.points[0].r = terrain[nx][nz].r;
						tri2.points[1].r = terrain[nx][z].r;
						tri2.points[2].r = terrain[x][nz].r;
	
						cuts = NULL;
						onPit = false;
						
						pit = firstPit;
						
						for(int i = 0; i < currentPitNum && pit; ++i) {
							
							//if (guy.x < -10)
							//	x1 = x1;
							
							//if (x*spacing >= pit->minX-spacing && x*spacing <= pit->maxX && z*spacing >= pit->minZ-spacing && z*spacing <= pit->maxZ) {
							if (x1*spacing >= pit->minX-spacing && x1*spacing <= pit->maxX && z1*spacing >= pit->minZ-spacing && z1*spacing <= pit->maxZ) {
								
								if (!onPit) {
									
									anything = CutTriangle(tri1, pit->corners, results, resultNum);
									anything2 = CutTriangle(tri2, pit->corners, results2, resultNum2);
									if (anything || anything2) {
										for(int i = 0; i < resultNum; ++i)
											AddTriangleNode(&cuts, results[i]);
										for(int i = 0; i < resultNum2; ++i)
											AddTriangleNode(&cuts, results2[i]);
										
										onPit = true;
									}
								} else {
									
									cursor = cuts;
									prev = NULL;
									while(cursor != NULL) {
										
										if (CutTriangle(cursor->tri, pit->corners, results, resultNum)) {
											if (resultNum > 0) {
												cursor->tri.points[0] = results[0].points[0];
												cursor->tri.points[1] = results[0].points[1];
												cursor->tri.points[2] = results[0].points[2];
												
												for(int i = 1; i < resultNum; ++i)
													AddTriangleNode(&cuts, results[i]);
												
												prev = cursor;
												cursor = cursor->next;
											} else {
												// triangle piece is gone; delete it
												if (prev == NULL) {
													cuts = cuts->next;
													delete cursor;
													cursor = cuts;
													--debug1;
												} else {
													toBeDeleted = cursor;
													cursor = cursor->next;
													prev->next = cursor;
													delete toBeDeleted;
													--debug1;
												}
											}
										} else {
											prev = cursor;
											cursor = cursor->next;
										}
									}
								}
							}
							
							pit = pit->next;
						}
						if (!onPit) {
							NewVertex(x,   z, x1,y1,z1);
							NewVertex(x,  nz, x2,y2,z2);
							NewVertex(nx, nz, x3,y3,z3);
							
							NewVertex(nx, nz, x3,y3,z3);
							NewVertex(nx,  z, x4,y4,z4);
							NewVertex(x,   z, x1,y1,z1);
						} else {
							
							NewInvisibleVertex(x1,y1,z1);
							NewInvisibleVertex(x2,y2,z2);
							NewInvisibleVertex(x3,y3,z3);
							
							NewInvisibleVertex(x3,y3,z3);
							NewInvisibleVertex(x4,y4,z4);
							NewInvisibleVertex(x1,y1,z1);
							
							cursor = cuts;
							while(cursor != NULL) {
								
								cursor->tri.points[0].y = minYValue(cursor->tri.points[0].x, cursor->tri.points[0].z);
								cursor->tri.points[1].y = minYValue(cursor->tri.points[1].x, cursor->tri.points[1].z);
								cursor->tri.points[2].y = minYValue(cursor->tri.points[2].x, cursor->tri.points[2].z);
								
								NewVertex(cursor->tri.points[0]);
								NewVertex(cursor->tri.points[1]);
								NewVertex(cursor->tri.points[2]);
								
								GetEdges(cursor->tri);
								
								toBeDeleted = cursor;
								cursor = cursor->next;
								delete toBeDeleted;
								--debug1;
							}
						}
						
						
					} else {
						if (terrain[x][z].onPit) {
							NewInvisibleVertex(x1,y1,z1);
							NewInvisibleVertex(x2,y2,z2);
							NewInvisibleVertex(x3,y3,z3);
							
							NewInvisibleVertex(x3,y3,z3);
							NewInvisibleVertex(x4,y4,z4);
							NewInvisibleVertex(x1,y1,z1);
							
							cursor = terrain[x][z].cuts;
							
							while(cursor != NULL) {
								if (!terrain[x][z].yCalculated) {
									cursor->tri.points[0].y = minYValue(cursor->tri.points[0].x, cursor->tri.points[0].z);
									cursor->tri.points[1].y = minYValue(cursor->tri.points[1].x, cursor->tri.points[1].z);
									cursor->tri.points[2].y = minYValue(cursor->tri.points[2].x, cursor->tri.points[2].z);
								}
								//NewVertex(cursor->tri.points[0].x / spacing, cursor->tri.points[0].y / spacing, cursor->tri.points[0].z / spacing);
								//NewVertex(cursor->tri.points[1].x / spacing, cursor->tri.points[1].y / spacing, cursor->tri.points[1].z / spacing);
								//NewVertex(cursor->tri.points[2].x / spacing, cursor->tri.points[2].y / spacing, cursor->tri.points[2].z / spacing);
								NewVertex(cursor->tri.points[0]);
								NewVertex(cursor->tri.points[1]);
								NewVertex(cursor->tri.points[2]);
								
								GetEdges(cursor->tri);
								
								cursor = cursor->next;
							}
							terrain[x][z].yCalculated = true;
						} else {
							NewVertex(x, z);
							NewVertex(x, nz);
							NewVertex(nx, nz);
							
							NewVertex(nx, nz);
							NewVertex(nx, z);
							NewVertex(x, z);
						}
						/*
						glColor3f(0.5,0,0);
						glVertex3f(x1,y1,z1);
						glColor3f(0.5,0.5,0);
						glVertex3f(x2,y2,z2);
						glColor3f(0,0.5,0);
						glVertex3f(x3,y3,z3);
						glColor3f(0,0.5,0.5);
						glVertex3f(x3,y3,z3);
						glColor3f(0,0,0.5);
						glVertex3f(x4,y4,z4);
						glColor3f(0.5,0,0.5);
						glVerte3f(x1,y1,z1);*/

					}
				}
			}
			++x;
			if (x > terrainSize-1) x = 0;
			
		}
		++z;
		if (z > terrainSize-1) z = 0;
	}
	
	//glEnd();
	//glPopMatrix();
	
	CreatePitList();
	
	
}

void DrawTerrain()
{
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	
	// calculate alpha values:
	
	if (superFog) {
		for(int i = 0; i < pointNum; ++i)
			colors[i*4+3] = calculateFog(vertices[i*3]*spacing, vertices[i*3+1]*spacing, vertices[i*3+2]*spacing);
		
	}// else
	//	glColorPointer (3, GL_FLOAT, sizeof(GL_FLOAT), colors);
	glColorPointer (4, GL_FLOAT, 0, colors);
	
	glTexCoordPointer (2, GL_FLOAT, 0, textureCoords);
	glVertexPointer (3, GL_FLOAT, 0, vertices);
	
	glPushMatrix();
	glScalef(spacing, spacing, spacing);
	
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kGrass].GetTextureID());
	
	glDrawElements(GL_TRIANGLES, vertexNum, GL_UNSIGNED_INT, vertexNumbers);
	
	glPopMatrix();
}

void DrawInvisiblePolygons()
{
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	
	glDisable(GL_LIGHTING);
	glDisable(GL_COLOR_MATERIAL);
	
	//glColorMask(0,0,0,0);
	if (superFog) {
		for(int i = 0; i < invisVertexNum; ++i)
			invisColors[i*4+3] = calculateFog(invisVertices[i*3]*spacing, invisVertices[i*3+1]*spacing, invisVertices[i*3+2]*spacing);
		
	}
	
	glColorPointer (4, GL_FLOAT, 0, invisColors);
	glVertexPointer (3, GL_FLOAT, 0, invisVertices);
	glColor3f(0,0,0);
	
	glPushMatrix();
	glScalef(spacing, spacing, spacing);
	
	glDrawArrays(GL_TRIANGLES, 0, invisVertexNum);
	
	glPopMatrix();
	
	
	//glColorMask(1,1,1,1);
}

void NewPolygon()
{
	int i, n;
	
	//return;
	double x ,z;
	
	i = (vertexNum/3)-1;
	
	x = vertices[vertexNumbers[i]*3] - terrain[xDrawOffset][0].x;
	if (x < 0 || x >= terrainSize) return;
	
	z = vertices[vertexNumbers[i]*3+2] - terrain[0][zDrawOffset].z;
	if (z < 0 || z >= terrainSize) return;
	
	n = terrainSize*z + x;
	
	//polygonGrid[n].data = i;
	/*blah = new Node;
	blah->data = i;
	
	if (polygonGrid[n] == NULL) {
		polygonGrid[n] = blah;
		polygonGrid[n]->next = NULL;
	} else {
		blah->next = polygonGrid[n];
		polygonGrid[n] = blah;
	}*/
}

void NewVertex(int x, int z)
{
	double blah;
	if (vertexPointers[(z*terrainSize)+x] == -1) {
		blah = terrain[x][z].x;
		blah = terrain[x][z].y;
		blah = terrain[x][z].z;
		vertices[pointNum*3] = terrain[x][z].x;
		vertices[pointNum*3+1] = terrain[x][z].y;
		vertices[pointNum*3+2] = terrain[x][z].z;
		colors[pointNum*4] = terrain[x][z].r;
		colors[pointNum*4+1] = terrain[x][z].g;
		colors[pointNum*4+2] = terrain[x][z].b;
		colors[pointNum*4+3] = 1;
		textureCoords[pointNum*2] = terrain[x][z].texX;
		textureCoords[pointNum*2+1] = terrain[x][z].texY;
		
		vertexPointers[(z*terrainSize)+x] = pointNum;
		
		vertexNumbers[vertexNum] = pointNum;
		++pointNum;
		++vertexNum;
	} else {
		vertexNumbers[vertexNum] = vertexPointers[(z*terrainSize)+x];
		++vertexNum;
	}
	//if (vertexNum%3 == 0)
	//	NewPolygon();
}

void NewVertex(int x, int z, double dx, double dy, double dz)
{
	vertices[pointNum*3] = dx;
	vertices[pointNum*3+1] = dy;
	vertices[pointNum*3+2] = dz;
	colors[pointNum*4] = terrain[x][z].r;
	colors[pointNum*4+1] = terrain[x][z].g;
	colors[pointNum*4+2] = terrain[x][z].b;
	colors[pointNum*4+3] = 1;
	textureCoords[pointNum*2] = terrain[x][z].texX;
	textureCoords[pointNum*2+1] = terrain[x][z].texY;
	
	vertexNumbers[vertexNum] = pointNum;
	++pointNum;
	++vertexNum;
	
	//if (vertexNum%3 == 0)
	//	NewPolygon();
}

void NewVertex(double dx, double dy, double dz)
{
	vertices[pointNum*3] = dx;
	vertices[pointNum*3+1] = dy;
	vertices[pointNum*3+2] = dz;
	colors[pointNum*4] = 1;
	colors[pointNum*4+1] = 1;
	colors[pointNum*4+2] = 1;
	colors[pointNum*4+3] = 1;
	textureCoords[pointNum*2] = 1;
	textureCoords[pointNum*2+1] = 1;
	
	vertexNumbers[vertexNum] = pointNum;
	++pointNum;
	++vertexNum;
	
	//if (vertexNum%3 == 0)
	//	NewPolygon();
}

void NewVertex(Point p)
{
	vertices[pointNum*3] = p.x / spacing;
	vertices[pointNum*3+1] = p.y / spacing;
	vertices[pointNum*3+2] = p.z / spacing;
	colors[pointNum*4] = p.r;
	colors[pointNum*4+1] = p.r;
	colors[pointNum*4+2] = p.r;
	colors[pointNum*4+3] = 1;
	textureCoords[pointNum*2] = p.x * (textureScale/4);
	textureCoords[pointNum*2+1] = p.z * (textureScale/4);
	
	vertexNumbers[vertexNum] = pointNum;
	++pointNum;
	++vertexNum;
	
	//if (vertexNum%3 == 0)
	//	NewPolygon();
}


void NewInvisibleVertex(double dx, double dy, double dz)
{
	invisVertices[invisVertexNum*3] = dx;
	invisVertices[invisVertexNum*3+1] = dy-2;
	invisVertices[invisVertexNum*3+2] = dz;
	
	++invisVertexNum;
	
	//if (vertexNum%3 == 0)
	//	NewPolygon();
}


bool InputPrompt()
{
	fstream file;
	char yn;
	file.open("prefs.txt", ios::in);
	
	file >> terrainSize;
	file >> targetFPS;
	file >> fullscreen;
	file >> maxSlope;
	file >> maxSlopeAccel;
	file >> slopeOrder;
	
	file >> spacing;
	file >> textureScale;
	
	file >> yn;
	
	if (yn == 'y' || yn == 'Y') {
		file >> normalSpeed;
		file >> wallsPerUnitArea;
		
		file >> airHoldTime;
		
		file >> gravity;
		file >> maxVSpeed;
		//danderDingy = false;
	}// else
		//danderDingy = true;
	file.close();
	return true;
}
/*
bool InputPrompt()
{
	cout << "\n\nTarget frames per second: ";
	cin >> targetFPS;
	cout << "\nFull screen? (1/0) ";
	cin >> fullscreen;
	cout << "\nMax slope: ";
	cin >> maxSlope;
	cout << "\nMax slope acceleration: ";
	cin >> maxSlopeAccel;
	cout << "\nSlope power order: ";
	cin >> slopeOrder;
	
	cout << "\nTerrain polygon spacing (pick 1?): ";
	cin >> spacing;
	cout << "\nTexture scale? (pick 1?): ";
	cin >> textureScale;
	
	cout << "\nUse default movement value thingies? (y/n) ";
	char yn;
	cin >> yn;
	
	if (yn == 'y' || yn == 'Y') {
		cout << "\nNormal unicycle guy speed: ";
		cin >> normalSpeed;
		cout << "\nWalls per unit area: ";
		cin >> wallsPerUnitArea;
		
		cout << "\nAir linear-travel time dealy: ";
		cin >> airHoldTime;
		
		cout << "\nGravity? ";
		cin >> gravity;
		cout << "\nUpward initial v-speed? ";
		cin >> maxVSpeed;
		
	} else if (yn != 'n' || yn != 'N') {
		cout << "And your an idiot.";
		return false;
	}
	int number;
	cout << "\nWhat's 1+5? ";
	cin >> number;
	if (number != 6) {
		cout << "And you're an idiot.";
		return false;
	}
	return true;
}
*/

void CreateMoreTerrain(double ox, double oz)
{
	int xPos, zPos;
	HillPiece p;
	int x,z,xi,zi,px,pz,nx,nz;
	
	xPos = int(ox)/spacing;
	zPos = int(oz)/spacing;
	
	if (initializeOldPos) {
		oldXPos = xPos;
		oldZPos = zPos;
		initializeOldPos = false;
	}
	
	xOffset = xPos-oldXPos;
	zOffset = zPos-oldZPos;
	
	DoDeviousThings(xOffset, zOffset);
	
	if (xOffset != 0) {
		reconstructTerrain = true;
		//camera.x -= s * xOffset;
		
		if (xOffset > 0) {
			
			for(int i = 0; i < xOffset; ++i) {
				z = zDrawOffset;
				for(zi = 0; zi < terrainSize; ++zi) {
					pz = z-1;
					if (pz < 0) pz = terrainSize-1;
					if (xDrawOffset-1 < 0)
						terrain[xDrawOffset][z].x = terrain[terrainSize-1][z].x+1;
					else
						terrain[xDrawOffset][z].x = terrain[xDrawOffset-1][z].x+1;
					if (zi == 0) {
						if (xDrawOffset-1 < 0)
							CreateForwardTerrainX(terrain[xDrawOffset][z], terrain[terrainSize-1][z]);
						else
							CreateForwardTerrainX(terrain[xDrawOffset][z], terrain[xDrawOffset-1][z]);
					} else {
						if (xDrawOffset-1 < 0)
							CreateForwardTerrainXZ(terrain[xDrawOffset][z], terrain[terrainSize-1][z], terrain[xDrawOffset][pz]);
						else
							CreateForwardTerrainXZ(terrain[xDrawOffset][z], terrain[xDrawOffset-1][z], terrain[xDrawOffset][pz]);
					}
					
					++z;
					if (z > terrainSize-1) z = 0;
				}
				++xDrawOffset;
				if (xDrawOffset > terrainSize-1) xDrawOffset = 0;
				
				
				
			}
		} else {
			
			for(int i = 0; i < -xOffset; ++i) {
				z = zDrawOffset-1;
				if (z < 0) z = terrainSize-1;
				
				for(zi = 0; zi < terrainSize; ++zi) {
					nz = z+1;
					if (nz > terrainSize-1) nz = 0;
					
					if (xDrawOffset-1 < 0)
						terrain[terrainSize-1][z].x = terrain[xDrawOffset][z].x-1;
					else
						terrain[xDrawOffset-1][z].x = terrain[xDrawOffset][z].x-1;
					
					if (zi == 0) {
						if (xDrawOffset-1 < 0)
							CreateBackwardTerrainX(terrain[terrainSize-1][z], terrain[xDrawOffset][z]);
						else
							CreateBackwardTerrainX(terrain[xDrawOffset-1][z], terrain[xDrawOffset][z]);
					} else {
						if (xDrawOffset-1 < 0)
							CreateBackwardTerrainXZ(terrain[terrainSize-1][z], terrain[xDrawOffset][z], terrain[terrainSize-1][nz]);
						else
							CreateBackwardTerrainXZ(terrain[xDrawOffset-1][z], terrain[xDrawOffset][z], terrain[xDrawOffset-1][nz]);
					}
					
					--z;
					if (z < 0) z = terrainSize-1;
					
				}
				--xDrawOffset;
				if (xDrawOffset < 0) xDrawOffset = terrainSize-1;
			}
		}
	}
	if (zOffset != 0) {
		reconstructTerrain = true;
		//camera.x -= spacing * xOffset;
		
		if (zOffset > 0) {
			
			for(int i = 0; i < zOffset; ++i) {
				x = xDrawOffset;
				for(xi = 0; xi < terrainSize; ++xi) {
					px = x-1;
					if (px < 0) px = terrainSize-1;
					if (zDrawOffset-1 < 0)
						terrain[x][zDrawOffset].z = terrain[x][terrainSize-1].z+1;
					else
						terrain[x][zDrawOffset].z = terrain[x][zDrawOffset-1].z+1;
					if (xi == 0) {
						if (zDrawOffset-1 < 0)
							CreateForwardTerrainZ(terrain[x][zDrawOffset], terrain[x][terrainSize-1]);
						else
							CreateForwardTerrainZ(terrain[x][zDrawOffset], terrain[x][zDrawOffset-1]);
					} else {
						if (zDrawOffset-1 < 0)
							CreateForwardTerrainXZ(terrain[x][zDrawOffset], terrain[px][zDrawOffset], terrain[x][terrainSize-1]);
						else
							CreateForwardTerrainXZ(terrain[x][zDrawOffset], terrain[px][zDrawOffset], terrain[x][zDrawOffset-1]);
					}
					
					++x;
					if (x > terrainSize-1) x = 0;
				}
				++zDrawOffset;
				if (zDrawOffset > terrainSize-1) zDrawOffset = 0;
			}
			
		} else {
			
			for(int i = 0; i < -zOffset; ++i) {
				x = xDrawOffset-1;
				if (x < 0) x = terrainSize-1;
				
				for(xi = 0; xi < terrainSize; ++xi) {
					nx = x+1;
					if (nx > terrainSize-1) nx = 0;
					
					if (zDrawOffset-1 < 0)
						terrain[x][terrainSize-1].z = terrain[x][zDrawOffset].z-1;
					else
						terrain[x][zDrawOffset-1].z = terrain[x][zDrawOffset].z-1;
					
					if (xi == 0) {
						if (zDrawOffset-1 < 0)
							CreateBackwardTerrainZ(terrain[x][terrainSize-1], terrain[x][zDrawOffset]);
						else
							CreateBackwardTerrainZ(terrain[x][zDrawOffset-1], terrain[x][zDrawOffset]);
					} else {
						if (zDrawOffset-1 < 0)
							CreateBackwardTerrainXZ(terrain[x][terrainSize-1], terrain[nx][terrainSize-1], terrain[x][zDrawOffset]);
						else
							CreateBackwardTerrainXZ(terrain[x][zDrawOffset-1], terrain[nx][zDrawOffset-1], terrain[x][zDrawOffset]);
					}
					
					--x;
					if (x < 0) x = terrainSize-1;
				}
				--zDrawOffset;
				if (zDrawOffset < 0) zDrawOffset = terrainSize-1;
			}
		}
	}
	
	// slice and dice terrain; must be done after it's created though:
	
	if (xOffset != 0) {
		reconstructTerrain = true;
	
		if (xOffset > 0) {
			
			for(int i = 0; i < xOffset; ++i) {
				z = zDrawOffset;
				xi = (xDrawOffset-(2+i)) % terrainSize;
				if (xi < 0) xi += terrainSize;
				
				for(zi = 0; zi < terrainSize; ++zi) {
					CutPits(xi,z);
					
					++z;
					if (z >= terrainSize) z = 0;
				}
			}
		} else {
			
			for(int i = 0; i < -xOffset; ++i) {
				z = zDrawOffset;
				xi = (xDrawOffset+i) % terrainSize;
				
				for(zi = 0; zi < terrainSize; ++zi) {
					CutPits(xi,z);
					
					++z;
					if (z >= terrainSize) z = 0;
				}
			}
		}
	}
	if (zOffset != 0) {
		reconstructTerrain = true;
		//camera.x -= spacing * xOffset;
		
		if (zOffset > 0) {
			
			for(int i = 0; i < zOffset; ++i) {
				x = xDrawOffset;
				zi = (zDrawOffset-(2+i)) % terrainSize;
				if (zi < 0) zi += terrainSize;
				
				for(xi = 0; xi < terrainSize; ++xi) {
					CutPits(x,zi);
					
					++x;
					if (x >= terrainSize) x = 0;
				}
			}
			
		} else {
			
			for(int i = 0; i < -zOffset; ++i) {
				x = xDrawOffset;
				zi = (zDrawOffset+i) % terrainSize;
				
				for(xi = 0; xi < terrainSize; ++xi) {
					CutPits(x,zi);
					
					++x;
					if (x >= terrainSize) x = 0;
				}
			}
		}
	}
	
	
	oldXPos = xPos;
	oldZPos = zPos;
	
}



void InitHill()
{
	GLfloat clearColor[4] = {0.0f, 1.0f, 1.0f, 1.0f};// Fog Color
	terrainSeed = clock();
	
	initializeOldPos = true;
	srand(terrainSeed);
	
	terrain = new HillPiece * [terrainSize];
	
	vertices = new GLfloat [terrainSize * terrainSize * 12];
	invisVertices = new GLfloat [terrainSize * terrainSize * 12];
	invisColors = new GLfloat [terrainSize * terrainSize * 12];
	colors = new GLfloat [terrainSize * terrainSize * 16];
	textureCoords = new GLfloat [terrainSize * terrainSize * 8];
	vertexPointers = new long [terrainSize * terrainSize];
	//polygonGrid = new Node [terrainSize * terrainSize];
	
	vertexNumbers = new GLuint [terrainSize * terrainSize * 12]; 
	
	for(int i = 0; i < terrainSize*terrainSize*12; ++i)
		invisColors[i] = 0;
	
//#ifndef TRIANGLES
	triangles = new GLuint [terrainSize * (terrainSize-1) * 2];
//#else
//	triangles = new GLuint [(terrainSize-1) * (terrainSize-1) * 6];
//#endif
	
	pitDisplayList = glGenLists(1);
	if (pitDisplayList == 0)
		error("Couldn't create a display list in InitHill() for some reason?!?!? This really shouldn't happen.", 0);
	
	pitBlacknessList = glGenLists(1);
	if (pitBlacknessList == 0)
		error("Couldn't create a display list in InitHill() for some reason?!?!? This really shouldn't happen.", 0);
	
	
	reconstructTerrain = true;
	
	int v = 0, c = 0, tc = 0;
	for(int x = 0; x < terrainSize; ++x) {
		terrain[x] = new HillPiece [terrainSize];
		for(int z = 0; z < terrainSize; ++z) {
			terrain[x][z].created = false;
			terrain[x][z].positiveCreated = false;
			terrain[x][z].onPit = false;
			terrain[x][z].onPitSimplified = false;
			terrain[x][z].cut = false;
			terrain[x][z].cuts = NULL;
			terrain[x][z].resizedCuts = NULL;
			
			terrain[x][z].x = 0;
			terrain[x][z].y = 0;
			terrain[x][z].z = 0;
			terrain[x][z].r = 0;
			terrain[x][z].g = 0;
			terrain[x][z].b = 0;
			terrain[x][z].texX = 0;
			terrain[x][z].texY = 0;
			
			//polygonGrid[z*terrainSize+x].next = NULL;
		}
	}
	
	lightAngle.Set(pi/4, 0);
	
	//camera.SetLocation((terrainSize * spacing) / 2.0, 1 * spacing,-(terrainSize * spacing) / 2.0);
	camera.Set(0,0,0,0,0,0);
	//camera.SetRotation(0,0,0);
	CreateTerrain();
}

void DestroyHill()
{
	//Node *toBeDeleted, *cursor;
	TriangleNode *triToBeDeleted, *triCursor;
	if (terrain) {
		for(int x = 0; x < terrainSize; ++x) {
			for(int y = 0; y < terrainSize; ++y) {
				triCursor = terrain[x][y].cuts;
				while(triCursor != NULL) {
					triToBeDeleted = triCursor;
					triCursor = triCursor->next;
					delete triToBeDeleted;
				}
				
				triCursor = terrain[x][y].resizedCuts;
				while(triCursor != NULL) {
					triToBeDeleted = triCursor;
					triCursor = triCursor->next;
					delete triToBeDeleted;
				}
			}
			delete[] terrain[x];
		}
		delete[] terrain;
	}
	//for(int i = 0; i < 10; ++i)
	//	KillNodes(head.next[i]);
	/*
	if (polygonGrid) {
		for(int i = 0; i < terrainSize*terrainSize; ++i) {
			cursor = polygonGrid[i].next;
			while(cursor != NULL) {
				toBeDeleted = cursor;
				cursor = cursor->next;
				delete toBeDeleted;
			}
		}
		delete[] polygonGrid;
	}*/
	if (vertexPointers)
		delete[] vertexPointers;
	if (vertices)
		delete[] vertices;
	if (invisVertices)
		delete[] invisVertices;
	if (invisColors)
		delete[] invisColors;
	if (colors)
		delete[] colors;
	if (textureCoords)
		delete[] textureCoords;
	if (vertexNumbers)
		delete[] vertexNumbers;
}

int DrawGLScene2(GLvoid)
{
	glDisable(GL_TEXTURE_2D);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	
	glRotatef(-camera.rx, 1,0,0);
	glRotatef(-camera.ry, 0,1,0);
	glRotatef(-camera.rz, 0,0,1);
	
	glTranslatef(-camera.x, -camera.y, -camera.z);
	
	double spacing = 0.4;
	
	for(int x = 0; x < terrainSize-1; ++x) {
		for(int z = 0; z < terrainSize-1; ++z) {
			if (terrain[x][z].created) {
				glColor3f(double(x)/terrainSize,0,double(z)/terrainSize);
				DrawSphere(terrain[x][z].x * spacing,terrain[x][z].y * spacing,terrain[x][z].z * spacing,0.2*spacing);
				
				if (terrain[x+1][z].created) {
					glBegin(GL_LINES);
						glVertex3f(terrain[x][z].x * spacing,terrain[x][z].y * spacing,terrain[x][z].z * spacing);
						glVertex3f(terrain[x+1][z].x * spacing,terrain[x+1][z].y * spacing,terrain[x+1][z].z * spacing);
					glEnd();
				}
				if (terrain[x][z+1].created) {
					glBegin(GL_LINES);
						glVertex3f(terrain[x][z].x * spacing,terrain[x][z].y * spacing,terrain[x][z].z * spacing);
						glVertex3f(terrain[x][z+1].x * spacing,terrain[x][z+1].y * spacing,terrain[x][z+1].z * spacing);
					glEnd();
				}
			}
		}
	}
	
	return true;
}

void NormalVector::Add(double dp, double dt)
{
	phi += dp;
	theta += dt;
	
	if (phi < 0) {
		phi = -phi;
		theta += pi;
	}
	if (theta < 0)
		theta += pi*2;
	if (theta > pi*2)
		theta -= 2 * pi * int(theta/(2 * pi));
}

void NormalVector::Subtract(double dp, double dt)
{
	phi -= dp;
	theta -= dt;
	
	if (phi < 0) {
		phi = -phi;
		theta += pi;
	}
	if (theta < 0)
		theta += pi*2;
	if (theta > pi*2)
		theta -= 2 * pi * int(theta/(2 * pi));
}

void NormalVector::Convert(double &x, double &y, double &z) const
{
	
	// Weird coordinate system:
	
	//     y |phi /
	//       |_ /
	//       |/____ x
	//      /
	//    /
	//z /
	
	x = cos(theta) * sin(phi);
	z = sin(theta) * sin(phi);
	y = cos(phi);
	
}

void CreateTerrain()
{
	double texDealyX = 0, texDealyY = 0;
	NormalVector prevNormal;
	int i = 0;
	
#ifdef SPHERES
	camera.z = 3;
#endif
	
	// create base piece:
	
	terrain[0][0].y = terrain[0][0].z = terrain[0][0].x = 0;
	terrain[0][0].normal.Set(0,0);
	
	texDealyX = 0;
	terrain[0][0].texX	= texDealyX;
	texDealyX			+= textureScale/2;
	//terrain[0][0].texXEnd	= texDealyX;
	
	texDealyY = 0;
	terrain[0][0].texY	= texDealyY;
	texDealyY			+= textureScale/2;
	//terrain[0][0].texYEnd	= texDealyY;
	
	terrain[0][0].created = true;
	terrain[0][0].CalculateShadow();
#ifdef SPHERES
	WaitNextHill();
#endif
	
	// create first row
	
	
	for(int x = 1; x < terrainSize; ++x) {
		terrain[x][0].x			= x;
		terrain[x][0].z			= 0;
		CreateForwardTerrainX(terrain[x][0], terrain[x-1][0]);
#ifdef SPHERES
		WaitNextHill();
#endif
	}
	
	// create all the other rows
	
	for(int z = 1; z < terrainSize; ++z) {
		
		terrain[0][z].x			= 0;
		terrain[0][z].z			= z;
		CreateForwardTerrainZ(terrain[0][z], terrain[0][z-1]);
#ifdef SPHERES
		WaitNextHill();
#endif
		
		for(int x = 1; x < terrainSize; ++x) {
			
			terrain[x][z].x			= x;
			terrain[x][z].z			= z;
			CreateForwardTerrainXZ(terrain[x][z], terrain[x-1][z], terrain[x][z-1]);
#ifdef SPHERES
			WaitNextHill();
#endif
		}
	}
	/*
	camera.SetLocation(	terrain[terrainSize/2][terrainSize/2].x * spacing,
						(terrain[terrainSize/2][terrainSize/2].y + 4) * spacing,
						terrain[terrainSize/2][terrainSize/2].z * spacing);
	*/
	camera.SetLocation(	terrain[terrainSize/2][terrainSize/2].x * spacing,
						(terrain[terrainSize/2][terrainSize/2].y + 4) * spacing,
						terrain[terrainSize/2][terrainSize/2].z * spacing);
	camera.ry = 180;
	/*
	for(int z = 0; z < terrainSize; ++z) {
		for(int x = 0; x < terrainSize; ++x) {
			
			vertices[(z*terrainSize+x)*3 + 0] = terrain[x][z].x * spacing;
			vertices[(z*terrainSize+x)*3 + 1] = terrain[x][z].y * spacing;
			vertices[(z*terrainSize+x)*3 + 2] = terrain[x][z].z * spacing;
			
			colors[(z*terrainSize+x)*3 + 0] = terrain[x][z].shadow;
			colors[(z*terrainSize+x)*3 + 1] = terrain[x][z].shadow;
			colors[(z*terrainSize+x)*3 + 2] = terrain[x][z].shadow;
			
			
			textureCoords[(z*terrainSize+x)*2 + 0] = terrain[x][z].texXBegin;
			textureCoords[(z*terrainSize+x)*2 + 1] = terrain[x][z].texYBegin;
			
		}
	}
	
#ifndef TRIANGLES
	for(int z = 0; z < terrainSize-1; ++z) {
		for(int x = 0; x < terrainSize; ++x) {
			triangles[i++] = z*terrainSize + x;
			triangles[i++] = (z+1)*terrainSize + x;
		}
	}
#else
	for(int z = 0; z < terrainSize-1; ++z) {
		for(int x = 0; x < terrainSize-1; ++x) {
			triangles[i++] = z*terrainSize + x;
			triangles[i++] = z*terrainSize + x + 1;
			triangles[i++] = (z+1)*terrainSize + x;
			triangles[i++] = z*terrainSize + x + 1;
			triangles[i++] = (z+1)*terrainSize + x + 1;
			triangles[i++] = (z+1)*terrainSize + x;
		}
	}
#endif
	*/
	
}

void AddTriangleNode(TriangleNode **head, const Triangle &tri)
{
	TriangleNode *thing;
	
	thing = new TriangleNode;
	
	thing->tri.points[0] = tri.points[0];
	thing->tri.points[1] = tri.points[1];
	thing->tri.points[2] = tri.points[2];
	thing->tri.edges[0] = tri.edges[0];
	thing->tri.edges[1] = tri.edges[1];
	thing->tri.edges[2] = tri.edges[2];
	
	thing->next = (*head);
	(*head) = thing;
	
	++debug1;
}

void HillPiece::DoStuffAfterHillPieceIsMade()
{
	created = true;
	CalculateShadow();
	cut = false;
	/*
	if (	(x == terrain[xDrawOffset][0].x && z != terrain[0][zDrawOffset+terrainSize-1].z) ||
			(z == terrain[0][zDrawOffset].x && x != terrain[xDrawOffset+terrainSize-1][0].z))
		CutPits();
	
	else 	(x == terrain[xDrawOffset+terrainSize-1][0].x  && z != terrain[0][zDrawOffset+terrainSize-1].z)
		terrain[
	*/
}


void CutPits(int x, int z)
{
	
	terrain[x][z].CutPits(x, z);
	
}


void HillPiece::CutPits(int ix, int iz)
{
	Triangle results[4], results2[4], tri1, tri2, tri3, tri4;
	Pit *pit;
	int resultNum, resultNum2;
	TriangleNode *cursor, *prev, *toBeDeleted;
	bool anything, anything2, simplified;
	int nx, nz, nx2, nz2;
	
	if (cut) return;
	
	cut = true;
	
	//GetTerrainPiece(x,z, ix, iz);
	nx = (ix+1)%terrainSize;
	nz = (iz+1)%terrainSize;
	
	nx2 = (ix+2)%terrainSize;
	nz2 = (iz+2)%terrainSize;
	
	if (ix%2 == 0 && iz%2 == 0)
		simplified = true;
	else
		simplified = false;
	
	
	tri1.points[0].x = x*spacing;
	tri1.points[0].z = z*spacing;
	tri1.points[0].texX = texX;
	tri1.points[0].texY = texY;
	
	tri1.points[1].x = (x+1)*spacing;
	tri1.points[1].z = z*spacing;
	tri1.points[1].texX = texX + textureScale/2;
	tri1.points[1].texY = texY;
	
	tri1.points[2].x = x*spacing;
	tri1.points[2].z = (z+1)*spacing;
	tri1.points[2].texX = texX;
	tri1.points[2].texY = texY + textureScale/2;
	
	tri2.points[0].x = (x+1)*spacing;
	tri2.points[0].z = (z+1)*spacing;
	tri2.points[0].texX = texX + textureScale/2;
	tri2.points[0].texY = texY + textureScale/2;
	
	tri2.points[1].x = (x+1)*spacing;
	tri2.points[1].z = z*spacing;
	tri2.points[1].texX = texX + textureScale/2;
	tri2.points[1].texY = texY;
	
	tri2.points[2].x = x*spacing;
	tri2.points[2].z = (z+1)*spacing;
	tri2.points[2].texX = texX;
	tri2.points[2].texY = texY + textureScale/2;
	
	tri1.points[0].r = terrain[ix][iz].r;
	tri1.points[1].r = terrain[nx][iz].r;
	tri1.points[2].r = terrain[ix][nz].r;
	tri2.points[0].r = terrain[nx][nz].r;
	tri2.points[1].r = terrain[nx][iz].r;
	tri2.points[2].r = terrain[ix][nz].r;
	
	if (simplified) {
			
		tri3.points[0].x = x*spacing;
		tri3.points[0].z = z*spacing;
		tri3.points[0].texX = texX;
		tri3.points[0].texY = texY;
		
		tri3.points[1].x = (x+2)*spacing;
		tri3.points[1].z = z*spacing;
		tri3.points[1].texX = texX + textureScale;
		tri3.points[1].texY = texY;
		
		tri3.points[2].x = x*spacing;
		tri3.points[2].z = (z+2)*spacing;
		tri3.points[2].texX = texX;
		tri3.points[2].texY = texY + textureScale;
		
		tri4.points[0].x = (x+2)*spacing;
		tri4.points[0].z = (z+2)*spacing;
		tri4.points[0].texX = texX + textureScale;
		tri4.points[0].texY = texY + textureScale;
		
		tri4.points[1].x = (x+2)*spacing;
		tri4.points[1].z = z*spacing;
		tri4.points[1].texX = texX + textureScale;
		tri4.points[1].texY = texY;
		
		tri4.points[2].x = x*spacing;
		tri4.points[2].z = (z+2)*spacing;
		tri4.points[2].texX = texX;
		tri4.points[2].texY = texY + textureScale;
	
		tri3.points[0].r = terrain[ix][iz].r;
		tri3.points[1].r = terrain[nx2][iz].r;
		tri3.points[2].r = terrain[ix][nz2].r;
		tri4.points[0].r = terrain[nx2][nz2].r;
		tri4.points[1].r = terrain[nx2][iz].r;
		tri4.points[2].r = terrain[ix][nz2].r;
		
	}
	
	
	
	
	//tri1.points[0].r = tri1.points[1].r = tri1.points[2].r = r;
	//tri2.points[0].r = tri2.points[1].r = tri2.points[2].r = r;
	
	cursor = cuts;
	while(cursor != NULL) {
		toBeDeleted = cursor;
		cursor = cursor->next;
		delete toBeDeleted;
		--debug1;
	}
	cuts = NULL;
	
	cursor = resizedCuts;
	while(cursor != NULL) {
		toBeDeleted = cursor;
		cursor = cursor->next;
		delete toBeDeleted;
		--debug1;
	}
	resizedCuts = NULL;
	
	onPit = false;
	onPitSimplified = false;
	yCalculated = false;
	yCalculatedSimplified = false;
	// Pitify terrain:
	
	pit = firstPit;
	for(int i = 0; i < currentPitNum && pit; ++i) {
		
		if (x*spacing >= pit->minX-spacing && x*spacing <= pit->maxX && z*spacing >= pit->minZ-spacing && z*spacing <= pit->maxZ) {
			
			if (!onPit) {
				
				anything = CutTriangle(tri1, pit->corners, results, resultNum);
				anything2 = CutTriangle(tri2, pit->corners, results2, resultNum2);
				if (anything || anything2) {
					for(int i = 0; i < resultNum; ++i)
						AddTriangleNode(&cuts, results[i]);
					for(int i = 0; i < resultNum2; ++i)
						AddTriangleNode(&cuts, results2[i]);
					
					onPit = true;
				}
			} else {
			
				cursor = cuts;
				prev = NULL;
				while(cursor != NULL) {
					
					if (CutTriangle(cursor->tri, pit->corners, results, resultNum)) {
						if (resultNum > 0) {
							cursor->tri.points[0] = results[0].points[0];
							cursor->tri.points[1] = results[0].points[1];
							cursor->tri.points[2] = results[0].points[2];
							cursor->tri.edges[0] = results[0].edges[0];
							cursor->tri.edges[1] = results[0].edges[1];
							cursor->tri.edges[2] = results[0].edges[2];
							
							for(int i = 1; i < resultNum; ++i)
								AddTriangleNode(&cuts, results[i]);
							
							prev = cursor;
							cursor = cursor->next;
						} else {
							// triangle piece is gone; delete it
							if (prev == NULL) {
								cuts = cuts->next;
								delete cursor;
								cursor = cuts;
								--debug1;
							} else {
								toBeDeleted = cursor;
								cursor = cursor->next;
								prev->next = cursor;
								delete toBeDeleted;
								--debug1;
							}
						}
					} else {
						prev = cursor;
						cursor = cursor->next;
					}
				}
			}
		}
		
		if (simplified) {
			
			if (x*spacing >= pit->minX-(spacing*2) && x*spacing <= pit->maxX && z*spacing >= pit->minZ-(spacing*2) && z*spacing <= pit->maxZ) {
				
				if (!onPitSimplified) {
					
					anything = CutTriangle(tri3, pit->corners, results, resultNum);
					anything2 = CutTriangle(tri4, pit->corners, results2, resultNum2);
					if (anything || anything2) {
						for(int i = 0; i < resultNum; ++i)
							AddTriangleNode(&resizedCuts, results[i]);
						for(int i = 0; i < resultNum2; ++i)
							AddTriangleNode(&resizedCuts, results2[i]);
						
						onPitSimplified = true;
					}
				} else {
				
					cursor = resizedCuts;
					prev = NULL;
					while(cursor != NULL) {
						
						if (CutTriangle(cursor->tri, pit->corners, results, resultNum)) {
							if (resultNum > 0) {
								cursor->tri.points[0] = results[0].points[0];
								cursor->tri.points[1] = results[0].points[1];
								cursor->tri.points[2] = results[0].points[2];
								cursor->tri.edges[0] = results[0].edges[0];
								cursor->tri.edges[1] = results[0].edges[1];
								cursor->tri.edges[2] = results[0].edges[2];
								
								for(int i = 1; i < resultNum; ++i)
									AddTriangleNode(&resizedCuts, results[i]);
								
								prev = cursor;
								cursor = cursor->next;
							} else {
								// triangle piece is gone; delete it
								if (prev == NULL) {
									resizedCuts = resizedCuts->next;
									delete cursor;
									cursor = resizedCuts;
									--debug1;
								} else {
									toBeDeleted = cursor;
									cursor = cursor->next;
									prev->next = cursor;
									delete toBeDeleted;
									--debug1;
								}
							}
						} else {
							prev = cursor;
							cursor = cursor->next;
						}
					}
				}
			}
			
		}
		pit = pit->next;
	}
}


void CreateForwardTerrainX(HillPiece &newHill, const HillPiece &px)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY;
	
	prevNormal = px.normal;
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder) ), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(newHill.x, newHill.z)));
	
	//newHill.normal.theta = 0;
	
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	prevNormal.Convert(a,b,c);
	
	// z = 0
	newY = -(double(a*newHill.x) + double(c*newHill.z) - double(a*px.x) - double(b*px.y) - double(c*px.z))/b;
	newHill.y = newY;
	
	//if (texDealyX >= 0.5) texDealyX -= 0.5;
	newHill.texX	= px.texX + textureScale/2;
	//newHill.texXEnd		= px.texXEnd + textureScale/2;
	
	newHill.texY	= px.texY;
	//newHill.texYEnd		= px.texYEnd;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

void CreateBackwardTerrainX(HillPiece &newHill, const HillPiece &nx)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY;
	
	prevNormal = nx.normal;
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder) ), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(nx.x, nx.z)));
	
	//newHill.normal.theta = 0;
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	prevNormal.Convert(a,b,c);
	
	// z = 0
	newY = -(a*newHill.x + c*newHill.z - a*nx.x - b*nx.y - c*nx.z)/b;
	newHill.y = newY;
	
	//if (texDealyX >= 0.5) texDealyX -= 0.5;
	//newHill.texXEnd		= nx.texXBegin;
	newHill.texX	= nx.texX - textureScale/2;
	
	newHill.texY	= nx.texY;
	//newHill.texYEnd		= nx.texYEnd;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

void CreateForwardTerrainZ(HillPiece &newHill, const HillPiece &pz)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY;
	
	prevNormal = pz.normal;
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder) ), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(newHill.x, newHill.z)));
	
	//newHill.normal.theta = -pi/4.0;
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	prevNormal.Convert(a,b,c);
	
	// x = 0
	newY = -(a*newHill.x + c*newHill.z - a*pz.x - b*pz.y - c*pz.z)/b;
	newHill.y = newY;
	
	newHill.texX	= pz.texX;
	//newHill.texXEnd		= pz.texXEnd;
	newHill.texY	= pz.texY + textureScale/2;
	//newHill.texYEnd		= pz.texYEnd + textureScale/2;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

void CreateBackwardTerrainZ(HillPiece &newHill, const HillPiece &nz)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY;
	
	prevNormal = nz.normal;
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder) ), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(nz.x, nz.z)));
	
	//newHill.normal.theta = -pi/4.0;
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	prevNormal.Convert(a,b,c);
	
	// x = 0
	newY = -(a*newHill.x + c*newHill.z - a*nz.x - b*nz.y - c*nz.z)/b;
	newHill.y = newY;
	
	newHill.texX	= nz.texX;
	//newHill.texXEnd		= nz.texXEnd;
	newHill.texY	= nz.texY - textureScale/2;
	//newHill.texYEnd		= nz.texYBegin;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

void CreateForwardTerrainXZ(HillPiece &newHill, const HillPiece &px, const HillPiece &pz)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY, newY2;
	
	prevNormal.Set(	(pz.normal.phi + px.normal.phi) / 2.0,
					(pz.normal.theta + px.normal.theta) / 2.0);
	
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder)), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(newHill.x, newHill.z)));
	
	//newHill.normal.theta = -pi/8.0;
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	px.normal.Convert(a,b,c);
	newY = -(a*newHill.x + c*newHill.z - a*px.x - b*px.y - c*px.z)/b;
	pz.normal.Convert(a,b,c);
	newY2 = -(a*newHill.x + c*newHill.z - a*pz.x - b*pz.y - c*pz.z)/b;
	
	newHill.y = (newY + newY2) / 2.0;
	
	//if (texDealyX >= 0.5) texDealyX -= 0.5;
	newHill.texX	= pz.texX;
	//newHill.texXEnd		= pz.texXEnd;
	
	newHill.texY	= px.texY;
	//newHill.texYEnd		= px.texYEnd;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

void CreateBackwardTerrainXZ(HillPiece &newHill, const HillPiece &nx, const HillPiece &nz)
{
	NormalVector prevNormal;
	double deltaPhi, a, b, c, newY, newY2;
	
	prevNormal.Set(	(nz.normal.phi + nx.normal.phi) / 2.0,
					(nz.normal.theta + nx.normal.theta) / 2.0);
	
	deltaPhi = RandomNumber(-maxDeltaPhi, maxDeltaPhi * (1 - pow(prevNormal.phi/maxPhi, slopeOrder)), FindSeed(newHill.x, newHill.z));
	
	newHill.normal = prevNormal;
	newHill.normal.Add(deltaPhi, RandomNumber(minDeltaTheta, maxDeltaTheta, FindSeed(nz.x, nz.z)));
	
	//newHill.normal.theta = pi/8.0;
	
	if (newHill.normal.phi > maxPhi)
		newHill.normal.phi = maxPhi;
	
	nx.normal.Convert(a,b,c);
	newY = -(a*newHill.x + c*newHill.z - a*nx.x - b*nx.y - c*nx.z)/b;
	nz.normal.Convert(a,b,c);
	newY2 = -(a*newHill.x + c*newHill.z - a*nz.x - b*nz.y - c*nz.z)/b;
	
	newHill.y = (newY + newY2) / 2.0;
	
	//if (texDealyX >= 0.5) texDealyX -= 0.5;
	newHill.texX	= nz.texX;
	//newHill.texXEnd		= nz.texXEnd;
	
	newHill.texY	= nx.texY;
	//newHill.texYEnd		= nx.texYEnd;
	
	newHill.DoStuffAfterHillPieceIsMade();
}

unsigned int FindSeed(int x, int y)
{
	unsigned int n;
	if (y > -x) {
		if (y > x)
			n = (4*y - 2)*y  +  (y-x);
		else
			n = (4*x - 2)*x  -  (x-y);
	} else {
		if (y > x)
			n = (4*x - 2)*x  -  (y-x);
		else
			n = (4*y - 2)*y  +  (x-y);
	}
	n = n*234 + 123 + terrainSeed;
	
	
	n = (terrainSize*x + y)*234 + 123 + terrainSeed;
	
	n = rand();
	return n;
}


double RandomNumber(double min, double max)
{
	double r = (double)rand() / (double)RAND_MAX;
	
	return r*(max-min) + min;
}

double NumFromSeed(unsigned int seed)
{
	double r;
	if (seed < 20) seed += 20;
	//srand(seed + terrainSeed);
	rand();
	rand();
	r = (double)rand() / (double)RAND_MAX;
	return r;
}

double RandomNumber(double min, double max, unsigned int seed)
{
	double r = NumFromSeed(seed);
	
	return r*(max-min) + min;
}

double NotSoRandomNumber(double min, double max, double r)
{
	r /= RAND_MAX;
	return r*(max-min) + min;
}

void CameraControls(bool *keys)
{
	double rotationSpeed = 1.0;
	double translationSpeed = 0.1 * spacing;
	double minY;
	
	if (keys['F']) translationSpeed = 0.01 * spacing;
	
	if (keys['O']) camera.z -= translationSpeed;
	if (keys['9']) camera.z += translationSpeed;
	if (keys['J']) camera.x -= translationSpeed;
	if (keys['L']) camera.x += translationSpeed;
	if (keys['K']) camera.y -= translationSpeed;
	if (keys['I']) camera.y += translationSpeed;
	
	if (keys['S']) camera.rx -= rotationSpeed;
	if (keys['W']) camera.rx += rotationSpeed;
	if (keys['A']) camera.ry += rotationSpeed;
	if (keys['D']) camera.ry -= rotationSpeed;
	
	if (keys[' ']) {
		
		camera.z += -cos(camera.ry * piOver180)*cos(camera.rx * piOver180) * translationSpeed;
		camera.x += -sin(camera.ry * piOver180)*cos(camera.rx * piOver180) * translationSpeed;
		camera.y += sin(camera.rx * piOver180) * translationSpeed;
		
	}
	
	//if (keys['F']) {
	//	blah = true;
	//	keys['F'] = false;
	//}
	if (camera.rx > 360) camera.rx -= 360;
	if (camera.rx < 0) camera.rx += 360;
	if (camera.ry > 360) camera.ry -= 360;
	if (camera.ry < 0) camera.ry += 360;
	
	//if (camera.x >= 0 && camera.x < terrainSize-1 && camera.z >= 0 && camera.z < terrainSize-1) {
	minY = minYValue(camera.x, camera.z);
	//if (camera.y < minY + 0.2)
	//	camera.y = minY + 0.2;
	
	//GetTerrainPiece(camera.x, camera.z, xi, zi);
	
	//camera.rx = -(terrain[xi][zi].normal.phi * (180 / pi));
	
	//}
	//if (camera.y < minY+0.1) camera.y = minY+0.1;
	
		//Vector1 X Vector2=
//(Vector1.y*Vector2.z)-(Vector1.z* Vector2.y) (Vector1.z*Vector2.x)- (Vector1.x*Vector2.z) (Vector1.x*Vector2.y)-(Vector1.y*Vector2.x)
	
	//if (camera.y < minCameraY && thingy > 50) {
	//	camera.y = minCameraY;
	//} else
	//	++thingy;
	//camera.y = minCameraY;
	
}

void CalculateNormals(float *normal, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
	double a,b,c,d;
	
	a = y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2);
	b = z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2);
	c = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
	
	d = sqrt(a*a + b*b + c*c);
	
	a /= d;
	b /= d;
	c /= d;
	
	normal[0] = a;
	normal[1] = b;
	normal[2] = c;
}

void HillPiece::CalculateShadow()
{
	// (max {L  n, 0}) * diffuselight * diffusematerial
	double nx,ny,nz, lx, ly, lz, shadow;
	double minLight = .35;
	
	normal.Convert(nx,ny,nz);
	lightAngle.Convert(lx,ly,lz);
	
	//lx = abs(lx);
	//ly = abs(ly);
	//lz = abs(lz);
	
	shadow = max(0.0, nx*lx + ny*ly + nz*lz);
	
	shadow *= (1 - minLight);
	shadow += minLight;
	
	r = g = b = shadow;
	
}

// for debugging
void GetOffsetCoords(double &x, double &z)
{
	x = terrain[xDrawOffset][0].x * spacing;
	z = terrain[0][zDrawOffset].z * spacing;
}

// Returns the terrain piece at world coord. xLoc,zLoc
void GetTerrainPiece(double xLoc, double zLoc, int &x, int &z)
{
	//int x2, z2;
	//if (int(xLoc) >= terrainSize-1)
	//	x = x;
	
	
	
	xLoc /= spacing;
	zLoc /= spacing;
	
	x = abs(int(xDrawOffset + (xLoc - terrain[xDrawOffset][0].x))) % terrainSize;
	z = abs(int(zDrawOffset + (zLoc - terrain[0][zDrawOffset].z))) % terrainSize;
	
	
	/*
	// Fail safe way of doing the same thing:
	
	int xInt, zInt;
	xInt = int(floor(xLoc));
	zInt = int(floor(zLoc));
	x = z = 0;
	for(int i = 0; i < terrainSize; ++i) {
		if (int(floor(terrain[i][0].x)) == xInt) {
			x = i;
			break;
		}
	}
	for(int i = 0; i < terrainSize; ++i) {
		if (int(floor(terrain[0][i].z)) == zInt) {
			z = i;
			break;
		}
	}*/
}

// Game coordinate: any particular location in the world.
// (Initially what is in view is 0 to terrainSize*spacing)

// Is game coordinate in view?
bool InSight(double x, double z)
{
	return (x > terrain[xDrawOffset][0].x*spacing && z > terrain[0][zDrawOffset].z*spacing && 
			x < (terrain[xDrawOffset][0].x+terrainSize-1)*spacing && z < (terrain[0][zDrawOffset].z+terrainSize-1)*spacing);
}

// Terrain coordinate = item in the array

// Is terrain coordinate existent?
bool OnTerrain(int x, int z)
{
	return (x >= 0 && x < terrainSize && z >= 0 && z < terrainSize);
}

double minYValue(double x, double z)
{
	double a,b,c, minY, xPortion, zPortion, vx1, vx2, vy1, vy2, vz1, vz2;
	int xi, zi, nextX, nextZ;
	
	GetTerrainPiece(x,z, xi,zi);
	
	z /= spacing;
	x /= spacing;
	
	if (OnTerrain(xi,zi)) {
		
		nextX = (xi+1)%terrainSize;
		nextZ = (zi+1)%terrainSize;
		
		if (x < 0)
			xPortion = 1 + (x - int(x));
		else
			xPortion = x - int(x);
		if (z < 0)
			zPortion = 1 + (z - int(z));
		else
			zPortion = z - int(z);
		
		if ( xPortion < zPortion) {   // upper of two triangles
			
			vx1 = terrain[nextX][nextZ].x - terrain[xi][nextZ].x;
			vy1 = terrain[nextX][nextZ].y - terrain[xi][nextZ].y;
			vz1 = terrain[nextX][nextZ].z - terrain[xi][nextZ].z;
			
			vx2 = terrain[xi][zi].x - terrain[xi][nextZ].x;
			vy2 = terrain[xi][zi].y - terrain[xi][nextZ].y;
			vz2 = terrain[xi][zi].z - terrain[xi][nextZ].z;
			
			a = vy1*vz2 - vz1*vy2;
			b = vz1*vx2 - vx1*vz2;
			c = vx1*vy2 - vy1*vx2;
			
			minY = (a*terrain[xi][nextZ].x + b*terrain[xi][nextZ].y + c*terrain[xi][nextZ].z - a*x - c*z)/b;
			
		} else {  // lower of two triangles
			
			vx1 = terrain[xi][zi].x - terrain[nextX][zi].x;
			vy1 = terrain[xi][zi].y - terrain[nextX][zi].y;
			vz1 = terrain[xi][zi].z - terrain[nextX][zi].z;
			
			vx2 = terrain[nextX][nextZ].x - terrain[nextX][zi].x;
			vy2 = terrain[nextX][nextZ].y - terrain[nextX][zi].y;
			vz2 = terrain[nextX][nextZ].z - terrain[nextX][zi].z;
			
			a = vy1*vz2 - vz1*vy2;
			b = vz1*vx2 - vx1*vz2;
			c = vx1*vy2 - vy1*vx2;
			
			minY = (a*terrain[nextX][zi].x + b*terrain[nextX][zi].y + c*terrain[nextX][zi].z - a*x - c*z)/b;
		}
	} else minY = -10000;
	
	minY *= spacing;
	
	return minY;
}


// calculates previous phi using Newton's method:  very sketchy
double findPreviousPhi(double phi2, double minDelta, double maxDelta, double r, double order)
{
	double a1 = -r*maxDelta;
	double c1 = r*minDelta+minDelta+phi2;
	double a2 = -r*order*maxDelta;
	const int accuracy = 10;
	
	double x = phi2;
	
	for(int i = 0; i < accuracy; ++i) {
		x = x - (a1*pow(x,order) - maxPhi + c1)/(a2*pow(x,order-1) - maxPhi);
	}
	
	return x * maxPhi;
}



bool PointInRect(Point point, double left, double top, double right, double bottom)
{
	return (point.x >= left && point.x <= right && point.y >= top && point.y <= bottom);
}


bool CutTriangle(const Triangle &triOrg, const Quadrilateral &rectOrg, Triangle *results, int &resultOn)
{
	Quadrilateral rect;
	Triangle tri;
	Point tp[3];
	Point rp[1];
	Point ip[4];
	short ipData[4][2];
	short tpData[3];
	short rpData[1];
	// for data:
	// ipData[x][0] = connecting triangle line
	// ipData[x][1] = connecting rectangle line
	int tpNum = 0, rpNum = 0, ipNum = 0;
	int pointNum = 0;
	double mt[3], mr[4], x, z;
	int st[3], sr[4], nextT, nextR;
	bool noPoints = false;
	int n, n2a, n2b, n3a, n3b;
	double dist1, dist2;
	//Triangle results[4];
	//int resultOn = 0;
	//short triEdges[3] = {0,0,0}, tpEdges[3] = {0,0,0}, tri2Edges[3] = {0,0,0};
	//double triEdgeSlopes[3] = {0,0,0}, tpEdgeSlopes[3] = {0,0,0} tri2EdgeSlopes = {0,0,0};
	
	resultOn = 0;
	
	tri.points[0] = triOrg.points[0];
	tri.points[1] = triOrg.points[1];
	tri.points[2] = triOrg.points[2];
	tri.edges[0] = triOrg.edges[0];
	tri.edges[1] = triOrg.edges[1];
	tri.edges[2] = triOrg.edges[2];
	rect.points[0] = rectOrg.points[0];
	rect.points[1] = rectOrg.points[1];
	rect.points[2] = rectOrg.points[2];
	rect.points[3] = rectOrg.points[3];
	results[0].edges[0] = false;
	results[0].edges[1] = false;
	results[0].edges[2] = false;
	results[1].edges[0] = false;
	results[1].edges[1] = false;
	results[1].edges[2] = false;
	results[2].edges[0] = false;
	results[2].edges[1] = false;
	results[2].edges[2] = false;
	results[3].edges[0] = false;
	results[3].edges[1] = false;
	results[3].edges[2] = false;
	
	
	if (tri.points[0].x == tri.points[1].x) tri.points[1].x += 0.0001;
	if (tri.points[1].x == tri.points[2].x) tri.points[2].x += 0.0001;
	if (tri.points[2].x == tri.points[0].x) tri.points[0].x += 0.0001;
	
	if (rect.points[0].x == rect.points[1].x) rect.points[1].x += 0.0001;
	if (rect.points[1].x == rect.points[2].x) rect.points[2].x += 0.0001;
	if (rect.points[2].x == rect.points[3].x) rect.points[3].x += 0.0001;
	if (rect.points[3].x == rect.points[0].x) rect.points[0].x += 0.0001;
	
	if (tri.points[0].z == tri.points[1].z) tri.points[1].z += 0.0001;
	if (tri.points[1].z == tri.points[2].z) tri.points[2].z += 0.0001;
	if (tri.points[2].z == tri.points[0].z) tri.points[0].z += 0.0001;
	
	if (rect.points[0].z == rect.points[1].z) rect.points[1].z += 0.0001;
	if (rect.points[1].z == rect.points[2].z) rect.points[2].z += 0.0001;
	if (rect.points[2].z == rect.points[3].z) rect.points[3].z += 0.0001;
	if (rect.points[3].z == rect.points[0].z) rect.points[0].z += 0.0001;
	
	
	// test for rectangle points being inside the triangle:
	
	if (tri.points[0].x - tri.points[1].x == 0) mt[0] = 99999999;
	else
		mt[0] = (tri.points[0].z - tri.points[1].z) / (tri.points[0].x - tri.points[1].x);
	
	if (tri.points[1].x - tri.points[2].x == 0) mt[1] = 99999999;
	else
		mt[1] = (tri.points[1].z - tri.points[2].z) / (tri.points[1].x - tri.points[2].x);
	
	if (tri.points[2].x - tri.points[0].x == 0) mt[2] = 99999999;
	else
		mt[2] = (tri.points[2].z - tri.points[0].z) / (tri.points[2].x - tri.points[0].x);
	
	st[0] = (tri.points[2].z > mt[0]*(tri.points[2].x-tri.points[0].x) + tri.points[0].z) ? 1 : -1;
	st[1] = (tri.points[0].z > mt[1]*(tri.points[0].x-tri.points[1].x) + tri.points[1].z) ? 1 : -1;
	st[2] = (tri.points[1].z > mt[2]*(tri.points[1].x-tri.points[2].x) + tri.points[2].z) ? 1 : -1;
	
	tri.points[0].edge = 0;
	tri.points[1].edge = 0;
	tri.points[2].edge = 0;
	ip[0].edge = 0;
	ip[1].edge = 0;
	ip[2].edge = 0;
	ip[3].edge = 0;
	
	if (tri.edges[0]) {
		tri.points[0].edge++;
		tri.points[1].edge++;
		tri.points[0].edgeSlope = tri.points[1].edgeSlope = mt[0];
	}
	if (tri.edges[1]) {
		tri.points[1].edge++;
		tri.points[2].edge++;
		tri.points[1].edgeSlope = tri.points[2].edgeSlope = mt[1];
	}
	if (tri.edges[2]) {
		tri.points[2].edge++;
		tri.points[0].edge++;
		tri.points[2].edgeSlope = tri.points[0].edgeSlope = mt[2];
	}
	
	
	double leftSide, rightSide;
	
	for(int i = 0; i < 4; ++i) {
		leftSide = rect.points[i].z*st[0];
		rightSide = (mt[0]*(rect.points[i].x-tri.points[0].x)+tri.points[0].z)*st[0];
		leftSide = rect.points[i].z*st[1];
		rightSide = (mt[1]*(rect.points[i].x-tri.points[1].x)+tri.points[1].z)*st[1];
		leftSide = rect.points[i].z*st[2];
		rightSide = (mt[2]*(rect.points[i].x-tri.points[2].x)+tri.points[2].z)*st[2];
		
		if (	rect.points[i].z*st[0] > (mt[0]*(rect.points[i].x-tri.points[0].x)+tri.points[0].z)*st[0] &&
				rect.points[i].z*st[1] > (mt[1]*(rect.points[i].x-tri.points[1].x)+tri.points[1].z)*st[1] &&
				rect.points[i].z*st[2] > (mt[2]*(rect.points[i].x-tri.points[2].x)+tri.points[2].z)*st[2]) {
			rp[0] = rect.points[i];
			rp[0].r = (tri.points[0].r + tri.points[1].r + tri.points[2].r)/3.0;
			//rp[0].y = minYValue(rp[0].x, rp[0].z);
			rpData[0] = i;
			++rpNum;
			
			break; // THERE CAN NEVER BE MORE THAN ONE RECTANGLE POINT IN THE TRIANGLE
		}
	}
	
	// test for triangle points NOT being inside the rectangle:
	
	if (rect.points[0].x - rect.points[1].x == 0) mr[0] = 99999999;
	else
		mr[0] = (rect.points[0].z - rect.points[1].z) / (rect.points[0].x - rect.points[1].x);
	
	if (rect.points[1].x - rect.points[2].x == 0) mr[1] = 99999999;
	else
		mr[1] = (rect.points[1].z - rect.points[2].z) / (rect.points[1].x - rect.points[2].x);
	
	if (rect.points[2].x - rect.points[3].x == 0) mr[2] = 99999999;
	else
		mr[2] = (rect.points[2].z - rect.points[3].z) / (rect.points[2].x - rect.points[3].x);
	
	if (rect.points[3].x - rect.points[0].x == 0) mr[3] = 99999999;
	else
		mr[3] = (rect.points[3].z - rect.points[0].z) / (rect.points[3].x - rect.points[0].x);
	
	sr[0] = (rect.points[2].z > mr[0]*(rect.points[2].x - rect.points[0].x) + rect.points[0].z) ? 1 : -1;
	sr[1] = (rect.points[3].z > mr[1]*(rect.points[3].x - rect.points[1].x) + rect.points[1].z) ? 1 : -1;
	sr[2] = (rect.points[0].z > mr[2]*(rect.points[0].x - rect.points[2].x) + rect.points[2].z) ? 1 : -1;
	sr[3] = (rect.points[1].z > mr[3]*(rect.points[1].x - rect.points[3].x) + rect.points[3].z) ? 1 : -1;
	
	
	for(int i = 0; i < 3; ++i) {
		// We're looking for points NOT in the rectangle, of course
		if (!(	tri.points[i].z*sr[0] >= (mr[0]*(tri.points[i].x - rect.points[0].x) + rect.points[0].z) * sr[0] &&
				tri.points[i].z*sr[1] >= (mr[1]*(tri.points[i].x - rect.points[1].x) + rect.points[1].z) * sr[1] &&
				tri.points[i].z*sr[2] >= (mr[2]*(tri.points[i].x - rect.points[2].x) + rect.points[2].z) * sr[2] &&
				tri.points[i].z*sr[3] >= (mr[3]*(tri.points[i].x - rect.points[3].x) + rect.points[3].z) * sr[3])) {
			tp[tpNum] = tri.points[i];
			tpData[tpNum] = i;
			
			//tpEdges[tpNum] = triEdges[i];
			//tpEdgeSlopes[tpNum] = triEdgeSlopes[i];
			
			//tp[tpNum].y = 0;
			
			++tpNum;
		}
	}
	
	// look for intersections
	
	bool duplicateIPoint = false;
	
	for(int r = 0; r < 4; ++r) {
		if (ipNum >= 4)
			break;
		nextR = (r+1) % 4;
		
		for(int t = 0; t < 3; ++t) {
			nextT = (t+1) % 3;
			
			if ((mt[t] - mr[r]) != 0) {
				if (mt[t] == 999999999) {
					x = tri.points[t].x;
					z = mr[r]*(x-rect.points[r].x) + rect.points[r].z;
				} else if (mr[r] == 999999999) {
					x = rect.points[r].x;
					z = mt[t]*(x-tri.points[t].x) + tri.points[t].z;
				} else {
					x = (mt[t]*tri.points[t].x - mr[r]*rect.points[r].x - tri.points[t].z + rect.points[r].z) / (mt[t] - mr[r]);
					z = mt[t]*(x-tri.points[t].x) + tri.points[t].z;
				}
				if (	between(tri.points[t].x, tri.points[nextT].x, x) && between(rect.points[r].x, rect.points[nextR].x, x) &&
						between(tri.points[t].z, tri.points[nextT].z, z) && between(rect.points[r].z, rect.points[nextR].z, z) ) {
					
					// removes possibility of intersection point being a triangle vertice:
					//if ( (x == tri.points[t].x && z == tri.points[t].z) || (x == tri.points[nextT].x && z == tri.points[nextT].z))
					//	continue;
					
					ip[ipNum].x = x;
					ip[ipNum].z = z;
					
					if (x == tri.points[t].x)
						ip[ipNum].r = tri.points[t].r + (tri.points[nextT].r - tri.points[t].r) * ((z - tri.points[t].z) / (tri.points[nextT].z - tri.points[t].z));
					else
						ip[ipNum].r = tri.points[t].r + (tri.points[nextT].r - tri.points[t].r) * ((x - tri.points[t].x) / (tri.points[nextT].x - tri.points[t].x));
					
					if (tri.points[t].edge > 0 && tri.points[nextT].edge > 0 && tri.points[t].edgeSlope == tri.points[nextT].edgeSlope) {
						ip[ipNum].edge = 1;
						ip[ipNum].edgeSlope = tri.points[t].edgeSlope;
					}
					
					//ip[ipNum].r = tri.points[t].r;
					
					// This is where you calculate the shadow for an intersection point.
					
					//ip[ipNum].texX = tri.points[t].texX + ((tri.points[nextT].texX-tri.points[t].texX) * fabs((x - tri.points[t].x) / (tri.points[nextT].x - tri.points[t].x)));
					//ip[ipNum].texY = tri.points[t].texY + ((tri.points[nextT].texY-tri.points[t].texY) * fabs((z - tri.points[t].z) / (tri.points[nextT].z - tri.points[t].z)));
					
					/*
					for(int i = 0; i < ipNum; ++i) {
						if (SamePointBasically(ip[ipNum], ip[i]))
							duplicateIPoint = true;
					}
					*/
					ipData[ipNum][0] = t;
					ipData[ipNum][1] = r;
			
					++ipNum;
					
					if (ipNum >= 4)
						break;
					
				}
			}
		}
	}
	
	
	
	// figure out the result!!!!!!!
	// There are 9 different ways the triangle can intersect the rectangle I do believe.
	
	// fix problems if two or more intersection points equal each other:
	
	/*
	if (duplicateIPoint) {
		if (	(tpNum == 2 && ipNum == 4 && rpNum == 0) ||
				(tpNum == 1 && ipNum == 3 && rpNum == 0)) {
			
			ipNum = 2;
			if (SamePointBasically(ip[0], ip[1])) {
				ip[0] = ip[2];
				ip[1] = ip[3];
			}
		} else if (	(tpNum == 2 && ipNum == 3 && rpNum == 1) ||
					(tpNum == 1 && ipNum == 3 && rpNum == 1)) {
			
			if (SamePointBasically(ip[0], ip[1])) {
				if (ipData[1][0] == ipData[2][0]) {
					
					
					
				}
				
				ip[1] = ip[2];
			}
			--ipNum;
		}
	}*/
		
	if (tpNum == 3 && ipNum == 0 && rpNum == 0) {
		
		results[resultOn].points[0] = tri.points[0];
		results[resultOn].points[1] = tri.points[1];
		results[resultOn].points[2] = tri.points[2];
		
		results[resultOn].edges[0] = tri.edges[0];
		results[resultOn].edges[1] = tri.edges[1];
		results[resultOn].edges[2] = tri.edges[2];
		++resultOn;
		
		return false;
		
	} else if (tpNum == 0 && ipNum == 0 && rpNum == 0) {
		
		
		// do NOTHING!
		
	} else if (tpNum == 2 && ipNum == 2 && rpNum == 0) {
		
		if (ipData[0][0] == tpData[0] || (ipData[0][0]+1)%3 == tpData[0]) {
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = tp[0];
			results[resultOn].edges[0] = true;
			++resultOn;
			
			
			results[resultOn].points[0] = ip[1];
			results[resultOn].points[1] = tp[0];
			results[resultOn].points[2] = tp[1];
			++resultOn;
		} else {
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = tp[1];
			results[resultOn].edges[0] = true;
			++resultOn;
			
			results[resultOn].points[0] = ip[1];
			results[resultOn].points[1] = tp[0];
			results[resultOn].points[2] = tp[1];
			++resultOn;
		}
		
		
	} else if (tpNum == 1 && ipNum == 2 && rpNum == 0) {
		
		results[resultOn].points[0] = ip[0];
		results[resultOn].points[1] = ip[1];
		results[resultOn].points[2] = tp[0];
		results[resultOn].edges[0] = true;
		++resultOn;
		
	} else if (tpNum == 1 && ipNum == 2 && rpNum == 1) {
		
		results[resultOn].points[0] = rp[0];
		results[resultOn].points[1] = ip[0];
		results[resultOn].points[2] = tp[0];
		results[resultOn].edges[0] = true;
		++resultOn;
		
		results[resultOn].points[0] = rp[0];
		results[resultOn].points[1] = ip[1];
		results[resultOn].points[2] = tp[0];
		results[resultOn].edges[0] = true;
		++resultOn;
		
	} else if (tpNum == 2 && ipNum == 4 && rpNum == 0) {
		
		if (	(ipData[0][0] == tpData[0] || (ipData[0][0]+1)%3 == tpData[0]) &&
				(ipData[1][0] == tpData[0] || (ipData[1][0]+1)%3 == tpData[0])) {
			
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = tp[0];
			results[resultOn].edges[0] = true;
			++resultOn;
			
			results[resultOn].points[0] = ip[2];
			results[resultOn].points[1] = ip[3];
			results[resultOn].points[2] = tp[1];
			results[resultOn].edges[0] = true;
			++resultOn;
		} else {
			
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = tp[1];
			results[resultOn].edges[0] = true;
			++resultOn;
			
			results[resultOn].points[0] = ip[2];
			results[resultOn].points[1] = ip[3];
			results[resultOn].points[2] = tp[0];
			results[resultOn].edges[0] = true;
			++resultOn;
		}
		
		
	} else if (tpNum == 2 && ipNum == 2 && rpNum == 1) {
		
		results[resultOn].points[0] = tp[0];
		results[resultOn].points[1] = tp[1];
		results[resultOn].points[2] = rp[0];
		++resultOn;
		
		if (ipData[0][0] == tpData[0] || (ipData[0][0]+1)%3 == tpData[0]) {
			
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = tp[0];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[2] = true;
			++resultOn;
			
			results[resultOn].points[0] = ip[1];
			results[resultOn].points[1] = tp[1];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[2] = true;
			++resultOn;
		} else {
			
			results[resultOn].points[0] = ip[1];
			results[resultOn].points[1] = tp[0];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[2] = true;
			++resultOn;
			
			results[resultOn].points[0] = ip[0];
			results[resultOn].points[1] = tp[1];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[2] = true;
			++resultOn;
		}
		
	} else if (tpNum == 3 && ipNum == 2 && rpNum == 1) {
		// This one is complicated.
		// Solution: test to see which of the two intersecting point is closer to the triangle vertices
		if (ipData[0][0] == tpData[0])
			n = 0;
		else if (ipData[0][0] == tpData[1])
			n = 1;
		else
			n = 2;
		
		results[resultOn].points[0] = tp[(n+1)%3];
		results[resultOn].points[1] = tp[(n+2)%3];
		results[resultOn].points[2] = rp[0];
		++resultOn;
		results[resultOn].points[0] = tp[(n+2)%3];
		results[resultOn].points[1] = tp[n];
		results[resultOn].points[2] = rp[0];
		++resultOn;
		
		dist1 = (tp[n].x - ip[0].x)*(tp[n].x - ip[0].x) + (tp[n].z - ip[0].z)*(tp[n].z - ip[0].z);
		dist2 = (tp[n].x - ip[1].x)*(tp[n].x - ip[1].x) + (tp[n].z - ip[1].z)*(tp[n].z - ip[1].z);
		
		if (dist1 < dist2) {
			
			results[resultOn].points[0] = tp[n];
			results[resultOn].points[1] = ip[0];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[1] = true;
			++resultOn;
			results[resultOn].points[0] = tp[(n+1)%3];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[1] = true;
			++resultOn;
			
		} else {
		
			results[resultOn].points[0] = tp[n];
			results[resultOn].points[1] = ip[1];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[1] = true;
			++resultOn;
			results[resultOn].points[0] = tp[(n+1)%3];
			results[resultOn].points[1] = ip[0];
			results[resultOn].points[2] = rp[0];
			results[resultOn].edges[1] = true;
			++resultOn;
			
		
		}
		
	} else if (tpNum == 3 && ipNum == 4 && rpNum == 0) {
		// This one is even more complicated.
		// Solution: find which intersection points connect to which triangle vertices, and see which of those are closer
				
		if (ipData[0][0] != tpData[0] && ipData[1][0] != tpData[0])
			n = 0;
		else if (ipData[0][0] != tpData[1] && ipData[1][0] != tpData[1])
			n = 1;
		else
			n = 2;
		
		if (ipData[0][0] == tpData[(n+1)%3]) {
			n2a = 0;
			n2b = 1;
		} else {
			n2a = 1;
			n2b = 0;
		}
		
		if (ipData[2][0] == tpData[(n+1)%3]) {
			n3a = 2;
			n3b = 3;
		} else {
			n3a = 3;
			n3b = 2;
		}
		
		dist1 = (tp[(n+1)%3].x - ip[n2a].x)*(tp[(n+1)%3].x - ip[n2a].x) + (tp[(n+1)%3].z - ip[n2a].z)*(tp[(n+1)%3].z - ip[n2a].z);
		dist2 = (tp[(n+1)%3].x - ip[n3a].x)*(tp[(n+1)%3].x - ip[n3a].x) + (tp[(n+1)%3].z - ip[n3a].z)*(tp[(n+1)%3].z - ip[n3a].z);
		
		if (dist1 < dist2) {
			
			results[resultOn].points[0] = tp[(n+1)%3];
			results[resultOn].points[1] = ip[n2a];
			results[resultOn].points[2] = ip[n2b];
			results[resultOn].edges[1] = true;
			++resultOn;
			
			results[resultOn].points[0] = tp[n];
			results[resultOn].points[1] = tp[(n+1)%3];
			results[resultOn].points[2] = ip[n2b];
			++resultOn;
			
			results[resultOn].points[0] = tp[(n+2)%3];
			results[resultOn].points[1] = ip[n3a];
			results[resultOn].points[2] = ip[n3b];
			results[resultOn].edges[1] = true;
			++resultOn;
			
		} else {
			
			results[resultOn].points[0] = tp[(n+1)%3];
			results[resultOn].points[1] = ip[n3a];
			results[resultOn].points[2] = ip[n3b];
			results[resultOn].edges[1] = true;
			++resultOn;
			
			results[resultOn].points[0] = tp[n];
			results[resultOn].points[1] = tp[(n+1)%3];
			results[resultOn].points[2] = ip[n3b];
			++resultOn;
			
			results[resultOn].points[0] = tp[(n+2)%3];
			results[resultOn].points[1] = ip[n2a];
			results[resultOn].points[2] = ip[n2b];
			results[resultOn].edges[1] = true;
			++resultOn;
		}
	}
	
	// calculate edges:
	
	for(int i = 0; i < resultOn; ++i) {
		
		if (results[i].points[0].edge > 0) {
			if (results[i].points[1].edge > 0 && results[i].points[0].edgeSlope == results[i].points[1].edgeSlope)
				results[i].edges[0] = true;
		}
		if (results[i].points[1].edge > 0) {
			if (results[i].points[2].edge > 0 && results[i].points[1].edgeSlope == results[i].points[2].edgeSlope)
				results[i].edges[1] = true;
		}
		if (results[i].points[2].edge > 0) {
			if (results[i].points[2].edge > 0 && results[i].points[2].edgeSlope == results[i].points[0].edgeSlope)
				results[i].edges[2] = true;
		}
	}
	
	return true;
}

// is c between a and b?
bool between(double a, double b, double c)
{
	double offset = 0.0000001; // accounts for floating point errors
	
	if (a > b)
		return (c >= b-offset && c <= a+offset);
	else
		return (c >= a-offset && c <= b+offset);
}

/*
void DrawLineThingies()
{
	glDisable(GL_DEPTH_TEST);
	
	glColor3f(1,0,0);
	
	glLineWidth(3);
	glBegin(GL_LINES);
	
	for(int i = 0; i < edgeNum; ++i) {
		
		glVertex3f(pitEdges[i].x1, pitEdges[i].y1, pitEdges[i].z1);
		glVertex3f(pitEdges[i].x2, pitEdges[i].y2, pitEdges[i].z2);
		
		
	}
	
	glEnd();
	glEnable(GL_DEPTH_TEST);
	
}*/


void CreatePitList()
{
	GLdouble pitTexScale = 10;
	double x1, x2, y1, y2, z1, z2, dx, dz, m, d, n1, n2;
	double nx,ny,nz, lx, ly, lz, shadow;
	double minLight = .55;
	
	//glEnable(GL_TEXTURE_2D);
	//glBindTexture(GL_TEXTURE_2D, textures[kPit].GetTextureID());
	
	//glDisable(GL_LIGHTING);
	
	//glNewList(pitDisplayList, GL_COMPILE);
	//glBegin(GL_QUADS);
	
	pitVertexNum = 0;
	
	for(int i = 0; (i < edgeNum && pitVertexNum < MAXEDGES); ++i) {
		
		//CalculateNormals(normals, pitEdges[i].x1, pitEdges[i].y1, pitEdges[i].z1, pitEdges[i].x2, pitEdges[i].y2, pitEdges[i].z2, pitEdges[i].x2, pitEdges[i].y2-100, pitEdges[i].z2);
		//glNormal3fv(normals);
		
		x1 = pitEdges[i].x1;
		x2 = pitEdges[i].x2;
		y1 = pitEdges[i].y1;
		y2 = pitEdges[i].y2;
		z1 = pitEdges[i].z1;
		z2 = pitEdges[i].z2;
		
		dx = fabs(x2-x1);
		dz = fabs(z2-z1);	
		d = sqrt(dz*dz+dx*dx);
		
		/*
		a = RandomNumber(-5,5);
		b = RandomNumber(-5,5);
		c = RandomNumber(-5,5);
		
		q = sqrt(a*a+b*b+c*c);
		
		glNormal3f(a/q,b/q,c/q);
		*/
		
		//glNormal3f(dx/d, -dz/d, 0);
		
		if (dx > dz) {
			m = dx/d;
			n1 = x1/m;
			n2 = x2/m;
		} else {
			m = dz/d;
			n1 = z1/m;
			n2 = z2/m;
		}
		
		lightAngle.Convert(lx,ly,lz);
		
		shadow = max(0.0, (dx/d)*lx + (dz/d)*lz);
		
		shadow *= (1 - minLight);
		shadow += minLight;
		
		pitColors[pitVertexNum*4]		= shadow;
		pitColors[pitVertexNum*4+1]		= shadow;
		pitColors[pitVertexNum*4+2]		= shadow;
		pitColors[pitVertexNum*4+3]		= 1;
		
		pitTexCoords[pitVertexNum*2]	= n1 / pitTexScale;
		pitTexCoords[pitVertexNum*2+1]	= 0;
		
		pitVertices[pitVertexNum*3]		= x1;
		pitVertices[pitVertexNum*3+1]	= pitEdges[i].y1;
		pitVertices[pitVertexNum*3+2]	= z1;
		++pitVertexNum;
		
		
		pitColors[pitVertexNum*4]		= shadow;
		pitColors[pitVertexNum*4+1]		= shadow;
		pitColors[pitVertexNum*4+2]		= shadow;
		pitColors[pitVertexNum*4+3]		= 1;
		
		pitTexCoords[pitVertexNum*2]	= n2 / pitTexScale;
		pitTexCoords[pitVertexNum*2+1]	= 0;
		
		pitVertices[pitVertexNum*3]		= x2;
		pitVertices[pitVertexNum*3+1]	= pitEdges[i].y2;
		pitVertices[pitVertexNum*3+2]	= z2;
		++pitVertexNum;
		
		
		pitColors[pitVertexNum*4]		= 0;
		pitColors[pitVertexNum*4+1]		= 0;
		pitColors[pitVertexNum*4+2]		= 0;
		pitColors[pitVertexNum*4+3]		= 1;
		
		pitTexCoords[pitVertexNum*2]	= n2 / pitTexScale;
		pitTexCoords[pitVertexNum*2+1]	= pitDepth/pitTexScale;
		
		pitVertices[pitVertexNum*3]		= x2;
		pitVertices[pitVertexNum*3+1]	= pitEdges[i].y2-pitDepth;
		pitVertices[pitVertexNum*3+2]	= z2;
		++pitVertexNum;
		
		
		pitColors[pitVertexNum*4]		= 0;
		pitColors[pitVertexNum*4+1]		= 0;
		pitColors[pitVertexNum*4+2]		= 0;
		pitColors[pitVertexNum*4+3]		= 1;
		
		pitTexCoords[pitVertexNum*2]	= n1 / pitTexScale;
		pitTexCoords[pitVertexNum*2+1]	= pitDepth/pitTexScale;
		
		pitVertices[pitVertexNum*3]		= x1;
		pitVertices[pitVertexNum*3+1]	= pitEdges[i].y1-pitDepth;
		pitVertices[pitVertexNum*3+2]	= z1;
		++pitVertexNum;
		
		/*
		glColor4f(1,1,1, calculateFog(x1,y1,z1));
		glTexCoord2d(  n1 / pitTexScale ,0);
		glVertex3f(x1, pitEdges[i].y1, z1);
		
		
		glColor4f(1,1,1, calculateFog(x2,y2,z2));
		glTexCoord2d(  n2 / pitTexScale ,0);
		glVertex3f(x2, pitEdges[i].y2, z2);
		
		
		glColor4f(0,0,0, calculateFog(x2,y2,z2));
		glTexCoord2d(  n2 / pitTexScale , pitDepth/pitTexScale);
		glVertex3f(x2, pitEdges[i].y2-pitDepth, z2);
		
		
		glColor4f(0,0,0, calculateFog(x1,y1,z1));
		glTexCoord2d(  n1 / pitTexScale ,pitDepth/pitTexScale);
		glVertex3f(x1, pitEdges[i].y1-pitDepth, z1);*/
		
	}
	//glEnd();
	//glEndList();
}

void DrawPitInnards()
{
	//GLfloat noSpecular[] = { 0,0,0,0 };
	
	//if (glIsList(pitDisplayList)) {
		
		
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[kPit].GetTextureID());
		
		glDisable(GL_BLEND);
		glDisable(GL_LIGHTING);
		glDisable(GL_COLOR_MATERIAL);
		//glMaterialfv(GL_FRONT, GL_SPECULAR, noSpecular);
		
		
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);
		glEnableClientState(GL_COLOR_ARRAY);
		
	
		//glColorMask(0,0,0,0);
		if (superFog) {
			for(int i = 0; i < pitVertexNum; ++i)
				pitColors[i*4+3] = calculateFog(pitVertices[i*3], pitVertices[i*3+1], pitVertices[i*3+2]);
			
		}
		
		glColorPointer (4, GL_FLOAT, 0, pitColors);
		glTexCoordPointer (2, GL_FLOAT, 0, pitTexCoords);
		glVertexPointer (3, GL_FLOAT, 0, pitVertices);
		
		glDrawArrays(GL_QUADS, 0, pitVertexNum);
		
		//glCallList(pitDisplayList);
	//}
}

void GetEdges(const Triangle &tri)
{
	if (edgeNum < MAXEDGES) {
		if (tri.edges[0]) {
			pitEdges[edgeNum].x1 = tri.points[0].x;
			pitEdges[edgeNum].y1 = tri.points[0].y;
			pitEdges[edgeNum].z1 = tri.points[0].z;
			pitEdges[edgeNum].x2 = tri.points[1].x;
			pitEdges[edgeNum].y2 = tri.points[1].y;
			pitEdges[edgeNum].z2 = tri.points[1].z;
			++edgeNum;
		}
		if (tri.edges[1]) {
			pitEdges[edgeNum].x1 = tri.points[1].x;
			pitEdges[edgeNum].y1 = tri.points[1].y;
			pitEdges[edgeNum].z1 = tri.points[1].z;
			pitEdges[edgeNum].x2 = tri.points[2].x;
			pitEdges[edgeNum].y2 = tri.points[2].y;
			pitEdges[edgeNum].z2 = tri.points[2].z;
			++edgeNum;
		}
		if (tri.edges[2]) {
			pitEdges[edgeNum].x1 = tri.points[2].x;
			pitEdges[edgeNum].y1 = tri.points[2].y;
			pitEdges[edgeNum].z1 = tri.points[2].z;
			pitEdges[edgeNum].x2 = tri.points[0].x;
			pitEdges[edgeNum].y2 = tri.points[0].y;
			pitEdges[edgeNum].z2 = tri.points[0].z;
			++edgeNum;
		}
	}
}
