/*
 * This code was created by Jeff Molofee '99 
 * (ported to Linux/SDL by Ti Leggett '01)
 *
 * If you've found this code useful, please let me know.
 *
 * Visit Jeff at http://nehe.gamedev.net/
 * 
 * or for port-specific comments, questions, bugreports etc. 
 * email to leggett@eecs.tulane.edu
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <SDL/SDL.h>

#include "external.h"
#include "openglstuff.h"
#include "game.h"
#include "terrain.h"


bool		keys[SDLK_LAST];// Array Used For The Keyboard Routine
bool		fullscreen=false;

bool		bufferFPS = true;
int			targetFPS = 60;
double		targetFrameTime = 1000.0 / targetFPS;
double		drawNextFrameTime = 0;
double		averageFPS = 0;
double		currentFPS = 0;
int			framesDropped = 0, currentFramesDropped = 0;

const int   frameTrackNum = 15;

/* screen width, height, and bit depth */
#define SCREEN_WIDTH  1024
#define SCREEN_HEIGHT 768
#define SCREEN_BPP	 24


/* This is our SDL surface */
SDL_Surface *surface;

/* function to release/destroy our resources and restoring the old desktop */
void Quit(int returnCode)
{
	DieDieDieDieDieDieDie();
	/* clean up the window */
	SDL_Quit();
	
	/* and exit appropriately */
	exit(returnCode);
}

void error(const char *error, const char *error2 = NULL)
{
	//fprintf( stderr, "Could not get a surface after resize: %s\n", SDL_GetError( ) );
	
	DieDieDieDieDieDieDie();
	SDL_Quit();
	exit(1);
}


//int main(int argc, char* argv[])

bool the = true;

//int WINAPI WinMain(	HINSTANCE	hInstance,				// Instance
//			HINSTANCE	hPrevInstance,				// Previous Instance
//			LPSTR		lpCmdLine,				// Command Line Parameters
//			int		nCmdShow)				// Window Show State

extern "C" int unicycleMain(int argc, char *argv[])
{
	

	/* Flags to pass to SDL_SetVideoMode */
	int videoFlags;
	/* main loop variable */
	int done = false;
	/* used to collect events */
	SDL_Event event;
	/* this holds some info about our display */
	const SDL_VideoInfo *videoInfo;
	/* whether or not the window is active */
	int isActive = true;
	// My stuff:
	int frameTime = 0, currentTime = 0, frames = 0, startTime = 0;
	long timeBuffer[frameTrackNum];
	int frameTrackOn = 0;
	short key;
	
	for(int i = 0; i < frameTrackNum; ++i)
		timeBuffer[i] = 0;
	
	/* initialize SDL */
	if ( SDL_Init( SDL_INIT_VIDEO ) < 0 )
		error("Video initialization failed!!", SDL_GetError());
	
	/* Fetch the video info */
	videoInfo = SDL_GetVideoInfo( );

	if ( !videoInfo )
		error("Video query failed!!", SDL_GetError());
	
	/* the flags to pass to SDL_SetVideoMode */
	videoFlags  = SDL_OPENGL;		  /* Enable OpenGL in SDL */
	videoFlags |= SDL_GL_DOUBLEBUFFER; /* Enable double buffering */
	videoFlags |= SDL_HWPALETTE;	   /* Store the palette in hardware */
	//videoFlags |= SDL_RESIZABLE;	   /* Enable window resizing */
	if (fullscreen)
		videoFlags |= SDL_FULLSCREEN;
	
	/* This checks to see if surfaces can be stored in memory */
	if ( videoInfo->hw_available )
		videoFlags |= SDL_HWSURFACE;
	else
		videoFlags |= SDL_SWSURFACE;

	/* This checks if hardware blits can be done */
	if ( videoInfo->blit_hw )
		videoFlags |= SDL_HWACCEL;
	
	/* Sets up OpenGL double buffering */
	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
	//SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_ALPHA_SIZE, 8 );
		

	/* get a SDL surface */
	surface = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP,
				videoFlags );
	
	/* Verify there is a surface */
	if ( !surface )
		error("Video mode set failed!!", SDL_GetError());

	/* initialize OpenGL */
	if (InitGL() == false)
		error("Could not initialize OpenGL!!");

	/* Resize the initial window */
	ReSizeGLScene( SCREEN_WIDTH, SCREEN_HEIGHT );
	
	InitProgram();	
	
	/* wait for events */
	while(!done) {
		/* handle the events in the queue */
		
		while ( SDL_PollEvent( &event ) )
		{
			switch( event.type )
			{
			case SDL_ACTIVEEVENT:
				/* Something's happend with our focus
				 * If we lost focus or we are iconified, we
				 * shouldn't draw the screen
				 */
				if ( event.active.gain == 0 )
					isActive = false;
				else
					isActive = true;
				break;
			case SDL_VIDEORESIZE:
				/* handle resize event */
				surface = SDL_SetVideoMode( event.resize.w, event.resize.h, 16, videoFlags );
				if ( !surface )
					error("Could not get a surface after resize!!", SDL_GetError( ) );
				ReSizeGLScene( event.resize.w, event.resize.h );
				break;
			case SDL_KEYDOWN:
				/* handle key presses */
				key = event.key.keysym.sym;
				switch (key)
				{
					case SDLK_ESCAPE:
						/* ESC key was pressed */
						done = true;
						break;
					case SDLK_F1:
						/* F1 key was pressed
						 * this toggles fullscreen mode
						 */
						SDL_WM_ToggleFullScreen(surface);
						break;
					case 'r':
						startTime = GetMilliseconds();
						frames = 0;
						break;
					default:
						keys[event.key.keysym.sym] = true;
						break;
				}
				break;
			case SDL_KEYUP:
				key = event.key.keysym.sym;
				keys[key] = false;
				break;
			case SDL_QUIT:
				/* handle quit requests */
				done = true;
				break;
			default:
				break;
			}
		}
		
		/* draw the scene */
		if (isActive) {
			
			currentTime = GetMilliseconds();
			if (startTime == 0)
				startTime = currentTime;
			else {
				averageFPS = double(frames) / ((currentTime-startTime)/1000.0);
				
				
			}
			
			
			//if ( (currentTime-frameTime) >= targetFrameTime || !bufferFPS) {
			if (!bufferFPS || currentTime >= drawNextFrameTime) {
				drawNextFrameTime = (floor(currentTime / targetFrameTime) + 1) * targetFrameTime;
				frameTime = currentTime;
				
				PlayGame();
				//if (the)
				DrawGLScene();
				//the = !the;
				SDL_GL_SwapBuffers();
				frames++;
				currentFramesDropped = 0;
				DoDebuggingStuff();
				
				if (timeBuffer[frameTrackOn] == 0)
					currentFPS = 0;
				else
					currentFPS = frameTrackNum / (double(currentTime - timeBuffer[frameTrackOn]) / 1000.0);
				
				timeBuffer[frameTrackOn] = currentTime;
				++frameTrackOn;
				if (frameTrackOn >= frameTrackNum)
					frameTrackOn = 0;
			}
				
			
			if (keys['R']) {
				startTime = currentTime;
				frames = 0;
			}
            
            static int blah = 0;
            blah += 1;
            if (blah > 20) {
                printf("currentFPS: %lf\n", currentFPS);
                blah = 0;
            }
            /*
			ostringstream s;
			
			if (currentTime - startTime > 0)
				s << frames/((currentTime-startTime) / 1000.0) << '\n' << camera.ry << '\n' << camera.rx <<
					'\n' << guy.x << '\n' << guy.y << '\n' << guy.z << '\n' << "Walls: "
					<< currentWallNum << "\nPits:" << currentPitNum << "\nX offset" << xOffset << "\nZ offset:"
					<< zOffset << "\nDead?: " << withinWall << "\nWallDealy: " << wallDealy <<  "\nSpeed: " << guy.speed;
			
			SetRect(&textRect, 0,0,200,350);
			DrawText(hDC, s.str().c_str(), -1, &textRect, DT_TOP);*/
		}
	}
	
	/* clean ourselves up and exit */
	Quit(0);

	/* Should never get here */
	return(0);
}


bool * GetKeys()
{
	return keys;
}

bool GetKey(int key)
{
	return keys[key];
}

long GetMilliseconds()
{
	return SDL_GetTicks();
}
