#include "external.h"
#include "openglstuff.h"
#include "textures.h"
#include "game.h"
#include <math.h>

#include "particles.h"

extern Camera			camera;
extern GLTexture		*textures;
extern GLUquadricObj	*quadratic;
extern int				terrainSize;
extern int				targetFPS;

const double sqrtTwo = sqrt(2.0);
const double pi = 3.141592653589;
const double twoPi = pi*2;
const double piOver180 = pi / 180.0;

Particle *particles = NULL;
const int maxParticles = 500;


GLuint lists[particleNum];


Particle::Particle()
{
	x = y = z = vx = vy = vz = ax = ay = az = r = vr = 0;
	active = false;
	
}


void Particle::Draw()
{
	--longevity;
	
	if (longevity == 0) active = false;
	
	vx += ax;
	vy += ay;
	vz += az;
	
	x += vx;
	y += vy;
	z += vz;
	
	r += vr;
	
	glPushMatrix();
	
	glTranslatef(x,y,z);
	glRotatef(camera.rz, 0,0,1);
	glRotatef(camera.ry, 0,1,0);
	glRotatef(camera.rx, 1,0,0);
	
	glRotatef(r, 0,0,1);
	
	glScalef(size,size,size);
	
	if (drawList == kPSparkle) {
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		double s = 0.2;
		
		glColor4f(1.0, 1.0, RandomNumber(0,1.0), 1.0);
		glBegin(GL_TRIANGLE_FAN);
			
			glVertex3f(0,0,0);
			glVertex3f(0,s,0);
			//glVertex3f(s/sqrtTwo,s/sqrtTwo,0);
			glVertex3f(s,0,0);
			//glVertex3f(s/sqrtTwo,-s/sqrtTwo,0);
			glVertex3f(0,-s,0);
			//glVertex3f(-s/sqrtTwo,-s/sqrtTwo,0);
			glVertex3f(-s,0,0);
			//glVertex3f(-s/sqrtTwo,s/sqrtTwo,0);
			glVertex3f(0,s,0);
		
		glEnd();
	
		glEnable(GL_BLEND);
		glEnable(GL_TEXTURE_2D);
	} else
		glCallList(lists[drawList]);
	
	glPopMatrix();
}

void DrawParticles()
{
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glColorMask(1,1,1,0);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	for(int i = 0; i < maxParticles; ++i) {
		if (particles[i].active)
			particles[i].Draw();
	}
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glColorMask(1,1,1,1);
	
}

void Particle::CreateParticle(double cx, double cy, double cz,
								double rxMin, double rxMax, double ryMin, double ryMax,
								double cvx, double cvy, double cvz,
								double cax, double cay, double caz,
								double crv,
								double minSpeed, double maxSpeed,
								double minSize, double maxSize,
								double minLife, double maxLife)
{
	double rx, ry;
	
	x = cx;
	y = cy;
	z = cz;
	
	ax = ConvertAcceleration(cax);
	ay = ConvertAcceleration(cay);
	az = ConvertAcceleration(caz);
	
	r = RandomNumber(0,360);
	vr = crv;
	
	speed = ConvertSpeed(RandomNumber(minSpeed, maxSpeed));
	size = RandomNumber(minSize, maxSize);
	longevity = targetFPS * (RandomNumber(minLife, maxLife));
	
	rx = RandomNumber(rxMin, rxMax);
	ry = RandomNumber(ryMin, ryMax);
	
	vx = sin(ry * piOver180) * cos(rx * piOver180) * speed + cvx;
	vz = cos(ry * piOver180) * cos(rx * piOver180) * speed + cvz;
	vy = sin(rx * piOver180) * speed + cvy;
	
	active = true;
} 

void CreateParticles(int num, int type, double cx, double cy, double cz,
						double rxMin, double rxMax, double ryMin, double ryMax,
						double cvx, double cvy, double cvz,
						double cax, double cay, double caz,
						double crv,
						double minSpeed, double maxSpeed,
						double minSize, double maxSize,
						double minLife, double maxLife)
{
	int n = 0;
	for(int i = 0; i < maxParticles && n < num; ++i) {
		if (!particles[i].active) {
			particles[i].drawList = type;
			particles[i].CreateParticle(cx, cy, cz, rxMin, rxMax, ryMin, ryMax, cvx, cvy, cvz, cax, cay, caz, crv, minSpeed, maxSpeed, minSize, maxSize, minLife, maxLife);
			++n;
		}
	}
}

void InitParticles()
{
	particles = new Particle [maxParticles];
	
	lists[kPStar] = glGenLists(1);
	glNewList(lists[kPStar], GL_COMPILE);
	
	glBindTexture(GL_TEXTURE_2D, textures[kStar].GetTextureID());
	
	glColor4f(1,1,0,1);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(-0.5,-0.5,0);
		
		glTexCoord2f(1,0);
		glVertex3f(0.5,-0.5,0);
		
		glTexCoord2f(1,1);
		glVertex3f(0.5,0.5,0);
		
		glTexCoord2f(0,1);
		glVertex3f(-0.5,0.5,0);
		
	glEnd();
	
	glEndList();
	
	
	
	lists[kPDirt] = glGenLists(1);
	glNewList(lists[kPDirt], GL_COMPILE);
	
	glBindTexture(GL_TEXTURE_2D, textures[kDirt].GetTextureID());
	
	glColor4f(1, 1, 1, 0.75);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(-0.5,-0.5,0);
		
		glTexCoord2f(1,0);
		glVertex3f(0.5,-0.5,0);
		
		glTexCoord2f(1,1);
		glVertex3f(0.5,0.5,0);
		
		glTexCoord2f(0,1);
		glVertex3f(-0.5,0.5,0);
		
	glEnd();
	
	glEndList();
}

void KillParticles()
{
	if (particles) {
		delete[] particles;
		glDeleteLists(lists[0], particleNum);
	}
}