#ifndef _OPENGLSTUFF_H_
#define _OPENGLSTUFF_H_




class Camera {
public:
	double x; 
	double y;
	double z;
	double rx; 
	double ry;
	double rz;
	
	Camera() : x(0), y(0), z(0), rx(0), ry(0), rz(0) {};
	Camera(double X, double Y, double Z) : x(X), y(Y), z(Z), rx(0), ry(0), rz(0) {};
	Camera(double X, double Y, double Z, double RX, double RY, double RZ) : x(X), y(Y), z(Z), rx(RX), ry(RY), rz(RZ) {};
	void SetLocation(double X, double Y, double Z);
	void SetRotation(double RX, double RY, double RZ);
	void Set(double X, double Y, double Z, double RX, double RY, double RZ);
};




// OpenGL stuff:

GLvoid ReSizeGLScene(GLsizei width, GLsizei height);
int InitGL(GLvoid);
int DrawGLScene(GLvoid);
void DEBUGAdjustFog();
void KillGL();
void SetupFog(float *clearColor);

void CalculateNormalVector(	double x1, double y1, double z1,
							double x2, double y2, double z2, 
							double x3, double y3, double z3, 
							double &rx, double &ry, double &rz);
							
void glVertex3fWithSuperFog(GLfloat x, GLfloat y, GLfloat z);
void SuperFog(GLfloat x, GLfloat y, GLfloat z, GLfloat r = 1, GLfloat g = 1, GLfloat b = 1);
GLfloat calculateFog(GLfloat x, GLfloat y, GLfloat z);
void GetProjection();

// for debugging only:


//void glDrawText(const char *text, GLfloat x, GLfloat y, GLfloat z, GLfloat size, int align);
//GLvoid KillFont(GLvoid);
//GLvoid BuildFont(GLvoid);
void DoDebuggingStuff();






#endif