
#ifndef _LAZYPOINTER_H_
#define _LAZYPOINTER_H_


template <class itemType>
class LazyPointer {
public:
	
	itemType *data;
	
	LazyPointer() : data(0L) {}
	
	const LazyPointer & operator = (const LazyPointer &rhs);
	const LazyPointer & operator = (itemType f);
	
	const LazyPointer & operator += (const LazyPointer &rhs);
	const LazyPointer & operator += (itemType f);
	const LazyPointer & operator -= (const LazyPointer &rhs);
	const LazyPointer & operator -= (itemType f);
	const LazyPointer & operator *= (const LazyPointer &rhs);
	const LazyPointer & operator *= (itemType f);
	const LazyPointer & operator /= (const LazyPointer &rhs);
	const LazyPointer & operator /= (itemType f);
	
	
	operator itemType () const {return *data;}
};

#include "lazypointer.cpp"

#endif