#ifndef LAZY_POINTER_H
#define LAZY_POINTER_H

#include "lazypointer.h"

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator =(const LazyPointer<itemType> &rhs)
{
	*data = *(rhs.data);
    return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator =(itemType f)
{
	*data = f;
    return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator += (const LazyPointer<itemType> &rhs)
{
	*data += *(rhs.data);
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator += (itemType f)
{
	*data += f;
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator -= (const LazyPointer<itemType> &rhs)
{
	*data -= *(rhs.data);
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator -= (itemType f)
{
	*data -= f;
	return *this;
}


template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator *= (const LazyPointer<itemType> &rhs)
{
	*data *= *(rhs.data);
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator *= (itemType f)
{
	*data *= f;
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator /= (const LazyPointer<itemType> &rhs)
{
	*data /= *(rhs.data);
	return *this;
}

template <class itemType>
const LazyPointer<itemType> & LazyPointer<itemType>::operator /= (itemType f)
{
	*data /= f;
	return *this;
}

#endif
