#ifndef _GAME_H_
#define _GAME_H_


enum {
	kTopleft		= 0,
	kTopRight		= 1,
	kBottomRight	= 2,
	kBottomLeft		= 3
};

class Pit {
public:
	bool exists;
	
	double x;
	double z;
	
	double rotation;
	int length;
	int width;
	
	// Data for actual corners of the bit + bounding box:
	Quadrilateral corners;
	double minX, minZ, maxX, maxZ;
	
	Pit *next;
	
	Pit() : x(0), z(0), exists(false), rotation(0) {};
	void CheckForDeath();
	void Draw();
	void ActuallyCreatePit(int x, int z, double rotationMin);
	
};


class BrickWall {
public:
	
	bool exists;
	bool reserved;
	
	double x;
	double z;
	
	double height;
	double rotation;
	double length;
	double width;
	
	BrickWall() : x(0), z(0), exists(false), height(0), rotation(0) {};
	void CheckForDeath();
	void Draw();
};


class SmileyFace {
public:
	
	bool exists;
	bool big;
	bool minYCalculated;
	bool shadowCalculated;
	
	double sx1, sy1, sz1;
	double sx2, sy2, sz2;
	double sx3, sy3, sz3;
	double sx4, sy4, sz4;
	double shadowSize;
	
	double x;
	double y;
	double z;
	
	double r;
	
	SmileyFace *next;
	
	SmileyFace() : x(0), y(0), z(0), exists(false) {};
	void Draw(int rotation);
	bool CheckForGotten();
};


class UnicycleGuy {
public:
	double x;
	double y;
	double z;
	double vx;
	double vy;
	double vz;
	double ax;
	double ay;
	double az;
	double rx;
	double ry;
	double rz;
	double xLean;
	double zLean;
	double targetXLean;
	double targetZLean;
	
	bool jumpKey;
	int airTime;
	
	double speed;
	
	bool justLanded;
	bool inAir;
	bool reallyDead;
	bool dead;
	int falling;
};

// game stuff:

void PlayGame();
void DetectStuff();
void MoveUnicycleGuy();
void UnicycleControls();
double ConvertSpeed(double pps);
double ConvertAcceleration(double ppsps);
void InitSpeeds();
void AdjustCamera();
void InitGame();
void KillGame();
void DoDeviousThings(int xOffset, int zOffset);
void CreateWall(int x, int z, double rotationMin);
void CreatePit(int x, int z, double rotationMin);
void DrawWalls();
void DrawPits();
bool WithinRange(double x, double z, double cx, double cz, double r);
bool WithinRect(double x, double z, double left, double top, double right, double bottom);
void DrawUnicycleGuyShadow();
void KillMurderKillStabityStabStabStabKill();
void GuyGoSplat();
void PitifyTerrain(double x, double z, double rotation, int length, int width);
void DrawSmilies();
void FallFallyMcFallsalotDeathySplayFall();

#endif