#include "external.h"
#include "openglstuff.h"
#include "textures.h"
#include "terrain.h"
#include "game.h"
#include <math.h>

extern UnicycleGuy	guy;
extern Camera			camera;
extern GLTexture		*textures;
extern GLUquadricObj	*quadratic;
extern int				terrainSize;
extern HillPiece		**terrain;
extern int				terrainLength;
extern double			spacing;
extern bool				superFog;
extern GLfloat			worldScale;

extern float ambient[4];
extern float diffuse[4];
extern float specular[4];
extern float lightPosition[4];

const int quadQual = 16;

const double pi = 3.141592653589;
const double sqrtTwo = sqrt(2.0);
const double piOver180 = pi/180.0;
const double oneEightyOverPi = 180.0/pi;


GLuint guyList, guyDeadList, skyList, pitList;


double whee = 0;
double woogle = 0.1;



int FindOrder(Point *interest, Point *result, int pointNum);
bool between(double a, double b, double c);
int FindIntersection(Point *tri, Point *rect, Point *result);


/*
void Pit::Draw()
{
	double xc,zc, xDX, zDX, xDZ, zDZ, startX, startZ, y;
	int thing = 0;
	int pxi, pzi;
	int pitDepth = 4;
	double *xPerim, *yPerim, *zPerim;
	int pointOn = 0, xi, zi;
	
	
	glPushMatrix();
	glTranslatef(x, 0, z);
	glRotatef(-rotation, 0,1,0);
	
	
	xPerim = new double [length*2 + width*2];
	yPerim = new double [length*2 + width*2];
	zPerim = new double [length*2 + width*2];
	
	
	xDX = cos(rotation * piOver180);
	zDX = sin(rotation * piOver180);
	xDZ = -sin(rotation * piOver180);
	zDZ = cos(rotation * piOver180);
	
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kPit].GetTextureID());
	glColor4f(1,1,1,0);
	
	
	glBegin(GL_QUAD_STRIP);
	// draw north edge
	xc = x;
	zc = z;
	for(int xi = 0; xi <= length; ++xi) {
		
		if (!InSight(xc,zc)) {
			break;
			
		} else {
			glTexCoord2f(xi,1);
			glVertex3f(xi, y = minYValue(xc,zc), 0);
			glTexCoord2f(xi,0);
			glVertex3f(xi, minYValue(xc,zc)-4, 0);
			
			if (xi < length) {
				xPerim[pointOn]   = xi;
				yPerim[pointOn]   = y;
				zPerim[pointOn++] = 0;
			}
			
			xc += xDX;
			zc += zDX;
		}
	}
	
	
	// draw east edge
	xc = x + xDX*length;
	zc = z + zDX*length;
	for(int zi = 0; zi <= width; ++zi) {
		
		if (!InSight(xc,zc)) {
			break;
			
		} else {
			glTexCoord2f(zi,1);
			glVertex3f(length, y = minYValue(xc,zc), zi);
			glTexCoord2f(zi,0);
			glVertex3f(length, minYValue(xc,zc)-4, zi);
			
			if (zi < width) {
				xPerim[pointOn]   = length;
				yPerim[pointOn]   = y;
				zPerim[pointOn++] = zi;
			}
			
			xc += xDZ;
			zc += zDZ;
		}
	}
	
	// draw south edge, reverse order
	xc = x + xDZ*width + xDX*length;
	zc = z + zDZ*width + zDX*length;
	for(int xi = length; xi >= 0; --xi) {
		
		if (!InSight(xc,zc)) {
			break;
			
		} else {
			glTexCoord2f(xi,1);
			glVertex3f(xi, y = minYValue(xc,zc), width);
			glTexCoord2f(xi,0);
			glVertex3f(xi, minYValue(xc,zc)-4, width);
			
			if (xi > 0) {
				xPerim[pointOn]   = xi;
				yPerim[pointOn]   = y;
				zPerim[pointOn++] = width;
			}
			
			xc -= xDX;
			zc -= zDX;
		}
	}
	
	
	// draw west edge, reverse order
	xc = x + xDZ*width;
	zc = z + zDZ*width;
	for(int zi = width; zi >= 0; --zi) {
		
		if (!InSight(xc,zc)) {
			break;
			
		} else {
			glTexCoord2f(zi,1);
			glVertex3f(0, y = minYValue(xc,zc), zi);
			glTexCoord2f(zi,0);
			glVertex3f(0, minYValue(xc,zc)-4, zi);
			
			if (zi > 0) {
				xPerim[pointOn]   = 0;
				yPerim[pointOn]   = y;
				zPerim[pointOn++] = zi;
			}
			
			xc -= xDZ;
			zc -= zDZ;
		}
	}
	
	glEnd();
	
	glPopMatrix();
	
	
	delete[] xPerim;
	delete[] yPerim;
	delete[] zPerim;
	
	glPopMatrix();
}
*/


/*
int FindIntersection(Point *tri, Point *rect, Point *result)
{
	Point interest[6];
	int pointNum = 0;
	double mt[3], mr[4], x, z;
	int st[3], sr[4], nextT, nextR;
	bool it[3], ir[4];
	bool noPoints = false;
	double leftSide, rightSide;
	
	// test for rectangle points being inside the triangle:
	
	if (tri[0].x - tri[1].x == 0) mt[0] = 9999999999;
	else
		mt[0] = (tri[0].z - tri[1].z) / (tri[0].x - tri[1].x);
	
	if (tri[1].x - tri[2].x == 0) mt[1] = 9999999999;
	else
		mt[1] = (tri[1].z - tri[2].z) / (tri[1].x - tri[2].x);
	
	if (tri[2].x - tri[0].x == 0) mt[2] = 9999999999;
	else
		mt[2] = (tri[2].z - tri[0].z) / (tri[2].x - tri[0].x);
	
	st[0] = (tri[2].z > mt[0]*(tri[2].x-tri[0].x) + tri[0].z) ? 1 : -1;
	st[1] = (tri[0].z > mt[1]*(tri[0].x-tri[1].x) + tri[1].z) ? 1 : -1;
	st[2] = (tri[1].z > mt[2]*(tri[1].x-tri[2].x) + tri[2].z) ? 1 : -1;
	
	for(int i = 0; i < 4; ++i) {
		leftSide = rect[i].z*st[0];
		rightSide = (mt[0]*(rect[i].x-tri[0].x)+tri[0].z)*st[0];
		leftSide = rect[i].z*st[1];
		rightSide = (mt[1]*(rect[i].x-tri[1].x)+tri[1].z)*st[1];
		leftSide = rect[i].z*st[2];
		rightSide = (mt[2]*(rect[i].x-tri[2].x)+tri[2].z)*st[2];
		
		if (	rect[i].z*st[0] > (mt[0]*(rect[i].x-tri[0].x)+tri[0].z)*st[0] &&
				rect[i].z*st[1] > (mt[1]*(rect[i].x-tri[1].x)+tri[1].z)*st[1] &&
				rect[i].z*st[2] > (mt[2]*(rect[i].x-tri[2].x)+tri[2].z)*st[2]) {
			interest[pointNum] = rect[i];
			++pointNum;
		}
	}
	
	if (pointNum == 4)
		return FindOrder(interest, result, pointNum);

	if (pointNum == 0)
		noPoints = true;
	
	// test for triangle points being inside the rectangle:
	
	if (rect[0].x - rect[1].x == 0) mr[0] = 9999999999;
	else
		mr[0] = (rect[0].z - rect[1].z) / (rect[0].x - rect[1].x);
	
	if (rect[1].x - rect[2].x == 0) mr[1] = 9999999999;
	else
		mr[1] = (rect[1].z - rect[2].z) / (rect[1].x - rect[2].x);
	
	if (rect[2].x - rect[3].x == 0) mr[2] = 9999999999;
	else
		mr[2] = (rect[2].z - rect[3].z) / (rect[2].x - rect[3].x);
	
	if (rect[3].x - rect[0].x == 0) mr[3] = 9999999999;
	else
		mr[3] = (rect[3].z - rect[0].z) / (rect[3].x - rect[0].x);

	sr[0] = (rect[2].z > mr[0]*(rect[2].x - rect[0].x) + rect[0].z) ? 1 : -1;
	sr[1] = (rect[3].z > mr[1]*(rect[3].x - rect[1].x) + rect[1].z) ? 1 : -1;
	sr[2] = (rect[0].z > mr[2]*(rect[0].x - rect[2].x) + rect[2].z) ? 1 : -1;
	sr[3] = (rect[1].z > mr[3]*(rect[1].x - rect[3].x) + rect[3].z) ? 1 : -1;

	for(int i = 0; i < 3; ++i) {
		if (	tri[i].z*sr[0] > (mr[0]*(tri[i].x - rect[0].x) + rect[0].z) * sr[0] &&
				tri[i].z*sr[1] > (mr[1]*(tri[i].x - rect[1].x) + rect[1].z) * sr[1] &&
				tri[i].z*sr[2] > (mr[2]*(tri[i].x - rect[2].x) + rect[2].z) * sr[2] &&
				tri[i].z*sr[3] > (mr[3]*(tri[i].x - rect[3].x) + rect[3].z) * sr[3]) {
			interest[pointNum] = tri[i];
			++pointNum;
		}
	}
	
	if (pointNum == 3 && noPoints)
		return FindOrder(interest, result, pointNum);
	
	// look for intersections
	
	for(int r = 0; r < 4; ++r) {
		nextR = (r+1) % 4;
		
		for(int t = 0; t < 3; ++t) {
			nextT = (t+1) % 3;
			
			if ((mt[t] - mr[r]) != 0) {
				if (mt[t] == 9999999999) {
					x = tri[t].x;
					z = mr[r]*(x-rect[r].x) + rect[r].z;
				} else if (mr[r] == 9999999999) {
					x = rect[r].x;
					z = mt[t]*(x-tri[t].x) + tri[t].z;
				} else {
					x = (mt[t]*tri[t].x - mr[r]*rect[r].x - tri[t].z + rect[r].z) / (mt[t] - mr[r]);
					z = mt[t]*(x-tri[t].x) + tri[t].z;
				}	
				
				if (	between(tri[t].x, tri[nextT].x, x) && between(rect[r].x, rect[nextR].x, x) &&
						between(tri[t].z, tri[nextT].z, z) && between(rect[r].z, rect[nextR].z, z) ) {
					interest[pointNum].x = x;
					interest[pointNum].z = z;
					//interest[pointNum].y = tri[t].y + (rect[r].y - tri[t].y) * ((x - tri[t].x) / (rect[r].x - tri[t].x));
					++pointNum;

					if (pointNum == 6)
						return FindOrder(interest, result, pointNum);
					
				}
			}
		}
	}
	return FindOrder(interest, result, pointNum);
}

// Find the propper order for the points
int FindOrder(Point *interest, Point *result, int pointNum)
{
	double x = 0, z = 0;
	double angles[6], minAngle;
	bool skip[6];
	int target = 0, pointOn = 0;
	const double rad2deg = (180/3.1415926535);
	
	for(int i = 0; i < pointNum; ++i) {
		x += interest[i].x;
		z += interest[i].z;
		skip[i] = false;
	}
	
	x /= pointNum;
	z /= pointNum;
	
	for(int i = 0; i < pointNum; ++i) {
		angles[i] = (atan( fabs(interest[i].z-z) / fabs(interest[i].x-x) )) * rad2deg;
		
		if ((interest[i].z-z) > 0) {
			if ((interest[i].x-x) < 0)
				angles[i] += 90;
		} else {
			if ((interest[i].x-x) > 0)
				angles[i] += 270;
			else
				angles[i] += 180;
		}
	}
	
	// sort from smallest to largest angle:
	
	for(int n = 0; n < pointNum; ++n) {
		minAngle = 1000;
		for(int i = 0; i < pointNum; ++i) {
			if (skip[i]) continue;
			if (angles[i] < minAngle) {
				minAngle = angles[i];
				target = i;
			}
		}
		result[pointOn] = interest[target];
		++pointOn;
		skip[target] = true;
	}
	
	return pointNum;
}


// is c between a and b?
bool between(double a, double b, double c)
{
	if (a > b)
		return (c >= b && c <= a);
	else
		return (c >= a && c <= b);
}

*/













void DrawSky()
{
	//glCallList(skyList);
	//return;
	double skyTextureSize = 0.4;
	double skySize = 20.0;
	double skyExtent = terrainLength, skyHeight = 5;
	double texRep = 5.0, texRepDiv2 = texRep/2.0;
	double tx = 0,ty = 0;
	
	/*
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	//glDisable(GL_FOG);
	
	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kSky].GetTextureID());
	glBegin(GL_QUADS);
		
		for(double z = -skyExtent; z <= skyExtent; z += skySize) {
			for(double x = -skyExtent; x <= skyExtent; x += skySize) {
				
				glTexCoord2f(tx,ty);
				glVertex3f(x,			skyHeight,		z);
				
				glTexCoord2f(tx + skyTextureSize,ty);
				glVertex3f(x + skySize,	skyHeight,		z);
				
				glTexCoord2f(tx + skyTextureSize,ty + skyTextureSize);
				glVertex3f(x + skySize,	skyHeight,		z + skySize);
				
				glTexCoord2f(tx,ty + skyTextureSize);
				glVertex3f(x,			skyHeight,		z + skySize);
				
				tx += skyTextureSize;
			}
			ty += skyTextureSize;
		}
	glEnd();*/
	//glDisable(GL_DEPTH_TEST);
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_LIGHTING);
	glDisable(GL_FOG);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kSky].GetTextureID());
	glColor3f(1,1,1);
	
	glPushMatrix();
	glRotatef(90,1,0,0);
	DrawSphere(0,0,2,10);
	glPopMatrix();
	
	/*
	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(-skyExtent, skyHeight, -skyExtent);
		
		glTexCoord2f(textureRepeat,0);
		glVertex3f(skyExtent, skyHeight, -skyExtent);
		
		glTexCoord2f(textureRepeat,textureRepeat);
		glVertex3f(skyExtent, skyHeight, skyExtent);
		
		glTexCoord2f(0,textureRepeat);
		glVertex3f(-skyExtent, skyHeight, skyExtent);
		
		
	glEnd();
	*/
	/*
	glBegin(GL_TRIANGLES);
		
		
		// left
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			skyHeight,	0);
		glTexCoord2f(0,texRep);
		glVertex3f(-skyExtent,	0,			skyExtent);
		glTexCoord2f(0,0);
		glVertex3f(-skyExtent,	0,			-skyExtent);
		
		// top
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			skyHeight,	0);
		glTexCoord2f(texRep,0);
		glVertex3f(skyExtent,	0,			-skyExtent);
		glTexCoord2f(0,0);
		glVertex3f(-skyExtent,	0,			-skyExtent);
		
		// right
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			skyHeight,	0);
		glTexCoord2f(texRep,texRep);
		glVertex3f(skyExtent,	0,			skyExtent);
		glTexCoord2f(texRep,0);
		glVertex3f(skyExtent,	0,			-skyExtent);
		
		// bottom
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			skyHeight,	0);
		glTexCoord2f(texRep,texRep);
		glVertex3f(skyExtent,	0,			skyExtent);
		glTexCoord2f(0,texRep);
		glVertex3f(-skyExtent,	0,			skyExtent);
		
		
		
		// left
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			-skyHeight,	0);
		glTexCoord2f(0,texRep);
		glVertex3f(-skyExtent,	0,			skyExtent);
		glTexCoord2f(0,0);
		glVertex3f(-skyExtent,	0,			-skyExtent);
		
		// top
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			-skyHeight,	0);
		glTexCoord2f(texRep,0);
		glVertex3f(skyExtent,	0,			-skyExtent);
		glTexCoord2f(0,0);
		glVertex3f(-skyExtent,	0,			-skyExtent);
		
		// right
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			-skyHeight,	0);
		glTexCoord2f(texRep,texRep);
		glVertex3f(skyExtent,	0,			skyExtent);
		glTexCoord2f(texRep,0);
		glVertex3f(skyExtent,	0,			-skyExtent);
		
		// bottom
		glTexCoord2f(texRepDiv2,texRepDiv2);
		glVertex3f(0,			-skyHeight,	0);
		glTexCoord2f(texRep,texRep);
		glVertex3f(skyExtent,	0,			skyExtent);
		glTexCoord2f(0,texRep);
		glVertex3f(-skyExtent,	0,			skyExtent);
		
	glEnd();
	*/
	
}


void SetupSky()
{
	double skyTextureSize = 1.0;
	double skySize = 1.0;
	int skyExtent = 20, skyHeight = 3;
	return;
	
	skyList = glGenLists(1);
	glNewList(skyList, GL_COMPILE);
	
	
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	//glDisable(GL_FOG);
	
	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kSky].GetTextureID());
	glBegin(GL_QUADS);
		
		for(double z = -skyExtent, ty = 0; z < skyExtent; z += skySize, ty += skyTextureSize) {
			for(double x = -skyExtent, tx = 0; x < skyExtent; x += skySize, tx += skyTextureSize) {
				
				glTexCoord2f(tx,ty);
				glVertex3f(x,skyHeight,z);
				
				glTexCoord2f(tx + skyTextureSize,ty);
				glVertex3f(x + skySize,skyHeight,z);
				
				glTexCoord2f(tx + skyTextureSize,ty + skyTextureSize);
				glVertex3f(x + skySize,skyHeight,z + skySize);
				
				glTexCoord2f(tx,ty + skyTextureSize);
				glVertex3f(x,skyHeight,z + skySize);
				
			}
		}
	glEnd();
	glEndList();
}

extern GLdouble pitDepth;
//#define SINKSINTOPITS

void BrickWall::Draw()
{
	//int xi, zi;
	double xc,yc,zc, startY, diffY, oldY, dx, dz, halfWidth;
	double nx, ny, nz;
	bool stopDrawing = false;
	float textureSize = 0.4;
	double dig = 2; // amount the wall sinks into the ground
    GLfloat noSpecular[] = { 0,0,0,0 };
	
	glEnable(GL_LIGHTING);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
	glEnable(GL_COLOR_MATERIAL);
	
    glMaterialfv(GL_FRONT, GL_SPECULAR, noSpecular);
	
	glPushMatrix();
	
	glTranslatef(x, 0, z);
	glRotatef(-rotation, 0,1,0);
	
	dx = cos(rotation * piOver180);
	dz = sin(rotation * piOver180);
	halfWidth = width / 2.0;
	
	stopDrawing = false;
	
	xc = x;
	zc = z;
	
	glPushMatrix();
	glLoadIdentity();
	glScalef(worldScale, worldScale, worldScale);
	glRotatef(-camera.ry, 0,1,0);
	glTranslatef(-camera.x, 0, -camera.z);
	
	glTranslatef(x, 0, z);
	glRotatef(-rotation, 0,1,0);
	
	
	GetProjection();
	glPopMatrix();
	
	glColor3f(1,1,1);
	glBegin(GL_QUADS);
		
		startY = yc = minYValue(xc, zc);//terrain[xi][zi].y;
		
		glNormal3f(-1,0,0);
		
		glTexCoord2f(-halfWidth*textureSize,(yc-dig)*textureSize);
		glVertex3fWithSuperFog(0,yc-dig,-halfWidth);
		
		glTexCoord2f(halfWidth*textureSize,(yc-dig)*textureSize);
		glVertex3fWithSuperFog(0,yc-dig,halfWidth);
		
		glTexCoord2f(halfWidth*textureSize,(yc+height)*textureSize);
		glVertex3fWithSuperFog(0,yc+height,halfWidth);
		
		glTexCoord2f(-halfWidth*textureSize,(yc+height)*textureSize);
		glVertex3fWithSuperFog(0,yc+height,-halfWidth);
		
		
		oldY = yc;
		
		for(int n = 0; n < length; ++n) {
			
			xc += dx;
			zc += dz;
			if (InSight(xc,zc)) {
				yc = minYValue(xc, zc);//terrain[xi][zi].y;
				diffY = yc - startY;
				
				glNormal3f(0,0,-1);
				
				glTexCoord2f((n)*textureSize,(oldY-dig)*textureSize);
				glVertex3fWithSuperFog(n,oldY-dig,-halfWidth);
				
				glTexCoord2f((n)*textureSize,(oldY+height)*textureSize);
				glVertex3fWithSuperFog(n,oldY+height,-halfWidth);
				
				glTexCoord2f((n+1)*textureSize,(yc+height)*textureSize);
				glVertex3fWithSuperFog(n+1,yc+height,-halfWidth);
				
				glTexCoord2f((n+1)*textureSize,(yc-dig)*textureSize);
				glVertex3fWithSuperFog(n+1,yc-dig,-halfWidth);
				
				
				
				
				
				
				
				
				
				glNormal3f(0,0,1);
				
				glTexCoord2f(n*textureSize,(oldY-dig)*textureSize);
				glVertex3fWithSuperFog(n,oldY-dig,halfWidth);
				
				glTexCoord2f((n+1)*textureSize,(yc-dig)*textureSize);
				glVertex3fWithSuperFog(n+1,yc-dig,halfWidth);
				
				glTexCoord2f((n+1)*textureSize,(yc+height)*textureSize);
				glVertex3fWithSuperFog(n+1,yc+height,halfWidth);
				
				glTexCoord2f(n*textureSize,(oldY+height)*textureSize);
				glVertex3fWithSuperFog(n,oldY+height,halfWidth);
				
				
				
				// top of wall:
				/*CalculateNormalVector( n,oldY+height,halfWidth,
									   n,oldY+height,-halfWidth,
									   n+1,yc+height,-halfWidth,
									   nx,ny,nz);
				glNormal3f(nx,ny,nz);
				
				glTexCoord2f(0,0);
				glVertex3f(n,oldY+height,halfWidth);
				
				glTexCoord2f(0,textureSize*(width));
				glVertex3f(n,oldY+height,-halfWidth);
				
				glTexCoord2f(textureSize,textureSize*(width));
				glVertex3f(n+1,yc+height,-halfWidth);
				
				glTexCoord2f(textureSize,0);
				glVertex3f(n+1,yc+height,halfWidth);
				*/
				oldY = yc;
			} else
				stopDrawing = true;
		}
		
		if (!stopDrawing) {
			glNormal3f(1,0,0);
			glTexCoord2f(textureSize*halfWidth,(yc+height)*textureSize);
			glVertex3fWithSuperFog(length,yc+height,halfWidth);
			
			glTexCoord2f(textureSize*halfWidth,(yc-dig)*textureSize);
			glVertex3fWithSuperFog(length,yc-dig,halfWidth);
			
			glTexCoord2f(textureSize*-halfWidth,(yc-dig)*textureSize);
			glVertex3fWithSuperFog(length,yc-dig,-halfWidth);
			
			glTexCoord2f(textureSize*-halfWidth,(yc+height)*textureSize);
			glVertex3fWithSuperFog(length,yc+height,-halfWidth);
			
			
		}
		
	glEnd();
	
	xc = x;
	zc = z;
	oldY = startY = minYValue(xc, zc);
	
	glBegin(GL_QUAD_STRIP);
		
		for(int n = 0; n <= length; ++n) {
			
			xc += dx;
			zc += dz;
			if (InSight(xc,zc)) {
				yc = minYValue(xc, zc);
				diffY = yc - startY;
				
				// top of wall:
				CalculateNormalVector( n,oldY+height,halfWidth,
									   n,oldY+height,-halfWidth,
									   n+1,yc+height,-halfWidth,
									   nx,ny,nz);
				glNormal3f(nx,ny,nz);
				
				
				glTexCoord2f(n*textureSize,-halfWidth*textureSize);
				glVertex3fWithSuperFog(n,oldY+height,-halfWidth);
				
				glTexCoord2f(n*textureSize,halfWidth*textureSize);
				glVertex3fWithSuperFog(n,oldY+height,halfWidth);
				
				oldY = yc;
			}
		}
	
	glEnd();
	
	glPopMatrix();
	glDisable(GL_CULL_FACE);
}


void CreateUnicycleGuy()
{	
	
	guyList = glGenLists(1);
	glNewList(guyList, GL_COMPILE);
	
	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	
	glPushMatrix();
	// Head:
	glBindTexture(GL_TEXTURE_2D, textures[kFace].GetTextureID());
	
	glTranslatef(0,0.3,0);
	glColor3f(1.0,1.0,1.0);
	glRotatef(-80, 1.0,0,0);
	gluSphere(quadratic, 0.28, quadQual,quadQual);
	
	glDisable(GL_TEXTURE_2D);
	
	// Neck:
	glPopMatrix();
	glPushMatrix();
	glTranslatef(0.0, 0.08, 0.0);
	glRotatef(90, 1,0,0);
	
	glColor3f(0.0,0.5,1.0);
	gluCylinder(quadratic, 0.125, 0.125, 0.08, quadQual,1);
	
	glPopMatrix();
	glPushMatrix();
	
	// Body:
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kBody].GetTextureID());
	
	glColor3f(1,1,1);
	glBegin(GL_QUADS);
		
		//top
		glNormal3f(0,1,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, 0.0, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, 0.0, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		// front
		glNormal3f(0,0,1);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, 0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, 0.25);
		
		//back
		glNormal3f(0,0,-1);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, -0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		
		//left side
		glNormal3f(-1,0,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(1,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(-0.25, 0.0, 0.25);
		
		//right side
		glNormal3f(1,0,0);
		glTexCoord2f(0,0);
		glVertex3f(0.25, 0.0, 0.25);
		glTexCoord2f(0,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, -0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		//bottom side
		glNormal3f(0,-1,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, -0.9, -0.25);
	glEnd();
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	// wheel holder dealy
	glPopMatrix();
	glBegin(GL_QUADS);
		
		glColor3f(0.6,0.6,0.6);
		glVertex3f(-0.125, -0.9, 0.25);
		glVertex3f(-0.125, -0.9, -0.25);
		glVertex3f(-0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		
		glVertex3f(0.125, -0.9, 0.25);
		glVertex3f(0.125, -0.9, -0.25);
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(0.05, -1.2, 0.08);
		
		glColor3f(0.7,0.7,0.7);
		
		glVertex3f(-0.125, -0.9, 0.25);
		glVertex3f(0.125, -0.9, 0.25);
		glVertex3f(0.05, -1.2, 0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		
		glVertex3f(-0.125, -0.9, -0.25);
		glVertex3f(0.125, -0.9, -0.25);
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, -0.08);
		
		
		glColor3f(0.6,0.6,0.6);
		glVertex3f(-0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		glVertex3f(-0.05, -1.6, 0.08);
		glVertex3f(-0.05, -1.6, -0.08);
		
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(0.05, -1.2, 0.08);
		glVertex3f(0.05, -1.6, 0.08);
		glVertex3f(0.05, -1.6, -0.08);
		
	glEnd();
	
	
	glEndList();
	
	
	
	
	guyDeadList = glGenLists(1);
	glNewList(guyDeadList, GL_COMPILE);
	
	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	
	glRotatef(90, 1,0,0);
	
	glPushMatrix();
	glPushMatrix();
	// Head:
	glBindTexture(GL_TEXTURE_2D, textures[kFace].GetTextureID());
	
	glTranslatef(0,0.3,0);
	glColor3f(1.0,1.0,1.0);
	glRotatef(-80, 1.0,0,0);
	gluSphere(quadratic, 0.28, quadQual,quadQual);
	
	glDisable(GL_TEXTURE_2D);
	
	// Neck:
	glPopMatrix();
	glPushMatrix();
	glTranslatef(0.0, 0.08, 0.0);
	glRotatef(90, 1,0,0);
	
	glColor3f(0.0,0.5,1.0);
	gluCylinder(quadratic, 0.125, 0.125, 0.08, quadQual,1);
	
	glPopMatrix();
	glRotatef(-90, 1,0,0);
	glPushMatrix();
	
	// Body:
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kBody].GetTextureID());
	
	glColor3f(1,1,1);
	glBegin(GL_QUADS);
		
		//top
		glNormal3f(0,1,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, 0.0, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, 0.0, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		// front
		glNormal3f(0,0,1);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, 0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, 0.25);
		
		//back
		glNormal3f(0,0,-1);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, -0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		
		//left side
		glNormal3f(-1,0,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, 0.0, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(1,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(-0.25, 0.0, 0.25);
		
		//right side
		glNormal3f(1,0,0);
		glTexCoord2f(0,0);
		glVertex3f(0.25, 0.0, 0.25);
		glTexCoord2f(0,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, -0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, 0.0, -0.25);
		
		//bottom side
		glNormal3f(0,-1,0);
		glTexCoord2f(0,0);
		glVertex3f(-0.25, -0.9, -0.25);
		glTexCoord2f(0,1);
		glVertex3f(-0.25, -0.9, 0.25);
		glTexCoord2f(1,1);
		glVertex3f(0.25, -0.9, 0.25);
		glTexCoord2f(1,0);
		glVertex3f(0.25, -0.9, -0.25);
	glEnd();
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	// wheel holder dealy
	glPopMatrix();
	
	// he's dead, so rotate the thingy:
	//glRotatef(-90, 1,0,0);
	glTranslatef(0,-1,0);
	glRotatef(-90, 1,0,0);
	glTranslatef(0, 0.8, 0.25);
		
	glBegin(GL_QUADS);
		
		glColor3f(0.6,0.6,0.6);
		glVertex3f(-0.125, -0.9, 0.25);
		glVertex3f(-0.125, -0.9, -0.25);
		glVertex3f(-0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		
		glVertex3f(0.125, -0.9, 0.25);
		glVertex3f(0.125, -0.9, -0.25);
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(0.05, -1.2, 0.08);
		
		glColor3f(0.7,0.7,0.7);
		
		glVertex3f(-0.125, -0.9, 0.25);
		glVertex3f(0.125, -0.9, 0.25);
		glVertex3f(0.05, -1.2, 0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		
		glVertex3f(-0.125, -0.9, -0.25);
		glVertex3f(0.125, -0.9, -0.25);
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, -0.08);
		
		
		glColor3f(0.6,0.6,0.6);
		glVertex3f(-0.05, -1.2, -0.08);
		glVertex3f(-0.05, -1.2, 0.08);
		glVertex3f(-0.05, -1.6, 0.08);
		glVertex3f(-0.05, -1.6, -0.08);
		
		glVertex3f(0.05, -1.2, -0.08);
		glVertex3f(0.05, -1.2, 0.08);
		glVertex3f(0.05, -1.6, 0.08);
		glVertex3f(0.05, -1.6, -0.08);
		
	glEnd();
	
	glPopMatrix();
	
	glEndList();
}

double footAngle = 0;

void DrawUnicycleGuy(double x, double y, double z, double rx, double ry, double rz)
{
	double legRadius = 0.25, LlegY, LlegZ, RlegY, RlegZ, LlegAngle, RlegAngle, legStart = -0.8;
	double hatBounce, armBounce;
	double speed = 4;
	double hatAngle;
	double scale = 0.5;
    GLfloat noSpecular[] = { 0,0,0,0 };
	float newAmbient[4] = {0.4, 0.4, 0.4, 1};
	float newDiffuse[4] = {0.7 ,0.7 ,0.7 , 1};
	
	glDisable(GL_NORMALIZE);
	glEnable(GL_COLOR_MATERIAL);
    glMaterialfv(GL_FRONT, GL_SPECULAR, noSpecular);
    
	if (guy.falling > -1) {
		
		newAmbient[0] *= guy.falling / 150.0;
		newAmbient[1] *= guy.falling / 150.0;
		newAmbient[2] *= guy.falling / 150.0;
		newDiffuse[0] *= guy.falling / 150.0;
		newDiffuse[1] *= guy.falling / 150.0;
		newDiffuse[2] *= guy.falling / 150.0;
		
		
	}
	glLightfv(GL_LIGHT0, GL_AMBIENT, newAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, newDiffuse);
	
	glPushMatrix();
	
	if (!guy.reallyDead) {
		hatBounce = sin(footAngle * piOver180) * speed;
		armBounce = sin(footAngle * piOver180) * 3;
		footAngle += guy.speed * 200;
	} else
		footAngle += guy.speed * 75;
	
	glTranslatef(x,y+1,z);
	glScalef(scale,scale,scale);
	
	if (guy.reallyDead) {
		glRotatef(ry, 0,1,0);
		glRotatef(180, 1,0,0);
		glTranslatef(0,2.6,0);
	
		glCallList(guyList);
	} else {
		
		glRotatef(ry, 0,1,0);
		glRotatef(rx, 1,0,0);
		glRotatef(rz, 0,1,0);
		
		if (guy.dead)
			glCallList(guyDeadList);
		else {
			glTranslatef(0,-2,0);
			glRotatef(guy.xLean, 1,0,0);
			glRotatef(guy.zLean, 0,0,1);
			glTranslatef(0,2,0);
			
			glCallList(guyList);
		}
	}
	
	
	LlegZ = sin(-footAngle * piOver180) * legRadius;
	LlegY = cos(-footAngle * piOver180) * legRadius - 1.45;
	LlegAngle = atan(  LlegZ / fabs(double(LlegY - legStart)) ) * oneEightyOverPi;
	
	RlegZ = sin((-footAngle+180) * piOver180) * legRadius;
	RlegY = cos((-footAngle+180) * piOver180) * legRadius - 1.45;
	RlegAngle = atan( RlegZ / fabs(RlegY - legStart) ) * oneEightyOverPi;
	
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	
	
	double hatTranslation = -0.125;
	
	
	// Hat:
	glPushMatrix();
	//if (guy.dead)
	//	glRotatef(90, 1,0,0);
	//glTranslatef(-.05,0.48,0);
	//glRotatef(-35, 0,sqrtTwo,-sqrtTwo);
	//glRotatef(90, 1,0,0);
	
	hatAngle = guy.speed;
	if (hatAngle > 15) hatAngle = 15;
	
	glTranslatef(0,0.3,0);
	glRotatef(80, 1,0,0);
	glRotatef(20, 0,1,0);
	
	
	if (!guy.reallyDead) { // no need for arms or a hat when he's dead
		
		glTranslatef(0,0,-0.18);
		glColor3f(0.0, 0.0, 0.8);
		gluDisk(quadratic, 0, 0.5, quadQual,1);
		gluCylinder(quadratic, 0.5, 0.5, 0.02, quadQual,1);
		
		glColor3f(0.0, 0.0, 1.0);
		glTranslatef(0.0, 0.0, -0.15);
		gluCylinder(quadratic, 0.25, 0.25, 0.15, quadQual,1);
		
		glColor3f(0.0, 1.0, 0.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		glColor3f(1.0, 0.0, 0.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		glColor3f(1.0, 1.0, 0.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		glColor3f(0.0, 0.0, 1.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		glColor3f(0.0, 1.0, 0.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		glColor3f(1.0, 0.0, 0.0);
		glRotatef(5, 0.0, 1.0, 0.0);
		glRotatef(hatBounce - hatAngle, 1.0, 0.0, 0.0);
		glTranslatef(0.0, 0.0, hatTranslation);
		gluCylinder(quadratic, 0.25, 0.24, 0.15, quadQual,1);
		
		gluDisk(quadratic, 0, 0.25, quadQual,1);
	
		// left arm:
		glPopMatrix();
		glPushMatrix();
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[kArm].GetTextureID());
		glColor3f(1.0,1.0,1.0);
		glTranslatef(-0.21,-0.1,0);
		glRotatef(-90, 0,1,0);
		glRotatef(-35 + armBounce, 1,0,0);
		gluCylinder(quadratic, 0.1, 0.1, 0.8, quadQual,1);
		glDisable(GL_TEXTURE_2D);
		glColor3f(0.8,0.8,0.8);
		glTranslatef(0,0,0.8);
		gluSphere(quadratic, 0.15, quadQual,quadQual);
		
		
		// right arm:
		glPopMatrix();
		glPushMatrix();
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[kArm].GetTextureID());
		glColor3f(1.0,1.0,1.0);
		glTranslatef(0.21,-0.1,0);
		glRotatef(90, 0,1,0);
		glRotatef(-35 + armBounce, 1,0,0);
		gluCylinder(quadratic, 0.1, 0.1, 0.8, quadQual,1);
		glDisable(GL_TEXTURE_2D);
		glColor3f(0.8,0.8,0.8);
		glTranslatef(0,0,0.8);
		gluSphere(quadratic, 0.15, quadQual,quadQual);
		
	}
	
	
	// Wheel edge:
	glPopMatrix();
	if (guy.dead && !guy.reallyDead) {
		glRotatef(-90, 1,0,0);
		glTranslatef(0,-1,0);
		glRotatef(-90, 1,0,0);
		glTranslatef(0, 0.8, 0.25);
	}
	glPushMatrix();
	glColor3f(0.15,0.15,0.15);
	glTranslatef(-0.04,-1.6,0);
	glRotatef(90, 0,1,0);
	gluCylinder(quadratic, 0.4, 0.4, 0.08, quadQual,1);
	// Wheel
	
	glColorMask(1,1,1,0);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_LIGHTING);
	glColor3f(1,1,1);
	glTranslatef(0,0,0.04);
	glRotatef(footAngle, 0,0,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[kWheel].GetTextureID());
	gluDisk(quadratic, 0, 0.39, quadQual,1);
	glColor3f(0.3,0.3,0.3);
	glBegin(GL_QUADS);
	
		glVertex3f(-0.03, 0.25, -0.07);
		glVertex3f(-0.03, -0.02,-0.07);
		glVertex3f(0.03, -0.02,-0.07);
		glVertex3f(0.03, 0.25, -0.07);
		
		glVertex3f(-0.03, 0.02, 0.07);
		glVertex3f(-0.03, -0.25, 0.07);
		glVertex3f(0.03, -0.25, 0.07);
		glVertex3f(0.03, 0.02, 0.07);
		
	glEnd();
	//glDisable(GL_BLEND);  // normal enabled
	glColorMask(1,1,1,1);
	
	// Left leg:
	glPopMatrix();
	glPushMatrix();
	
	glTranslatef(-0.19, legStart, 0);
	glRotatef(90 + LlegAngle, 1,0,0);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
	glColor3f(1.0,0,0);
	
	glPushMatrix();
	glScalef(1,2,1);
	gluCylinder(quadratic, 0.05, 0.05, -(LlegY-legStart), quadQual,1);
	glPopMatrix();
	
	glColor3f(0.5, 0.25, 0);
	glBegin(GL_QUADS);
		
		glNormal3f(1,0,0);
		glVertex3f(0.05, 0.1, -(LlegY-legStart));
		glVertex3f(0.05, -0.1, -(LlegY-legStart));
		glVertex3f(0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(LlegY-legStart)+0.15);
		
		glNormal3f(-1,0,0);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart));
		glVertex3f(-0.05, -0.1, -(LlegY-legStart));
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.15);
		
		glNormal3f(0,-1,0);
		glVertex3f(0.05, -0.1, -(LlegY-legStart));
		glVertex3f(-0.05, -0.1, -(LlegY-legStart));
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.05, -0.1, -(LlegY-legStart)+0.15);
		
		glNormal3f(0,1,0);
		glVertex3f(0.05, 0.1, -(LlegY-legStart));
		glVertex3f(-0.05, 0.1, -(LlegY-legStart));
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(LlegY-legStart)+0.15);
		
		glNormal3f(0,0,1);
		glVertex3f(0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(LlegY-legStart)+0.15);
		
		
		glColor3f(0,0,0);
		
		glNormal3f(1,0,0);
		glVertex3f(0.12, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.12, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.12, -0.1, -(LlegY-legStart)+0.2);
		glVertex3f(0.12, 0.1, -(LlegY-legStart)+0.2);
		
		glNormal3f(-1,0,0);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.2);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.2);
		
		glNormal3f(0,-1,0);
		glVertex3f(0.12, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.2);
		glVertex3f(0.12, -0.1, -(LlegY-legStart)+0.2);
		
		glNormal3f(0,1,0);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.12, 0.1, -(LlegY-legStart)+0.15);
		glVertex3f(0.12, 0.1, -(LlegY-legStart)+0.2);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.2);
		
		glNormal3f(0,0,1);
		glVertex3f(-0.05, -0.1, -(LlegY-legStart)+0.2);
		glVertex3f(0.12, -0.1, -(LlegY-legStart)+0.2);
		glVertex3f(0.12, 0.1, -(LlegY-legStart)+0.2);
		glVertex3f(-0.05, 0.1, -(LlegY-legStart)+0.2);
		
	glEnd();
	
	// Right leg:
	glPopMatrix();
	
	glTranslatef(0.19, legStart, 0);
	glRotatef(90 + RlegAngle, 1,0,0);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
	glColor3f(1.0,0,0);
	
	glPushMatrix();
	glScalef(1,2,1);
	gluCylinder(quadratic, 0.05, 0.05, -(RlegY-legStart), quadQual,1);
	glPopMatrix();
	
	glColor3f(0.5, 0.25, 0);
	glBegin(GL_QUADS);
		
		glNormal3f(1,0,0);
		glVertex3f(0.05, 0.1, -(RlegY-legStart));
		glVertex3f(0.05, -0.1, -(RlegY-legStart));
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.15);
		
		glNormal3f(-1,0,0);
		glVertex3f(-0.05, 0.1, -(RlegY-legStart));
		glVertex3f(-0.05, -0.1, -(RlegY-legStart));
		glVertex3f(-0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.05, 0.1, -(RlegY-legStart)+0.15);
		
		glNormal3f(0,-1,0);
		glVertex3f(0.05, -0.1, -(RlegY-legStart));
		glVertex3f(-0.05, -0.1, -(RlegY-legStart));
		glVertex3f(-0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.15);
		
		glNormal3f(0,1,0);
		glVertex3f(0.05, 0.1, -(RlegY-legStart));
		glVertex3f(-0.05, 0.1, -(RlegY-legStart));
		glVertex3f(-0.05, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.15);
		
		glNormal3f(0,0,1);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.05, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.15);
		
		
		glColor3f(0,0,0);
		
		glNormal3f(1,0,0);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.2);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.2);
		
		glNormal3f(-1,0,0);
		glVertex3f(-0.12, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, -0.1, -(RlegY-legStart)+0.2);
		glVertex3f(-0.12, 0.1, -(RlegY-legStart)+0.2);
		
		glNormal3f(0,-1,0);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, -0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, -0.1, -(RlegY-legStart)+0.2);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.2);
		
		glNormal3f(0,1,0);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, 0.1, -(RlegY-legStart)+0.15);
		glVertex3f(-0.12, 0.1, -(RlegY-legStart)+0.2);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.2);
		
		glNormal3f(0,0,1);
		glVertex3f(0.05, -0.1, -(RlegY-legStart)+0.2);
		glVertex3f(-0.12, -0.1, -(RlegY-legStart)+0.2);
		glVertex3f(-0.12, 0.1, -(RlegY-legStart)+0.2);
		glVertex3f(0.05, 0.1, -(RlegY-legStart)+0.2);
		
	glEnd();
	
	glPopMatrix();
	
	//glEnable(GL_NORMALIZE);
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
	glColorMask(1,1,1,1);
}

GLuint smilieList, bigSmilieList;
double smilieSize = 0.3;

void CreateSmilieList()
{
	double smilieHeight = 0.1;
	int	smilieSides = 12;
	int	bigSmilieSides = 15;
	Point points[36];
	double dd, d;
	
	d = 0;
	dd = 2*pi / smilieSides;
	
	for(int i = 0; i < smilieSides; ++i) {
		
		points[i].x = cos(d);
		points[i].y = sin(d);
		
		d += dd;
	}
	
	
	smilieList = glGenLists(1);
	
	glNewList(smilieList, GL_COMPILE);
	
	
	glEnable(GL_TEXTURE_2D);
	
	glNormal3f(0,0,1);
	glBegin(GL_TRIANGLE_FAN);
		glTexCoord2f(0.5,0.5);
		glVertex3f(0,0,smilieHeight/2);
		
		for(int i = 0; i < smilieSides; ++i) {
			glTexCoord2f(0.5 + points[i].x/2, 0.5 + points[i].y/2);
			glVertex3f(points[i].x * smilieSize,points[i].y * smilieSize,smilieHeight/2);
		}
			
		glTexCoord2f(0.5 + points[0].x/2, 0.5 + points[0].y/2);
		glVertex3f(points[0].x * smilieSize,points[0].y * smilieSize,smilieHeight/2);
		
	glEnd();
	
	glNormal3f(0,0,-1);
	glBegin(GL_TRIANGLE_FAN);
		glTexCoord2f(0.5,0.5);
		glVertex3f(0,0,-smilieHeight/2);
		
		for(int i = smilieSides-1; i >= 0; --i) {
			glTexCoord2f(0.5 + points[i].x/2, 0.5 + points[i].y/2);
			glVertex3f(points[i].x * smilieSize,points[i].y * smilieSize,-smilieHeight/2);
		}
		
		glTexCoord2f(0.5 + points[smilieSides-1].x/2, 0.5 + points[smilieSides-1].y/2);
		glVertex3f(points[smilieSides-1].x * smilieSize,points[smilieSides-1].y * smilieSize,-smilieHeight/2);
		
	glEnd();
	
	glDisable(GL_TEXTURE_2D);
	
	glBegin(GL_QUAD_STRIP);
		for(int i = 0; i < smilieSides; ++i) {
			glNormal3f(points[i].x,points[i].y,0);
			glVertex3f(points[i].x * smilieSize,points[i].y * smilieSize,smilieHeight/2);
			glVertex3f(points[i].x * smilieSize,points[i].y * smilieSize,-smilieHeight/2);
		}
		glNormal3f(points[0].x,points[0].y,0);
		glVertex3f(points[0].x * smilieSize,points[0].y * smilieSize,smilieHeight/2);
		glVertex3f(points[0].x * smilieSize,points[0].y * smilieSize,-smilieHeight/2);
	glEnd();
	
	
	glEndList();
	
	
	
	
	d = 0;
	dd = 2*pi / bigSmilieSides;
	
	for(int i = 0; i < bigSmilieSides; ++i) {
		
		points[i].x = cos(d);
		points[i].y = sin(d);
		
		d += dd;
	}
	
	
	bigSmilieList = glGenLists(1);
	
	glNewList(bigSmilieList, GL_COMPILE);
	
	
	glEnable(GL_TEXTURE_2D);
	glColor3f(1,1,1);
	
	glNormal3f(0,0,1);
	glBegin(GL_TRIANGLE_FAN);
		glTexCoord2f(0.5,0.5);
		glVertex3f(0,0,smilieHeight/2);
		
		for(int i = 0; i < bigSmilieSides; ++i) {
			glTexCoord2f(0.5 + points[i].x/2, 0.5 + points[i].y/2);
			glVertex3f(points[i].x * (1.5*smilieSize),points[i].y * (1.5*smilieSize),smilieHeight/2);
		}
			
		glTexCoord2f(0.5 + points[0].x/2, 0.5 + points[0].y/2);
		glVertex3f(points[0].x * (1.5*smilieSize),points[0].y * (1.5*smilieSize),smilieHeight/2);
		
	glEnd();
	
	glNormal3f(0,0,-1);
	glBegin(GL_TRIANGLE_FAN);
		glTexCoord2f(0.5,0.5);
		glVertex3f(0,0,-smilieHeight/2);
		
		for(int i = bigSmilieSides-1; i >= 0; --i) {
			glTexCoord2f(0.5 + points[i].x/2, 0.5 + points[i].y/2);
			glVertex3f(points[i].x * (1.5*smilieSize),points[i].y * (1.5*smilieSize),-smilieHeight/2);
		}
		
		glTexCoord2f(0.5 + points[bigSmilieSides-1].x/2, 0.5 + points[bigSmilieSides-1].y/2);
		glVertex3f(points[bigSmilieSides-1].x * (1.5*smilieSize),points[bigSmilieSides-1].y * (1.5*smilieSize),-smilieHeight/2);
		
	glEnd();
	
	glDisable(GL_TEXTURE_2D);
	glColor3f(1,1,0);
	
	glBegin(GL_QUAD_STRIP);
		for(int i = 0; i < bigSmilieSides; ++i) {
			glNormal3f(points[i].x,points[i].y,0);
			glVertex3f(points[i].x * (1.5*smilieSize),points[i].y * (1.5*smilieSize),smilieHeight/2);
			glVertex3f(points[i].x * (1.5*smilieSize),points[i].y * (1.5*smilieSize),-smilieHeight/2);
		}
		glNormal3f(points[0].x,points[0].y,0);
		glVertex3f(points[0].x * (1.5*smilieSize),points[0].y * (1.5*smilieSize),smilieHeight/2);
		glVertex3f(points[0].x * (1.5*smilieSize),points[0].y * (1.5*smilieSize),-smilieHeight/2);
	glEnd();
	
	
	glEndList();
	
}


void SmileyFace::Draw(int rotation)
{
	int ix, iz, nx, nz;
    GLfloat yeaSpecular[] = { 1,1,1,0};
    GLfloat shininess = 8;
    GLfloat noSpecular[] = { 0,0,0,0};
    GLfloat noShininess = 1;
	
	if (!minYCalculated) {
		y += minYValue(x,z);
		minYCalculated = true;
	}
	
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_LIGHTING);
	
	
	glPushMatrix();
	glTranslatef(x,y,z);
	glRotatef(rotation+r, 0,1,0);
		
	if (big) {
		
	    glMaterialfv(GL_FRONT, GL_SPECULAR, noSpecular);
	    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, noShininess);	
	    	
		if (superFog)
			glColor4f(1,1,1,calculateFog(x,y,z));
		else
			glColor4f(1,1,1,1);
		glBindTexture(GL_TEXTURE_2D, textures[kBigSmiley].GetTextureID());
		
		glCallList(bigSmilieList);
	} else {
	
	
	    glMaterialfv(GL_FRONT, GL_SPECULAR, yeaSpecular);
	    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
	    
		if (superFog)
			glColor4f(1,1,0,calculateFog(x,y,z));
		else
			glColor4f(1,1,0,1);
		glBindTexture(GL_TEXTURE_2D, textures[kSmiley].GetTextureID());
	
		glCallList(smilieList);
	}
	
	//gluSphere(quadratic, 1, 25,25);
	glPopMatrix();
	
	
	glDisable(GL_CULL_FACE);
	
	if (WithinRange(guy.x, guy.z, x, z, terrainSize*0.66)) {
		if (!shadowCalculated) {
			shadowSize = (0.32/smilieSize)/8.0;
			
			GetTerrainPiece(x, z, ix, iz);
			nx = ((ix+1) % terrainSize);
			nz = ((iz+1) % terrainSize);
			
			sx1 = terrain[ix][iz].x * spacing;
			sy1 = terrain[ix][iz].y * spacing + 0.05;
			sz1 = terrain[ix][iz].z * spacing;
			
			sx2 = terrain[nx][iz].x * spacing;
			sy2 = terrain[nx][iz].y * spacing + 0.05;
			sz2 = terrain[nx][iz].z * spacing;
			
			sx3 = terrain[nx][nz].x * spacing;
			sy3 = terrain[nx][nz].y * spacing + 0.05;
			sz3 = terrain[nx][nz].z * spacing;
			
			sx4 = terrain[ix][nz].x * spacing;
			sy4 = terrain[ix][nz].y * spacing + 0.05;
			sz4 = terrain[ix][nz].z * spacing;
			shadowCalculated = true;
		}
		glDisable(GL_LIGHTING);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[kShadow].GetTextureID());
		glDepthMask(false);
		
		glColorMask(1,1,1,0);
		glColor4f(1.0,1.0,1.0, 0.4);
		
		glBegin(GL_TRIANGLES);
			
			glTexCoord2f(-shadowSize,-shadowSize);
			glVertex3f(sx1, sy1, sz1);
			glTexCoord2f(shadowSize,-shadowSize);
			glVertex3f(sx2, sy2, sz2);
			glTexCoord2f(shadowSize,shadowSize);
			glVertex3f(sx3, sy3, sz3);
			
			glTexCoord2f(shadowSize,shadowSize);
			glVertex3f(sx3, sy3, sz3);
			glTexCoord2f(-shadowSize,shadowSize);
			glVertex3f(sx4, sy4, sz4);
			glTexCoord2f(-shadowSize,-shadowSize);
			glVertex3f(sx1, sy1, sz1);
			
		glEnd();
		glColorMask(1,1,1,1);
		glDepthMask(true);
	}
}