 /*   
 	SoFont - SDL Object Font Library
 	
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.
	
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	

	ChangeLog:

	Karl Bartel <karlb@gmx.net>:
		* Wrote original SFont C library
	
	Luc-Olivier de Charriere:
		* Copied into a C++ object to allow multiple fonts

	David Olofson <do@reologica.se>:
		* Strings changed to 'const char *'
		* Cursor tests first check if '|' is present.
		* Shadowed variables fixed.
		* Garbage data in spacing table fixed. (Thanks to
		  Andreas Spngberg for discovering this one!)
*/

#ifndef __SOFONT_H
#define __SOFONT_H

#include <SDL/SDL.h>

class SoFont
{
public:
	SoFont();
	~SoFont();

	bool load(SDL_Surface *FontSurface);

	// Blits a string to a surface
	//   Destination: the suface you want to blit to
	//   text: a string containing the text you want to blit.
	void PutString(SDL_Surface *Surface, int x, int y, const char *text, SDL_Rect *clip=NULL);
	void PutStringWithCursor(SDL_Surface *Surface, int x, int y, const char *text, int cursPos, SDL_Rect *clip=NULL, bool showCurs=true);

	// Returns the width of "text" in pixels
	int TextWidth(const char *text, int min=0, int max=255);

	int FontHeight()	{ return height; }

	// Blits a string to with centered x position
	void XCenteredString(SDL_Surface *Surface, int y, const char *text, SDL_Rect* clip=NULL);
	// Blits a string to with centered x & y position
	void CenteredString(SDL_Surface *Surface, const char *text, SDL_Rect* clip=NULL);
	// Blits a string to with centered around x & y positions
	void CenteredString(SDL_Surface *Surface, int x, int y, const char *text, SDL_Rect* clip=NULL);
	
	// This was specially developped for GUI
	void PutStringCleverCursor(SDL_Surface *Surface, const char *text, int cursPos, SDL_Rect *r, SDL_Rect* clip=NULL, bool showCurs=true);
	
	// Gives the cursor position given a x-axix point in the text
	int TextCursorAt(const char *text, int px);
	int CleverTextCursorAt(const char *text, int px, int cursPos, SDL_Rect *r);
	
#	define START_CHAR 33
	int getMinChar(){return START_CHAR;}
	int getMaxChar(){return max_i;}

protected:
	int height;
	SDL_Surface *picture;
	int *CharPos;
	int *Spacing;
	
	int max_i, spacew, cursShift;
	Uint32 background;
	bool DoStartNewChar(Sint32 x);
	void CleanSurface();
};

#endif
