/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.TextResource;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import java.util.StringTokenizer;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.SFX;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class Area
extends Feature
implements Tickable {
    public static final long serialVersionUID = 1L;
    private String id;
    private String group;
    private String mouseOff;
    private String mouseOn;
    private String disabled;
    private Point position;
    private Dimension size;
    private boolean noClick;
    private boolean debug;
    private int layer;
    private boolean visible = true;
    private String text;
    private Color color;
    private String leftFocus;
    private String rightFocus;
    private String upFocus;
    private String downFocus;
    private String nextFocus;
    private String prevFocus;
    private boolean defaultFocus;
    private boolean mirrored;
    private boolean flipped;
    private transient AnimatedAppearanceResource mouseOnResource;
    private transient AnimatedAppearanceResource mouseOffResource;
    private transient AnimatedAppearanceResource disabledResource;
    private transient Sprite sprite;
    private transient Rectangle bounds;
    private transient Screen screen;
    private transient boolean ignoreMouse;
    private transient boolean enabled;
    private transient GLTextArea textArea;
    private transient TextResource textResource;
    private transient String[] groups;
    private transient AnimatedAppearance currentAppearance;

    public Area() {
        this.setSubResource(true);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.mouseOffResource != null) {
            if (this.mouseOffResource instanceof SpriteImage) {
                SpriteImage img = (SpriteImage)this.mouseOffResource;
                this.bounds = new Rectangle(this.position.getX() - img.getHotspotX(), this.position.getY() - img.getHotspotY(), img.getWidth(), img.getHeight());
            }
        } else {
            if (this.size == null && this.mouseOff != null) {
                throw new Exception("Can't create area " + this + ": " + this.mouseOff + " not found.");
            }
            this.bounds = new Rectangle((ReadablePoint)this.position, (ReadableDimension)this.size);
            if (this.textResource != null) {
                this.textArea = new GLTextArea();
                this.textArea.setFont(Res.getSmallFont());
                this.textArea.setText(this.textResource.getText());
                this.textArea.setBounds((ReadableRectangle)this.bounds);
                this.textArea.setVerticalAlignment(GLTextArea.TOP);
                this.textArea.setHorizontalAlignment(TextLayout.CENTERED);
            }
        }
        if (this.group != null) {
            StringTokenizer st = new StringTokenizer(this.group, ",", false);
            this.groups = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                this.groups[count] = st.nextToken().trim();
                ++count;
            }
        }
        this.enabled = true;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.cleanup();
    }

    public void spawn(Screen newScreen) {
        this.screen = newScreen;
        newScreen.addTickable(this);
        if (this.mouseOffResource != null) {
            this.sprite = newScreen.allocateSprite(this);
            if (this.sprite == null) {
                System.err.println("Failed to create " + this + ": no sprite available");
                this.destroy();
            } else {
                this.sprite.setLayer(this.layer);
                this.sprite.setLocation(this.position.getX(), this.position.getY(), 0);
                this.sprite.setMirrored(this.mirrored);
                this.sprite.setFlipped(this.flipped);
                this.sprite.setAppearance((AnimatedAppearance)this.mouseOffResource);
            }
        }
        this.setVisible(this.visible);
    }

    public void cleanup() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
    }

    public void tick() {
        if (!this.screen.isOpen()) {
            return;
        }
        boolean selectDown = false;
        boolean armed = false;
        boolean clicked = false;
        if (this.screen.isKeyboardNavigationEnabled()) {
            selectDown = Keyboard.isKeyDown((int)57) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)28) || Binding.isBindingDown("select.binding") || Binding.isBindingDown("select.binding.alt");
            armed = this.isFocused();
            if (selectDown && armed) {
                clicked = true;
            } else {
                boolean mouseArmed;
                selectDown = Mouse.isButtonDown((int)0);
                boolean bl = mouseArmed = this.bounds != null && this.bounds.contains(this.screen.getMouseX(), this.screen.getMouseY());
                if (selectDown && mouseArmed) {
                    clicked = true;
                    if (this.enabled) {
                        this.requestFocus();
                    }
                } else {
                    armed |= mouseArmed;
                }
            }
        } else {
            selectDown = Mouse.isButtonDown((int)0);
            boolean bl = armed = this.bounds != null && this.bounds.contains(this.screen.getMouseX(), this.screen.getMouseY());
            if (selectDown && armed) {
                clicked = true;
            }
        }
        if (this.sprite != null) {
            if (this.mouseOnResource != null && armed && this.enabled) {
                if (this.currentAppearance != this.mouseOnResource) {
                    if (this.visible && !this.noClick) {
                        SFX.buttonHover();
                        this.screen.onHover(this.id, true);
                    }
                    this.setAppearance((AnimatedAppearance)this.mouseOnResource);
                }
            } else if (this.enabled && this.mouseOffResource != null) {
                if (this.currentAppearance != this.mouseOffResource) {
                    this.setAppearance((AnimatedAppearance)this.mouseOffResource);
                    this.screen.onHover(this.id, false);
                }
            } else if (this.disabledResource != null) {
                this.setAppearance((AnimatedAppearance)this.disabledResource);
            }
        }
        if (selectDown && this.visible && armed && !this.noClick && !this.ignoreMouse && this.enabled && clicked) {
            SFX.buttonClick();
            this.ignoreMouse = true;
            this.screen.onClicked(this.id);
        } else if (!selectDown) {
            this.ignoreMouse = false;
        }
    }

    private void setAppearance(AnimatedAppearance appearance) {
        if (this.sprite == null || this.currentAppearance == appearance) {
            return;
        }
        this.sprite.setAppearance(appearance);
        this.currentAppearance = appearance;
    }

    public void render() {
        if (this.textArea != null && this.visible) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            this.textArea.render();
        }
        if (this.position != null && this.size != null && this.debug) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            GL11.glBegin((int)7);
            GL11.glVertex2i((int)this.position.getX(), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glVertex2i((int)this.position.getX(), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glEnd();
        }
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return "Area[" + this.id + "]";
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.ignoreMouse = true;
        }
        if (this.sprite != null) {
            this.sprite.setVisible(visible);
        }
    }

    public void setAlpha(int alpha) {
        if (this.sprite != null) {
            this.sprite.setAlpha(alpha);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.sprite != null) {
            if (enabled) {
                this.setAppearance((AnimatedAppearance)this.mouseOffResource);
            } else if (this.disabledResource != null) {
                this.setAppearance((AnimatedAppearance)this.disabledResource);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isActive() {
        return this.isCreated();
    }

    public void remove() {
    }

    public String getNextFocus() {
        return this.nextFocus;
    }

    public String getPrevFocus() {
        return this.prevFocus;
    }

    public String getLeftFocus() {
        return this.leftFocus;
    }

    public String getRightFocus() {
        return this.rightFocus;
    }

    public String getUpFocus() {
        return this.upFocus;
    }

    public String getDownFocus() {
        return this.downFocus;
    }

    public boolean isFocused() {
        return this.screen.getFocus() == this && this.screen.isKeyboardNavigationEnabled() && this.visible && this.enabled && !this.noClick;
    }

    public boolean isDefaultFocus() {
        return this.defaultFocus;
    }

    public boolean isFocusable() {
        return this.visible && this.enabled && !this.noClick;
    }

    public boolean isInGroup(String groupToCheck) {
        if (groupToCheck == null || this.groups == null) {
            return false;
        }
        int i = 0;
        while (i < this.groups.length) {
            if (groupToCheck.equals(this.groups[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void requestFocus() {
        this.screen.requestFocus(this);
    }
}

