/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AbstractAWTInput;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.LinuxEvent;
import org.lwjgl.opengl.LinuxMouse;
import org.lwjgl.opengl.LinuxPeerInfo;
import org.lwjgl.opengl.PeerInfo;

final class LinuxAWTInput
extends AbstractAWTInput {
    private final long display;
    private final long input_window;
    private final LinuxEvent event = new LinuxEvent();
    private long cached_window;
    private LinuxMouse cached_mouse;
    private long blank_cursor = 0L;
    private boolean input_grabbed;
    private boolean input_released;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxAWTInput(AWTGLCanvas canvas) throws LWJGLException {
        super(canvas);
        LinuxDisplay.lockAWT();
        try {
            this.display = LinuxDisplay.openDisplay();
            this.input_window = LinuxAWTInput.createInputOnlyWindow(this.display, LinuxDisplay.nGetDefaultScreen(this.display));
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native long createInputOnlyWindow(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        super.destroy();
        LinuxDisplay.lockAWT();
        try {
            this.destroyCursor();
            LinuxDisplay.nDestroyWindow(this.display, this.input_window);
            LinuxDisplay.closeDisplay(this.display);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungrabInputLocked() {
        LinuxDisplay.lockAWT();
        try {
            this.ungrabInput();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void ungrabInput() {
        if (this.input_grabbed) {
            LinuxDisplay.nUngrabPointer(this.display);
            LinuxDisplay.nSetRepeatMode(this.display, 2);
            this.input_grabbed = false;
        }
    }

    private void grabInput(long window) {
        if (!this.input_grabbed) {
            LinuxDisplay.nSetRepeatMode(this.display, 0);
            int res2 = LinuxDisplay.nGrabPointer(this.display, window, this.blank_cursor);
            if (res2 == 0) {
                this.input_grabbed = true;
            }
        }
    }

    private final void destroyCursor() {
        if (this.blank_cursor != 0L) {
            LinuxDisplay.nDestroyCursor(this.display, this.blank_cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processInput(PeerInfo peer_info) {
        LinuxDisplay.lockAWT();
        try {
            LinuxPeerInfo linux_peer_info = (LinuxPeerInfo)peer_info;
            long new_window = linux_peer_info.getDrawable();
            if (this.cached_mouse == null || new_window != this.cached_window) {
                this.ungrabInput();
                this.cached_window = new_window;
                try {
                    this.cached_mouse = new LinuxMouse(this.display, new_window, this.input_window);
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Failed to create input devices: " + e);
                }
                this.destroyCursor();
                this.blank_cursor = LinuxDisplay.nCreateBlankCursor(this.display, new_window);
            }
            this.checkFocus();
            if (!this.input_grabbed && this.shouldGrab()) {
                this.grabInput(new_window);
            }
            this.update();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void checkFocus() {
        if (this.getCanvas().isFocusOwner()) {
            this.input_released = false;
        } else {
            this.input_released = true;
            this.ungrabInput();
        }
    }

    private boolean shouldGrab() {
        return !this.input_released && this.isGrabbed();
    }

    private void update() {
        while (LinuxEvent.getPending(this.display) > 0) {
            this.event.nextEvent(this.display);
            if (!this.shouldGrab()) continue;
            long event_window = this.event.getWindow();
            boolean bl = this.event.filterEvent(event_window) || this.cached_mouse.filterEvent(this.isGrabbed(), this.shouldGrab(), this.event);
        }
    }

    public synchronized void grabMouse(boolean grab) {
        if (grab != this.isGrabbed()) {
            super.grabMouse(grab);
            if (this.cached_mouse != null) {
                this.cached_mouse.changeGrabbed(grab, this.shouldGrab());
            }
            this.ungrabInputLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        if (this.isGrabbed()) {
            LinuxDisplay.lockAWT();
            try {
                if (this.cached_mouse == null) return;
                this.cached_mouse.poll(this.isGrabbed(), coord_buffer, buttons);
                return;
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        } else {
            super.pollMouse(coord_buffer, buttons);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void readMouse(ByteBuffer buffer) {
        if (this.isGrabbed()) {
            LinuxDisplay.lockAWT();
            try {
                if (this.cached_mouse == null) return;
                this.cached_mouse.read(buffer);
                return;
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        } else {
            super.readMouse(buffer);
        }
    }
}

