/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLUtil;
import com.shavenpuppy.jglib.sprites.Style;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;

final class TextureRun {
    private static GLBaseTexture lastRenderedTexture0;
    private static GLBaseTexture lastRenderedTexture1;
    private static Style lastRenderedStyle;
    GLBaseTexture texture0;
    GLBaseTexture texture1;
    Style style;
    int offset;
    int spritesToRender;

    TextureRun() {
    }

    void init(GLBaseTexture texture0, GLBaseTexture texture1, Style style, int offset) {
        this.texture0 = texture0;
        this.texture1 = texture1;
        this.style = style;
        this.offset = offset;
        this.spritesToRender = 0;
    }

    void add() {
        ++this.spritesToRender;
    }

    public void preRender() {
        if (this.style != lastRenderedStyle) {
            if (lastRenderedStyle != null) {
                lastRenderedStyle.resetState();
            }
            this.style.setupState();
            lastRenderedStyle = this.style;
        }
        if (this.texture0 != lastRenderedTexture0) {
            if (this.texture0 != null) {
                this.texture0.render();
            }
            lastRenderedTexture0 = this.texture0;
        }
        if (this.texture1 != null && this.texture1 != lastRenderedTexture1 && GLUtil.isMultitextureSupported()) {
            GLUtil.glActiveTexture(33985);
            this.texture1.render();
            lastRenderedTexture1 = this.texture1;
            GLUtil.glActiveTexture(33984);
        }
    }

    void render() {
        this.preRender();
        if (this.spritesToRender > 0) {
            GL11.glDrawArrays((int)7, (int)(this.offset << 2), (int)(this.spritesToRender << 2));
        }
    }

    void drawRangeElements(ShortBuffer indices) {
        this.preRender();
        ShortBuffer runIndices = indices.slice();
        int startIndex = this.offset * 4;
        runIndices.position(startIndex);
        runIndices.limit(startIndex + this.spritesToRender * 4);
        GL11.glDrawElements((int)7, (ShortBuffer)runIndices);
    }

    void done() {
        if (lastRenderedStyle != null) {
            lastRenderedStyle.resetState();
        }
        lastRenderedStyle = null;
        lastRenderedTexture0 = null;
        lastRenderedTexture1 = null;
    }
}

