/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceConverter
implements Resource.Loader {
    private static final boolean DEBUG = false;
    HashMap typeMap = new HashMap();
    static final Class[] namedSig;
    static final Class[] unnamedSig;
    Stack stack = new Stack();
    private boolean overwrite;
    private Set included = new HashSet();
    private ResourceLoadedListener loadedListener;
    private Stack resourcePath = new Stack();
    private int uniqueNameCounter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.shavenpuppy.jglib.resources.ResourceConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        namedSig = classArray;
        unnamedSig = new Class[0];
    }

    public ResourceConverter() {
    }

    public ResourceConverter(ResourceLoadedListener loadedListener) {
        this.loadedListener = loadedListener;
    }

    public ResourceConverter(String resourceName) throws Exception {
        this.include(resourceName);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.err.println("Usage: ResourceConverter <classpath-xml-resource> <destpath>");
                System.exit(-1);
            }
            new ResourceConverter(args[0]);
            Resources.save(new FileOutputStream(args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetIncludes() {
        this.included.clear();
    }

    private void log(String msg) {
    }

    public void include(String resourceName) throws Exception {
        this.log("Including resources from:" + resourceName);
        this.resourcePath.push(resourceName);
        ClassLoader l = this.getClass().getClassLoader();
        InputStream is = l.getResourceAsStream(resourceName);
        if (is == null && (is = new BufferedInputStream(new FileInputStream(resourceName))) == null) {
            throw new Exception("Failed to find resource '" + resourceName + "'");
        }
        this.include(is);
        this.resourcePath.pop();
    }

    public void include(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        Element root = document.getDocumentElement();
        String name = XMLUtil.getString(root, "name", null);
        if (name != null) {
            if (this.included.contains(name)) {
                return;
            }
            this.included.add(name);
            this.resourcePath.push(name);
        }
        NodeList childNodeList = root.getChildNodes();
        int i = 0;
        while (i < childNodeList.getLength()) {
            Node node = childNodeList.item(i);
            if (node.getNodeType() == 1) {
                Element featureElement = (Element)node;
                this.load(featureElement);
            }
            ++i;
        }
        if (name != null) {
            this.resourcePath.pop();
        }
    }

    private void ifDef(Element element, boolean match) throws Exception {
        String key = element.getAttribute("key");
        String value = element.getAttribute("value");
        this.log("Checking condition: " + key + "=" + value + "...");
        if (System.getProperty(key, "<undefined>").equals(value) == match) {
            this.log("true");
            NodeList children = element.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    this.load((Element)child);
                }
                ++i;
            }
        } else {
            this.log("false");
        }
    }

    public Resource load(Element featureElement) throws Exception {
        if (featureElement.getNodeName().equals("include")) {
            String name = featureElement.getAttribute("resource");
            if (name == null) {
                throw new Exception("Missing 'resource' attribute in include tag");
            }
            this.log("Including " + name);
            this.include(name);
            return null;
        }
        if (featureElement.getNodeName().equals("map")) {
            String tag = featureElement.getAttribute("tag");
            if (tag == null || "".equals(tag)) {
                throw new Exception("Missing 'tag' attribute");
            }
            if (tag.equals("map")) {
                throw new Exception("Cannot reassign 'map' tag");
            }
            String className = featureElement.getAttribute("class");
            if (className == null || "".equals(className)) {
                throw new Exception("Missing 'class' attribute");
            }
            Class<?> clazz = Class.forName(className);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.shavenpuppy.jglib.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new Exception(clazz + " is not a Resource.");
            }
            this.typeMap.put(tag, clazz);
            this.log("Mapping <" + tag + "> to " + className);
            return null;
        }
        if (featureElement.getNodeName().equals("instance")) {
            String className = featureElement.getAttribute("class");
            if (className == null || "".equals(className)) {
                throw new Exception("Missing 'class' attribute");
            }
            Class<?> clazz = Class.forName(className);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("com.shavenpuppy.jglib.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isAssignableFrom(clazz)) {
                throw new Exception(clazz + " is not a Resource.");
            }
            return this.loadInstance(true, featureElement, clazz);
        }
        if (featureElement.getNodeName().equals("ifdef")) {
            this.ifDef(featureElement, true);
            return null;
        }
        if (featureElement.getNodeName().equals("ifndef")) {
            this.ifDef(featureElement, false);
            return null;
        }
        if (featureElement.getNodeName().equals("property")) {
            XMLUtil.putVar(XMLUtil.getString(featureElement, "key"), XMLUtil.getString(featureElement, "value"));
            return null;
        }
        Class featureClass = (Class)this.typeMap.get(featureElement.getTagName());
        if (featureClass == null) {
            throw new Exception("No mapping specified for " + featureElement.getTagName());
        }
        return this.loadInstance(false, featureElement, featureClass);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource loadInstance(boolean isInstance, Element featureElement, Class featureClass) throws Exception {
        int i;
        NamedNodeMap atts;
        int i2;
        NamedNodeMap atts2;
        if (!$assertionsDisabled) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("com.shavenpuppy.jglib.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$1 = clazz2;
            }
            if (!clazz.isAssignableFrom(featureClass)) {
                throw new AssertionError((Object)(String.valueOf(featureClass.getName()) + " is not a Resource"));
            }
        }
        Constructor namedCtor = null;
        Constructor unnamedCtor = null;
        boolean canBeUnNamed = false;
        boolean canBeNamed = false;
        boolean named = false;
        try {
            namedCtor = featureClass.getConstructor(namedSig);
            canBeNamed = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            unnamedCtor = featureClass.getConstructor(unnamedSig);
            canBeUnNamed = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!canBeNamed && !canBeUnNamed) {
            throw new Exception("No suitable constructor found for " + featureElement.getTagName());
        }
        try {
            Resource newFeature = null;
            String name = null;
            name = featureElement.getAttribute("name");
            named = !"".equals(name);
            boolean exists = false;
            boolean wasCreated = false;
            if (this.overwrite && named && (exists = Resources.exists(name))) {
                newFeature = Resources.peek(name);
                if (newFeature.isLocked()) {
                    return newFeature;
                }
                this.log("Reloading " + newFeature);
                wasCreated = newFeature.isCreated();
                if (wasCreated) {
                    newFeature.destroy();
                }
            }
            if (newFeature == null) {
                if (canBeNamed && named) {
                    newFeature = (Resource)namedCtor.newInstance(name);
                } else if (canBeUnNamed && !named) {
                    newFeature = (Resource)unnamedCtor.newInstance(new Object[0]);
                } else {
                    if (canBeNamed && !named) {
                        throw new Exception("Resource has no 'name' attribute (a " + featureElement.getTagName() + "/" + featureClass.getName() + ")");
                    }
                    if (!canBeUnNamed) throw new Exception("Something strange happened.");
                    if (!named) throw new Exception("Something strange happened.");
                    throw new Exception("Resource cannot be named (a " + featureClass.getName() + ")");
                }
            }
            if (!named) {
                StringBuffer sb = new StringBuffer(128);
                Iterator i3 = this.resourcePath.iterator();
                while (true) {
                    if (!i3.hasNext()) {
                        sb.append(featureClass.getName());
                        sb.append(this.uniqueNameCounter++);
                        newFeature.setName(sb.toString());
                        break;
                    }
                    sb.append(i3.next());
                    sb.append('.');
                }
            }
            try {
                newFeature.load(featureElement, this);
            }
            catch (Exception e) {
                System.err.println("Failed to load " + newFeature + " due to " + e);
                throw e;
            }
            if (newFeature.isSubResource()) return newFeature;
            if (exists) {
                if (wasCreated) {
                    newFeature.create();
                }
                if (this.loadedListener == null) return newFeature;
                this.loadedListener.resourceLoaded(newFeature);
                return newFeature;
            }
            boolean bl = named = newFeature.getName() != null;
            if (!named) {
                Resources.add(newFeature);
                if (this.loadedListener == null) return newFeature;
                this.loadedListener.resourceLoaded(newFeature);
                return newFeature;
            }
            if (!this.overwrite && Resources.exists(name)) {
                throw new Exception("Resource " + newFeature + " has already been defined.");
            }
            Resources.put(newFeature);
            if (this.loadedListener != null) {
                this.loadedListener.resourceLoaded(newFeature);
            }
            this.log("Resource " + newFeature + ": loaded");
            return newFeature;
        }
        catch (InstantiationException e) {
            e.printStackTrace(System.err);
            throw new Exception("Resource " + featureElement.getAttribute("name") + " [" + featureElement.getAttribute("class") + "] failed to instantiate.", e.getCause());
        }
        catch (Exception e) {
            this.log("Exception loading resource from tag " + featureElement.getNodeName());
            atts2 = featureElement.getAttributes();
            i2 = 0;
        }
        while (true) {
            if (i2 >= atts2.getLength()) {
                throw e;
            }
            this.log("\tAttribute " + atts2.item(i2).getNodeName() + "=" + featureElement.getAttribute(atts2.item(i2).getNodeName()));
            ++i2;
        }
        catch (AssertionError e) {
            this.log("Exception loading resource from tag " + featureElement.getNodeName());
            atts = featureElement.getAttributes();
            i = 0;
        }
        while (true) {
            if (i >= atts.getLength()) {
                throw e;
            }
            this.log("\tAttribute " + atts.item(i).getNodeName() + "=" + featureElement.getAttribute(atts.item(i).getNodeName()));
            ++i;
        }
    }

    public void setLoadedListener(ResourceLoadedListener loadedListener) {
        this.loadedListener = loadedListener;
    }

    public ResourceLoadedListener getLoadedListener() {
        return this.loadedListener;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void pushMap(Map map) {
        this.stack.push(this.typeMap);
        this.typeMap = new HashMap(this.typeMap);
        this.typeMap.putAll(map);
    }

    public Map popMap() {
        if (this.stack.size() == 0) {
            return null;
        }
        HashMap existingMap = this.typeMap;
        this.typeMap = (HashMap)this.stack.pop();
        return existingMap;
    }
}

