/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Named;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class Resource
implements Serializable,
Comparable,
Named,
Cloneable {
    public static final long serialVersionUID = 1L;
    private static int idCounter;
    protected String name;
    private int id = idCounter++;
    private boolean locked;
    private boolean subResource;
    transient boolean created;
    transient boolean queued;
    transient boolean dying;
    transient Thread queuedThread;
    private boolean directSerialize;

    public Resource() {
    }

    public Resource(String name) {
        this.name = name;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        if (this.isValidContext() && this.isCreated()) {
            this.destroy();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized void create() throws Exception {
        block7: {
            if (this.created) break block7;
            if (!this.queued) {
                try {
                    this.queued = true;
                    this.queuedThread = Thread.currentThread();
                    Resources.allocate(this);
                    this.notifyAll();
                }
                catch (Exception e) {
                    System.err.println("Failed to create " + this + " due to " + e);
                    e.printStackTrace(System.err);
                    this.queued = false;
                    this.queuedThread = null;
                    this.notifyAll();
                    throw e;
                }
            }
            if (!this.queued || this.queuedThread != Thread.currentThread()) ** GOTO lbl23
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
lbl23:
                // 3 sources

                ** while (this.queued && !this.created)
            }
lbl24:
            // 1 sources

            this.queuedThread = null;
            if (!this.queued && !this.created) {
                throw new Exception("Resource " + this + " was dequeued");
            }
        }
    }

    public final synchronized void destroy() {
        if (this.created) {
            if (!this.dying) {
                this.dying = true;
                Resources.deallocate(this);
            }
            while (this.created) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void doCreate() throws Exception {
    }

    protected void doDestroy() {
    }

    public final synchronized boolean isCreated() {
        return this.created;
    }

    public String toString() {
        if (this.name == null) {
            return "a " + this.getClass().getName();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public final String getName() {
        return this.name;
    }

    public void load(Element element, Loader loader) throws Exception {
    }

    public Element save(Resource parent) {
        return null;
    }

    public void register() {
    }

    public void deregister() {
    }

    public final int compareTo(Object o) {
        if (o == null || !(o instanceof Resource)) {
            return 0;
        }
        Resource r = (Resource)o;
        if (this.id < r.id) {
            return -1;
        }
        if (this.id > r.id) {
            return 1;
        }
        return 0;
    }

    protected boolean isValidContext() {
        return true;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final void setLocked(boolean locked) {
        this.locked = locked;
    }

    public final boolean isSubResource() {
        return this.subResource;
    }

    public final void setSubResource(boolean subResource) {
        this.subResource = subResource;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (Resources.isRunMode() && !this.directSerialize) {
            return new SerializedResource(this);
        }
        return this;
    }

    public void setName(String name) {
        Resource oldResource = Resources.forget(this);
        this.name = name;
        if (oldResource != null) {
            if (name == null) {
                Resources.add(this);
            } else {
                Resources.put(this);
            }
        }
    }

    public static interface Loader {
        public Resource load(Element var1) throws Exception;

        public void include(InputStream var1) throws Exception;

        public void pushMap(Map var1);

        public Map popMap();

        public void setLoadedListener(ResourceLoadedListener var1);

        public ResourceLoadedListener getLoadedListener();

        public void setOverwrite(boolean var1);

        public boolean isOverwrite();
    }

    private static final class SerializedResource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String resourceName;
        private String className;
        private transient Resource resource;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Resource$SerializedResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public SerializedResource(Resource resourceToSerialize) {
            this.resourceName = resourceToSerialize.getName();
            this.className = resourceToSerialize.getClass().getName();
            if (this.resourceName == null) {
                this.resource = resourceToSerialize;
            }
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.resourceName != null) {
                try {
                    return Resources.get(this.resourceName);
                }
                catch (Exception e) {
                    throw new InvalidObjectException("Failed to deserialize resource " + this.resourceName + " due to " + e);
                }
            }
            try {
                if (!this.resource.isCreated()) {
                    this.resource.create();
                }
                return this.resource;
            }
            catch (Exception e) {
                throw new InvalidObjectException("Failed to deserialize resource due to " + e);
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.resourceName == null) {
                block3: {
                    this.resource.directSerialize = true;
                    try {
                        stream.writeObject(this.resource.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace(System.err);
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
                this.resource.directSerialize = false;
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            if (this.resourceName == null) {
                this.resource = (Resource)stream.readObject();
            }
        }
    }
}

