
var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove(event) {
	if (!flipShown && !lockAnimation) {
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval('animateRollie();',13);
		animation.from = animation.now;
		animation.to = 1.0;
		animateRollie();
		flipShown = true;
	}
}

function mouseexit(event) {
	if (flipShown && !lockAnimation) {
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval('animateRollie();',13);
		animation.from = animation.now;
		animation.to = 0.0;
		animateRollie();
		flipShown = false;
	}
}

function animateRollie() {
	var T;
	var ease;
	var time = (new Date).getTime();
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	if (T >= animation.duration) {
		clearInterval(animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	} else {
		ease = 0.5 - (0.5*Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat(animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}

function limit_3(a,b,c) {
	return a < b ? b : (a > c ? c: a);
}

function computeNextFloat(from, to, ease) {
	return from + (to - from) * ease;
}

function enterflip(event) {
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
	document.getElementById('fliprollie').style.display = 'none';
}

function showBack() {
	var front = document.getElementById('front');
	var back = document.getElementById('back');
	
	if (gameTimer) clearTimeout(gameTimer);
	stopAndUpdateTimer();
	onFront = false;
	
	if (window.widget) widget.prepareForTransition("ToBack");
	
	front.style.display='none';
	back.style.display='block';
	
	if (window.widget) setTimeout('widget.performTransition();',0);
}

function hideBack() {
	var front = document.getElementById('front');
	var back = document.getElementById('back');

	updatePuzzleDisplay();
	document.getElementById('fliprollie').style.display = 'none';
	
	if (window.widget) widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	back.style.display="none";
	if (!puzzleComplete) {
		document.getElementById('highScores').style.display = 'none';
		document.getElementById('grid').style.display = 'block';
		document.getElementById('thePuzzle').style.display = 'block';
		document.getElementById('highlight').style.display = 'block';
		document.getElementById('grid').style.opacity = 1.0;
		document.getElementById('thePuzzle').style.opacity = 1.0;
	}	

	if (window.widget) setTimeout('widget.performTransition();',0);
}

function getCheckBoxValue(objName) {
	var obj = document.getElementById(objName);
	
	if (obj.checked) {
		return true;
	} else {
		return false;
	}
}

function setCheckBoxValue(objName,checked) {
	var obj = document.getElementById(objName);
	
	obj.checked = checked;
}

function getSelectValue(objName) {
	var obj = document.getElementById(objName);
	var index = obj.selectedIndex;
	
	return obj.options[index].value;
}

function setSelectValue(objName,index) {
	document.getElementById(objName).selectedIndex = index;
}

function valueExistsInArray(value, theArray) {
	var i;
	
	if (!theArray.length) return -1;
	
	for (i=0; i<theArray.length; i++) {
		if (theArray[i] == value) return i;
	}
	
	return -1;
}

function convertArrayToString(theArray) {
	var i;
	var strReturn = '';
	
	for (i=0; i<theArray.length; i++) {
		if (i) strReturn = strReturn + ":";
		strReturn = strReturn + theArray[i];
	}

	return strReturn;
}

function goToBdeboer(evt) {
	if (window.widget) widget.openURL('http://www.briandeboer.com');
}

function showHideElements(elements, style) {
	var i;
	var elementArray = elements.split(',');
	
	for (i=0;i<elementArray.length;i++) {
		document.getElementById(elementArray[i]).style.display = style;
	}
}
