/*
Copyright (C) 2005, Brian DeBoer  All rights reserved.
Code and art: B. DeBoer

No portion of this code may be duplicated or reproduced in another widget 
without written permission from Brian DeBoer Contact: bdeboer@bdeboer.com

Let us know if you make any improvements or have any new ideas!

1.0 - 8/22/05 - First release
1.1 - 8/28/05 - Added/Fixed many things
	AutoScratches (thanks to Wout Mertens!)
	incorrect vs. not possible solutions
	made more difficult puzzles
	keyboard navigation
	very simple finish - will implement more later
	blank puzzle option with ability to lock puzzle and start timer
	puzzle solver
	timer
2.0 - 12/24/05
	+ high scores/stats
	- show high scores
	+ leave puzzle on completion
	+ easier level
	+ remove auto scratches
	+ points system
	- timer still starts sometimes when it shouldn't
	- problem with numbers disappearing
	- reload
	- problem with info icon in bottom
*/

var versionNumber = 1.50;
// setup what grids are in which blocks
// create grid map
var i = 0;

var showIncorrectAnswers;
var showAutoScratches;
var onlyPencilMarks;

var timesDone = 0;
var arrayFields = new Array();
var solution = new Array();
var keyboardLock = false;
var onFront = true;
var enteringBlanks = false;
var emptyFieldsLeft = 0;
var lastMinuteCount = -1;
var clockRotation = 0;

var scratches = new Array(81);
for (i=0;i<81;i++) scratches[i] = new Array();

var autoScratches = new Array(81);
for (i=0;i<81;i++) autoScratches[i] = new Array();

var antiScratches = new Array(81);
for (i=0;i<81;i++) antiScratches[i] = new Array();

var gameStartTime = 0;
var gameStopTime = 0;
var gameStoredTime = 0;
var gameTimer;
var lockAnimation = false;
var computerSolved = false;
var puzzleComplete = false;

var animationCongrats = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, secondElement:null, timer:null};

var score = 0;
var scoreShowAutoScratches = false;
var scoreShowIncorrectAnswers = false;
var easyHighScores = new Array();
var medHighScores = new Array();
var hardHighScores = new Array();
var diabloHighScores = new Array();
var currentHighScoreDisplay = 'easy';

var DIABLO = 415;
var HARD = 390;
var MED = 370;
var EASY = 320;

selectedNum = 0;
currentCell = 0;

function checkSolution() {
	var i;
	var theSame = true;
	
	for (i=0; i<81; i++) {
		if (solution[i] != Math.abs(arrayFields[i])) theSame = false;
	}
	
	return theSame;
}			

function emptyFields() {
	var i;
	var count = 0;
		
	for (i=0; i<81; i++) {
		if (arrayFields[i] == 0) count++;
	}
	
	return count;
}

function generatePuzzle() {
	var numToHide, numGuesses, i;
	var tmpDifficulty;
	
	tmpDifficulty = getSelectValue('difficulty');

	if (tmpDifficulty != -1) {
		tmpDifficulty = tmpDifficulty.split(':');
		numToHide = tmpDifficulty[0];
		numGuesses = tmpDifficulty[1];
	} else {
		numToHide = -1;
	}
	
	document.getElementById('status').innerHTML = "Generating new puzzle...please wait";
	showHideElements('status','block');
	showHideElements('newPuzzleBtn,solvePuzzleBtn,doneBtn,highScoresBtn','none');
	
	if (!numToHide) numToHide = 350;

	if (numToHide > 0) {
		enteringBlanks = false;
		var sudokuCall = "./SudokuC -n " + numToHide;
		if (numGuesses) {
			sudokuCall += " -g " + numGuesses;
		}
		alert("Calling SudokuC: " + sudokuCall);
		if (window.widget) {
			var tmpSudoku = widget.system(sudokuCall, null).outputString;
		} else {
			tmpSudoku = '4:3:1:6:7:2:5:9:8:6:2:5:4:9:8:7:1:3:7:9:8:5:1:3:6:2:4:1:4:2:8:3:5:9:7:6:8:5:7:9:6:1:4:3:2:9:6:3:7:2:4:8:5:1:2:7:9:1:8:6:3:4:5:3:8:4:2:5:9:1:6:7:5:1:6:3:4:7:2:8:9|4:3:1:6:7:2:5:9:8:6:2:5:4:9:8:7:1:3:7:9:8:5:1:3:6:2:4:1:4:2:8:3:5:9:7:6:8:5:7:9:6:1:4:3:2:9:6:3:7:2:4:8:5:1:2:7:9:1:8:6:3:4:5:3:8:4:2:5:9:1:6:7:5:1:6:3:4:7:2:8:9';
		}
		
		tmpSudoku = tmpSudoku.split('|');

		arrayFields = tmpSudoku[0].split(':');
		solution = tmpSudoku[1].split(':');

		scratches = new Array(81);
		antiScratches = new Array(81);
		for (i=0;i<81;i++) scratches[i] = new Array();
		for (i=0;i<81;i++) antiScratches[i] = new Array();
		updateAutoScratches();
		gameStartTimer();
	} else {
		enteringBlanks = true;
		arrayFields = new Array();
		solution = new Array();
		scratches = new Array(81);

		for (i=0;i<81;i++) scratches[i] = new Array();
		
		for (i=0;i<81;i++) {
			arrayFields[i] = 0;
			solution[i] = 0;
			var obj = document.getElementById('field_' + i);
			while (obj.firstChild) { obj.removeChild(obj.firstChild); }
		}
		updateAutoScratches();
	}

	score = numToHide/415 * 20000;

	scoreShowAutoScratches = false;
	scoreShowIncorrectAnswers = false;

	if (getCheckBoxValue('showAutoScratchesCheckBox')) {
		scoreShowAutoScratches = true;
	}

	if (getCheckBoxValue('showIncorrectCheckBox')) {
		scoreShowIncorrectAnswers = true;
	}

	//alert('Starting score = ' + score);
		
	showHideElements('status','none');
	showHideElements('newPuzzleBtn,solvePuzzleBtn,doneBtn,highScoresBtn','block');
	
	updatePuzzleDisplay();
}

function updateAutoScratches() {
	var i, j, rowstart, colstart, blockstart, digit, exists, index;
	for (i=0;i<81;i++) {
		if(arrayFields[i] <= 0) {
			rowstart = Math.floor(i/9)*9;
			colstart = i%9;
			blockstart = Math.floor(rowstart/9/3)*9*3 + Math.floor(colstart/3)*3;
			for(digit=1;digit<=9;digit++) {
				exists = false;
				for(j=colstart;!exists && j<81;j+=9) {
					if (Math.abs(arrayFields[j]) == digit) {
						exists = true;
					}
				}
				for(j=rowstart;!exists && j<rowstart+9;j++) {
					if (Math.abs(arrayFields[j]) == digit) {
						exists = true;
					}
				}
				for(j=blockstart;!exists && j<blockstart+3;j++) {
					if (Math.abs(arrayFields[j]) == digit) {
						exists = true;
					}
				}
				for(j=blockstart+9;!exists && j<blockstart+9+3;j++) {
					if (Math.abs(arrayFields[j]) == digit) {
						exists = true;
					}
				}
				for(j=blockstart+18;!exists && j<blockstart+18+3;j++) {
					if (Math.abs(arrayFields[j]) == digit) {
						exists = true;
					}
				}
				index = valueExistsInArray(digit,autoScratches[i])
				if (index < 0) {
					if (!exists) {
						if (autoScratches[i].length < 9) autoScratches[i][autoScratches[i].length] = digit;
						elem = document.getElementById('field_'+i);
					}
				} else {
					if (exists) {
						autoScratches[i].splice(index,1);
						elem = document.getElementById('field_'+i);
					}
				}
			} // all digits
		} // non-committed
	} // all fields
}

function showCongratsText() {
	if (gameTimer) clearTimeout(gameTimer);
	var obj = document.getElementById('selectableNumbers');
	obj.style.display = 'none';
	obj.style.opacity = 1.0;
	
	showHideElements('highScores','block');
	document.getElementById('highScores').innerHTML = 'Congratulations! You finished in ' + secondsToMinutes(gameStoredTime / 1000) + '<br>and scored ' + Math.round(score) + ' points.';
	lockAnimation = false;
}

function showHighScores() {
	showHideElements('backNormal','none');
	showHideElements('backHighScores','block');
	showHideElements('highScoresBtn','none');
	showHideElements('newPuzzleBtn','none');
	showHideElements('solvePuzzleBtn','none');
	showHideElements('doneBtn','none');
	showHideElements('optionsBtn','block');
	
	showScores(currentHighScoreDisplay);
}

function showScores(level) {
	var selectedScore = '';
	var values;
	var obj;
	
	document.getElementById('show_'+currentHighScoreDisplay).className = '';
	document.getElementById('show_'+level).className = 'selectedChoice';
	
	currentHighScoreDisplay = level;
	
	selectedScore = eval(level + "HighScores");
	var i = 1;

	if (selectedScore) {
		for (i=1;i<=10 && i<=selectedScore.length;i++) {
			values = selectedScore[i-1].split('|');
			obj = document.getElementById('highScoreName'+i);
			obj.innerHTML = values[0];
			
			obj = document.getElementById('highScore'+i);
			obj.innerHTML = values[2];
			
			obj = document.getElementById('highScoreTime'+i);
			obj.innerHTML = secondsToMinutes(values[3] / 1000);
		}
	}
	
	for (;i<=10; i++) {
		obj = document.getElementById('highScoreName'+i);
		obj.innerHTML = '...';
		
		obj = document.getElementById('highScore'+i);
		obj.innerHTML = '...';
		
		obj = document.getElementById('highScoreTime'+i);
		obj.innerHTML = '...';
	}
}

function hideHighScores() {
	showHideElements('backHighScores','none');
	showHideElements('backNormal','block');
	showHideElements('highScoresBtn','block');
	showHideElements('newPuzzleBtn','block');
	showHideElements('solvePuzzleBtn','block');
	showHideElements('optionsBtn','none');
	showHideElements('doneBtn','block');
}

function calculateScore() {
	if (!puzzleComplete) { 
		score = score * 250 / (gameStoredTime/1000);
		if (scoreShowAutoScratches) {
			score = score / 50;
		}
		
		if (scoreShowIncorrectAnswers) {
			score = score / 2;
		}
		
		if (score < 0) score = 0;
	}
}

function sortHighScores(a,b) {
	var tmpArray;
	var tmp1, tmp2;

	tmpArray = a.split('|');
	if (tmpArray.length > 2) {
		tmp1 = tmpArray[2];
	}

	tmpArray = b.split('|');
	if (tmpArray.length > 2) {
		tmp2 = tmpArray[2];
	}

	return parseInt(tmp2) - parseInt(tmp1);
}

function addHighScores(theArray,strTemp) {
	var i;
	
	theArray[theArray.length] = strTemp;
	theArray.sort(sortHighScores);
	
	for (i=theArray.length; i > 10; i--) {
		theArray.pop();
	}
}

function setHighScores() {
	var strTemp;
	var tmpDifficulty = getSelectValue('difficulty').split(':')[0]

	strTemp = document.getElementById('name').value + '|';
	strTemp = strTemp + tmpDifficulty + '|';
	strTemp = strTemp + Math.round(score) + '|';
	strTemp = strTemp + gameStoredTime;

	if (tmpDifficulty >= DIABLO) {
		addHighScores(diabloHighScores,strTemp);
	} else if (tmpDifficulty >= HARD) {
		addHighScores(hardHighScores,strTemp);
	} else if (tmpDifficulty >= MED) {
		addHighScores(medHighScores,strTemp);
	} else {
		addHighScores(easyHighScores,strTemp);
	}	
}

function showCongrats() {
	stopAndUpdateTimer();
	calculateScore();

	if (!puzzleComplete) {
		// insert score into high scores
		setHighScores();	
	}
	
	puzzleComplete = true;
	lockPuzzle();
	
	// fade out the puzzle
	if (animationCongrats.timer != null) {
		clearInterval(animationCongrats.timer);
		animationCongrats.timer = null;
	}
	
	showHideElements('highlight','none');
	
	var starttime = (new Date).getTime() - 13;
	lockAnimation = true;
	animationCongrats.duration = 1500;
	animationCongrats.starttime = starttime;
	animationCongrats.firstElement = document.getElementById('selectableNumbers');
	animationCongrats.secondElement = null;
	animationCongrats.timer = setInterval('animateCongrats();',13);
	animationCongrats.from = 1.0;
	animationCongrats.to = 0.0;
	animateCongrats();
	setTimeout("showCongratsText();",1500);
}

function lockPuzzle() {
	var i;
	
	for (i=0; i<81; i++) {
		arrayFields[i] = Math.abs(arrayFields[i]);
	}
}

function updatePuzzleDisplay() {
	var i;
	var displayType = 'set';
	var elem , obj;

	showIncorrectAnswers = getCheckBoxValue('showIncorrectCheckBox');
	showAutoScratches = getCheckBoxValue('showAutoScratchesCheckBox');
	
	if (showAutoScratches) updateAutoScratches();
	
	// get number of empty's
	if (!computerSolved) {
		if (emptyFields() == 0) {
			if (checkSolution()) {
				// show congrats
				showCongrats();
			}
		}
	}
	
	for (i=0; i<arrayFields.length; i++) {
		if (arrayFields[i]) {
			if (arrayFields[i] < 0) {
				// check incorrect answers if desired
				
				if (solution[i] != Math.abs(arrayFields[i])) {
					if (showIncorrectAnswers && !enteringBlanks) {
						displayType = 'wrong';
					} else {
						displayType = 'right';
					}
				} else {
					displayType = 'right';
				}
			} else {
				displayType = 'set';
			}
			obj = document.getElementById('field_'+i);
			while (obj.firstChild) { obj.removeChild(obj.firstChild); }
			
			if (displayType != 'set') {
				elem = document.createElement('img');
				elem.setAttribute('src','images/puzzle_numbers/' + Math.abs(arrayFields[i]) + '_' + displayType + '.png');
				elem.setAttribute('width',22);
				elem.setAttribute('height',21);
				elem.setAttribute('id','number');
			
				obj.appendChild(elem);
			} else {
				obj.innerHTML = '<img src="images/puzzle_numbers/' + arrayFields[i] + '_set.png">';
			}
		} else {
			elem = document.getElementById('field_'+i);
			while (elem.firstChild) { elem.removeChild(elem.firstChild) }
			// check for scratches
			if (scratches[i] && !showAutoScratches) {
				//display scratches
				addSmallNumbers(elem, scratches[i], new Array());
			} else if (autoScratches[i] && showAutoScratches) {
				addSmallNumbers(elem, autoScratches[i], antiScratches[i]);
			}
		}
	}
	document.getElementById('keyInput').focus();
}

function createNewPuzzle() {
	generatePuzzle();

	
	var tmpDate = new Date();
	gameStartTime = tmpDate.getTime();
	gameTime = 0;
	gameStopTime = 0;
	gameStoredTime = 0;
	clockRotation = 0;
	computerSolved = false;
	currentCell = 0;
	lockAnimation = false;
	puzzleComplete = false;
	savePrefs();

	showHideElements('highScores','none');
	showHideElements('selectableNumbers','block');
	document.getElementById('selectableNumbers').style.opacity = 1.0;
	
	moveHighlight();
	
	hideBack();
}

function solvePuzzle() {
	var tmpString;
	var i;

	showHideElements('newPuzzleBtn,solvePuzzleBtn,doneBtn,highScoresBtn','none');
	
	document.getElementById('status').innerHTML = "Solving puzzle...please wait";
	showHideElements('status','block');
	
	if (solution[0] == 0) {
		tmpString = '';
		
		for (i=0; i<81; i++) {
			if (arrayFields[i]) {
				tmpString += Math.abs(arrayFields[i]);
			} else {
				tmpString += 0;
			}
		}
		if (window.widget) {
			var tmpSudoku = widget.system("./SudokuC -p " + tmpString, null).outputString;
		}
		
		if (tmpSudoku) {
			arrayFields = tmpSudoku.split(':');
		} else {
			document.getElementById('status').innerHTML = "Puzzle not solvable!";
			setTimeout("showHideElements('status','none');",1600);
			setTimeout("showHideElements('newPuzzleBtn,solvePuzzleBtn,doneBtn,highScoresBtn','block');",1600);
			setTimeout("hideBack();",1500);
			return false;
		}
	} else {
		for (i=0; i<81; i++) {
			arrayFields[i] = -solution[i];
		}
		puzzleComplete = true;
		computerSolved = true;
		lockPuzzle();
	}
	
	showHideElements('status','none');
	showHideElements('newPuzzleBtn,solvePuzzleBtn,doneBtn,highScoresBtn','block');
	
	updatePuzzleDisplay();
	hideBack();
}

function returnToPuzzle() {
	// restart the timer
	savePrefs();
	onFront = true;
	gameStartTimer();
	hideBack();
}

function createHTMLElements() {
	var i, elem;
	var theObj, theChild;
	var elem;
	var top, left;
	
	// create generic buttons
	if (window.widget) createGenericButton(document.getElementById('doneBtn'), 'Go Back', returnToPuzzle);
	if (window.widget) createGenericButton(document.getElementById('newPuzzleBtn'), 'New', createNewPuzzle);
	if (window.widget) createGenericButton(document.getElementById('solvePuzzleBtn'), 'Solve', solvePuzzle);
	if (window.widget) createGenericButton(document.getElementById('highScoresBtn'),'High Scores', showHighScores);
	if (window.widget) createGenericButton(document.getElementById('optionsBtn'),'Return to options', hideHighScores);
	
	// create all the selectable numbers 
	theObj = document.getElementById('selectableNumbers');
	for (i=1; i<=9; i++) {
		elem = document.createElement('img');
		elem.setAttribute('id','selectNum_' + i);
		elem.setAttribute('src','images/select_numbers/' + i + '_off.png');
		elem.setAttribute('width',24);
		elem.setAttribute('height',22);

		theObj.appendChild(elem);
		theChild = document.getElementById('selectNum_' + i);
		theChild.onmouseover = function() { 
			myId = this.id.substring(10,11);
			if (myId != selectedNum) {
				this.src = 'images/select_numbers/' + myId + '_on.png';
			}
		}
		theChild.onmouseout = function() {
			myId = this.id.substring(10,11);
			if (myId != selectedNum) {
				this.src = 'images/select_numbers/' + myId + '_off.png';
			}
		}
		theChild.onclick = function() {
			myId = this.id.substring(10,11);
			if (myId != selectedNum) {
				if (selectedNum) {
					tempObj = document.getElementById('selectNum_' + selectedNum);
					tempObj.src = 'images/select_numbers/' + selectedNum + '_off.png';
				}
				this.src = 'images/select_numbers/' + myId + '_sel.png';
				selectedNum = myId;
			}
			document.getElementById('keyInput').focus();
		}
	}

	// create the puzzle fields
	var theObj = document.getElementById('thePuzzle');
	for (i=0; i<81; i++) {
		elem = document.createElement('div');
		elem.style.position = 'absolute';
		top = Math.round(Math.floor(i/9) * 27.75) + 20;
		if (i / 9 >= 3) top+= 5;
		if (i / 9 >= 6) top+= 5;
		left = Math.round((i%9) * 28.4) + 20;
		if (i%9 > 2) left += 6;
		if (i%9 > 5) left += 6;
		elem.style.top = top + 'px';
		elem.style.left = left + 'px';
		elem.setAttribute('id','field_'+i);
		elem.style.width = 24;
		elem.style.height = 22;
		theObj.appendChild(elem);
		
		// modify the child to have the clickable properties
		document.getElementById('field_' + i).onclick = handleClick;
	}
}

function updateGameTimer() {
	var tmpDate = new Date();
	var tmpTime = tmpDate.getTime();

	var seconds = (tmpTime - gameStartTime)/1000 + gameStoredTime/1000;
	var minutes = Math.floor(seconds/60);
	
	// draw the clock here
	var canvas = document.getElementById("canvas");
    var context = canvas.getContext("2d");
	context.clearRect(0,0,30,30);
	context.globalAlpha = '.4';
	context.strokeStyle = '#FFFFFF';
	context.save();

	clockRotation += .105;
	context.translate(16,15.5);
	context.rotate(clockRotation);
	context.moveTo(0,0);
	context.lineTo(0,-10);
	context.stroke();
	
	context.restore();
	
	if (Math.floor(seconds/60) == seconds/60) {
		clockRotation = 0;
	}

	// end drawing of clock

	document.getElementById('clockDiv').innerHTML = Math.floor(seconds/60);
}

function gameStartTimer() {
	if (!enteringBlanks) {
		var tmpDate = new Date();
		gameStartTime = tmpDate.getTime();
		if (gameTimer) clearTimeout(gameTimer);
					
		gameTimer = setInterval("updateGameTimer()",1000);
		
	}
}

function stopAndUpdateTimer() {
	if (!enteringBlanks && !puzzleComplete && document.getElementById('front').style.display != 'none') {
		var tmpDate = new Date();
		gameStopTime = tmpDate.getTime();
		if (gameStartTime) gameStoredTime += gameStopTime - gameStartTime;
			
		clearTimeout(gameTimer);
	}
}

function setup() {	
	var tempPref, tmpScratches;

	// set up buttons, fields, etc...
	createHTMLElements();

	// check for prefs
	getPrefs();
	
	if (window.widget) {
		widget.onhide = function () {
			stopAndUpdateTimer();
			savePrefs();
		}
		widget.onshow = function () { if (!puzzleComplete) gameStartTimer(); }
		widget.onremove = function () { clearPrefs(); }
	}
	
	if (arrayFields.length != 81 || solution.length != 81) {
		generatePuzzle();
	}
	
	document.getElementById("front").onclick = function () { document.getElementById('keyInput').focus(); }
	document.getElementById("keyInput").onkeypress = handleKey;
	
	updatePuzzleDisplay();
	
	document.getElementById('keyInput').focus();
	
	if (gameTimer) clearTimeout(gameTimer);
	gameStartTimer();
}

function clearPrefs() {
	widget.setPreferenceForKey(versionNumber,'version');
	widget.setPreferenceForKey(null,'solution');
	widget.setPreferenceForKey(null,'scratches');
	widget.setPreferenceForKey(null,'antiScratches');
	widget.setPreferenceForKey(null,'difficulty');
	widget.setPreferenceForKey(null,'dontShowIncorrectAnswers');
	widget.setPreferenceForKey(null,'dontShowAutoScratches');
	widget.setPreferenceForKey(null,'gameStoredTime');
	widget.setPreferenceForKey(null,'currentScore');
	widget.setPreferenceForKey(null,'puzzleComplete');
	widget.setPreferenceForKey(null,'computerSolved');
	widget.setPreferenceForKey(null,'diabloHighScores');
	widget.setPreferenceForKey(null,'hardHighScores');
	widget.setPreferenceForKey(null,'medHighScores');
	widget.setPreferenceForKey(null,'easyHighScores');
	widget.setPreferenceForKey(null,'dontDoOnlyPencilMarks');
	widget.setPreferenceForKey(null,'name');
}

function savePrefs() {
	var i,j;
	var tmpArrayFields = '';
	var tmpSolution = '';
	var tmpPref;
	var tmpDifficulty;
	var tmpScratches = '';
	var tmpAntiScratches = '';
	
		// set up the preferences
	for (i=0;i<81;i++) {
		if (arrayFields[i]) tmpArrayFields += arrayFields[i];
		if (solution[i]) tmpSolution += solution[i];
		if (scratches[i].length) {
			tmpScratches += i + '|';
			for (j=0; j<scratches[i].length; j++) {
				tmpScratches += scratches[i][j];

				if (j != (scratches[i].length-1)) tmpScratches += ',';
			}
		}
		if (antiScratches[i].length) {
			tmpAntiScratches += i + '|';
			for (j=0; j<antiScratches[i].length; j++) {
				tmpAntiScratches += antiScratches[i][j];

				if (j != (antiScratches[i].length-1)) tmpAntiScratches += ',';
			}
		}
		
		if (i != 80) {
			tmpArrayFields += ':';
			tmpSolution += ':';
			tmpScratches += ':';
			tmpAntiScratches += ':';
		}
	}
	
	// set the prefs
	if (window.widget) {
		widget.setPreferenceForKey(tmpArrayFields,'arrayFields');
		widget.setPreferenceForKey(tmpSolution,'solution');
		widget.setPreferenceForKey(tmpScratches,'scratches');
		widget.setPreferenceForKey(tmpAntiScratches,'antiScratches')
		
		tmpPref = document.getElementById('difficulty').selectedIndex;
		widget.setPreferenceForKey(tmpPref,'difficulty');
		
		tmpPref = getCheckBoxValue('showIncorrectCheckBox');
		widget.setPreferenceForKey(!tmpPref,'dontShowIncorrectAnswers');

		widget.setPreferenceForKey(!onlyPencilMarks,'dontDoOnlyPencilMarks');
		
		tmpPref = getCheckBoxValue('showAutoScratchesCheckBox');
		widget.setPreferenceForKey(!tmpPref,'dontShowAutoScratches');
		
		widget.setPreferenceForKey(gameStoredTime,'gameStoredTime');
		widget.setPreferenceForKey(score,'currentScore');

		widget.setPreferenceForKey(puzzleComplete,'puzzleComplete');
		widget.setPreferenceForKey(computerSolved,'computerSolved');
		
		widget.setPreferenceForKey(convertArrayToString(diabloHighScores.sort(sortHighScores)),'diabloHighScores');
		widget.setPreferenceForKey(convertArrayToString(hardHighScores.sort(sortHighScores)),'hardHighScores');
		widget.setPreferenceForKey(convertArrayToString(medHighScores.sort(sortHighScores)),'medHighScores');
		widget.setPreferenceForKey(convertArrayToString(easyHighScores.sort(sortHighScores)),'easyHighScores');

		widget.setPreferenceForKey(document.getElementById('name').value,'name');
	}
}

function getPrefs() {
	var tmpPref;
	var i;
	var tmpScratches;
	var tmpValue;
	
	if (window.widget) {
		// version
		// clear out the prefs if this is a different version
		tmpPref = widget.preferenceForKey('version');
		if (tmpPref != versionNumber) {
			clearPrefs();
		} else {
			// arrayFields
			tmpPref = widget.preferenceForKey('arrayFields');
			if (tmpPref && tmpPref.length > 0) {
				arrayFields = tmpPref.split(':');
			}

			// solution
			tmpPref = widget.preferenceForKey('solution');
			if (tmpPref && tmpPref.length > 0) {
				solution = tmpPref.split(':');
			}

			// scratches
			tmpPref = widget.preferenceForKey('scratches');
			if (tmpPref && tmpPref.length > 0) {
				tmpPref = tmpPref.split(':');
				for (i=0; i<tmpPref.length; i++) {
					tmpScratches = tmpPref[i].split('|');
					if (tmpScratches.length == 2) scratches[tmpScratches[0]] = tmpScratches[1].split(',');
				}
			}

			// antiscratches
			tmpPref = widget.preferenceForKey('antiScratches');
			if (tmpPref && tmpPref.length > 0) {
				tmpPref = tmpPref.split(':');
				for (i=0; i<tmpPref.length; i++) {
					tmpAntiScratches = tmpPref[i].split('|');
					if (tmpAntiScratches.length == 2) antiScratches[tmpAntiScratches[0]] = tmpAntiScratches[1].split(',');
				}
			}
			
			// level of difficulty
			tmpPref = widget.preferenceForKey('difficulty');
			if (tmpPref) {
				tmpValue = tmpPref;
				if (tmpValue >= 0 && tmpValue < 5) {
					// set the index
					document.getElementById('difficulty').selectedIndex = tmpValue;
				}
			}

			// show incorrect answers
			tmpPref = widget.preferenceForKey('dontShowIncorrectAnswers');
			showIncorrectAnswers = true;
			if (tmpPref || tmpPref == null) {
				showIncorrectAnswers = false;
			}
			elem = document.getElementById('showIncorrectCheckBox');
			if (showIncorrectAnswers) elem.checked = true; else elem.checked = false;
			
			// show auto scratches
			tmpPref = widget.preferenceForKey('dontShowAutoScratches');
			showAutoScratches = true;
			if (tmpPref || tmpPref == null) {
				showAutoScratches = false;
			}
			elem = document.getElementById('showAutoScratchesCheckBox');
			if (showAutoScratches) elem.checked = true; else elem.checked = false;
			
			// only pencil marks status
			tmpPref = widget.preferenceForKey('dontDoOnlyPencilMarks');
			onlyPencilMarks = true;
			if (tmpPref || tmpPref == null) {
				onlyPencilMarks = false;
			}
			
			// set the highlight to the correct color
			obj = document.getElementById('highlight');
			if (onlyPencilMarks) {
				obj.firstChild.src = "images/highlight_cell_pencil.png";
			} else {
				obj.firstChild.src = "images/highlight_cell.png";
			}
			
			// update timer
			tmpPref = widget.preferenceForKey('gameStoredTime');
			if (tmpPref) {
				gameStoredTime = tmpPref;
				// update clock rotation
				clockRotation = ((gameStoredTime / 1000) % 60) * .105;
			}

			// get the current score 
			tmpPref = widget.preferenceForKey('currentScore');
			if (tmpPref) {
				score = tmpPref;
			}

			// get puzzle complete
			tmpPref = widget.preferenceForKey('puzzleComplete');
			if (tmpPref) {
				puzzleComplete = true;
			}

			// get computer solved
			tmpPref = widget.preferenceForKey('computerSolved');
			if (tmpPref) {
				computerSolved = true;
			}

			// get name
			tmpPref = widget.preferenceForKey('name');
			if (tmpPref) {
				document.getElementById('name').value = tmpPref;
			}

			// high scores
			tmpPref = widget.preferenceForKey('diabloHighScores');
			if (tmpPref) {
				diabloHighScores = tmpPref.split(':');
			}
			tmpPref = widget.preferenceForKey('hardHighScores');
			if (tmpPref) {
				hardHighScores = tmpPref.split(':');
			}
			tmpPref = widget.preferenceForKey('medHighScores');
			if (tmpPref) {
				medHighScores = tmpPref.split(':');
			}
			tmpPref = widget.preferenceForKey('easyHighScores');
			if (tmpPref) {
				easyHighScores = tmpPref.split(':');
			}
		}
	}
}

function handleClick(evt) {
	var rightOrWrong;
	var index;
	var i;

	var elem = evt.target;
	if (!elem.id) elem = elem.parentNode;

	if (elem.id) {
		if (elem.id == "number" || elem.id == 'scratch') {
			// we hit a number field
			elem = elem.parentNode;
		}

		myId = elem.id.substring(6,8);
		currentCell = parseInt(myId);

		if (selectedNum) {
			if (arrayFields[myId] <= 0 || !arrayFields[myId]) {
				if (!evt.shiftKey && !onlyPencilMarks) {
					if (arrayFields[myId] == -(selectedNum)) {
						arrayFields[myId] = 0;
					} else {
						arrayFields[myId] = -(selectedNum);
						rightOrWrong = 'right';
						if (Math.abs(selectedNum) != solution[myId]) {
							if (showIncorrectAnswers) {
								rightOrWrong = 'wrong';
							}
							score = score - 50;
						}
					}
				} else if (!showAutoScratches) {
					arrayFields[myId] = 0;

					// add small scratches
					// check that the number isn't already there
					index = valueExistsInArray(selectedNum,scratches[myId])
					if (index < 0) {
						if (scratches[myId].length < 6) scratches[myId][scratches[myId].length] = selectedNum;
					} else {
						scratches[myId].splice(index,1);
					}
				} else if (showAutoScratches) {
					// add anti scratches
					// check that the number isn't already there
					index = valueExistsInArray(selectedNum,antiScratches[myId])
					if (index < 0) {
						antiScratches[myId][antiScratches[myId].length] = selectedNum;
					} else {
						antiScratches[myId].splice(index,1);
					}
				}
			}
		}
	}
	moveHighlight();
	updatePuzzleDisplay();
}

function addBigNumber(obj, number, rightOrWrong) {
	if (obj.firstChild) obj.removeChild(obj.firstChild);
	
	// add the number
	elem = document.createElement('img');
	elem.setAttribute('src','images/puzzle_numbers/' + number + '_' + rightOrWrong + '.png');
	elem.setAttribute('width',22);
	elem.setAttribute('height',21);
	elem.setAttribute('id','number');
	elem.onclick = handleClick;

	obj.appendChild(elem);
}

function addSmallNumbers(obj, numbersArray, antiNumbers) {
	var i;
	numbersArray.sort();
	var index;
	
	if (obj.firstChild) obj.removeChild(obj.firstChild);

	var theStr = '';
	for (i=0; i<numbersArray.length; i++) {
		if (numbersArray) {
			index = valueExistsInArray(numbersArray[i],antiNumbers);
		} else {
			index = -1;
		}
		
		if (index < 0) {
			theStr += numbersArray[i];
		} else {
			theStr = theStr + '<span style="text-decoration: line-through;">' + numbersArray[i] + '</span>';
		}
		if (i != numbersArray.length-1) theStr += ' ';
	}
	
	obj.innerHTML = '<span id="scratch">'+theStr+'</span>';
	
	//obj.appendChild(elem);
}

function moveHighlight() {
	var top, left;
	var obj = document.getElementById('highlight');
	
	top = Math.round(Math.floor(currentCell/9) * 27.75) + 15;
	if (currentCell / 9 >= 3) top+= 5;
	if (currentCell / 9 >= 6) top+= 4;
	left = Math.round((currentCell%9) * 28.4) + 16;
	if (currentCell%9 > 2) left += 6;
	if (currentCell%9 > 5) left += 6;

	obj.style.left = left;
	obj.style.top = top;
}
	
function handleKey(evt) {
	var keyHitNum;
	var count;
	var newCell;
	var needToUpdateDisplay = false;
	var rowstart, colstart;

	var i, tmpStr;
	
	evt = (evt) ? evt : ((window.event) ? event : null);
	
	if (evt) {
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem) {
			var charCode = (evt.charCode) ? evt.charCode : ((evt.which) ? evt.which : evt.keyCode);
			
			if (charCode > 48 && charCode < 58) {
				// hit 1 through 9
				keyHitNum = charCode - 48;
				if (keyHitNum != selectedNum) {
					if (selectedNum) document.getElementById('selectNum_' + selectedNum).src = 'images/select_numbers/' + selectedNum + '_off.png';
					document.getElementById('selectNum_' + keyHitNum).src = 'images/select_numbers/' + keyHitNum + '_sel.png';

					selectedNum = keyHitNum;
				}
			} else if (charCode >= 63232 && charCode <= 63235) {
				// arrow keys
				if (!keyboardLock) {
					count = 0;
					rowstart = Math.floor(currentCell/9)*9;
					rowend = rowstart + 8;
					colstart = currentCell%9;
					colend = colstart + 72;
		
					if (charCode == 63234) {
						currentCell -= 1;	//left
						if (currentCell < rowstart) currentCell = rowend;
					}
					if (charCode == 63232) {
						currentCell -= 9;	//up
						if (currentCell < colstart) currentCell = colend;
					}
					if (charCode == 63235) {
						currentCell += 1;	//right
						if (currentCell > rowend) currentCell = rowstart;
					}
					if (charCode == 63233) {
						currentCell += 9;	//down
						if (currentCell > colend) currentCell = colstart;
					}
					keyboardLock = true;
					moveHighlight();
				} else keyboardLock = false;
			} else if (charCode == 9) {
				// tab key
				// go to next clear field
				count = 0;
				do {
					currentCell += 1;
					count++;
					if (currentCell > 80) currentCell = 0;
					if (currentCell < 0) currentCell = 80;
				} while (arrayFields[currentCell] > 0 && count < 81);
				moveHighlight();
			} else if (charCode == 25) {
				// shift tab key
				// go to previous clear field
				count = 0;
				do {
					currentCell -= 1;
					count++;
					if (currentCell > 80) currentCell = 0;
					if (currentCell < 0) currentCell = 80;
				} while (arrayFields[currentCell] > 0 && count < 81);
				moveHighlight();
			} else if (charCode == 8) {
				//delete key
				if (!evt.shiftKey && !evt.ctrlKey) {
					if (arrayFields[currentCell] <= 0) {
						arrayFields[currentCell] = 0;
						scratches[currentCell] = new Array();
						antiScratches[currentCell] = new Array();
					}
				} else if (evt.shiftKey) {
					scratches = new Array(81);
					antiScratches = new Array(81);
					for (i=0;i<81;i++) scratches[i] = new Array();
					for (i=0;i<81;i++) antiScratches[i] = new Array();
				} else {
					for (i=0;i<81;i++) {
						if (arrayFields[i] <= 0) arrayFields[i] = 0;
					}
					scratches = new Array(81);
					antiScratches = new Array(81);
					for (i=0;i<81;i++) scratches[i] = new Array();
					for (i=0;i<81;i++) antiScratches[i] = new Array();
				}
				needToUpdateDisplay = true;
			} else if (charCode == 32 && selectedNum && (!evt.shiftKey && !onlyPencilMarks)) {
				// add a big number
				if (arrayFields[currentCell] <= 0) {
					if (arrayFields[currentCell] != -selectedNum) {
						arrayFields[currentCell] = -selectedNum;
						// check if this is an incorrect answer and 
						// subtract from the score if needed
						if (solution[currentCell] != Math.abs(arrayFields[currentCell])) {
							score = score - 50;
						}
					} else {
						arrayFields[currentCell] = 0;
					}
				}
				needToUpdateDisplay = true;
			} else if (charCode == 32 && selectedNum && (evt.shiftKey || onlyPencilMarks)) {
				// add a small number
				if (!showAutoScratches && arrayFields[currentCell] <= 0) {
					arrayFields[currentCell] = 0;
					
					// add small scratches
					// check that the number isn't already there
					var index = valueExistsInArray(selectedNum,scratches[currentCell])
					if (index < 0) {
						if (scratches[currentCell].length < 6) scratches[currentCell][scratches[currentCell].length] = selectedNum;
					} else {
						scratches[currentCell].splice(index,1);
					}
				} else if (showAutoScratches && arrayFields[currentCell] == 0) {
					
					// add small scratches
					// check that the number isn't already there
					var index = valueExistsInArray(selectedNum,antiScratches[currentCell])
					if (index < 0) {
						antiScratches[currentCell][antiScratches[currentCell].length] = selectedNum;
					} else {
						antiScratches[currentCell].splice(index,1);
					}
				}
				needToUpdateDisplay = true;
			} else if (charCode == 97) {
				// assist only this cell
				if (!showAutoScratches && arrayFields[currentCell] <= 0) {
					updateAutoScratches();
					
					arrayFields[currentCell] = 0;
					
					scratches[currentCell] = new Array();
					for (i=0; i<autoScratches[currentCell].length; i++) {
						scratches[currentCell][i] = autoScratches[currentCell][i];
					}

					if (!scoreShowAutoScratches) {
						score = score / (1 + (1000/score));
					}
					needToUpdateDisplay = true;
				}
			} else if (charCode == 65) {
				// assist all cells
				// just insert the auto numbers in any fields that doesnt have them
				if (!showAutoScratches) {
					updateAutoScratches();

					for (j=0; j<arrayFields.length; j++) {
						if (arrayFields[j] <= 0 && !scratches[j].length) {
							scratches[j] = new Array();
							scratches[j] = autoScratches[j];
						}
					}
					scoreShowAutoScratches = true;
					needToUpdateDisplay = true;
				}
			} else if (charCode == 229) {
				// Mega-Assist locked
				// ie. show and constantly update Auto numbers
				showAutoScratches = !showAutoScratches;

				if (!scoreShowAutoScratches) {
					scoreShowAutoScratches = true;
				}
				
				if (showAutoScratches) updateAutoScratches();
				setCheckBoxValue('showAutoScratchesCheckBox',showAutoScratches);
				savePrefs();
				needToUpdateDisplay = true;
			} else if (charCode == 104 || charCode == 72) {
				// incorrect
				showIncorrectAnswers = !showIncorrectAnswers;

				if (!scoreShowIncorrectAnswers) {
					scoreShowIncorrectAnswers = true;
				}
									
				setCheckBoxValue('showIncorrectCheckBox',showIncorrectAnswers);
				savePrefs();
				needToUpdateDisplay = true;
			} else if (charCode == 108 || charCode == 76) {
				// check that we are doing blank puzzle
				// letter L for LOCK
				if (getSelectValue('difficulty') == -1) {
					lockPuzzle();
					enteringBlanks = false;
					gameStartTimer();
					needToUpdateDisplay = true;
				}
			} else if (charCode == 122) {
				// comment this out later
				/*tmpStr = '';
				for (i=0;i<81;i++) {
					tmpStr += Math.abs(arrayFields[i]);
				}
				alert(tmpStr);*/
			} else if (charCode == 112 || charCode == 80) {
				onlyPencilMarks = !onlyPencilMarks;
				obj = document.getElementById('highlight');
				if (onlyPencilMarks) {
					obj.firstChild.src = "images/highlight_cell_pencil.png";
				} else {
					obj.firstChild.src = "images/highlight_cell.png";
				}
			} else {
				// do nothing
				//alert("Character code: " + charCode);
			}
		}
	}
	document.getElementById('keyInput').value = " ";
	if (needToUpdateDisplay) { updatePuzzleDisplay(); }
}

function animateCongrats() {
	var T;
	var ease;
	var time = (new Date).getTime();
	
	T = limit_3(time-animationCongrats.starttime, 0, animationCongrats.duration);
	if (T >= animationCongrats.duration) {
		clearInterval(animationCongrats.timer);
		animationCongrats.timer = null;
		animationCongrats.now = animationCongrats.to;
	} else {
		ease = 0.5 - (0.5*Math.cos(Math.PI * T / animationCongrats.duration));
		animationCongrats.now = computeNextFloat(animationCongrats.from, animationCongrats.to, ease);
	}
	
	animationCongrats.firstElement.style.opacity = animationCongrats.now;
	if (animationCongrats.secondElement) {
		animationCongrats.secondElement.style.opacity = animationCongrats.now;
	}
}

function secondsToMinutes(seconds) {
	var minutes = Math.floor(seconds/60);
	var extraZero = "";
	
	seconds = Math.floor(seconds - minutes*60);
	if (seconds < 10) extraZero = "0";
	
	return minutes + ":" + extraZero + seconds;
}

function showInstructions() {
	showHideElements('instructions','block');
	showHideElements('keyCommands','none');
	document.getElementById('instructionsLink').className = 'selectedChoice';
	document.getElementById('keyCommandsLink').className = '';
}

function showKeyCommands() {
	showHideElements('instructions','none');
	showHideElements('keyCommands','block');
	document.getElementById('instructionsLink').className = '';
	document.getElementById('keyCommandsLink').className = 'selectedChoice';
}
