/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2017 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/
#include "../../SDL_internal.h"

#ifndef SDL_cocoavideo_h_
#define SDL_cocoavideo_h_

#include "SDL_opengl.h"

#if defined(__ALTIVEC__) && !defined(MAC_OS_X_VERSION_10_5)
/* to cricumvent a bug in Mac OS X 10.4 SDK */
#define vector __vector
#include <CoreServices/CoreServices.h>
#undef vector
#endif
#include <ApplicationServices/ApplicationServices.h>
#include <IOKit/pwr_mgt/IOPMLib.h>
#include <Cocoa/Cocoa.h>

#include "SDL_keycode.h"
#include "../SDL_sysvideo.h"

#include "SDL_cocoaclipboard.h"
#include "SDL_cocoaevents.h"
#include "SDL_cocoakeyboard.h"
#include "SDL_cocoamodes.h"
#include "SDL_cocoamouse.h"
#include "SDL_cocoaopengl.h"
#include "SDL_cocoawindow.h"

#if !defined(MAC_OS_X_VERSION_10_5)
typedef long int NSInteger;
typedef unsigned int NSUInteger;
#endif

#ifndef MAC_OS_X_VERSION_10_12
#define DECLARE_EVENT(name) static const NSEventType NSEventType##name = NS##name
DECLARE_EVENT(LeftMouseDown);
DECLARE_EVENT(LeftMouseUp);
DECLARE_EVENT(RightMouseDown);
DECLARE_EVENT(RightMouseUp);
DECLARE_EVENT(OtherMouseDown);
DECLARE_EVENT(OtherMouseUp);
DECLARE_EVENT(MouseMoved);
DECLARE_EVENT(LeftMouseDragged);
DECLARE_EVENT(RightMouseDragged);
DECLARE_EVENT(OtherMouseDragged);
DECLARE_EVENT(ScrollWheel);
DECLARE_EVENT(KeyDown);
DECLARE_EVENT(KeyUp);
DECLARE_EVENT(FlagsChanged);
#undef DECLARE_EVENT

#if MAC_OS_X_VERSION_MIN_REQUIRED >= 1060
static const NSEventMask NSEventMaskAny = NSAnyEventMask;
#endif

#define DECLARE_MODIFIER_FLAG(name) static const NSUInteger NSEventModifierFlag##name = NS##name##KeyMask
DECLARE_MODIFIER_FLAG(Shift);
DECLARE_MODIFIER_FLAG(Control);
DECLARE_MODIFIER_FLAG(Command);
DECLARE_MODIFIER_FLAG(NumericPad);
DECLARE_MODIFIER_FLAG(Help);
DECLARE_MODIFIER_FLAG(Function);
#undef DECLARE_MODIFIER_FLAG
static const NSUInteger NSEventModifierFlagCapsLock = NSAlphaShiftKeyMask;
static const NSUInteger NSEventModifierFlagOption = NSAlternateKeyMask;

#define DECLARE_WINDOW_MASK(name) static const unsigned int NSWindowStyleMask##name = NS##name##WindowMask
DECLARE_WINDOW_MASK(Borderless);
DECLARE_WINDOW_MASK(Titled);
DECLARE_WINDOW_MASK(Closable);
DECLARE_WINDOW_MASK(Miniaturizable);
DECLARE_WINDOW_MASK(Resizable);
DECLARE_WINDOW_MASK(TexturedBackground);
DECLARE_WINDOW_MASK(UnifiedTitleAndToolbar);
#if MAC_OS_X_VERSION_MIN_REQUIRED >= 1060
DECLARE_WINDOW_MASK(FullScreen);
#endif
/*DECLARE_WINDOW_MASK(FullSizeContentView);*/ /* Not used, fails compile on older SDKs */
static const unsigned int NSWindowStyleMaskUtilityWindow = NSUtilityWindowMask;
static const unsigned int NSWindowStyleMaskDocModalWindow = NSDocModalWindowMask;
#if defined(MAC_OS_X_VERSION_10_5)
static const unsigned int NSWindowStyleMaskHUDWindow = NSHUDWindowMask;
#endif
#undef DECLARE_WINDOW_MASK

#define DECLARE_ALERT_STYLE(name) static const NSUInteger NSAlertStyle##name = NS##name##AlertStyle
DECLARE_ALERT_STYLE(Warning);
DECLARE_ALERT_STYLE(Informational);
DECLARE_ALERT_STYLE(Critical);
#undef DECLARE_ALERT_STYLE
#endif

/* Private display data */

@class SDLTranslatorResponder;

typedef struct SDL_VideoData
{
    int allow_spaces;
    unsigned int modifierFlags;
    void *key_layout;
    SDLTranslatorResponder *fieldEdit;
    NSInteger clipboard_count;
    Uint32 screensaver_activity;
    BOOL screensaver_use_iopm;
#if defined(MAC_OS_X_VERSION_10_5)
    IOPMAssertionID screensaver_assertion;
#endif

} SDL_VideoData;

/* Utility functions */
extern NSImage * Cocoa_CreateImage(SDL_Surface * surface);

#endif /* SDL_cocoavideo_h_ */

/* vi: set ts=4 sw=4 expandtab: */
