/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.progress;

import com.installshield.util.GenericProgress;
import com.installshield.util.ImageUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.util.Progress;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ComponentUtils;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.SwingProgressRendererImpl;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.progress.BillboardProgressRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class BillboardProgressRendererSwingImpl
extends SwingProgressRendererImpl
implements ActionListener,
Runnable,
WindowListener {
    private JPanel center = null;
    private JLabel imgPane = null;
    private int imgCount = 0;
    private int curImage = -1;
    private JLabel status = null;
    private JLabel detail = null;
    private JProgressBar progress = null;
    private int displayMode = -1;
    private JFrame fullScreen = null;
    static /* synthetic */ Class class$java$awt$Toolkit;

    public void actionPerformed(ActionEvent actionEvent) {
        ((SwingWizardUI)this.getWizard().getUI()).doCancel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void endProgress() {
        if (this.displayMode == 2) {
            new Thread(this).start();
        }
    }

    public void initialize() {
        Serializable serializable;
        if (!(this.getProgressRenderer() instanceof BillboardProgressRenderer)) {
            throw new IllegalStateException();
        }
        BillboardProgressRenderer billboardProgressRenderer = (BillboardProgressRenderer)this.getProgressRenderer();
        this.imgCount = ((BillboardProgressRenderer)this.getProgressRenderer()).getImages().length;
        this.displayMode = billboardProgressRenderer.getDisplayMode();
        this.setLayout(new BorderLayout());
        if (this.displayMode == 2) {
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
            this.setBackground(PropertyUtils.createColor(billboardProgressRenderer.getFullScreenBackground(), this.getBackground()));
        }
        this.center = new JPanel();
        this.center.setLayout(new ColumnLayout());
        if (billboardProgressRenderer.isImageBorderVisible()) {
            serializable = new JScrollPane(this.center, 21, 31);
            this.add((Component)serializable, "Center");
        } else {
            this.add((Component)this.center, "Center");
        }
        serializable = PropertyUtils.createColor(billboardProgressRenderer.getImageBackground(), null);
        if (serializable != null) {
            this.center.setBackground((Color)serializable);
        }
        this.imgPane = new JLabel();
        if (billboardProgressRenderer.getImageVAlign() == 2 || billboardProgressRenderer.getImageVAlign() == 3) {
            this.center.add(Spacing.createVerticalSpacing(0), ColumnConstraints.createVerticalFill());
        }
        if (billboardProgressRenderer.getImageHAlign() == 1) {
            this.center.add((Component)this.imgPane, ColumnConstraints.createLeftAlign());
        } else if (billboardProgressRenderer.getImageHAlign() == 2) {
            this.center.add((Component)this.imgPane, ColumnConstraints.createCenterAlign());
        } else {
            this.center.add((Component)this.imgPane, ColumnConstraints.createRightAlign());
        }
        if (billboardProgressRenderer.getImageVAlign() == 1 || billboardProgressRenderer.getImageVAlign() == 2) {
            this.center.add(Spacing.createVerticalSpacing(0), ColumnConstraints.createVerticalFill());
        }
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        jPanel.setLayout(new ColumnLayout());
        jPanel.setVisible(billboardProgressRenderer.isStatusVisible() || billboardProgressRenderer.isProgressVisible());
        this.status = new JLabel(" ", 2);
        jPanel.add((Component)this.status, ColumnConstraints.createHorizontalFill());
        this.status.setVisible(billboardProgressRenderer.isStatusVisible());
        this.detail = new JLabel(" ", 2);
        jPanel.add((Component)this.detail, ColumnConstraints.createHorizontalFill());
        this.detail.setVisible(billboardProgressRenderer.isDetailVisible());
        if (this.status.isVisible() || this.detail.isVisible()) {
            jPanel.add(Spacing.createVerticalSpacing(4));
        }
        this.progress = new JProgressBar();
        jPanel.add((Component)this.progress, ColumnConstraints.createHorizontalFill());
        this.progress.setVisible(billboardProgressRenderer.isProgressVisible());
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setStringPainted(true);
        if (this.displayMode == 2) {
            jPanel.add(Spacing.createVerticalSpacing(6));
            JButton jButton = new JButton();
            MnemonicString mnemonicString = new MnemonicString(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancelWithMn"));
            jButton.setText(ComponentUtils.padButtonCaption(mnemonicString.toString()));
            if (mnemonicString.isMnemonicSpecified()) {
                jButton.setMnemonic(mnemonicString.getMnemonicChar());
            }
            jPanel.add((Component)jButton, ColumnConstraints.createCenterAlign());
            jPanel.add(Spacing.createVerticalSpacing(4));
            jButton.addActionListener(this);
        }
    }

    private void maximizeFrame(JFrame jFrame) {
        Object object;
        Insets insets = new Insets(0, 0, 0, 0);
        try {
            object = jFrame.getClass().getMethod("getGraphicsConfiguration", null);
            Object object2 = ((Method)object).invoke((Object)jFrame, null);
            Class<?> clazz = Class.forName("java.awt.GraphicsConfiguration");
            Method method = (class$java$awt$Toolkit != null ? class$java$awt$Toolkit : (class$java$awt$Toolkit = BillboardProgressRendererSwingImpl.class$("java.awt.Toolkit"))).getMethod("getScreenInsets", clazz);
            insets = (Insets)method.invoke((Object)Toolkit.getDefaultToolkit(), object2);
        }
        catch (Throwable throwable) {}
        object = Toolkit.getDefaultToolkit().getScreenSize();
        ((Dimension)object).width -= insets.left + insets.right;
        ((Dimension)object).height -= insets.top + insets.bottom;
        ((Component)jFrame).setSize((Dimension)object);
        ((Component)jFrame).setLocation(insets.left, insets.top);
    }

    public void run() {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            throw new Error();
        }
        this.fullScreen.removeAll();
        this.fullScreen.dispose();
        ((Component)((SwingWizardUI)this.getWizard().getUI()).getFrame()).setVisible(true);
    }

    public void startProgress() {
        if (this.displayMode == 2) {
            Frame frame = ((SwingWizardUI)this.getWizard().getUI()).getFrame();
            this.fullScreen = new JFrame(frame.getTitle());
            this.fullScreen.setDefaultCloseOperation(0);
            this.fullScreen.addWindowListener(this);
            ((Frame)this.fullScreen).setIconImage(frame.getIconImage());
            this.fullScreen.getContentPane().setLayout(new BorderLayout());
            this.fullScreen.getContentPane().add((Component)this, "Center");
            this.maximizeFrame(this.fullScreen);
            ((Component)this.fullScreen).setVisible(true);
        }
    }

    public void starting() {
        GenericProgress genericProgress = new GenericProgress();
        genericProgress.setPercentComplete(0);
        this.updateProgress(genericProgress);
        if (this.displayMode == 2) {
            ((Component)((SwingWizardUI)this.getWizard().getUI()).getFrame()).setVisible(false);
        }
    }

    public void updateProgress(Progress progress) {
        int n;
        String string;
        if (this.status.isVisible()) {
            string = progress.getStatusDescription();
            if (!this.status.getText().equals(string)) {
                if (string.length() > 0) {
                    this.status.setText(string);
                } else {
                    this.status.setText(" ");
                }
            }
        }
        if (this.detail.isVisible()) {
            string = ComponentUtils.spliceFileName(progress.getStatusDetail(), this.detail);
            if (!this.detail.getText().equals(string)) {
                if (string.length() > 0) {
                    this.detail.setText(string);
                } else {
                    this.detail.setText(" ");
                }
            }
        }
        if ((n = (int)Math.floor((double)(this.imgCount * progress.getPercentComplete()) / 100.0)) != this.curImage && n >= 0 && n < this.imgCount) {
            block14: {
                this.curImage = n;
                BillboardProgressRenderer billboardProgressRenderer = (BillboardProgressRenderer)this.getProgressRenderer();
                try {
                    URL uRL = billboardProgressRenderer.getImageResource(this.curImage);
                    if (uRL != null) {
                        Image image = ImageUtils.loadImage((Component)this, uRL);
                        this.imgPane.setIcon(new ImageIcon(image));
                        this.center.validate();
                    }
                }
                catch (IOException iOException) {
                    this.logEvent(this, "err", iOException);
                }
                catch (InterruptedException interruptedException) {
                    if (System.getProperty("is.debug") == null) break block14;
                    interruptedException.printStackTrace();
                }
            }
            if (!this.imgPane.isVisible()) {
                this.imgPane.setVisible(true);
            }
        }
        this.progress.setValue(progress.getPercentComplete());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

