/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.progress;

import com.installshield.util.LocaleUtils;
import com.installshield.wizard.ProgressRenderer;
import com.installshield.wizard.WizardBuilderSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

public class BillboardProgressRenderer
extends ProgressRenderer {
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_MIDDLE = 2;
    public static final int ALIGN_BOTTOM = 3;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int MODE_PANEL = 1;
    public static final int MODE_FULLSCREEN = 2;
    private String[] images = new String[0];
    private int halign = 2;
    private int valign = 2;
    private String imageBackground = "";
    private String fullScreenBackground = "";
    private boolean imageBorderVisible = true;
    private boolean progressVisible = true;
    private boolean statusVisible = true;
    private boolean detailVisible = true;
    private int displayMode = 1;
    private boolean includeLocalizedImages = false;
    static /* synthetic */ Class class$com$installshield$wizardx$progress$BillboardProgressRendererAWTImpl;
    static /* synthetic */ Class class$com$installshield$wizardx$progress$BillboardProgressRendererSwingImpl;
    static /* synthetic */ Class class$com$installshield$wizardx$progress$StandardProgressRendererConsoleImpl;
    static /* synthetic */ Class class$com$installshield$wizard$console$DefaultProgressRendererConsoleImpl;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        int n = 0;
        while (n < this.images.length) {
            block7: {
                try {
                    String string = this.getImageKey(n);
                    File file = new File(this.resolveString(this.images[n], "images[" + n + "]", wizardBuilderSupport));
                    if (!file.exists()) {
                        wizardBuilderSupport.logEvent(this.getRunnableWizardBean(), "err", "Billboard image file for wizard action " + this.getRunnableWizardBean().getBeanId() + " doesn't exist: " + file.getAbsolutePath());
                    }
                    wizardBuilderSupport.putResource(file.getAbsolutePath(), string);
                    if (!this.getIncludeLocalizedImages()) break block7;
                    int n2 = 0;
                    while (n2 < wizardBuilderSupport.getSelectedLocales().length) {
                        Locale locale = wizardBuilderSupport.getSelectedLocales()[n2];
                        try {
                            File file2 = new File(LocaleUtils.createLocalizedFileName(this.images[n], locale, 3));
                            wizardBuilderSupport.putResource(file2.getAbsolutePath(), LocaleUtils.createLocalizedFileName(string, locale, 3));
                        }
                        catch (IOException iOException) {
                            wizardBuilderSupport.logEvent(this, "wrn", "Error building localized billboard image: " + iOException);
                        }
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    wizardBuilderSupport.logEvent(this, "wrn", "Error building billboard image: " + iOException);
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public String getFullScreenBackground() {
        return this.fullScreenBackground;
    }

    public String getImageBackground() {
        return this.imageBackground;
    }

    public int getImageHAlign() {
        return this.halign;
    }

    protected String getImageKey(int n) {
        return String.valueOf(this.getRunnableWizardBean().getBeanId()) + "/img" + n;
    }

    protected URL getImageResource(int n) {
        URL uRL;
        block3: {
            String string = this.getImageKey(n);
            uRL = null;
            if (this.getIncludeLocalizedImages()) {
                uRL = this.getLocalizedImage(string);
            }
            if (uRL != null) break block3;
            try {
                uRL = this.getRunnableWizardBean().getWizard().getResource(string);
            }
            catch (IOException iOException) {}
        }
        return uRL;
    }

    public int getImageVAlign() {
        return this.valign;
    }

    public String[] getImages() {
        return this.images;
    }

    public boolean getIncludeLocalizedImages() {
        return this.includeLocalizedImages;
    }

    private URL getLocalizedImage(String string) {
        try {
            String string2 = LocaleUtils.createLocalizedFileName(string, Locale.getDefault(), 3);
            return this.getRunnableWizardBean().getWizard().getResource(string2);
        }
        catch (IOException iOException) {
            try {
                String string3 = LocaleUtils.createLocalizedFileName(string, Locale.getDefault(), 2);
                return this.getRunnableWizardBean().getWizard().getResource(string3);
            }
            catch (IOException iOException2) {
                try {
                    String string4 = LocaleUtils.createLocalizedFileName(string, Locale.getDefault(), 1);
                    return this.getRunnableWizardBean().getWizard().getResource(string4);
                }
                catch (IOException iOException3) {
                    return null;
                }
            }
        }
    }

    public Class getProgressRendererImpl(String string) {
        if (string.equals("awt")) {
            return class$com$installshield$wizardx$progress$BillboardProgressRendererAWTImpl != null ? class$com$installshield$wizardx$progress$BillboardProgressRendererAWTImpl : (class$com$installshield$wizardx$progress$BillboardProgressRendererAWTImpl = BillboardProgressRenderer.class$("com.installshield.wizardx.progress.BillboardProgressRendererAWTImpl"));
        }
        if (string.equals("swing")) {
            return class$com$installshield$wizardx$progress$BillboardProgressRendererSwingImpl != null ? class$com$installshield$wizardx$progress$BillboardProgressRendererSwingImpl : (class$com$installshield$wizardx$progress$BillboardProgressRendererSwingImpl = BillboardProgressRenderer.class$("com.installshield.wizardx.progress.BillboardProgressRendererSwingImpl"));
        }
        if (string.equals("console")) {
            if (this.progressVisible) {
                return class$com$installshield$wizardx$progress$StandardProgressRendererConsoleImpl != null ? class$com$installshield$wizardx$progress$StandardProgressRendererConsoleImpl : (class$com$installshield$wizardx$progress$StandardProgressRendererConsoleImpl = BillboardProgressRenderer.class$("com.installshield.wizardx.progress.StandardProgressRendererConsoleImpl"));
            }
            if (this.statusVisible) {
                return class$com$installshield$wizard$console$DefaultProgressRendererConsoleImpl != null ? class$com$installshield$wizard$console$DefaultProgressRendererConsoleImpl : (class$com$installshield$wizard$console$DefaultProgressRendererConsoleImpl = BillboardProgressRenderer.class$("com.installshield.wizard.console.DefaultProgressRendererConsoleImpl"));
            }
        }
        return null;
    }

    public boolean isDetailVisible() {
        return this.detailVisible;
    }

    public boolean isImageBorderVisible() {
        return this.imageBorderVisible;
    }

    public boolean isProgressVisible() {
        return this.progressVisible;
    }

    public boolean isStatusVisible() {
        return this.statusVisible;
    }

    public void setDetailVisible(boolean bl) {
        this.detailVisible = bl;
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
    }

    public void setFullScreenBackground(String string) {
        this.fullScreenBackground = string;
    }

    public void setImageBackground(String string) {
        this.imageBackground = string;
    }

    public void setImageBorderVisible(boolean bl) {
        this.imageBorderVisible = bl;
    }

    public void setImageHAlign(int n) {
        this.halign = n;
    }

    public void setImageVAlign(int n) {
        this.valign = n;
    }

    public void setImages(String[] stringArray) {
        this.images = stringArray;
    }

    public void setIncludeLocalizedImages(boolean bl) {
        this.includeLocalizedImages = bl;
    }

    public void setProgressVisible(boolean bl) {
        this.progressVisible = bl;
    }

    public void setStatusVisible(boolean bl) {
        this.statusVisible = bl;
    }
}

