/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizardx.panels.ApprovalPanel;
import com.installshield.wizardx.panels.TextDisplayPanelSwingImpl;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ApprovalPanelSwingImpl
extends TextDisplayPanelSwingImpl
implements ItemListener {
    private int choiceType = -1;
    private JComponent choiceUI = null;
    JComboBox choice = null;
    JCheckBox check = null;
    JRadioButton approve = null;
    JRadioButton disapprove = null;
    ButtonGroup group = new ButtonGroup();

    private JComponent createChoiceUI() {
        MnemonicString mnemonicString = new MnemonicString(this.resolveString(this.getAP().getApproveCaption()));
        String string = mnemonicString.toString();
        MnemonicString mnemonicString2 = new MnemonicString(this.resolveString(this.getAP().getDisapproveCaption()));
        String string2 = mnemonicString2.toString();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        jPanel.setLayout(this.createFlowLayout());
        if (this.getAP().getUiType() == 1) {
            this.choiceType = 1;
            this.choice = new JComboBox();
            this.choice.getAccessibleContext().setAccessibleName(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ApprovalPanelSwingImpl.choice"));
            jPanel.add(this.choice);
            this.choice.addItem(string);
            this.choice.addItem(string2);
            this.choice.addItemListener(this);
        } else if (this.getAP().getUiType() == 2) {
            this.choiceType = 2;
            this.check = new JCheckBox(string);
            jPanel.add(this.check);
            this.check.addItemListener(this);
            this.check.getAccessibleContext().setAccessibleName(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ApprovalPanelSwingImpl.choice"));
            if (mnemonicString.isMnemonicSpecified()) {
                this.check.setMnemonic(mnemonicString.getMnemonicChar());
            }
        } else if (this.getAP().getUiType() == 3) {
            this.choiceType = 3;
            JPanel jPanel2 = new JPanel(new ColumnLayout());
            jPanel.add(jPanel2);
            this.approve = new JRadioButton(string, false);
            jPanel2.add((Component)this.approve, ColumnConstraints.createLeftAlign());
            this.approve.addItemListener(this);
            this.approve.getAccessibleContext().setAccessibleDescription(mnemonicString.toString());
            if (mnemonicString.isMnemonicSpecified()) {
                this.approve.setMnemonic(mnemonicString.getMnemonicChar());
            }
            this.approve.getAccessibleContext().setAccessibleParent(jPanel2);
            this.group.add(this.approve);
            this.disapprove = new JRadioButton(string2, false);
            this.group.add(this.disapprove);
            jPanel2.add((Component)this.disapprove, ColumnConstraints.createLeftAlign());
            this.disapprove.addItemListener(this);
            this.disapprove.getAccessibleContext().setAccessibleDescription(mnemonicString2.toString());
            this.disapprove.getAccessibleContext().setAccessibleParent(jPanel2);
            if (mnemonicString2.isMnemonicSpecified()) {
                this.disapprove.setMnemonic(mnemonicString2.getMnemonicChar());
            }
        }
        this.setSelection(this.getAP().getSelection());
        return jPanel;
    }

    private FlowLayout createFlowLayout() {
        if (this.getAP().getUiAlignment() == 3) {
            return new FlowLayout(1, 0, 0);
        }
        if (this.getAP().getUiAlignment() == 2) {
            return new FlowLayout(2, 0, 0);
        }
        return new FlowLayout(0, 0, 0);
    }

    protected ApprovalPanel getAP() {
        return (ApprovalPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.choiceUI = this.createChoiceUI();
        this.getContentPane().add((Component)this.choiceUI, "South");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.getAP().setPropertyNotification(false);
        if (itemEvent.getSource() == this.choice) {
            if (this.choice.getSelectedIndex() == 0) {
                this.getAP().setSelection(1);
            } else {
                this.getAP().setSelection(2);
            }
        } else if (itemEvent.getSource() == this.check) {
            if (this.check.isSelected()) {
                this.getAP().setSelection(1);
            } else {
                this.getAP().setSelection(2);
            }
        } else if (itemEvent.getSource() == this.approve && this.approve.isSelected()) {
            this.getAP().setSelection(1);
        } else if (itemEvent.getSource() == this.disapprove && this.disapprove.isSelected()) {
            this.getAP().setSelection(2);
        }
        this.getAP().setPropertyNotification(true);
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        this.getContentPane().remove(this.choiceUI);
        this.choiceUI = this.createChoiceUI();
        this.getContentPane().add((Component)this.choiceUI, "South");
        this.validate();
        this.repaint();
    }

    private void setSelection(int n) {
        if (this.choiceType == 1) {
            if (n == 1) {
                this.choice.setSelectedIndex(0);
            } else {
                this.choice.setSelectedIndex(1);
            }
        } else if (this.choiceType == 2) {
            this.check.setSelected(n == 1);
        } else if (this.choiceType == 3) {
            if (n == 0) {
                this.group.remove(this.approve);
                this.group.remove(this.disapprove);
            }
            this.approve.setSelected(n == 1);
            this.disapprove.setSelected(n == 2);
            if (n == 0) {
                this.group.add(this.approve);
                this.group.add(this.disapprove);
            }
        }
    }
}

