/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizardx.panels.TextDisplayPanel;
import java.io.IOException;

public class ApprovalPanel
extends TextDisplayPanel {
    public static final int DROP_DOWN_TYPE = 1;
    public static final int CHECK_BOX_TYPE = 2;
    public static final int RADIO_BUTTON_TYPE = 3;
    public static final int DISABLE_NEXT_BUTTON = 1;
    public static final int SHOW_WARNING_MESSAGE = 2;
    public static final int LEFT_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    public static final int CENTER_ALIGN = 3;
    public static final int UNSET = 0;
    public static final int APPROVE = 1;
    public static final int DISAPPROVE = 2;
    private String approveCaption = "";
    private String disapproveCaption = "";
    private int selection = 1;
    private int uiType = 3;
    private int uiAlignment = 1;
    private int onDisapprove = 1;
    private String warningMessage = "";
    private String consoleChoiceCaption = "";

    public ApprovalPanel() {
        this.setDescription("");
        this.setText("");
        this.setApproveCaption("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.approval)");
        this.setDisapproveCaption("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.disapproval)");
        this.setConsoleChoiceCaption("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.consoleChoiceCaption)");
        this.setTitle("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.title)");
        this.setWarningMessage("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.cantContinueMsg)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.wizardx.i18n.WizardXResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        this.refreshNavStates();
        return super.entered(wizardBeanEvent);
    }

    public String getApproveCaption() {
        return this.approveCaption;
    }

    public String getConsoleChoiceCaption() {
        return this.consoleChoiceCaption;
    }

    public String getDisapproveCaption() {
        return this.disapproveCaption;
    }

    public int getOnDisapprove() {
        return this.onDisapprove;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ApprovalPanel.ote1Title", new String[]{this.resolveString(this.getTitle())});
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ApprovalPanel.ote1Doc", new String[]{this.resolveString(this.getTitle()), "0", "1", this.resolveString(this.getApproveCaption()), "2", this.resolveString(this.getDisapproveCaption()), this.getBeanId()});
        String string3 = "-W " + this.getBeanId() + ".selection=";
        string3 = n == 1 ? String.valueOf(string3) + this.getOptionsFileTemplateValueStr() : String.valueOf(string3) + this.getSelection();
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string, string2, string3)};
    }

    public int getSelection() {
        return this.selection;
    }

    public int getUiAlignment() {
        return this.uiAlignment;
    }

    public int getUiType() {
        return this.uiType;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        if (this.selection != 1) {
            if (this.onDisapprove == 2) {
                wizardBeanEvent.getUserInterface().displayUserMessage(this.resolveString(this.getTitle()), this.resolveString(this.getWarningMessage()), 4);
            }
            return false;
        }
        this.setEntered(false);
        return true;
    }

    private void refreshNavStates() {
        this.getWizard().getUI().setStopped(this.onDisapprove == 1 && this.selection != 1);
    }

    public void setApproveCaption(String string) {
        this.approveCaption = string;
        this.propertyChanged("approveCaption");
    }

    public void setConsoleChoiceCaption(String string) {
        this.consoleChoiceCaption = string;
    }

    public void setDisapproveCaption(String string) {
        this.disapproveCaption = string;
        this.propertyChanged("disapproveCaption");
    }

    public void setOnDisapprove(int n) {
        this.onDisapprove = n;
    }

    public void setSelection(int n) {
        this.selection = n;
        this.propertyChanged("selection");
        if (this.isEntered()) {
            this.refreshNavStates();
        }
    }

    public void setUiAlignment(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid alignment type " + n);
        }
        this.uiAlignment = n;
        this.propertyChanged("uiAlignment");
    }

    public void setUiType(int n) {
        if (n != 3 && n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid uiType : " + n);
        }
        this.uiType = n;
        this.propertyChanged("uiType");
    }

    public void setWarningMessage(String string) {
        this.warningMessage = string;
    }
}

