/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx.utils;

import com.installshield.util.FileAttributes;

public class UnixAttributes {
    private static int S_ISUID = 2048;
    private static int S_ISGID = 1024;
    private static int S_ISVTX = 512;
    private static int S_IRWXU = 448;
    private static int S_IRUSR = 256;
    private static int S_IWUSR = 128;
    private static int S_IXUSR = 64;
    private static int S_IRWXG = 56;
    private static int S_IRGRP = 32;
    private static int S_IWGRP = 16;
    private static int S_IXGRP = 8;
    private static int S_IRWXO = 7;
    private static int S_IROTH = 4;
    private static int S_IWOTH = 2;
    private static int S_IXOTH = 1;

    public static FileAttributes getAttributeObject(int n) {
        FileAttributes fileAttributes = new FileAttributes();
        if ((n & S_IRUSR) == S_IRUSR) {
            fileAttributes.setAttributeState(1, true);
        }
        if ((n & S_IRGRP) == S_IRGRP) {
            fileAttributes.setAttributeState(8, true);
        }
        if ((n & S_IROTH) == S_IROTH) {
            fileAttributes.setAttributeState(64, true);
        }
        if ((n & S_IWUSR) == S_IWUSR) {
            fileAttributes.setAttributeState(2, true);
        }
        if ((n & S_IWGRP) == S_IWGRP) {
            fileAttributes.setAttributeState(16, true);
        }
        if ((n & S_IWOTH) == S_IWOTH) {
            fileAttributes.setAttributeState(128, true);
        }
        if ((n & S_IXUSR) == S_IXUSR) {
            fileAttributes.setAttributeState(4, true);
        }
        if ((n & S_IXGRP) == S_IXGRP) {
            fileAttributes.setAttributeState(32, true);
        }
        if ((n & S_IXOTH) == S_IXOTH) {
            fileAttributes.setAttributeState(256, true);
        }
        return fileAttributes;
    }

    public static FileAttributes getAttributeObject(String string, int n) {
        FileAttributes fileAttributes = UnixAttributes.getAttributeObject(n);
        if (string.charAt(0) == '.') {
            fileAttributes.setAttributeState(512, true);
        }
        return fileAttributes;
    }

    public static String getAttributeString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & S_IRUSR) == S_IRUSR) {
            stringBuffer.append("rU");
        }
        if ((n & S_IRGRP) == S_IRGRP) {
            stringBuffer.append("rG");
        }
        if ((n & S_IROTH) == S_IROTH) {
            stringBuffer.append("rO");
        }
        if ((n & S_IWUSR) == S_IWUSR) {
            stringBuffer.append("wU");
        }
        if ((n & S_IWGRP) == S_IWGRP) {
            stringBuffer.append("wG");
        }
        if ((n & S_IWOTH) == S_IWOTH) {
            stringBuffer.append("wO");
        }
        if ((n & S_IXUSR) == S_IXUSR) {
            stringBuffer.append("xU");
        }
        if ((n & S_IXGRP) == S_IXGRP) {
            stringBuffer.append("xG");
        }
        if ((n & S_IXOTH) == S_IXOTH) {
            stringBuffer.append("xO");
        }
        if ((n & S_ISUID) == S_ISUID) {
            stringBuffer.append("s");
        }
        if ((n & S_ISGID) == S_ISGID) {
            stringBuffer.append("g");
        }
        return stringBuffer.toString();
    }

    public static int getMode(FileAttributes fileAttributes) {
        int n = 0;
        if (fileAttributes.getAttributeState(1)) {
            n |= S_IRUSR;
        }
        if (fileAttributes.getAttributeState(8)) {
            n |= S_IRGRP;
        }
        if (fileAttributes.getAttributeState(64)) {
            n |= S_IROTH;
        }
        if (fileAttributes.getAttributeState(2)) {
            n |= S_IWUSR;
        }
        if (fileAttributes.getAttributeState(16)) {
            n |= S_IWGRP;
        }
        if (fileAttributes.getAttributeState(128)) {
            n |= S_IWOTH;
        }
        if (fileAttributes.getAttributeState(4)) {
            n |= S_IXUSR;
        }
        if (fileAttributes.getAttributeState(32)) {
            n |= S_IXGRP;
        }
        if (fileAttributes.getAttributeState(256)) {
            n |= S_IXOTH;
        }
        return n;
    }

    public static int getMode(String string) {
        int n = 0;
        if (string.indexOf("rU") != -1) {
            n |= S_IRUSR;
        }
        if (string.indexOf("rG") != -1) {
            n |= S_IRGRP;
        }
        if (string.indexOf("rO") != -1) {
            n |= S_IROTH;
        }
        if (string.indexOf("wU") != -1) {
            n |= S_IWUSR;
        }
        if (string.indexOf("wG") != -1) {
            n |= S_IWGRP;
        }
        if (string.indexOf("wO") != -1) {
            n |= S_IWOTH;
        }
        if (string.indexOf("xU") != -1) {
            n |= S_IXUSR;
        }
        if (string.indexOf("xG") != -1) {
            n |= S_IXGRP;
        }
        if (string.indexOf("xO") != -1) {
            n |= S_IXOTH;
        }
        if (string.indexOf("s") != -1) {
            n |= S_ISUID;
        }
        if (string.indexOf("g") != -1) {
            n |= S_ISGID;
        }
        return n;
    }
}

