/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx.service.file;

import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.macosx.MacOSXUtils;
import com.installshield.wizard.platform.macosx.utils.UnixAttributes;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;

public class MacOSXFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private static final short MACOSX_LOCAL_MOUNT_FLAG = 4096;
    private static final String DATA_FILE_NAME = ".DS_Store";

    protected boolean acceptDirectoryListEntry(String string, String string2, int n) throws ServiceException {
        if (string2.trim().equals(DATA_FILE_NAME)) {
            return false;
        }
        return super.acceptDirectoryListEntry(string, string2, n);
    }

    protected long calculateDirectorySizeImpl(String string) throws ServiceException {
        long l = 0L;
        String string2 = this.createFileName(string, DATA_FILE_NAME);
        if (this.fileExists(string2)) {
            l += (long)this.getFileSize(string2);
        }
        return l;
    }

    private native void chown(String var1, String var2, String var3) throws ServiceException;

    private void deleteDataFile(String string) throws ServiceException {
        String string2 = this.createFileName(string, DATA_FILE_NAME);
        if (this.fileExists(string2)) {
            this.deleteFile(string2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String var1_1, boolean var2_2, boolean var3_3) throws ServiceException {
        var4_4 = 0;
        var5_5 = false;
        var6_6 = "";
        var7_7 = this.createFileName(this.getCurrentDirectory(), var1_1);
        if (this.fileExists(var7_7) && this.isDirectory(var7_7) && this.getParent(var7_7) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(var7_7)) {
            if (!var2_2 && !var3_3) {
                try {
                    var8_8 = String.valueOf(FileUtils.appendSeparator(var7_7, this.getSeparator())) + "*";
                    var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + var8_8 + "\""});
                    if (var9_14.getExitCode() == 0) {
                        var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                        if (var9_14.getExitCode() == 0) ** GOTO lbl43
                        var5_5 = true;
                        var6_6 = var9_14.getStderr();
                    }
                    var5_5 = true;
                    var6_6 = var9_14.getStderr();
                }
                catch (Exception var8_9) {
                    throw new ServiceException(var8_9);
                }
            } else if (var2_2 && !var3_3) {
                try {
                    this.deleteDataFile(var7_7);
                    var8_10 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                    if (var8_10.getExitCode() == 0) ** GOTO lbl43
                    var5_5 = true;
                    var6_6 = var8_10.getStderr();
                }
                catch (Exception var8_11) {
                    throw new ServiceException(var8_11);
                }
            } else if (!var2_2 && var3_3) {
                try {
                    var8_12 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf " + var7_7});
                    if (var8_12.getExitCode() == 0) ** GOTO lbl43
                    var5_5 = true;
                    var6_6 = var8_12.getStderr();
                }
                catch (Exception var8_13) {
                    throw new ServiceException(var8_13);
                }
            } else {
                var4_4 = super.deleteDirectory(var1_1, var2_2, var3_3);
            }
        }
lbl43:
        // 10 sources

        if (var5_5) {
            throw new ServiceException(2, "Error deleting directory: " + var6_6);
        }
        return var4_4;
    }

    protected boolean deleteDirectoryImpl(String string) throws ServiceException {
        this.deleteDataFile(string);
        return new File(string).delete();
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        return UnixAttributes.getAttributeObject(string, this.getFileMode(string));
    }

    private native int getFileMode(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected String getLibraryDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "usr" + File.separator + "lib";
    }

    public String getPartitionFormat(String string) throws ServiceException {
        return this.getPartitionFormatName(string);
    }

    private native String getPartitionFormatName(String var1) throws ServiceException;

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    private native short getPartitionMountFlags(String var1) throws ServiceException;

    public native String[] getPartitionNames() throws ServiceException;

    public int getPartitionType(String string) throws ServiceException {
        short s = this.getPartitionMountFlags(string);
        System.out.println("mountFlags = " + s);
        int n = (s & 0x1000) == 4096 ? 1 : 2;
        return n;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "Applications";
    }

    public int getSystemCompatibility() {
        return MacOSXUtils.getSystemCompatibility();
    }

    public native int getSystemUMask() throws ServiceException;

    protected native String getTempDirectory() throws ServiceException;

    protected void initialized() {
        super.initialized();
        try {
            MacOSXUtils.loadLibrary(this.getResource(MacOSXUtils.getJNILibraryResourceName()), MacOSXUtils.getJNILibraryName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "serviceCannotLoadJniLibrary", new String[]{"fileService", MacOSXUtils.getJNILibraryName()}));
            exception.printStackTrace();
        }
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        this.setFileMode(string, UnixAttributes.getMode(fileAttributes));
    }

    public void setFileCreated(String string, long l) throws ServiceException {
        this.setFileModified(string, l);
    }

    public void setFileExecutable(String string) throws ServiceException {
        FileAttributes fileAttributes = this.getFileAttributes(string);
        int n = 292;
        fileAttributes.setAttributeState(n, true);
        this.setFileMode(string, UnixAttributes.getMode(fileAttributes));
    }

    private native void setFileMode(String var1, int var2) throws ServiceException;

    public native void setFileModified(String var1, long var2) throws ServiceException;

    public void setFileOwner(String string, String string2) throws ServiceException {
        this.chown(string, string2, null);
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        this.chown(string, null, string2);
    }

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public native void setSystemUMask(int var1) throws ServiceException;

    public boolean supportsLongFileNames(String string) throws ServiceException {
        return true;
    }

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }
}

