/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx;

import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.macosx.MacOSXPlatform;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.net.URL;

public class MacOSXUtils {
    public static final String JVM_VERIFY_CLASS_NAME = "Verify.jar";
    public static final String LAUNCHER_NAME = "launcher";
    public static final String JVM_KEY = "macosx";
    public static final String PLATFORM_ID = "macosxppk";
    private static final String JNI_LIBRARY_NAME = "libmacosxppk.jnilib";

    public static void addHelperClassesToArchive(ServiceBuilderSupport serviceBuilderSupport) throws IOException {
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.macosx.MacOSXPlatform");
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.macosx.MacOSXUtils");
    }

    public static void addNativeSupportToArchive(ServiceBuilderSupport serviceBuilderSupport, WizardServices wizardServices) throws IOException {
        String[] stringArray = new String[]{JNI_LIBRARY_NAME, JVM_VERIFY_CLASS_NAME};
        int n = 0;
        while (n < stringArray.length) {
            String string = String.valueOf(MacOSXUtils.getMacOSXPPKSubdir()) + stringArray[n];
            URL uRL = wizardServices.getResource(string);
            serviceBuilderSupport.putResource(uRL, string);
            ++n;
        }
    }

    public static String getJNILibraryName() {
        return JNI_LIBRARY_NAME;
    }

    public static String getJNILibraryResourceName() {
        return String.valueOf(MacOSXUtils.getMacOSXPPKSubdir()) + MacOSXUtils.getJNILibraryName();
    }

    public static String getMacOSXPPKSubdir() {
        return "macosxppk/";
    }

    public static String getPlatformId() {
        return PLATFORM_ID;
    }

    public static String getPlatformLauncherResource() {
        return String.valueOf(MacOSXUtils.getMacOSXPPKSubdir()) + LAUNCHER_NAME;
    }

    public static int getSystemCompatibility() {
        int n = 0;
        try {
            if (MacOSXPlatform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static String getVerifyClassResource() {
        return String.valueOf(MacOSXUtils.getMacOSXPPKSubdir()) + JVM_VERIFY_CLASS_NAME;
    }

    public static void loadLibrary(URL uRL, String string) {
        try {
            LibraryLoader.loadLibrary(uRL, string);
        }
        catch (Throwable throwable) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXUtils.cannotLoadJniLibrary", new String[]{uRL.toString()}));
            throwable.printStackTrace();
        }
    }
}

