/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.awt.BorderPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ImagePanel
extends BorderPanel {
    private Image image = null;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image cannot be null");
        }
        this.image = image;
        this.prepareImage(image, this);
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this) + 2 * this.getThickness(), this.image.getHeight(this) + 2 * this.getThickness());
        }
        return super.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            int n = this.getThickness();
            int n2 = this.getThickness();
            graphics.drawImage(this.image, n, n2, this);
        }
        super.paint(graphics);
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            this.prepareImage(image, this);
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (this.image != null) {
            int n = this.getThickness();
            int n2 = this.getThickness();
            Color color = this.getBackground();
            graphics.drawImage(this.image, n, n2, new Color(color.getRed(), color.getGreen(), color.getBlue()), this);
        }
        super.update(graphics);
    }
}

