/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.AWTWizardPanelImpl;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.Spacing;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class DefaultAWTWizardPanelImpl
extends AWTWizardPanelImpl
implements FocusListener {
    private Panel descPane = null;
    private Panel contentPane = null;
    private FlowLabel description = null;

    public void entering(WizardBeanEvent wizardBeanEvent) {
        this.refreshDescription();
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = (Component)focusEvent.getSource();
        int n = component.getLocation().y;
        int n2 = component.getLocation().x;
        Container container = ((Component)focusEvent.getSource()).getParent();
        while (container != null) {
            if (container instanceof ScrollPane) {
                this.scrollRectToVisible((ScrollPane)container, new Rectangle(new Point(n2, n), component.getSize()));
                n = 0;
                n2 = 0;
                component = container;
            }
            n += container.getLocation().y;
            n2 += container.getLocation().x;
            container = container.getParent();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected Container getContentPane() {
        if (this.descPane == null) {
            throw new IllegalStateException("content pane not initialized -- call super.initialize() first");
        }
        return this.contentPane;
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.setLayout(new ColumnLayout());
        this.descPane = new Panel();
        this.add((Component)this.descPane, ColumnConstraints.createHorizontalFill());
        this.descPane.setLayout(new ColumnLayout());
        this.description = new FlowLabel();
        this.refreshDescription();
        this.contentPane = new Panel();
        this.add((Component)this.contentPane, ColumnConstraints.createBothFill());
    }

    private int positionAdjustment(int n, int n2, int n3) {
        if (n3 >= 0 && n2 + n3 <= n) {
            return 0;
        }
        if (n3 <= 0 && n2 + n3 >= n) {
            return 0;
        }
        if (n3 > 0 && n2 <= n) {
            return -n3 + n - n2;
        }
        if (n3 >= 0 && n2 >= n) {
            return -n3;
        }
        if (n3 <= 0 && n2 <= n) {
            return -n3;
        }
        if (n3 < 0 && n2 >= n) {
            return -n3 + n - n2;
        }
        return 0;
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        if (string.equals("description")) {
            this.refreshDescription();
        }
    }

    private void refreshDescription() {
        this.descPane.removeAll();
        String string = this.resolveString(this.getPanel().getDescription());
        if (string.length() > 0) {
            this.description.setText(string);
            this.descPane.add((Component)this.description, ColumnConstraints.createHorizontalFill());
            this.descPane.add(Spacing.createVerticalSpacing(6));
            this.description.repaint();
        }
        this.doLayout();
        if (this.contentPane != null) {
            this.contentPane.doLayout();
        }
        this.validate();
        this.repaint();
    }

    protected void registerFocusListener(FocusListener focusListener, Container container) {
        int n = 0;
        while (n < container.getComponentCount()) {
            if (container.getComponent(n) instanceof Container) {
                this.registerFocusListener(this, (Container)container.getComponent(n));
            }
            if (container.getComponent(n).isFocusTraversable()) {
                container.getComponent(n).addFocusListener(this);
            }
            ++n;
        }
    }

    public void scrollRectToVisible(ScrollPane scrollPane, Rectangle rectangle) {
        Component component;
        Component component2 = component = scrollPane.getComponentCount() > 0 ? scrollPane.getComponent(0) : null;
        if (component == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n = this.positionAdjustment(scrollPane.getViewportSize().width, rectangle.width, rectangle.x);
        n2 = this.positionAdjustment(scrollPane.getViewportSize().height, rectangle.height, rectangle.y);
        if (n != 0 || n2 != 0) {
            Point point = scrollPane.getScrollPosition();
            Dimension dimension = component.getSize();
            int n3 = point.x;
            int n4 = point.y;
            Dimension dimension2 = scrollPane.getViewportSize();
            point.x -= n;
            if (point.x + dimension2.width > dimension.width) {
                point.x = Math.max(0, dimension.width - dimension2.width);
            } else if (point.x < 0) {
                point.x = 0;
            }
            point.y -= n2;
            if (point.y + dimension2.height > dimension.height) {
                point.y = Math.max(0, dimension.height - dimension2.height);
            } else if (point.y < 0) {
                point.y = 0;
            }
            if (point.x != n3 || point.y != n4) {
                scrollPane.setScrollPosition(point);
            }
        }
    }

    protected void unregisterFocusListener(FocusListener focusListener, Container container) {
        int n = 0;
        while (n < container.getComponentCount()) {
            if (container.getComponent(n) instanceof Container) {
                this.unregisterFocusListener(this, (Container)container.getComponent(n));
            }
            if (container.getComponent(n).isFocusTraversable()) {
                container.getComponent(n).removeFocusListener(this);
            }
            ++n;
        }
    }
}

