/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.awt.AWTIconBase;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.util.Observer;
import java.util.Vector;

public class AWTIconListBox
extends AWTIconBase
implements ItemSelectable {
    private int imageWidth = 20;
    private int imageHeight = 15;
    private int[] pixels = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -8684677, -8684677, -8684677, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -4342339, -256, -4342339, -256, -4342339, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -1, -1, -1, -1, -1, -1, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -16777216, -1, -1, -1, -1, -1, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int[] filesPixels = new int[]{0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -8355712, -8355712, -8355712, -8355712, -8355712, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -8355712, -8355712, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -8355712, -8355712, -8355712, -8355712, -8355712, -1, -8355712, -8355712, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -8355712, -8355712, -1, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -8355712, -8355712, -8355712, -8355712, -8355712, -1, -8355712, -8355712, -8355712, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -8355712, -8355712, -1, -1, -16777216, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -8355712, -8355712, -16777216, -1, -16777216, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, -1, -16777216, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, -1, -16777216, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, -1, -16777216, -16777216, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, -16777216, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -8355712, -1, -1, -1, -1, -1, -1, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0xFF00FF};
    private Image image = this.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, ColorModel.getRGBdefault(), this.pixels, 0, this.imageWidth));
    private Image fimage = this.createImage(new MemoryImageSource(16, 16, ColorModel.getRGBdefault(), this.filesPixels, 0, 16));
    private Image filesImage;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private String commandTopRowChanged = "Top_Row_Changed";
    private String commandDoubleClicked = "Double_Clicked";
    private String OSName;
    private Font defaultfont = new Font("Dialog", 0, 12);
    private FontMetrics fontMetrics;
    private Observer observer;
    private boolean multipleSelections = false;
    private int prev = -1;
    private int first = 0;
    private int textHigh = 20;
    private Vector items = new Vector();
    private int selected = -1;
    private Color listBoxBGColor = Color.white;
    private Color colText = Color.black;
    private Color colSelText = SystemColor.textHighlightText;
    private Color colSelTextBG = SystemColor.textHighlight;
    private int nIndentTop = 4;
    private int nIndentLeft = 4;
    private int nIndentText = 7;
    private Dimension sz = new Dimension(100, 125);

    public AWTIconListBox() {
        this(false);
    }

    public AWTIconListBox(boolean bl) {
        super(false);
        this.multipleSelections = bl;
        this.setBackground(this.listBoxBGColor);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void addItem(FileStructure fileStructure) {
        this.items.addElement(fileStructure);
        this.updateScrollbar();
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        this.fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.defaultfont);
        this.textHigh = Math.max(this.imageHeight, this.fontMetrics.getHeight() - 1);
    }

    public synchronized void clear() {
        this.items = new Vector();
        this.selected = -1;
        this.prev = -1;
        this.first = 0;
        this.updateScrollbar();
        this.update();
    }

    private final int countItems() {
        return this.items.size();
    }

    public void draw(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height / this.textHigh;
        int n2 = this.items.size();
        graphics.setColor(this.listBoxBGColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n3 = 0;
        int n4 = this.first;
        while (n4 < n2 && n4 < this.first + n) {
            if (n3 > dimension.height) break;
            if (n3 + this.textHigh >= 0) {
                this.drawItem(graphics, n4, n3);
            }
            n3 += this.textHigh;
            ++n4;
        }
        this.paintBorder(graphics, 0, 0, dimension.width, dimension.height, false);
    }

    protected void drawItem(Graphics graphics, int n, int n2) {
        try {
            this.drawText(graphics, n, n2);
        }
        catch (Exception exception) {}
    }

    protected void drawText(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        if (this.isSelected(n)) {
            graphics.setColor(this.colSelTextBG);
            graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
            graphics.setColor(this.colSelText);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
            graphics.setColor(this.colText);
        }
        if (this.isDirectory(n)) {
            graphics.drawImage(this.image, this.nIndentLeft, n2 + this.nIndentTop, this);
        } else {
            graphics.drawImage(this.fimage, this.nIndentLeft, n2 + this.nIndentTop, this);
        }
        graphics.drawString(((FileStructure)this.items.elementAt(n)).getName(), this.nIndentText + 20, n2 + this.textHigh);
    }

    public Image getFilesImage() {
        return this.filesImage;
    }

    public String getItem(int n) {
        return ((FileStructure)this.items.elementAt(n)).getName();
    }

    public int getLastVisibleRow() {
        int n = 0;
        int n2 = this.items.size();
        int n3 = 0;
        while (n3 < this.getSize().height && n < n2) {
            if (n > this.first) {
                n3 += this.textHigh;
            }
            ++n;
        }
        return n - 1;
    }

    protected int getMaxTopRow() {
        Dimension dimension = this.getSize();
        Font font = this.getFont();
        this.fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.defaultfont);
        this.textHigh = Math.max(this.imageHeight, this.fontMetrics.getHeight());
        return Math.max(0, this.items.size() - (dimension.height - 4) / this.textHigh + 1);
    }

    public Dimension getMinimumSize() {
        return this.sz;
    }

    public Dimension getPreferredSize() {
        return this.sz;
    }

    private int getSelected(int n, int n2) {
        Dimension dimension = super.getSize();
        int n3 = dimension.height / this.textHigh;
        int n4 = this.items.size();
        int n5 = this.textHigh + this.nIndentTop;
        int n6 = this.first;
        while (n6 < n4 && n6 < this.first + n3) {
            if (n2 < n5) {
                return n6;
            }
            n5 += this.textHigh;
            ++n6;
        }
        return -1;
    }

    public synchronized String getSelectedItem() {
        return this.selected < 0 ? null : ((FileStructure)this.items.elementAt(this.selected)).getName();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public boolean isDirectory(int n) {
        return ((FileStructure)this.items.elementAt(n)).isDirectory();
    }

    public synchronized boolean isSelected(int n) {
        return n == this.selected;
    }

    protected boolean mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.requestFocus();
        int n3 = this.getSelected(n, n2);
        if (this.isSelected(n3) && mouseEvent.getClickCount() == 2) {
            if (this.observer != null) {
                this.observer.update(null, this);
            }
            return true;
        }
        if (n3 != -1) {
            this.prev = n3;
            this.select(n3);
        }
        return true;
    }

    protected void onTopRowChanged(int n) {
        if (this.first != n) {
            this.first = n;
            this.update();
        }
    }

    private void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(SystemColor.controlLtHighlight);
        if (bl) {
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.drawLine(n, n2, n, n2 + n4);
        } else {
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        }
        graphics.setColor(SystemColor.controlHighlight);
        if (!bl) {
            graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
        }
        graphics.setColor(SystemColor.controlShadow);
        if (bl) {
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        } else {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
        }
        graphics.setColor(SystemColor.controlDkShadow);
        if (bl) {
            graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        } else {
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 501: {
                Point point = ((MouseEvent)aWTEvent).getPoint();
                this.mouseDown((MouseEvent)aWTEvent, point.x, point.y);
                break;
            }
        }
        super.processEvent(aWTEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401) {
            switch (n) {
                case 40: {
                    if (this.prev >= this.items.size() - 1) break;
                    this.select(++this.prev);
                    this.scrollToView(this.prev, 1005);
                    break;
                }
                case 38: {
                    if (this.prev <= 0) break;
                    this.select(--this.prev);
                    this.scrollToView(this.prev, 1004);
                    break;
                }
                case 37: {
                    this.prev = 0;
                    this.select(this.prev);
                    this.scrollToView(this.prev, 1006);
                    break;
                }
                case 39: {
                    this.prev = this.items.size() - 1;
                    this.select(this.prev);
                    this.scrollToView(this.prev, 1007);
                    break;
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void scrollToView(int n) {
        if (!this.getVScrollbar().isShowing()) {
            return;
        }
        Scrollbar scrollbar = this.getVScrollbar();
        if (n < this.first) {
            int n2 = scrollbar.getValue() - this.first + n;
            if (n2 < scrollbar.getMinimum()) {
                n2 = scrollbar.getMinimum();
            }
            scrollbar.setValue(n2);
            this.onTopRowChanged(n2);
        }
    }

    public void scrollToView(int n, int n2) {
        int n3;
        int n4 = this.getLastVisibleRow();
        Scrollbar scrollbar = this.getVScrollbar();
        if (n < this.first && n2 == 1004) {
            n3 = scrollbar.getValue() - 1;
            if (n3 < scrollbar.getMinimum()) {
                n3 = scrollbar.getMinimum();
            }
            scrollbar.setValue(n3);
            this.onTopRowChanged(n3);
        }
        if (n > n4 - 2 && n2 == 1005) {
            n3 = scrollbar.getValue() + 1;
            if (n3 >= scrollbar.getMaximum()) {
                n3 = scrollbar.getMaximum();
            }
            if (scrollbar.getMaximum() == 1) {
                n3 = 0;
            }
            scrollbar.setValue(n3);
            this.onTopRowChanged(n3);
        }
        if (n2 == 1006) {
            n3 = scrollbar.getMinimum();
            scrollbar.setValue(n3);
            this.onTopRowChanged(n3);
        }
        if (n2 == 1007) {
            n3 = scrollbar.getMaximum();
            scrollbar.setValue(n3);
            this.onTopRowChanged(n3);
        }
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.countItems()) {
            return;
        }
        if (this.selected != n) {
            this.selected = n;
            this.scrollToView(n);
            if (this.observer != null) {
                this.observer.update(null, null);
            }
            this.update();
        }
    }

    public void setFilesImage(Image image) {
        this.filesImage = image;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
        observer.update(null, this);
    }

    class FileStructure {
        String name;
        String parent;
        boolean isDirectory = false;

        public FileStructure(String string, String string2) {
            this.name = string;
            this.parent = string2;
            File file = new File(string2, string);
            this.isDirectory = !file.isFile();
        }

        public String getName() {
            return this.name;
        }

        public String getParent() {
            return this.parent;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

