/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

public class WizardException
extends Exception {
    public static final int INIT_GENERAL = 100;
    public static final int NO_WIZARDHOME = 101;
    public static final int INVALID_LISTENER_CLASS = 102;
    public static final int INIT_UI = 103;
    public static final int CANNOT_LOAD_WIZARD = 104;
    public static final int CANNOT_LOAD_WIZARD_INF = 105;
    public static final int CANNOT_LOAD_WIZARD_TREE = 106;
    public static final int DIGEST_TEST_FAILED = 107;
    public static final int BUILD_ERROR = 300;
    public static final int BUILD_CANCELED = 301;
    public static final int WIZARD_GENERAL = 400;
    public static final int CANNOT_PERFORM_UI_OPERATION = 401;
    public static final int WIZARD_TREE_NOT_SET = 402;
    public static final int EXIT_CODE = 403;
    public static final int EXTERNAL_WIZARD_ERROR = 404;
    public static final int UNKNOWN_ERROR = 499;
    public static final int WIZARD_BEAN_EXCEPTION = 500;
    public static final int WIZARD_ACTION_CANCELED = 501;
    public static final int JAVA_EXCEPTION = 200;
    private int code = 0;
    private String msg = null;
    private Object data = null;

    public WizardException(int n) {
        this.code = n;
    }

    public WizardException(int n, Object object) {
        this(n, null, object);
    }

    public WizardException(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public WizardException(int n, String string, Object object) {
        this(n, string);
        this.data = object;
    }

    public WizardException(Exception exception) {
        this.code = 200;
        this.msg = exception.getMessage();
        this.data = exception;
    }

    public static final int getBaseCode(String string) {
        int n = (String.valueOf(string) + "aaa").hashCode();
        return Math.abs(n) / 10000 * 10000;
    }

    public Object getData() {
        return this.data;
    }

    private String getDataDesc() {
        if (this.code == 200) {
            return "exception";
        }
        return "additional data";
    }

    public int getErrorCode() {
        return this.code;
    }

    public static String getErrorMsg(int n) {
        switch (n) {
            case 100: {
                return "general initialization error";
            }
            case 101: {
                return "could not find wizard home";
            }
            case 102: {
                return "could not create wizard listener from class name";
            }
            case 400: {
                return "general wizard exception";
            }
            case 401: {
                return "cannot perform user interface operation";
            }
            case 200: {
                return "Java exception";
            }
            case 103: {
                return "an error occurred during the initialization of the user interface";
            }
            case 104: {
                return "could not load wizard specified in /wizard.inf";
            }
            case 105: {
                return "could not load /wizard.inf";
            }
            case 106: {
                return "could not load wizard tree specified in /wizard.inf";
            }
            case 500: {
                return "wizard bean exception";
            }
            case 501: {
                return "wizard action canceled";
            }
            case 404: {
                return "an error occurred opening an external wizard";
            }
            case 301: {
                return "build canceled";
            }
            case 300: {
                return "build error";
            }
            case 107: {
                return "digest test failed";
            }
            case 499: {
                return "unknown error code -- refer to stderr output for more information";
            }
        }
        return "unknown error code";
    }

    public String getMessage() {
        return this.msg != null ? this.msg : WizardException.getErrorMsg(this.code);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: WizardException error_code");
            System.exit(-1);
        }
        try {
            System.out.println(WizardException.getErrorMsg(Integer.parseInt(stringArray[0])));
        }
        catch (Exception exception) {
            System.out.println("invalid error code: " + stringArray[0]);
        }
    }

    public String toString() {
        return "WizardException: (error code = " + this.code + "; message=\"" + this.getMessage() + "\"" + (this.data != null ? "; " + this.getDataDesc() + " = [" + this.data + "]" : "") + ")";
    }
}

