/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.jvm.LauncherEntry;
import com.installshield.wizard.service.WizardServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class LaunchScript
extends LauncherEntry {
    static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String[] classPath = null;
    private String title = "";
    private String mainClass = "";
    private Hashtable systemProperties = new Hashtable();
    private String otherArgs = "";
    private String mainClassArgs = "";
    private boolean consoleVisible = false;
    private boolean autoSetWorkingDir = true;
    private String archiveExpression = null;

    public LaunchScript() {
        this.setName("launch.txt");
    }

    protected void appendClasspath(StringBuffer stringBuffer, String[] stringArray) {
        stringBuffer.append(" %CP%(");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\"");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("\"");
                ++n;
            }
        }
        stringBuffer.append(") ");
    }

    protected void appendJavaExe(StringBuffer stringBuffer) {
        stringBuffer.append("\"@JVM_HOME@/@JVM_EXE@\"");
    }

    protected void appendOtherArgs(StringBuffer stringBuffer, String string) {
        stringBuffer.append(String.valueOf(string) + " ");
    }

    protected void appendRuntimeJavaArgs(StringBuffer stringBuffer) {
        stringBuffer.append("%RUNTIME_JAVAARGS%() ");
    }

    protected void appendRuntimeSystemProperties(StringBuffer stringBuffer) {
        stringBuffer.append(" %RUNTIME_SYSTEMPROP%() ");
    }

    protected void appendSystemProperty(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("%SYSTEMPROP%(\"" + string.toString() + "\", \"" + string2.toString() + "\") ");
    }

    public long calculateSize() throws IOException {
        return this.getBytes().length;
    }

    public String[] createLaunchScriptClassPath(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = LaunchScript.formatValue(stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    public Dictionary createLaunchScriptSystemProperties(String[] stringArray, WizardServices wizardServices) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf(61);
            String string2 = n2 != -1 ? string.substring(0, n2) : string;
            String string3 = n2 != -1 ? string.substring(n2 + 1) : "";
            hashtable.put(LaunchScript.formatValue(wizardServices.resolveString(string2)), LaunchScript.formatValue(wizardServices.resolveString(string3)));
            ++n;
        }
        return hashtable;
    }

    public static String formatValue(String string) {
        String string2 = "";
        int n = 0;
        int n2 = string.indexOf("\"", n);
        while (n2 >= 0) {
            string2 = String.valueOf(string2) + string.substring(n, n2 + 1);
            string2 = String.valueOf(string2) + "\"";
            n = n2 + 1;
            n2 = string.indexOf("\"", n);
        }
        if (n >= 0) {
            string2 = String.valueOf(string2) + string.substring(n);
        }
        return string2;
    }

    public String getArchiveExpression() {
        return this.archiveExpression;
    }

    public boolean getAutoSetWorkingDir() {
        return this.autoSetWorkingDir;
    }

    private byte[] getBytes() throws IOException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if (this.title != null && this.title.length() > 0) {
            stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.title.length()) {
                char c = this.title.charAt(n);
                if (c < '\u0000' || c > '\u007f') {
                    stringBuffer.append("\\u");
                    int n2 = (c & 0xF000) >> 12;
                    stringBuffer.append(hexdigits[n2]);
                    n2 = (c & 0xF00) >> 8;
                    stringBuffer.append(hexdigits[n2]);
                    n2 = (c & 0xF0) >> 4;
                    stringBuffer.append(hexdigits[n2]);
                    n2 = c & 0xF;
                    stringBuffer.append(hexdigits[n2]);
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            this.writeSetting(printWriter, "DESC", stringBuffer.toString());
        }
        this.writeSetting(printWriter, "DISPLAY_CONSOLE", this.consoleVisible ? "1" : "0");
        this.writeSetting(printWriter, "AUTO_SET_WORKING_DIR", this.autoSetWorkingDir ? "1" : "0");
        if (this.archiveExpression != null) {
            this.writeSetting(printWriter, "ARCHIVE", this.archiveExpression);
        }
        stringBuffer = new StringBuffer(128);
        this.appendJavaExe(stringBuffer);
        this.appendClasspath(stringBuffer, this.classPath);
        if (this.systemProperties != null) {
            Enumeration enumeration = this.systemProperties.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.systemProperties.get(k);
                if (v == null) continue;
                this.appendSystemProperty(stringBuffer, k.toString(), v.toString());
            }
        }
        this.appendRuntimeSystemProperties(stringBuffer);
        if (this.otherArgs != null && this.otherArgs.length() > 0) {
            this.appendOtherArgs(stringBuffer, this.otherArgs);
        }
        this.appendRuntimeJavaArgs(stringBuffer);
        if (this.mainClass != null && this.mainClass.length() > 0) {
            stringBuffer.append(String.valueOf(this.mainClass) + " ");
        }
        if (this.mainClassArgs != null && this.mainClassArgs.length() > 0) {
            stringBuffer.append(String.valueOf(this.mainClassArgs) + " ");
        }
        this.writeSetting(printWriter, "COMMAND", "\"" + LaunchScript.formatValue(stringBuffer.toString()) + "\"");
        printWriter.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        printWriter.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public boolean getConsoleVisible() {
        return this.consoleVisible;
    }

    public InputStream getInputStream() throws IOException {
        byte[] byArray = this.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainClassArgs() {
        return this.mainClassArgs;
    }

    public String getOtherArgs() {
        return this.otherArgs;
    }

    public Dictionary getSystemProperties() {
        return this.systemProperties;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return 2;
    }

    public void setArchiveExpression(String string) {
        this.archiveExpression = string;
    }

    public void setAutoSetWorkingDir(boolean bl) {
        this.autoSetWorkingDir = bl;
    }

    public void setClassPath(String[] stringArray) {
        this.classPath = stringArray;
    }

    public void setConsoleVisible(boolean bl) {
        this.consoleVisible = bl;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
    }

    public void setMainClassArgs(String string) {
        this.mainClassArgs = string;
    }

    public void setOtherArgs(String string) {
        this.otherArgs = string;
    }

    public void setSystemProperties(Dictionary dictionary) {
        this.systemProperties.clear();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.systemProperties.put(k, dictionary.get(k));
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    protected void writeSetting(PrintWriter printWriter, String string, String string2) throws IOException {
        printWriter.write(String.valueOf(string) + ": ");
        printWriter.write(string2);
        printWriter.println("");
    }
}

