/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.TreeNode;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GenericTreeNode
implements TreeNode {
    private static final long serialVersionUID = -5971920470771817217L;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    private GenericTreeNode parent = null;
    private Vector children;
    private Object userObject;
    private boolean allowsChildren;

    public GenericTreeNode() {
        this(null);
    }

    public GenericTreeNode(Object object) {
        this(object, true);
    }

    public GenericTreeNode(Object object, boolean bl) {
        this.allowsChildren = bl;
        this.userObject = object;
    }

    public void addChild(GenericTreeNode genericTreeNode) {
        if (genericTreeNode != null && genericTreeNode.getParent() == this) {
            this.insertChild(genericTreeNode, this.getChildCount() - 1);
        } else {
            this.insertChild(genericTreeNode, this.getChildCount());
        }
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public GenericTreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getChildIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (n < this.getChildCount() - 1) {
            return (GenericTreeNode)this.getChildAt(n + 1);
        }
        return null;
    }

    public TreeNode getChildAt(int n) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("invalid child index (" + n + ")");
        }
        return (TreeNode)this.children.elementAt(n);
    }

    public GenericTreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getChildIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (n > 0) {
            return (GenericTreeNode)this.getChildAt(n - 1);
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getChildIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(treeNode)) {
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    public GenericTreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return (GenericTreeNode)this.getChildAt(0);
    }

    public GenericTreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return (GenericTreeNode)this.getChildAt(this.getChildCount() - 1);
    }

    public GenericTreeNode getNextSibling() {
        GenericTreeNode genericTreeNode = (GenericTreeNode)this.getParent();
        GenericTreeNode genericTreeNode2 = genericTreeNode == null ? null : genericTreeNode.getChildAfter(this);
        if (genericTreeNode2 != null && !this.isNodeSibling(genericTreeNode2)) {
            throw new InternalError("child of parent is not a sibling");
        }
        return genericTreeNode2;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public GenericTreeNode getPreviousSibling() {
        GenericTreeNode genericTreeNode = (GenericTreeNode)this.getParent();
        GenericTreeNode genericTreeNode2 = genericTreeNode == null ? null : genericTreeNode.getChildBefore(this);
        if (genericTreeNode2 != null && !this.isNodeSibling(genericTreeNode2)) {
            throw new InternalError("child of parent is not a sibling");
        }
        return genericTreeNode2;
    }

    public GenericTreeNode getRoot() {
        GenericTreeNode genericTreeNode;
        GenericTreeNode genericTreeNode2 = this;
        do {
            genericTreeNode = genericTreeNode2;
        } while ((genericTreeNode2 = (GenericTreeNode)genericTreeNode2.getParent()) != null);
        return genericTreeNode;
    }

    public int getSiblingCount() {
        TreeNode treeNode = this.getParent();
        if (treeNode == null) {
            return 1;
        }
        return treeNode.getChildCount();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void insertChild(GenericTreeNode genericTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (genericTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(genericTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        GenericTreeNode genericTreeNode2 = (GenericTreeNode)genericTreeNode.getParent();
        if (genericTreeNode2 != null) {
            genericTreeNode2.removeChild(genericTreeNode);
        }
        genericTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(genericTreeNode, n);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }

    public boolean isNodeSibling(TreeNode treeNode) {
        boolean bl;
        if (treeNode == null) {
            bl = false;
        } else if (treeNode == this) {
            bl = true;
        } else {
            GenericTreeNode genericTreeNode = (GenericTreeNode)this.getParent();
            boolean bl2 = bl = genericTreeNode != null && genericTreeNode == treeNode.getParent();
            if (bl && !genericTreeNode.isNodeChild(treeNode)) {
                throw new InternalError("sibling has different parent");
            }
        }
        return bl;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void removeAllChildren() {
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            this.removeChild(n);
            --n;
        }
    }

    public void removeChild(int n) {
        TreeNode treeNode = this.getChildAt(n);
        this.children.removeElementAt(n);
        if (treeNode instanceof GenericTreeNode) {
            ((GenericTreeNode)treeNode).setParent(null);
        }
    }

    public void removeChild(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(treeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.removeChild(this.getChildIndex(treeNode));
    }

    public void setAllowsChildren(boolean bl) {
        if (bl != this.allowsChildren) {
            this.allowsChildren = bl;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    public void setParent(GenericTreeNode genericTreeNode) {
        this.parent = genericTreeNode;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }
}

