/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.wizardbeans.LocalePanel;
import com.installshield.util.LocaleUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class LocalePanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements ItemListener {
    private JScrollPane scroll = null;
    private JPanel view = null;
    private Hashtable localesPerButton = new Hashtable();

    public void entering(WizardBeanEvent wizardBeanEvent) {
        Object object;
        this.view.removeAll();
        this.localesPerButton.clear();
        Locale[] localeArray = this.getLP().getAvailableLocales();
        Locale[] localeArray2 = this.getLP().getSelectedLocales();
        ButtonGroup buttonGroup = this.getLP().isMultipleSelection() ? null : new ButtonGroup();
        JToggleButton jToggleButton = this.getLP().isMultipleSelection() ? new JCheckBox() : new JRadioButton();
        int n = 0;
        while (n < localeArray.length) {
            if (jToggleButton instanceof JCheckBox) {
                object = new JCheckBox(LocaleUtils.getLocaleDisplayName(localeArray[n]));
            } else {
                object = new JRadioButton(LocaleUtils.getLocaleDisplayName(localeArray[n]));
                buttonGroup.add((AbstractButton)object);
            }
            this.view.add((Component)object, ColumnConstraints.createLeftAlign());
            ((AbstractButton)object).setSelected(this.getLP().isSelected(localeArray[n]));
            ((Component)object).getAccessibleContext().setAccessibleName(LocaleUtils.getLocaleDisplayName(localeArray[n]));
            this.localesPerButton.put(object, localeArray[n]);
            ++n;
        }
        object = this.localesPerButton.keys();
        while (object.hasMoreElements()) {
            ((AbstractButton)object.nextElement()).addItemListener(this);
        }
        this.scroll.getHorizontalScrollBar().setValue(0);
        this.scroll.getVerticalScrollBar().setValue(0);
    }

    private LocalePanel getLP() {
        return (LocalePanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.getContentPane().add(this.scroll);
        if (this.scroll.getVerticalScrollBar().getUnitIncrement() < 5) {
            this.scroll.getVerticalScrollBar().setUnitIncrement(15);
        }
        this.view = new JPanel();
        this.view.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.view.setLayout(new ColumnLayout());
        this.scroll.add(this.view);
        this.scroll.setViewportView(this.view);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        Vector vector = new Vector();
        int n = 0;
        while (n < this.view.getComponentCount()) {
            object = (AbstractButton)this.view.getComponent(n);
            if (((AbstractButton)object).isSelected()) {
                vector.addElement(this.localesPerButton.get(object));
            }
            ++n;
        }
        object = new Locale[vector.size()];
        vector.copyInto((Object[])object);
        this.getLP().setSelectedLocales((Locale[])object);
    }
}

