/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.ProductTree;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.PropertyUtils;
import com.installshield.util.sort.LocaleCompare;
import com.installshield.util.sort.SortUtils;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocalePanel
extends WizardPanel {
    private boolean multipleSelection = true;
    private boolean requireSelection = true;
    private boolean autoSelect = true;
    private int localeOption = 0;
    Locale[] available = new Locale[0];
    Locale[] selected = new Locale[0];

    public LocalePanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, LocalePanel.description, $P(displayName))");
        this.setTitle("$L(com.installshield.product.i18n.ProductResources, LocalePanel.title)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.product.i18n.ProductResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    private String encodeSelected() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.selected.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.selected[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        this.refreshNavStates();
        return true;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        this.updateSelected();
    }

    public boolean getAutoSelect() {
        return this.autoSelect;
    }

    Locale[] getAvailableLocales() {
        return this.available;
    }

    private int getLocaleOption() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            return (Integer)productService.getProductTreeProperty("/product.xml", "localeOption");
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
            return ProductTree.LOCALE_OPTION_PROMPT;
        }
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        Locale[] localeArray = this.getAvailableLocales();
        if (localeArray.length == 0) {
            this.refreshAvailable();
            localeArray = this.getAvailableLocales();
        }
        String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "LocalePanel.ote1Title");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<enum>");
        int n2 = 0;
        while (n2 < localeArray.length) {
            stringBuffer.append("<value>");
            stringBuffer.append(String.valueOf(localeArray[n2].toString()) + ":" + LocaleUtils.getLocaleDisplayName(localeArray[n2]));
            stringBuffer.append("</value>");
            ++n2;
        }
        stringBuffer.append("</enum>");
        String string2 = LocaleUtils.getLocaleDisplayName(localeArray[0]);
        String string3 = "-P selectedLocales=" + localeArray[0].toString();
        String string4 = "";
        if (localeArray.length > 1) {
            string4 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "LocalePanel.ote1MultLocales", new String[]{localeArray[0].toString(), localeArray[1].toString(), LocaleUtils.getLocaleDisplayName(localeArray[0]), LocaleUtils.getLocaleDisplayName(localeArray[1])});
        }
        String string5 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "LocalePanel.ote1Doc", new String[]{stringBuffer.toString(), string2, string3, string4});
        String string6 = "-P selectedLocales=";
        if (n == 1) {
            string6 = String.valueOf(string6) + this.getOptionsFileTemplateValueStr();
        } else {
            try {
                ProductService productService = (ProductService)this.getService("productService");
                String string7 = (String)productService.getProductTreeProperty("/product.xml", "selectedLocales");
                if (string7 == null) {
                    string7 = "";
                }
                string6 = String.valueOf(string6) + string7;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string, string5, string6)};
    }

    public boolean getRequireSelection() {
        return this.requireSelection;
    }

    Locale[] getSelectedLocales() {
        return this.selected;
    }

    boolean isAvailable(Locale locale) {
        int n = 0;
        while (n < this.available.length) {
            if (this.available[n].equals(locale)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    boolean isSelected(Locale locale) {
        int n = 0;
        while (n < this.selected.length) {
            if (this.selected[n].equals(locale)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        Object object;
        if (!this.getAutoSelect()) {
            return true;
        }
        this.refreshAvailable();
        int n = this.getLocaleOption();
        if (n == ProductTree.LOCALE_OPTION_SYSTEM || n == ProductTree.LOCALE_OPTION_SYSTEM_THEN_PROMPT || n == ProductTree.LOCALE_OPTION_SYSTEM_THEN_DEFAULT) {
            object = LocaleUtils.findBestMatch(this.available, Locale.getDefault());
            if (object != null) {
                this.setSelectedLocales(new Locale[]{object});
                this.logEvent(this, "msg1", "autoselected locales based on product tree locale option");
                this.updateSelected();
                return false;
            }
            if (n == ProductTree.LOCALE_OPTION_SYSTEM) {
                this.logEvent(this, "wrn", "system locale is not available -- unable to update product tree locales");
                return false;
            }
        }
        if (this.available.length == 0) {
            this.setSelectedLocales(this.available);
            this.logEvent(this, "msg1", "autoselected locales because only one is available");
            this.updateSelected();
            return false;
        }
        try {
            object = (ProductService)this.getService("productService");
            String string = (String)object.getProductTreeProperty("/product.xml", "selectedLocales");
            StringTokenizer stringTokenizer = new StringTokenizer(string != null ? string : "", ",");
            this.selected = new Locale[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.selected[n2++] = PropertyUtils.createLocale(stringTokenizer.nextToken());
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            this.selected = new Locale[0];
        }
        return super.queryEnter(wizardBeanEvent);
    }

    private void refreshAvailable() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            String[] stringArray = productService.getProductLocales("/product.xml");
            this.available = new Locale[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.available[n] = PropertyUtils.createLocale(stringArray[n]);
                ++n;
            }
            SortUtils.qsort(this.available, new LocaleCompare());
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            this.available = new Locale[0];
        }
    }

    private void refreshNavStates() {
        boolean bl = !this.getRequireSelection() || this.getAvailableLocales().length == 0 || this.getSelectedLocales().length > 0;
        this.getWizard().getUI().setStopped(bl ^ true);
    }

    public void setAutoSelect(boolean bl) {
        this.autoSelect = bl;
    }

    public void setMultipleSelection(boolean bl) {
        this.multipleSelection = bl;
    }

    public void setRequireSelection(boolean bl) {
        this.requireSelection = bl;
    }

    void setSelectedLocales(Locale[] localeArray) {
        if (localeArray == null) {
            throw new IllegalStateException("selected cannot be null");
        }
        this.selected = localeArray;
        if (this.isEntered()) {
            this.refreshNavStates();
        }
    }

    protected void updateProductTree(String string) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            this.logEvent(this, "msg1", "setting selected locales to \"" + string + "\"");
            productService.setProductTreeProperty("/product.xml", "selectedLocales", string);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void updateSelected() {
        this.updateProductTree(this.encodeSelected());
    }
}

