/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class SelectedLocalesIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;
    private String[] selectedLocales;

    public SelectedLocalesIterator(FilteredProductTreeIterator filteredProductTreeIterator, String[] stringArray) {
        this.iter = filteredProductTreeIterator;
        this.selectedLocales = stringArray;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        boolean bl = false;
        String string = this.getLocale(productBean);
        if (string != null && string.length() > 0) {
            int n = 0;
            while (!bl && n < this.selectedLocales.length) {
                bl = string.equals(this.selectedLocales[n]);
                ++n;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    private String getLocale(ProductBean productBean) {
        String string = null;
        if (productBean instanceof SoftwareObject) {
            SoftwareObject softwareObject = (SoftwareObject)((Object)productBean);
            string = softwareObject.getLocale();
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null) {
                string = softwareObject.getLocale();
            }
        }
        return string;
    }

    public ProductBean getNext(ProductBean productBean) {
        return this.iter.getNext(productBean);
    }

    public ProductBean getPrevious(ProductBean productBean) {
        return this.iter.getPrevious(productBean);
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

