/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import java.util.Vector;

public class RequiredTreeIterator
implements BaseProductTreeIterator {
    private ProductBean root;
    private ProductBean begin = new Marker();
    private ProductBean end = new Marker();
    private Vector filters = new Vector();
    private boolean visitRequired = false;

    public RequiredTreeIterator(GenericSoftwareObject genericSoftwareObject) {
        this.root = genericSoftwareObject.getRequiredTree().getRoot();
    }

    protected final boolean accept(ProductBean productBean) {
        Vector vector = this.filters;
        synchronized (vector) {
            int n = this.filters.size();
            int n2 = 0;
            while (n2 < n) {
                if (!((ProductBeanFilter)this.filters.elementAt(n2)).accept(productBean)) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n2;
            }
        }
        return true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.filters.addElement(productBeanFilter);
    }

    public ProductBean begin() {
        return this.begin;
    }

    public ProductBean end() {
        return this.end;
    }

    private ProductBean getFirst() {
        ProductBean productBean = this.root.getProductTree().getFirstChild(this.root);
        while (productBean != null) {
            if (this.accept(productBean)) {
                return productBean;
            }
            productBean = productBean.getProductTree().getNextSibling(productBean);
        }
        return this.end();
    }

    private ProductBean getLast() {
        ProductBean productBean = this.root.getProductTree().getLastChild(this.root);
        while (productBean != null) {
            if (this.accept(productBean)) {
                return productBean;
            }
            productBean = productBean.getProductTree().getPreviousSibling(productBean);
        }
        return this.begin();
    }

    public ProductBean getNext(ProductBean productBean) {
        if (productBean == null || productBean == this.end()) {
            return null;
        }
        if (productBean == this.begin()) {
            return this.getFirst();
        }
        ProductBean productBean2 = this.root.getProductTree().getNextSibling(productBean);
        while (productBean2 != null) {
            if (this.accept(productBean2)) {
                return productBean2;
            }
            productBean2 = this.root.getProductTree().getNextSibling(productBean2);
        }
        return this.end();
    }

    public ProductBean getPrevious(ProductBean productBean) {
        if (productBean == null || productBean == this.begin()) {
            return null;
        }
        if (productBean == this.end()) {
            return this.getLast();
        }
        ProductBean productBean2 = this.root.getProductTree().getPreviousSibling(productBean);
        while (productBean2 != null) {
            if (this.accept(productBean2)) {
                return productBean2;
            }
            productBean2 = this.root.getProductTree().getPreviousSibling(productBean2);
        }
        return this.begin();
    }

    public ProductBean getRoot() {
        return this.root;
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.filters.removeElement(productBeanFilter);
    }

    public void setRoot(ProductBean productBean) {
        this.root = productBean;
    }

    class Marker
    extends ProductBean {
        Marker() {
        }
    }
}

