/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class HasLocaleTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;

    public HasLocaleTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator) {
        this.iter = filteredProductTreeIterator;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        return this.ancestorHasLocale(productBean) ^ true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    private boolean ancestorHasLocale(ProductBean productBean) {
        boolean bl = false;
        ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
        while (productBean2 != null && !bl) {
            bl = this.hasLocale(productBean2);
            productBean2 = productBean2.getProductTree().getParent(productBean2);
        }
        return bl;
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        while (productBean2 != this.end() && !this.hasLocale(productBean2)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        while (productBean2 != this.begin() && !this.hasLocale(productBean2)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    private boolean hasLocale(ProductBean productBean) {
        boolean bl = false;
        if (productBean instanceof SoftwareObject) {
            SoftwareObject softwareObject = (SoftwareObject)((Object)productBean);
            bl = softwareObject.getLocale() != null;
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null) {
                bl = softwareObject.getLocale() != null;
            }
        }
        return bl;
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

