/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.Launcher;
import com.installshield.product.actions.LauncherExtra;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.jvm.JVMService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class UninstallerLauncher
extends ProductAction {
    private String wizardArgs = "";
    private String[] additionalClassPaths = new String[0];
    private String[] systemProperties = new String[0];
    private String javaArgs = "%IF_EXISTS%(\"INIT_JAVA_HEAP\", \"@INIT_JAVA_HEAP@20m\") %IF_EXISTS%(\"MAX_JAVA_HEAP\", \"@MAX_JAVA_HEAP@60m\")";
    private String installedFileName = null;
    static /* synthetic */ Class class$com$installshield$product$actions$UninstallerLauncherBeanInfo;
    static /* synthetic */ Class class$com$installshield$product$actions$Launcher;

    public UninstallerLauncher() {
        this.setActive(false);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        Launcher launcher = new Launcher(this);
        launcher.setJVMId("foo");
        launcher.setTitle("bar");
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                launcher.getExtendedProperties().put(k, v);
            }
        }
        launcher.setActive(this.isActive());
        launcher.build(productBuilderSupport);
        try {
            productBuilderSupport.putClass((class$com$installshield$product$actions$UninstallerLauncherBeanInfo != null ? class$com$installshield$product$actions$UninstallerLauncherBeanInfo : (class$com$installshield$product$actions$UninstallerLauncherBeanInfo = UninstallerLauncher.class$("com.installshield.product.actions.UninstallerLauncherBeanInfo"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$Launcher != null ? class$com$installshield$product$actions$Launcher : (class$com$installshield$product$actions$Launcher = UninstallerLauncher.class$("com.installshield.product.actions.Launcher"))).getName());
            productBuilderSupport.putRequiredService("jvmService");
            productBuilderSupport.putRequiredService("systemUtilService");
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Launcher createLauncher() {
        Launcher launcher = new Launcher(this);
        launcher.initialize(this.getServices());
        launcher.setTitle("InstallShield Wizard");
        launcher.setMainClass("run");
        launcher.setMainClassArguments(this.getWizardArguments());
        UninstallerArchive uninstallerArchive = this.getProductTree().getUninstallerArchive();
        String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(uninstallerArchive), uninstallerArchive.getArchiveName());
        String[] stringArray = new String[this.additionalClassPaths.length + 1];
        int n = 0;
        while (n < this.additionalClassPaths.length) {
            stringArray[n] = this.formatClassPath(this.additionalClassPaths[n]);
            ++n;
        }
        stringArray[stringArray.length - 1] = this.formatClassPath(string);
        launcher.setClassPath(stringArray);
        launcher.setJavaArguments(this.getJavaArguments());
        launcher.setJVMId(this.getProductTree().getUninstallerJVMResolution().getJVMId());
        launcher.setLauncherPurpose((byte)2);
        return launcher;
    }

    private String[] createLauncherSystemProperties(LauncherExtra launcherExtra) throws ProductException {
        String[] stringArray = this.getSystemProperties();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        vector.addElement("is.jvm.file=" + launcherExtra.addISMPSystemPropertyMacro("JVM_FILE", "\"@JVM_FILE@\""));
        vector.addElement("is.jvm.temp=" + launcherExtra.addISMPSystemPropertyMacro("JVM_TEMP", "\"@JVM_TEMP@\""));
        vector.addElement("is.jvm.home=" + launcherExtra.addISMPSystemPropertyMacro("JVM_HOME", "\"@JVM_HOME@\""));
        vector.addElement("is.launcher.file=" + launcherExtra.addISMPSystemPropertyMacro("LAUNCHER_FILE", "\"%LAUNCHER_FILE%()\""));
        vector.addElement("temp.dir=" + launcherExtra.addISMPSystemPropertyMacro("TEMP_DIR", "\"%TEMP_DIR%()\""));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected String formatClassPath(String string) {
        String string2 = !string.startsWith("\"") ? "\"" + string : string;
        if (!string.endsWith("\"")) {
            string2 = String.valueOf(string2) + "\"";
        }
        return string2;
    }

    public String[] getAdditionalClassPaths() {
        return this.additionalClassPaths;
    }

    private LauncherExtra getExtra(String string) {
        LauncherExtra launcherExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && launcherExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof LauncherExtra) || !string.equals(((LauncherExtra)v).getPlatformId())) continue;
                launcherExtra = (LauncherExtra)v;
            }
        }
        return launcherExtra;
    }

    public String getInstalledFileName() {
        return this.installedFileName;
    }

    public String getJavaArguments() {
        return this.javaArgs;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        if (!this.uninstallerLauncherExists()) {
            try {
                JVMService jVMService = (JVMService)this.getService("jvmService");
                LauncherExtra launcherExtra = this.getExtra(jVMService.getPlatformId());
                if (launcherExtra != null) {
                    String string = this.getProductTree().getInstallLocation(this.getProductTree().getUninstallerArchive());
                    String string2 = FileUtils.createFileName(string, this.resolveString(launcherExtra.getFileName()));
                    requiredBytesTable.addBytes(this.createLauncher().getRequiredBytes(launcherExtra, string2));
                }
            }
            catch (ServiceException serviceException) {
                throw new ProductException(serviceException);
            }
        }
        return requiredBytesTable;
    }

    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    public String getWizardArguments() {
        return this.wizardArgs;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        try {
            JVMService jVMService = (JVMService)this.getService("jvmService");
            LauncherExtra launcherExtra = this.getExtra(jVMService.getPlatformId());
            if (launcherExtra != null) {
                Launcher launcher = this.createLauncher();
                String string = this.getProductTree().getInstallLocation(this.getProductTree().getUninstallerArchive());
                this.installedFileName = FileUtils.createFileName(string, this.resolveString(launcherExtra.getFileName()));
                launcher.setSystemProperties(this.createLauncherSystemProperties(launcherExtra));
                launcher.install(launcherExtra, this.installedFileName, productActionSupport);
            }
        }
        catch (ProductException productException) {
            throw productException;
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
            throw new ProductException(exception);
        }
    }

    public void setAdditionalClassPaths(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.additionalClassPaths = stringArray;
    }

    public void setInstalledFileName(String string) {
        this.installedFileName = string;
    }

    public void setJavaArguments(String string) {
        this.javaArgs = string;
    }

    public void setSystemProperties(String[] stringArray) {
        this.systemProperties = stringArray;
    }

    public void setWizardArguments(String string) {
        this.wizardArgs = string;
    }

    public String toString() {
        return "Product Uninstaller Launcher";
    }

    public void uninstall(ProductActionSupport productActionSupport) {
        try {
            if (this.installedFileName != null && this.installedFileName.trim().length() > 0) {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                systemUtilService.deleteFileOnExit(this.installedFileName);
            }
        }
        catch (ServiceException serviceException) {
            productActionSupport.logEvent(this, "err", serviceException);
        }
    }

    public boolean uninstallerLauncherExists() {
        if (this.installedFileName != null) {
            return new File(this.installedFileName).exists();
        }
        return false;
    }
}

