/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.archive.AllArchiveFilter;
import com.installshield.archive.ArchiveEntry;
import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveReader;
import com.installshield.archive.ArchiveResourceWriterFactory;
import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.ArchiveWriterOutputStream;
import com.installshield.archive.ArchiveWriterZipOutputStream;
import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceReaderFactory;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.SoftwareObject;
import com.installshield.qjml.QJML;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.URLUtils;
import com.installshield.util.ZipUtils;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardInf;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class UninstallerArchive
extends ProductAction
implements Locatable {
    private static final String SERVICES_DEF = "/services.xml";
    private static final String WIZARD_INF = "/wizard.inf";
    private static final String WIZARD_DEF = "/wizard.xml";
    private static final String WIZARDTREE_DEF = "/wizardTree.xml";
    private static final String PRODUCT_DEF = "/product.xml";
    private static final String ARCHIVE_INDEX_NAME = "index";
    private static final String MD5_FOLDER_NAME = "md5";
    private static final long RESOURCE_ARCHIVE_DEFAULT_SIZE = 100000L;
    private static final double DEFAULT_COMPRESSION_ESTIMATE = 0.7;
    private String installLocation = "_uninst";
    private String archiveName = "uninstall.jar";
    private String resourcesFileName = "uninstall.dat";
    private Vector resourceExclusions = new Vector();
    private Vector classUpdateExclusions = new Vector();
    private Vector installedFiles = new Vector();
    private String uninstallerWizardId = null;
    private String uninstallerResId = null;
    private String uninstallerWizard = null;
    private String uninstallerWizardTree = null;
    private long uninstallerSize = -1L;
    private String uninstallResources = null;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;
    static /* synthetic */ Class class$com$installshield$wizard$WizardLoader;
    static /* synthetic */ Class class$com$installshield$wizard$Wizard;
    static /* synthetic */ Class class$com$installshield$wizard$WizardTree;
    static /* synthetic */ Class class$com$installshield$product$ProductTree;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UninstallerFilterUtils");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UpdateUninstallerResourcesFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UpdateUninstallerClassesFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$AbstractCreateUninstallerFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$CreateUninstallerFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$CreateInactiveUninstallerFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UninstallerArchiveWriter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UninstallerArchiveWriterOutputStream");
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private UninstallerArchiveWriter createClassWriter(String string, String string2, String string3, ServicesDefinition servicesDefinition) throws IOException {
        UninstallerArchiveWriter uninstallerArchiveWriter = new UninstallerArchiveWriter(string, string3);
        uninstallerArchiveWriter.putClassResource(this.createManifest(), "META-INF/MANIFEST.MF");
        WizardInf wizardInf = this.createWizardInf(string3);
        URL uRL = this.getResource(this.getUninstallerWizard());
        wizardInf.setWizardDigest(QJML.createDigest(uRL, class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = UninstallerArchive.class$("com.installshield.wizard.Wizard")), (class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = UninstallerArchive.class$("com.installshield.wizard.Wizard"))).getName().getBytes()));
        URL uRL2 = this.getResource(this.getUninstallerWizardTree());
        wizardInf.setWizardTreeDigest(QJML.createDigest(uRL2, class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = UninstallerArchive.class$("com.installshield.wizard.WizardTree")), (class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = UninstallerArchive.class$("com.installshield.wizard.WizardTree"))).getName().getBytes()));
        String string4 = this.getServices().getHome();
        CreateUninstallerFilter createUninstallerFilter = new CreateUninstallerFilter(string2, string3, WIZARD_INF, WIZARD_DEF, WIZARDTREE_DEF, this, PRODUCT_DEF, SERVICES_DEF, ARCHIVE_INDEX_NAME, MD5_FOLDER_NAME);
        uninstallerArchiveWriter.putArchive(string4, createUninstallerFilter);
        servicesDefinition.removeAllResourceLocations();
        servicesDefinition.putResourceLocation(String.valueOf(this.getResourcesFileName()) + "+/" + string3);
        uninstallerArchiveWriter.putDefinition(servicesDefinition, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = UninstallerArchive.class$("com.installshield.wizard.service.ServicesDefinition")), SERVICES_DEF);
        wizardInf.setServicesDigest(QJML.createDigest(servicesDefinition, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = UninstallerArchive.class$("com.installshield.wizard.service.ServicesDefinition")), (class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = UninstallerArchive.class$("com.installshield.wizard.service.ServicesDefinition"))).getName().getBytes()));
        uninstallerArchiveWriter.putClassResource(wizardInf.getInputStream(), WIZARD_INF);
        return uninstallerArchiveWriter;
    }

    private InputStream createManifest() throws IOException {
        return Wizard.createManifest().getInputStream();
    }

    private UninstallerArchiveWriter createResourceWriter(String string, String string2) throws IOException {
        UninstallerArchiveWriter uninstallerArchiveWriter = new UninstallerArchiveWriter(string, string2);
        ProductTree productTree = this.getProductTree().getUninstallTree() != null ? this.getProductTree().getUninstallTree() : this.getProductTree();
        uninstallerArchiveWriter.putDefinition(productTree, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = UninstallerArchive.class$("com.installshield.product.ProductTree")), PRODUCT_DEF);
        uninstallerArchiveWriter.putArchive(this.getUninstallResources(), new AllArchiveFilter());
        return uninstallerArchiveWriter;
    }

    private WizardInf createWizardInf(String string) throws IOException {
        WizardInf wizardInf = new WizardInf((class$com$installshield$wizard$WizardLoader != null ? class$com$installshield$wizard$WizardLoader : (class$com$installshield$wizard$WizardLoader = UninstallerArchive.class$("com.installshield.wizard.WizardLoader"))).getName().getBytes());
        wizardInf.setResId(string);
        return wizardInf;
    }

    private void deleteUninstaller(ProductActionSupport productActionSupport) {
        Object object;
        Service service;
        try {
            service = (FileService)this.getService("fileService");
            object = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            ((WizardServicesImpl)this.getServices()).closeResourceArchive((String)object);
            service.deleteFile((String)object);
        }
        catch (Exception exception) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstallerResources"));
            this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstallerResources"));
        }
        try {
            service = (SystemUtilService)this.getService("systemUtilService");
            service.deleteFileOnExit(FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName()));
            object = this.installedFiles.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.logEvent(this, WizardLog.subclassEvent("dbg", "uninstaller"), "attempting to delete " + string + " on exit");
                service.deleteFileOnExit(string);
            }
            service.deleteDirectoryOnExit(this.getProductTree().getInstallLocation(this), true);
        }
        catch (ServiceException serviceException) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstaller"));
            this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstaller"));
        }
    }

    private boolean ensureResources() {
        try {
            this.getServices().ensureResources("", CommandLineTokenizer.createSpaceDelimitedString(this.getResourceExclusions()));
            return true;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String[] getClassUpdateExclusions() {
        Object[] objectArray = new String[this.classUpdateExclusions.size()];
        this.classUpdateExclusions.copyInto(objectArray);
        return objectArray;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String[] getInstalledFiles() {
        Object[] objectArray = new String[this.installedFiles.size()];
        this.installedFiles.copyInto(objectArray);
        return objectArray;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        Object object;
        String string = this.getProductTree().getInstallLocation(this);
        if (this.uninstallerSize == -1L) {
            if (!this.uninstallerExists()) {
                this.uninstallerSize = 100000L;
                object = this.getServices().getHome();
                CreateInactiveUninstallerFilter createInactiveUninstallerFilter = new CreateInactiveUninstallerFilter(this.getServices().getId(), WIZARD_INF, WIZARD_DEF, WIZARDTREE_DEF, this, PRODUCT_DEF, SERVICES_DEF, ARCHIVE_INDEX_NAME, MD5_FOLDER_NAME);
                try {
                    ArchiveReader archiveReader = new ArchiveReader((String)object);
                    Enumeration enumeration = archiveReader.entries(createInactiveUninstallerFilter, null);
                    while (enumeration.hasMoreElements()) {
                        ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
                        ResourceReader resourceReader = archiveEntry.getReader();
                        long l = resourceReader.getSize();
                        this.uninstallerSize += Math.round(0.7 * (double)l);
                    }
                    archiveReader.close();
                }
                catch (IOException iOException) {
                    throw new ProductException(iOException);
                }
            } else {
                this.uninstallerSize = 0L;
            }
        }
        object = new RequiredBytesTable();
        ((RequiredBytesTable)object).addBytes(string, this.uninstallerSize);
        return object;
    }

    public String[] getResourceExclusions() {
        Object[] objectArray = new String[this.resourceExclusions.size()];
        this.resourceExclusions.copyInto(objectArray);
        return objectArray;
    }

    public String getResourcesFileName() {
        return this.resourcesFileName;
    }

    public String getUninstallResources() {
        return this.uninstallResources;
    }

    public String getUninstallerResId() {
        return this.uninstallerResId;
    }

    public String getUninstallerWizard() {
        return this.uninstallerWizard;
    }

    public String getUninstallerWizardId() {
        return this.uninstallerWizardId;
    }

    public String getUninstallerWizardTree() {
        return this.uninstallerWizardTree;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.ensureResources()) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Uninstaller.resourcesNotEnsured"));
        }
        if (this.uninstallerExists()) {
            this.updateUninstallerResourceArchive(productActionSupport);
            this.updateUninstallerClassArchive(productActionSupport);
        } else {
            this.writeUninstaller(productActionSupport);
        }
    }

    private boolean isProductUninstalled() {
        SoftwareObject softwareObject = (SoftwareObject)((Object)this.getProductTree().getRoot());
        return softwareObject.getInstallStatus() == 4;
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    public void putClassUpdateExclusion(String string) {
        if (!this.classUpdateExclusions.contains(string)) {
            this.classUpdateExclusions.addElement(string);
        }
    }

    public void putInstalledFile(String string) {
        if (!this.installedFiles.contains(string)) {
            this.installedFiles.addElement(string);
        }
    }

    public void putResourceExclusion(String string) {
        if (!this.resourceExclusions.contains(string)) {
            this.resourceExclusions.addElement(string);
        }
    }

    public void removeClassUpdateExclusion(String string) {
        this.classUpdateExclusions.removeElement(string);
    }

    public void removeInstalledFile(String string) {
        this.installedFiles.removeElement(string);
    }

    public void removeResourceExclusion(String string) {
        this.resourceExclusions.removeElement(string);
    }

    private void replaceArchive(String string, String string2) throws ServiceException, IOException {
        FileService fileService = (FileService)this.getServices().getService("fileService");
        ((WizardServicesImpl)this.getServices()).closeResourceArchive(string2);
        fileService.moveFile(string, string2, true);
    }

    public void setArchiveName(String string) {
        this.archiveName = string;
    }

    public void setClassUpdateExclusions(String[] stringArray) {
        this.classUpdateExclusions.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.classUpdateExclusions.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setInstallLocation(String string) {
        this.installLocation = string.trim().length() == 0 ? null : string;
    }

    public void setInstalledFiles(String[] stringArray) {
        this.installedFiles.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.installedFiles.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setResourceExclusions(String[] stringArray) {
        this.resourceExclusions.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.resourceExclusions.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setResourcesFileName(String string) {
        this.resourcesFileName = string;
    }

    public void setUninstallResources(String string) {
        this.uninstallResources = string;
    }

    public void setUninstallerResId(String string) {
        this.uninstallerResId = string;
    }

    public void setUninstallerWizard(String string) {
        this.uninstallerWizard = string;
    }

    public void setUninstallerWizardId(String string) {
        this.uninstallerWizardId = string;
    }

    public void setUninstallerWizardTree(String string) {
        this.uninstallerWizardTree = string;
    }

    public String toString() {
        String string = this.getArchiveName();
        if (FileUtils.isAbsolute(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getInstallLocation();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(String.valueOf(string2) + File.separatorChar);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.ensureResources()) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Uninstaller.resourcesNotEnsured"));
        }
        if (this.isProductUninstalled()) {
            this.deleteUninstaller(productActionSupport);
        } else {
            this.updateUninstallerResourceArchive(productActionSupport);
        }
    }

    public boolean uninstallerExists() {
        String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
        return new File(string).exists();
    }

    private void updateUninstallerClassArchive(ProductActionSupport productActionSupport) {
        try {
            Object object;
            Object object2;
            String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName());
            this.putInstalledFile(string);
            ServicesDefinition servicesDefinition = new ServicesDefinition(((WizardServicesImpl)this.getServices()).getServicesDefinition());
            try {
                object2 = new URL("archive", "", -1, URLUtils.encodeArchiveURLPath(String.valueOf(string) + "+/" + this.getUninstallerResId() + SERVICES_DEF));
                object = (ServicesDefinition)QJML.read((URL)object2, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = UninstallerArchive.class$("com.installshield.wizard.service.ServicesDefinition")));
                servicesDefinition.mergeServicesDefinition((ServicesDefinition)object);
            }
            catch (Exception exception) {
                productActionSupport.logEvent(this, "wrn", exception);
                this.logEvent(this, "wrn", exception);
            }
            object2 = this.createClassWriter(FileUtils.createTempFile(), this.getServices().getId(), this.getUninstallerResId(), servicesDefinition);
            object = new UpdateUninstallerClassesFilter(this, this.getServices().getHome());
            ((ArchiveWriter)object2).putArchive(string, (ArchiveFilter)object);
            ((UninstallerArchiveWriter)object2).write();
            ((UninstallerArchiveWriter)object2).close();
            try {
                this.replaceArchive(((UninstallerArchiveWriter)object2).getArchiveFileName(), string);
            }
            catch (Exception exception) {
                productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerClasses"));
                this.logEvent(this, "err", exception);
                this.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerClasses"));
            }
        }
        catch (IOException iOException) {
            productActionSupport.logEvent(this, "err", iOException);
            this.logEvent(this, "err", iOException);
        }
    }

    private void updateUninstallerResourceArchive(ProductActionSupport productActionSupport) {
        try {
            UninstallerArchiveWriter uninstallerArchiveWriter = this.createResourceWriter(FileUtils.createTempFile(), this.getUninstallerResId());
            UpdateUninstallerResourcesFilter updateUninstallerResourcesFilter = new UpdateUninstallerResourcesFilter(this, this.getUninstallerResId(), PRODUCT_DEF);
            String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            uninstallerArchiveWriter.putArchive(string, updateUninstallerResourcesFilter);
            uninstallerArchiveWriter.write();
            uninstallerArchiveWriter.close();
            try {
                this.replaceArchive(uninstallerArchiveWriter.getArchiveFileName(), string);
            }
            catch (Exception exception) {
                productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerResources"));
                this.logEvent(this, "err", exception);
                this.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerResources"));
            }
        }
        catch (IOException iOException) {
            productActionSupport.logEvent(this, "err", iOException);
            this.logEvent(this, "err", iOException);
        }
    }

    private void writeUninstaller(ProductActionSupport productActionSupport) {
        try {
            String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName());
            String string2 = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            this.putInstalledFile(string);
            this.putInstalledFile(string2);
            ServicesDefinition servicesDefinition = new ServicesDefinition(((WizardServicesImpl)this.getServices()).getServicesDefinition());
            UninstallerArchiveWriter uninstallerArchiveWriter = this.createClassWriter(string, this.getServices().getId(), this.getUninstallerResId(), servicesDefinition);
            uninstallerArchiveWriter.write();
            uninstallerArchiveWriter.close();
            UninstallerArchiveWriter uninstallerArchiveWriter2 = this.createResourceWriter(string2, this.getUninstallerResId());
            uninstallerArchiveWriter2.write();
            uninstallerArchiveWriter2.close();
        }
        catch (IOException iOException) {
            productActionSupport.logEvent(this, "err", iOException);
            this.logEvent(this, "err", iOException);
        }
    }

    private static class UninstallerFilterUtils {
        UninstallerFilterUtils() {
        }

        public static String createResourcePath(String string, String string2) {
            string = string.replace(File.separatorChar, '/');
            string2 = string2.replace(File.separatorChar, '/');
            StringBuffer stringBuffer = new StringBuffer();
            if (!string.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
            if (!string.endsWith("/") && !string2.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        public static String stripId(String string, String string2) {
            String string3 = "/" + string + "/";
            if (string2.startsWith(string3)) {
                return string2.substring(string3.length());
            }
            return string2;
        }
    }

    private abstract class AbstractCreateUninstallerFilter
    implements ArchiveFilter {
        protected String installerResId;
        protected String uninstallerResId;
        protected String wizardInfName;
        protected String installerDef;
        protected String installerTreeDef;
        protected String uninstallerId;
        protected String uninstaller;
        protected String uninstallerTreeDef;
        protected Vector exclusions;
        protected String productDef;
        protected String servicesDef;
        protected String archiveIndexName;
        protected String md5FolderName;

        AbstractCreateUninstallerFilter(String string, String string2, String string3, String string4, String string5, UninstallerArchive uninstallerArchive2, String string6, String string7, String string8, String string9) {
            this.installerResId = string;
            this.uninstallerResId = string2;
            this.wizardInfName = string3;
            this.installerDef = UninstallerFilterUtils.createResourcePath(string, string4);
            this.installerTreeDef = UninstallerFilterUtils.createResourcePath(string, string5);
            this.uninstallerId = uninstallerArchive2.getUninstallerWizardId();
            this.uninstaller = UninstallerFilterUtils.createResourcePath(string, uninstallerArchive2.getUninstallerWizard());
            this.uninstallerTreeDef = UninstallerFilterUtils.createResourcePath(string, uninstallerArchive2.getUninstallerWizardTree());
            this.exclusions = new Vector();
            String[] stringArray = uninstallerArchive2.getResourceExclusions();
            int n = 0;
            while (n < stringArray.length) {
                String string10 = UninstallerFilterUtils.createResourcePath(string, stringArray[n]);
                if (!this.exclusions.contains(string10)) {
                    this.exclusions.addElement(string10);
                }
                ++n;
            }
            this.productDef = UninstallerFilterUtils.createResourcePath(string, string6);
            this.servicesDef = UninstallerFilterUtils.createResourcePath(string, string7);
            this.archiveIndexName = UninstallerFilterUtils.createResourcePath(string, string8);
            this.md5FolderName = UninstallerFilterUtils.createResourcePath(string, string9);
        }

        public abstract boolean filter(ArchiveEntry var1, ResourceWriterFactory var2) throws IOException;
    }

    private class CreateUninstallerFilter
    extends AbstractCreateUninstallerFilter {
        CreateUninstallerFilter(String string, String string2, String string3, String string4, String string5, UninstallerArchive uninstallerArchive2, String string6, String string7, String string8, String string9) {
            super(string, string2, string3, string4, string5, uninstallerArchive2, string6, string7, string8, string9);
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.wizardInfName)) {
                return false;
            }
            if (string.equals(this.installerDef)) {
                return false;
            }
            if (string.equals(this.installerTreeDef)) {
                return false;
            }
            if (string.equals(this.uninstaller)) {
                archiveEntry.setWriter(resourceWriterFactory.createDefinitionWriter(UninstallerFilterUtils.stripId(this.installerResId, this.installerDef)));
                return true;
            }
            if (string.equals(this.uninstallerTreeDef)) {
                archiveEntry.setWriter(resourceWriterFactory.createDefinitionWriter(UninstallerFilterUtils.stripId(this.installerResId, this.installerTreeDef)));
                return true;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.equals(this.servicesDef)) {
                return false;
            }
            if (string.equals(this.archiveIndexName)) {
                return false;
            }
            if (string.startsWith(this.md5FolderName)) {
                return false;
            }
            if (string.startsWith("/" + this.installerResId)) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            bl = true;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
                if (!bl) {
                    archiveEntry.setWriter(resourceWriterFactory.createFileResourceWriter(UninstallerFilterUtils.stripId(this.installerResId, string)));
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    private class CreateInactiveUninstallerFilter
    extends AbstractCreateUninstallerFilter {
        CreateInactiveUninstallerFilter(String string, String string2, String string3, String string4, UninstallerArchive uninstallerArchive2, String string5, String string6, String string7, String string8) {
            super(string, "", string2, string3, string4, uninstallerArchive2, string5, string6, string7, string8);
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.installerDef)) {
                return false;
            }
            if (string.equals(this.installerTreeDef)) {
                return false;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.equals(this.archiveIndexName)) {
                return false;
            }
            if (string.startsWith(this.md5FolderName)) {
                return false;
            }
            if (string.startsWith("/" + this.installerResId)) {
                int n = 0;
                while (n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            return false;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
            }
            return true;
        }
    }

    private class UpdateUninstallerResourcesFilter
    implements ArchiveFilter {
        private String productDef;
        private Vector exclusions;
        private String resId;

        public UpdateUninstallerResourcesFilter(UninstallerArchive uninstallerArchive2, String string, String string2) {
            this.productDef = UninstallerFilterUtils.createResourcePath(string, string2);
            this.resId = string;
            this.exclusions = new Vector();
            String[] stringArray = uninstallerArchive2.getResourceExclusions();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = UninstallerFilterUtils.createResourcePath(string, stringArray[n]);
                if (!this.exclusions.contains(string3)) {
                    this.exclusions.addElement(string3);
                }
                ++n;
            }
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.startsWith("/" + this.resId)) {
                int n = 0;
                while (n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            return false;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
            }
            return true;
        }
    }

    private class UpdateUninstallerClassesFilter
    implements ArchiveFilter {
        private Hashtable exclusions;
        private Vector updateExclusions;
        private String exclusionArchiveName;
        private boolean isInitialized = false;

        public UpdateUninstallerClassesFilter(UninstallerArchive uninstallerArchive2, String string) {
            this.exclusionArchiveName = string;
            this.updateExclusions = new Vector();
            String[] stringArray = uninstallerArchive2.getClassUpdateExclusions();
            int n = 0;
            while (n < stringArray.length) {
                if (!this.updateExclusions.contains(stringArray[n])) {
                    this.updateExclusions.addElement(stringArray[n]);
                }
                ++n;
            }
        }

        private void addFileEntries(File file, int n, Hashtable hashtable) throws IOException {
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                File file2 = new File(file, stringArray[n2]);
                if (file2.isDirectory()) {
                    this.addFileEntries(file2, n, hashtable);
                }
                if (file2.isFile() || file2.isDirectory()) {
                    String string = this.format(file2);
                    hashtable.put(this.formatExclusion(string.substring(n)), "");
                }
                ++n2;
            }
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            int n = 0;
            while (n < this.updateExclusions.size()) {
                try {
                    if (this.updateExclusions.elementAt(n) != null && Rex.matches(string, (String)this.updateExclusions.elementAt(n))) {
                        return false;
                    }
                }
                catch (RegExprSyntaxException regExprSyntaxException) {
                    this.updateExclusions.setElementAt(null, n);
                }
                ++n;
            }
            return this.shouldExclude(string) ^ true;
        }

        private String format(File file) {
            String string = file.getAbsolutePath();
            if (file.isDirectory() && !string.endsWith("/") && !string.endsWith(File.separator)) {
                return String.valueOf(string) + File.separator;
            }
            return string;
        }

        private String formatExclusion(String string) {
            String string2 = string.replace(File.separatorChar, '/');
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            return string2;
        }

        private void initializeExclusions() throws IOException {
            if (!this.isInitialized) {
                this.exclusions = new Hashtable();
                this.initializeExclusions(this.exclusionArchiveName, this.exclusions);
                this.isInitialized = true;
            }
        }

        public void initializeExclusions(String string, Hashtable hashtable) throws IOException {
            File file = new File(string);
            if (file.isFile()) {
                if (!ZipUtils.isZipEmpty(string)) {
                    ZipFile zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        hashtable.put(this.formatExclusion(zipEntry.getName()), "");
                    }
                    zipFile.close();
                }
            } else if (file.isDirectory()) {
                String string2 = file.getAbsolutePath();
                int n = string2.length();
                if (!string2.endsWith("/") && !string2.endsWith(File.separator)) {
                    ++n;
                }
                this.addFileEntries(file, n, hashtable);
            }
        }

        private boolean shouldExclude(String string) throws IOException {
            this.initializeExclusions();
            return this.exclusions.containsKey(string);
        }
    }

    private class UninstallerArchiveWriter
    extends ArchiveWriter {
        private String archiveFileName;
        private ArchiveWriterOutputStream archiveOut;
        private ResourceReaderFactory readerFactory;

        UninstallerArchiveWriter(String string, String string2) throws IOException {
            File file = new File(string);
            String[] stringArray = FileUtils.createDirs(new File(file.getParent()));
            int n = 0;
            while (n < stringArray.length) {
                UninstallerArchive.this.putInstalledFile(stringArray[n]);
                ++n;
            }
            this.archiveFileName = string;
            UninstallerArchive uninstallerArchive2 = UninstallerArchive.this;
            uninstallerArchive2.getClass();
            this.archiveOut = uninstallerArchive2.new UninstallerArchiveWriterOutputStream(file.getParent(), file.getName());
            this.readerFactory = new StandardResourceReaderFactory(UninstallerArchive.this.getServices().getHome());
            this.initialize(this.readerFactory, new ArchiveResourceWriterFactory(this.archiveOut, string2));
        }

        void close() throws IOException {
            block2: {
                try {
                    this.archiveOut.finish();
                    this.archiveOut.close();
                }
                catch (ZipException zipException) {
                    if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                    throw zipException;
                }
            }
            this.readerFactory.close();
        }

        String getArchiveFileName() {
            return this.archiveFileName;
        }

        public void write() {
            this.setCalculateProgress(false);
            super.write();
        }
    }

    private class UninstallerArchiveWriterOutputStream
    extends ArchiveWriterZipOutputStream {
        public UninstallerArchiveWriterOutputStream(String string, String string2) {
            super(string, "disk", string2, "", null);
        }

        protected void closeExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }

        protected void closeInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            int n = archiveWriterEntry.getEntryType();
            if (n != 1) {
                if (n == 2 || n == 3) {
                    throw new IOException("Indexed entries not supported for UninstallerArchive.");
                }
                throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
            }
            this.closeArchiveEntry(archiveWriterEntry);
        }

        public String getApplicationArchiveName() {
            return FileUtils.createFileName(super.getArchiveRootFolder(), super.getArchiveName());
        }

        protected void putNextExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }

        protected void putNextInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            int n = archiveWriterEntry.getEntryType();
            if (n != 1) {
                if (n == 2 || n == 3) {
                    throw new IOException("Indexed entries not supported for UninstallerArchive.");
                }
                throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
            }
            this.putNextArchiveEntry(archiveWriterEntry);
        }

        protected boolean requireMediaInfs() {
            return false;
        }

        protected void writeToExternalArchive(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }
    }
}

