/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class DeleteDirectory
extends ProductAction {
    public static int INSTALL = 0;
    public static int UNINSTALL = 1;
    private String directory = "";
    private int runtime = INSTALL;

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.directory.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Directory property must be specified");
        }
        productBuilderSupport.putRequiredService("fileService");
    }

    private void deleteDirectory(String string) throws ProductException {
        block4: {
            try {
                FileService fileService = (FileService)this.getService("fileService");
                string = fileService.createFileName(this.getParentComponent().getAbsoluteInstallLocation(), string);
                if (!fileService.fileExists(string)) {
                    this.logEvent(this, "dbg", "Directory " + string + " does not exist");
                    break block4;
                }
                if (fileService.isDirectory(string)) {
                    fileService.deleteDirectory(string, false, true);
                    break block4;
                }
                throw new ProductException(601, "err", "Unable to delete " + string + " since it is a file");
            }
            catch (ServiceException serviceException) {
                throw new ProductException(601, "err", "Unable to delete " + string + " : " + serviceException);
            }
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (this.runtime == INSTALL) {
            this.deleteDirectory(this.resolveString(this.directory));
        }
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public void setRuntime(int n) {
        this.runtime = n;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (this.runtime == UNINSTALL) {
            this.deleteDirectory(this.resolveString(this.directory));
        }
    }
}

