/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.archive.BuildFilterable;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.product.ProductTree;
import com.installshield.util.ClassUtils;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.Log;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverUtil;
import com.installshield.util.StringUtils;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;

public abstract class ProductBean
implements PropertiesExtendible,
Log,
BuildFilterable {
    private static int nextId = 1;
    private String beanId = "";
    private String displayName = "";
    private Properties extendedProperties = new Properties();
    private boolean active = true;
    private String comments = "";
    private String buildCategories = "";
    private ProductBean parent = null;
    GenericTreeNode node = new GenericTreeNode();
    ProductTree tree = null;
    private WizardServices services = null;

    public ProductBean() {
        this.setBeanId(ProductBean.nextBeanId());
    }

    public Dictionary buildCategories() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = StringUtils.parseCommaDelimitedString(this.buildCategories);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        return hashtable;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getBuildCategories() {
        return this.buildCategories;
    }

    public String getComments() {
        return this.comments;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Dictionary getExtendedProperties() {
        return this.extendedProperties;
    }

    public ProductTree getProductTree() {
        return this.tree;
    }

    protected Service getService(String string) throws ServiceException {
        if (this.services == null) {
            throw new IllegalStateException("service manager not initialized");
        }
        return this.services.getService(string);
    }

    public WizardServices getServices() {
        return this.services;
    }

    public void initialize(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEventLogged(String string) {
        return this.services != null && this.services.getWizardLog().isEventLogged(string);
    }

    public void logEvent(Object object, String string, Object object2) {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        this.services.logEvent(object, string, object2);
    }

    private static String nextBeanId() {
        return "bean" + nextId++;
    }

    protected String resolveString(String string) {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        return this.services.resolveString(string);
    }

    protected String resolveString(String string, String string2, Log log) {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        return StringResolverUtil.resolveString(string, string2, log, this, this.services);
    }

    protected String resolveStringWithValidation(String string) throws StringResolverException {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        return this.services.resolveStringWithValidation(string);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setBeanId(String string) {
        this.beanId = string;
    }

    public void setBuildCategories(String string) {
        if (string == null) {
            throw new IllegalArgumentException("categories cannot be null");
        }
        this.buildCategories = string;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String toString() {
        return String.valueOf(ClassUtils.createObjectDisplayName(this)) + " (" + this.getBeanId() + ")";
    }
}

