/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.zipupdate.ui;

import de.vxart.zipupdate.ProgressListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressPanel
extends Box
implements ProgressListener {
    private JProgressBar progressBar;
    private JLabel message = new JLabel("\u00bf?");
    private JLabel leftDetail;
    private JLabel rightDetail;
    private boolean speedShown = true;
    private boolean timeShown = true;
    private long start;
    private long prevSecsLeft;
    private float prevSpeed;
    private int call = 0;

    public ProgressPanel() {
        super(1);
        Box box = new Box(0);
        box.add(this.message);
        box.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        this.leftDetail = new JLabel(" ");
        this.rightDetail = new JLabel(" ");
        Box box2 = new Box(0);
        box2.add(this.leftDetail);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.rightDetail);
        this.add(box);
        this.add(box2);
        this.add(this.progressBar);
    }

    public void init(String string) {
        this.message.setText(string);
        this.leftDetail.setText(" ");
        this.rightDetail.setText(" ");
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(true);
        this.start = System.currentTimeMillis();
        this.call = 0;
    }

    public void init(String string, int n, int n2) {
        this.message.setText(string);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
        this.start = System.currentTimeMillis();
        this.call = 0;
    }

    public void update(int n) {
        long l = System.currentTimeMillis();
        float f = (long)n / (1L + (l - this.start));
        f = (f + this.prevSpeed) / 2.0f;
        String string = String.valueOf(f);
        string = string.substring(0, string.indexOf(46) + 2);
        this.prevSpeed = f;
        int n2 = 100 * n / this.progressBar.getMaximum();
        long l2 = (l - this.start) / 1000L;
        long l3 = 100L * l2 / (long)(n2 + 1);
        long l4 = 1L + l3 - l2;
        this.prevSecsLeft = l4 = (l4 + this.prevSecsLeft) / 2L;
        if (f > 0.0f && this.speedShown) {
            this.leftDetail.setText(string + " KB/s");
        } else {
            this.leftDetail.setText("");
        }
        if (this.timeShown) {
            this.rightDetail.setText("(" + ProgressPanel.getFormattedTime(l4) + " left)");
        }
        this.progressBar.setValue(n);
        ++this.call;
    }

    public void label(String string) {
        this.message.setText(string);
    }

    private static String getFormattedTime(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = l / 60L;
        if (l2 > 0L) {
            stringBuffer.append(l2);
            stringBuffer.append("m ");
            l %= 60L;
        }
        stringBuffer.append(l);
        stringBuffer.append("s");
        return stringBuffer.toString();
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public void finish() {
    }

    public boolean isSpeedShown() {
        return this.speedShown;
    }

    public void setSpeedShown(boolean bl) {
        this.speedShown = bl;
        if (!bl) {
            this.leftDetail.setText(" ");
        }
    }

    public boolean isTimeShown() {
        return this.timeShown;
    }

    public void setTimeShown(boolean bl) {
        this.timeShown = bl;
        if (!bl) {
            this.rightDetail.setText(" ");
        }
    }
}

