/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ZipHeader {
    public int signature;
    public int size;
    protected ByteBuffer buffer;

    protected ZipHeader(int n, int n2, byte[] byArray) {
        this.signature = n;
        this.size = n2;
        this.init(byArray);
    }

    protected ZipHeader(int n, int n2, InputStream inputStream) throws IOException {
        this.signature = n;
        this.size = n2;
        this.init(inputStream);
    }

    private void init(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.size];
        int n2 = 0;
        do {
            if ((n = inputStream.read(byArray, n2, this.size - n2)) >= 0) continue;
            throw new EOFException();
        } while ((n2 += n) < this.size);
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        if (byArray.length != this.size) {
            throw new IllegalArgumentException("Data for " + this.getClass().getName() + " has to be " + this.size + " bytes long: " + byArray.length);
        }
        this.buffer = ByteBuffer.wrap(byArray);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = this.buffer.getInt();
        if (n != this.signature) {
            throw new IllegalArgumentException("Data for " + this.getClass().getName() + " doesn't start with magic number " + this.hex(this.signature) + ": " + this.hex(n));
        }
    }

    protected String hex(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected String hex(long l) {
        return "0x" + Long.toHexString(l);
    }
}

