/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.net;

import de.vxart.io.LimitedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartMessage
implements Iterable<Part>,
Iterator<Part> {
    private static final byte[] DASH_DELIM = new byte[]{45, 45};
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_RANGE = "Content-Range";
    private final String DASH_BOUNDARY;
    private DataInputStream input;
    private Part previousPart;

    public MultipartMessage(InputStream inputStream, String string) {
        this.DASH_BOUNDARY = new String(DASH_DELIM) + string;
        this.input = new DataInputStream(inputStream);
    }

    private long getDataSize(Map<String, String> map) throws IOException {
        long l = -1L;
        String string = map.get(CONTENT_LENGTH);
        if (string == null) {
            String string2 = map.get(CONTENT_RANGE.toLowerCase());
            if (string2 == null) {
                throw new IOException("Missing header to extract length of data.");
            }
            Pattern pattern = Pattern.compile("(\\d)+");
            Matcher matcher = pattern.matcher(string2);
            long[] lArray = new long[3];
            try {
                int n = 0;
                while (matcher.find()) {
                    lArray[n] = Long.parseLong(matcher.group());
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid Content-Range header to extract length of data: " + string2);
            }
            l = lArray[1] - lArray[0];
        } else {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid Content-Length header to extract length of data: " + string);
            }
        }
        return l;
    }

    private String readLine() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.input.read()) != -1) {
            if (n == 13) {
                if (this.input.read() == 10) break;
                throw new IllegalArgumentException("Found CR in line but not followed by LF.");
            }
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), "us-ascii");
    }

    private void ensurePosition() {
        if (this.previousPart != null) {
            this.previousPart.skip();
        }
    }

    @Override
    public Iterator<Part> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.ensurePosition();
        try {
            String string;
            while (!(string = this.readLine()).startsWith(this.DASH_BOUNDARY)) {
            }
            if (string.endsWith("--")) {
                this.input.close();
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public Part next() {
        this.ensurePosition();
        try {
            Part part;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (!(string = this.readLine()).equals("")) {
                int n = string.indexOf(58);
                String string2 = string.substring(0, n).trim().toLowerCase();
                String string3 = string.substring(n + 1).trim();
                hashMap.put(string2, string3);
            }
            this.previousPart = part = new Part(hashMap, this.input, this.getDataSize(hashMap));
            return part;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Part {
        private Map<String, String> headers;
        private LimitedInputStream data;

        public Part(Map<String, String> map, DataInputStream dataInputStream, long l) {
            this.headers = map;
            this.data = new LimitedInputStream(dataInputStream, l + 1L);
        }

        public boolean skip() {
            try {
                return this.data.skipAll() > 0L;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to skip data", iOException);
            }
        }

        public InputStream openStream() {
            return this.data;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

