/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ThrottledInputStream
extends FilterInputStream {
    private long kiloBytesPerSecond;

    public ThrottledInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.kiloBytesPerSecond = l;
    }

    private void throttle(long l) throws IOException {
        try {
            long l2 = 1024L * l / (1000L * this.kiloBytesPerSecond);
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted: " + interruptedException.getMessage());
        }
    }

    public int read() throws IOException {
        this.throttle(4L);
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.throttle(n2 - n);
        return this.in.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        this.throttle(byArray.length);
        return this.in.read(byArray);
    }

    public long skip(long l) throws IOException {
        this.throttle(l);
        return this.in.skip(l);
    }
}

