/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.launcher;

import com.turborilla.mule.launcher.Download;
import com.turborilla.mule.launcher.MuleProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Updater {
    private static Logger logger = Logger.getLogger(Updater.class.getCanonicalName());
    private String remoteDir;
    private String host;
    private String buildNumberOnServer;

    public Updater(String string, String string2) {
        this.host = string;
        this.remoteDir = string2;
    }

    protected boolean isNewerBuildNumberOnServer(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL("http", this.host, this.remoteDir + "/" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.SEVERE, malformedURLException.toString(), malformedURLException);
            return false;
        }
        logger.info("About to download " + uRL);
        Download download = Download.startDownload(uRL);
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 3000L && download.getState() == 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (download.getState() != 2) {
            Throwable throwable = download.getLastException();
            if (throwable == null) {
                logger.info("Could not download build number. Unknown error.");
            } else {
                logger.info("Could not download build number due to " + throwable.toString());
            }
            return false;
        }
        byte[] byArray = download.getData();
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            logger.severe("Could not download build number due to " + iOException);
            return false;
        }
        this.buildNumberOnServer = properties.getProperty("build.number");
        if (this.buildNumberOnServer == null) {
            logger.info("build number on server not found");
            return false;
        }
        logger.info("build number on server: " + this.buildNumberOnServer);
        return !this.buildNumberOnServer.equalsIgnoreCase(string);
    }

    protected String getBuildNumberOnServer() {
        return this.buildNumberOnServer;
    }

    /*
     * WARNING - void declaration
     */
    protected File[] findAllJars(String string) throws IOException {
        File[] fileArray = null;
        try {
            void var12_15;
            File file = string != null ? new File(System.getProperty("user.dir") + File.separator + string) : new File(System.getProperty("user.dir"));
            URL uRL = new URL("http", this.host, this.remoteDir + "/" + "jarlist.txt");
            logger.info("About to download " + uRL);
            Download download = Download.startDownload(uRL);
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l < 3000L && download.getState() == 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (download.getState() != 2) {
                logger.severe("Could not download jar list due to " + download.getLastException());
                throw new IOException(download.getLastException().getMessage());
            }
            byte[] byArray = download.getData();
            String string2 = new String(byArray);
            logger.info("jarlist (" + byArray.length + " bytes):\n" + string2);
            String[] stringArray = string2.split("\n");
            logger.info("jarlist entries: " + stringArray.length);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string3 : stringArray) {
                string3.trim();
                if (string3.length() == 0) continue;
                if (string3.length() > 1 && Character.getType(string3.charAt(string3.length() - 1)) == 15) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (MuleProperties.isNativesJar(string3)) {
                    String string4 = MuleProperties.getNativesJar(this.getOsName());
                    if (!string3.endsWith(string4)) continue;
                    arrayList.add(new File(file, string4));
                    continue;
                }
                arrayList.add(new File(file, string3));
            }
            fileArray = arrayList.toArray(new File[0]);
            String string5 = "Found the following jars:\n";
            for (File file2 : fileArray) {
                String string6 = (String)var12_15 + file2 + "\n";
            }
            logger.info((String)var12_15);
        }
        catch (Exception exception) {
            logger.severe("Could not download or parse jar list due to " + exception);
            throw new IOException(exception.getMessage());
        }
        return fileArray;
    }

    protected ZipFile newZipFile(File file) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            logger.warning("Could not open \"" + file + "\" due to " + exception + ". Creating empty one.");
            file.delete();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.putNextEntry(new ZipEntry("dummy"));
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
            zipFile = new ZipFile(file);
        }
        return zipFile;
    }

    public String getOsName() {
        String string = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            string = "windows";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            string = "linux";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            string = "mac";
        }
        return string;
    }

    public static void unzip(File file, String string, File file2) {
        ZipFile zipFile = null;
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            zipFile = new ZipFile(new File(file, string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file3;
                zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0 || (file3 = new File(file2, zipEntry.getName())).exists()) continue;
                file3.mkdirs();
            }
            enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0) continue;
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[2048];
                File file4 = new File(file2, zipEntry.getName());
                if (file4.exists()) {
                    file4.delete();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            zipFile.close();
        }
        catch (ZipException zipException) {
            logger.log(Level.SEVERE, zipException.toString(), zipException);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.toString(), iOException);
        }
    }

    public String getRemoteDir() {
        return this.remoteDir;
    }

    public void setRemoteDir(String string) {
        this.remoteDir = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }
}

