/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.launcher;

import com.turborilla.mule.launcher.MuleProperties;
import com.turborilla.mule.launcher.Updater;
import de.vxart.zipupdate.ProgressListener;
import de.vxart.zipupdate.UpdateEngine;
import de.vxart.zipupdate.UpdateLocation;
import de.vxart.zipupdate.ui.MultiProgressDialog;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class DynamicUpdater
extends Updater {
    private static Logger logger = Logger.getLogger(DynamicUpdater.class.getCanonicalName());
    private String fromBuild;

    public DynamicUpdater(String string, String string2) {
        super(string, string2);
    }

    public boolean isNewBuildNumber() {
        String string = null;
        try {
            URL uRL = Updater.class.getClassLoader().getResource("build.txt");
            if (uRL == null) {
                logger.info("Missing file build.txt");
                string = "unknown";
            } else {
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                string = properties.getProperty("build.number", "unknown");
            }
            logger.info("this build number: " + string);
            this.fromBuild = string;
            if (string == null) {
                return false;
            }
            if (this.isNewerBuildNumberOnServer(string, "build.txt")) {
                return true;
            }
            logger.info("Build number not newer on server");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Could not compare build numbers due to: " + exception.toString(), exception);
        }
        return false;
    }

    public void update(ProgressListener progressListener) throws IOException {
        Serializable serializable;
        String string;
        this.setHost("www.planetmule.com");
        this.setRemoteDir("/updater");
        File[] fileArray = this.findAllJars(null);
        if (fileArray == null || fileArray.length <= 0) {
            logger.info("No jars found in jarlist");
            return;
        }
        ZipFile[] zipFileArray = new ZipFile[fileArray.length];
        UpdateLocation[] updateLocationArray = new UpdateLocation[fileArray.length];
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            string = fileArray[i].getName();
            serializable = new URL("http", this.getHost(), this.getRemoteDir() + "/data/" + string);
            if (string.equals("launcher.jar")) {
                fileArray[i] = new File("launcher-update.jar");
                logger.info("Storing launcher in " + fileArray[i].getName());
            }
            zipFileArray[i] = this.newZipFile(fileArray[i]);
            updateLocationArray[i] = new UpdateLocation((URL)serializable);
            stringArray[i] = "Updating " + fileArray[i].getName() + "...";
        }
        UpdateEngine updateEngine = new UpdateEngine();
        if (progressListener != null) {
            updateEngine.addProgressListener(progressListener);
        }
        try {
            updateEngine.update(zipFileArray, updateLocationArray, stringArray);
        }
        catch (IOException iOException) {
            if (progressListener != null) {
                updateEngine.removeProgressListener(progressListener);
                if (progressListener instanceof MultiProgressDialog) {
                    ((MultiProgressDialog)progressListener).getOverallProgressListener().finish();
                }
                progressListener.finish();
            }
            throw iOException;
        }
        string = MuleProperties.getNativesJar(this.getOsName());
        try {
            serializable = new File(System.getProperty("user.dir"));
            File file = ((File)serializable).getParentFile();
            File file2 = new File((File)serializable, string);
            if (file2.exists()) {
                logger.info("Extracting " + string + " from " + serializable + " to " + file);
                progressListener.init("Extracting natives", 0, 100);
                progressListener.update(0);
                DynamicUpdater.unzip((File)serializable, string, file);
                this.setPermissions(file);
                progressListener.finish();
            } else {
                logger.info("No natives available. " + string + " doesn't exist.");
            }
        }
        catch (RuntimeException runtimeException) {
            logger.severe("Failed to unzip " + string + " due to " + runtimeException);
        }
    }

    private void setPermissions(File file) {
        for (String string : MuleProperties.linuxExecutableFiles) {
            try {
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                String string2 = "chmod 555 " + file2.getAbsolutePath();
                logger.info("Setting permissions: " + string2);
                try {
                    Runtime.getRuntime().exec(string2);
                }
                catch (Exception exception) {
                    logger.severe("Failed to set executable permission on file " + file2.toString() + ". " + exception.toString());
                }
            }
            catch (Exception exception) {
                logger.severe("Failed to open file " + string);
            }
        }
    }

    public String getCurrentBuildNumber() {
        return this.fromBuild;
    }

    public String getNewBuildNumber() {
        return this.getBuildNumberOnServer();
    }
}

